/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class EventPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfSynonym;
    private Event event;
    private JButton btnFlow;
    private JTextField tfText;
    private List pList;
    private JTable pTable;
    private JPanel pnProcess;
    private JIntegerField ifFrequency;
    private JRadioButton rbEvery;
    private JRadioButton rbOn;
    private JLabel lbFrequency;
    private JComboBox cbDayOfWeek;
    private JIntegerField ifDayOfMonth;
    private JComboBox cbMonth;
    private JRadioButton rbFirst;
    private JRadioButton rbSecond;
    private JRadioButton rbThird;
    private JRadioButton rbFourth;
    private JRadioButton rbAll;
    private JIntegerField ifYear;
    private JRadioButton rbFiscal;
    private JRadioButton rbCalendar;
    private JPanel pnDays;
    private int quarter;
    private JRadioButton rbAtOpenDay;
    private JRadioButton rbAtCloseDay;
    private JRadioButton rbDuringDay;
    private JRadioButton rbAtSpecifiedTime;
    private JRadioButton rbAt;
    private JRadioButton rbEveryTime;
    private JLabel lbTimeFrequency;
    private JIntegerField ifTimeFreq;
    private JLabel lbHour;
    private JIntegerField ifHour;
    private JLabel lbMinute;
    private JIntegerField ifMinute;
    private JPanel pnTimes;
    private int timesWhenRun;
    private JTextField tfType;
    private JLabel lbDayOfWeek;
    private JLabel lbDayOfMonth;
    private JLabel lbMonth;
    private JLabel lbYear;

    public EventPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    public EventPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog, applicationView, designObject);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_SYNOMYM);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfSynonym));
        JLabel jLabel2 = new JLabel(LB_FLOW);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.btnFlow = new JButton();
        this.btnFlow.setPreferredSize(this.getDefaultSize());
        this.btnFlow.setFont(this.btnFlow.getFont().deriveFont(0));
        this.btnFlow.setEnabled(false);
        this.btnFlow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EventPropertiesDialogEx.this.event.getFlow() != null) {
                    EventPropertiesDialogEx.this.event.getFlow().showPropertyDialog();
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.btnFlow));
        JLabel jLabel3 = new JLabel(LB_EVENT_TEXT);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.tfText = new JTextField();
        this.tfText.setEnabled(false);
        this.tfText.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.tfText));
        JLabel jLabel4 = new JLabel(LB_TYPE);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.tfType = new JTextField();
        this.tfType.setPreferredSize(this.getDefaultSize());
        this.tfType.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.tfType));
    }

    @Override
    public String getCaption() {
        return Messages.getString("EventPropertiesDialogEx.EventProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Event) {
            Object object;
            this.event = (Event)designObject;
            this.initDefaults(false);
            this.tfSynonym.setText(this.event.getSynonym());
            int n = this.event.getEventType();
            if (n == 2 || n == 3) {
                this.tfText.setEnabled(true);
                this.tfText.setText(this.event.getText());
            }
            if (n == 0) {
                object = this.event.getFlow() != null ? this.event.getFlow().getName() : Messages.getString("EventPropertiesDialogEx.NONE");
                this.btnFlow.setEnabled(true);
                this.btnFlow.setText((String)object);
            }
            switch (n) {
                case 0: {
                    this.tfType.setText(Messages.getString("EventPropertiesDialogEx.InformationFlow"));
                    break;
                }
                case 1: {
                    this.tfType.setText(Messages.getString("EventPropertiesDialogEx.ClockCalendar"));
                    break;
                }
                case 2: {
                    this.tfType.setText(Messages.getString("EventPropertiesDialogEx.Person"));
                    break;
                }
                case 3: {
                    this.tfType.setText(Messages.getString("EventPropertiesDialogEx.Storage"));
                    break;
                }
                default: {
                    this.tfType.setText(Messages.getString("EventPropertiesDialogEx.InformationFlow"));
                }
            }
            if (this.event.getFlow() != null) {
                object = this.event.getFlow().getTargetProcessObject();
                if (object instanceof Process) {
                    this.pList.add(object);
                } else {
                    this.pList.add(this.event.getFlow().getSourceProcessObject());
                }
            }
            this.pList.addAll(this.event.getProcessTriggered());
            if (this.event.isOnDay()) {
                this.rbOn.setSelected(true);
            } else {
                this.rbEvery.setSelected(true);
            }
            if (this.event.isFiscal()) {
                this.rbFiscal.setSelected(true);
            } else {
                this.rbCalendar.setSelected(true);
            }
            this.setFrequency();
            this.ifFrequency.setValue((long)this.event.getFrequency());
            this.cbDayOfWeek.setSelectedItem(this.translate(this.event.getDayOfWeek(), Event.DAYS_OF_WEEK, Event.DAYS_OF_WEEK_DISPLAY));
            this.ifDayOfMonth.setValue((long)this.event.getDayOfMonth());
            this.cbMonth.setSelectedItem(this.translate(this.event.getMonths(), Event.MONTHS, Event.MONTHS_DISPLAY));
            this.ifYear.setValue((long)this.event.getYear());
            this.quarter = this.event.getQuarter();
            switch (this.quarter) {
                case 1: {
                    this.rbFirst.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbSecond.setSelected(true);
                    break;
                }
                case 3: {
                    this.rbThird.setSelected(true);
                    break;
                }
                case 4: {
                    this.rbFourth.setSelected(true);
                    break;
                }
                case 0: {
                    this.rbAll.setSelected(true);
                    break;
                }
                default: {
                    this.rbAll.setSelected(true);
                }
            }
            this.timesWhenRun = this.event.getTimesWhenRun();
            switch (this.timesWhenRun) {
                case 1: {
                    this.rbAtOpenDay.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbAtCloseDay.setSelected(true);
                    break;
                }
                case 3: {
                    this.rbDuringDay.setSelected(true);
                    break;
                }
                case 4: {
                    this.rbAtSpecifiedTime.setSelected(true);
                    break;
                }
                default: {
                    this.rbAtOpenDay.setSelected(true);
                }
            }
            if (this.event.isAtTime()) {
                this.rbAt.setSelected(true);
            } else {
                this.rbEveryTime.setSelected(true);
            }
            this.ifTimeFreq.setValue((long)this.event.getTimeFreq());
            this.ifHour.setValue((long)this.event.getHour());
            this.ifMinute.setValue((long)this.event.getMinute());
            this.setTimeFreq();
            this.enableTimePanel();
            this.enableTimePage();
            this.enableDaysPage();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            object = this.event.getPropertyNames();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = this.event.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.event.setName(this.tfName.getText());
        this.event.setComment(this.taComments.getText());
        this.event.setSynonym(this.tfSynonym.getText());
        this.event.setNotes(this.taNotes.getText());
        int n = this.event.getEventType();
        if (!(n != 2 && n != 3 || this.tfText.getText().trim().equals(""))) {
            this.event.setText(this.tfText.getText());
        }
        if (this.event.getEventType() == 1) {
            boolean bl = this.rbOn.isSelected();
            this.event.setOnDay(bl);
            if (!bl) {
                this.event.setFrequency(this.ifFrequency.getIntValue());
            }
            this.event.setDayOfWeek(this.translate((String)this.cbDayOfWeek.getSelectedItem(), Event.DAYS_OF_WEEK_DISPLAY, Event.DAYS_OF_WEEK));
            this.event.setDayOfMonth(this.ifDayOfMonth.getIntValue());
            this.event.setMonths(this.translate((String)this.cbMonth.getSelectedItem(), Event.MONTHS_DISPLAY, Event.MONTHS));
            this.event.setQuarter(this.quarter);
            this.event.setYear(this.ifYear.getIntValue());
            this.event.setFiscal(this.rbFiscal.isSelected());
            this.event.setTimesWhenRun(this.timesWhenRun);
            if (this.timesWhenRun == 4) {
                boolean bl2 = this.rbAt.isSelected();
                this.event.setAtTime(bl2);
                if (!bl2) {
                    this.event.setTimeFreq(this.ifTimeFreq.getIntValue());
                }
                this.event.setHour(this.ifHour.getIntValue());
                this.event.setMinute(this.ifMinute.getIntValue());
            }
        }
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        EventPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.event.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.event.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getProcessPanel());
        this.addToTree(defaultMutableTreeNode, this.getDaysWhenRunPanel());
        this.addToTree(defaultMutableTreeNode, this.getTimesWhenRunPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "EVENT_PROPERTIES_DIALOG";
    }

    private JPanel getProcessPanel() {
        this.pList = new ArrayList();
        if (this.pnProcess == null) {
            this.pnProcess = this.createPage(Messages.getString("EventPropertiesDialogEx.ProcessTriggered"));
            this.pTable = new JTable(new ProcessTableModel());
            this.pTable.setSelectionMode(0);
            this.pTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = EventPropertiesDialogEx.this.pTable.getSelectedRow()) != -1 && EventPropertiesDialogEx.this.pList.size() > 0 && n < EventPropertiesDialogEx.this.pList.size()) {
                        Process process = (Process)EventPropertiesDialogEx.this.pList.get(n);
                        process.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.pTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("EventPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = EventPropertiesDialogEx.this.pTable.getSelectedRow();
                    if (n != -1 && EventPropertiesDialogEx.this.pList.size() > 0 && n < EventPropertiesDialogEx.this.pList.size()) {
                        Process process = (Process)EventPropertiesDialogEx.this.pList.get(n);
                        process.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 195));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnProcess.add(jPanel2);
        }
        return this.pnProcess;
    }

    private JPanel getDaysWhenRunPanel() {
        if (this.pnDays == null) {
            this.pnDays = this.createPage(Messages.getString("EventPropertiesDialogEx.DaysWhenRun"));
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
            JPanel jPanel3 = new JPanel(new GridLayout(0, 2));
            DayListener dayListener = new DayListener();
            this.rbEvery = new JRadioButton(Messages.getString("EventPropertiesDialogEx.Every"));
            this.rbEvery.addActionListener(dayListener);
            this.rbEvery.setMnemonic(69);
            this.rbOn = new JRadioButton(Messages.getString("EventPropertiesDialogEx.On"));
            this.rbOn.addActionListener(dayListener);
            this.rbOn.setMnemonic(79);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbEvery);
            buttonGroup.add(this.rbOn);
            jPanel3.add(this.rbEvery);
            jPanel3.add(this.rbOn);
            jPanel2.add((Component)jPanel3, "West");
            this.lbFrequency = new JLabel(LB_FREQUENCY);
            this.ifFrequency = new JIntegerField();
            this.ifFrequency.setPreferredSize(new Dimension(70, 20));
            JPanel jPanel4 = new JPanel(new BorderLayout(20, 20));
            jPanel4.add((Component)this.lbFrequency, "West");
            jPanel4.add(this.ifFrequency);
            jPanel2.add((Component)jPanel4, "East");
            jPanel.add((Component)jPanel2, "North");
            JPanel jPanel5 = new JPanel(new BorderLayout(10, 10));
            jPanel5.setBorder(BorderFactory.createTitledBorder(""));
            JPanel jPanel6 = new JPanel(new GridLayout(0, 1, 10, 10));
            this.lbDayOfWeek = new JLabel(LB_DAY_OF_WEEK);
            this.lbDayOfWeek.setPreferredSize(this.getDefaultSize());
            this.cbDayOfWeek = new JComboBox<String>(Event.DAYS_OF_WEEK_DISPLAY);
            this.cbDayOfWeek.setFont(this.cbDayOfWeek.getFont().deriveFont(0));
            this.cbDayOfWeek.setPreferredSize(this.getDefaultSize());
            this.cbDayOfWeek.setMaximumRowCount(Event.DAYS_OF_WEEK_DISPLAY.length);
            jPanel6.add(this.createRow(this.lbDayOfWeek, this.cbDayOfWeek));
            this.lbDayOfMonth = new JLabel(LB_DAY_OF_MONTH);
            this.lbDayOfMonth.setPreferredSize(this.getDefaultSize());
            this.ifDayOfMonth = new JIntegerField();
            this.ifDayOfMonth.setFont(this.ifDayOfMonth.getFont().deriveFont(0));
            this.ifDayOfMonth.setPreferredSize(this.getDefaultSize());
            this.ifDayOfMonth.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    String string = EventPropertiesDialogEx.this.ifDayOfMonth.getText();
                    if (!"".equalsIgnoreCase(string)) {
                        if (EventPropertiesDialogEx.this.ifDayOfMonth.getIntValue() > 31) {
                            EventPropertiesDialogEx.this.ifDayOfMonth.setValue(0L);
                            JOptionPane.showMessageDialog(EventPropertiesDialogEx.this, Messages.getString("EventPropertiesDialogEx.DayValueMustBePositiveInteger"));
                            EventPropertiesDialogEx.this.ifDayOfMonth.grabFocus();
                        }
                    } else {
                        EventPropertiesDialogEx.this.ifDayOfMonth.setValue(0L);
                    }
                }
            });
            jPanel6.add(this.createRow(this.lbDayOfMonth, this.ifDayOfMonth));
            this.lbMonth = new JLabel(LB_MONTH);
            this.lbMonth.setPreferredSize(this.getDefaultSize());
            this.cbMonth = new JComboBox<String>(Event.MONTHS_DISPLAY);
            this.cbMonth.setFont(this.cbMonth.getFont().deriveFont(0));
            this.cbMonth.setPreferredSize(this.getDefaultSize());
            this.cbMonth.setMaximumRowCount(Event.MONTHS_DISPLAY.length);
            jPanel6.add(this.createRow(this.lbMonth, this.cbMonth));
            jPanel5.add((Component)jPanel6, "North");
            jPanel.add((Component)jPanel5, "Center");
            JPanel jPanel7 = new JPanel(new BorderLayout(20, 20));
            JPanel jPanel8 = new JPanel(new GridLayout(0, 5));
            jPanel8.setBorder(BorderFactory.createTitledBorder(Messages.getString("EventPropertiesDialogEx.Quarter")));
            QuarterListener quarterListener = new QuarterListener();
            this.rbFirst = new JRadioButton(Messages.getString("EventPropertiesDialogEx.1st"));
            this.rbFirst.addActionListener(quarterListener);
            this.rbFirst.setMnemonic(49);
            this.rbSecond = new JRadioButton(Messages.getString("EventPropertiesDialogEx.2nd"));
            this.rbSecond.addActionListener(quarterListener);
            this.rbSecond.setMnemonic(50);
            this.rbThird = new JRadioButton(Messages.getString("EventPropertiesDialogEx.3rd"));
            this.rbThird.addActionListener(quarterListener);
            this.rbThird.setMnemonic(51);
            this.rbFourth = new JRadioButton(Messages.getString("EventPropertiesDialogEx.4th"));
            this.rbFourth.addActionListener(quarterListener);
            this.rbFourth.setMnemonic(52);
            this.rbAll = new JRadioButton(Messages.getString("EventPropertiesDialogEx.All"));
            this.rbAll.addActionListener(quarterListener);
            this.rbAll.setMnemonic(65);
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbFirst);
            buttonGroup.add(this.rbSecond);
            buttonGroup.add(this.rbThird);
            buttonGroup.add(this.rbFourth);
            buttonGroup.add(this.rbAll);
            jPanel8.add(this.rbFirst);
            jPanel8.add(this.rbSecond);
            jPanel8.add(this.rbThird);
            jPanel8.add(this.rbFourth);
            jPanel8.add(this.rbAll);
            jPanel7.add((Component)jPanel8, "North");
            JPanel jPanel9 = new JPanel(new GridLayout(0, 2, 10, 10));
            this.lbYear = new JLabel(LB_YEAR);
            this.lbYear.setPreferredSize(new Dimension(50, 20));
            this.ifYear = new JIntegerField();
            this.ifYear.setPreferredSize(new Dimension(110, 20));
            jPanel9.add(this.createRow(this.lbYear, this.ifYear));
            JPanel jPanel10 = new JPanel(new GridLayout(0, 2));
            this.rbFiscal = new JRadioButton(Messages.getString("EventPropertiesDialogEx.Fiscal"));
            this.rbFiscal.setMnemonic(70);
            this.rbCalendar = new JRadioButton(Messages.getString("EventPropertiesDialogEx.Calendar"));
            this.rbCalendar.setMnemonic(67);
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbFiscal);
            buttonGroup.add(this.rbCalendar);
            jPanel10.add(this.rbFiscal);
            jPanel10.add(this.rbCalendar);
            jPanel9.add(jPanel10);
            jPanel7.add(jPanel9);
            jPanel.add((Component)jPanel7, "South");
            this.pnDays.add(jPanel);
        }
        return this.pnDays;
    }

    private void setFrequency() {
        this.ifFrequency.setEnabled(this.rbEvery.isSelected());
        this.lbFrequency.setEnabled(this.ifFrequency.isEnabled());
    }

    private JPanel getTimesWhenRunPanel() {
        if (this.pnTimes == null) {
            this.pnTimes = this.createPage(Messages.getString("EventPropertiesDialogEx.TimesWhenRun"));
            JPanel jPanel = new JPanel(new GridLayout(0, 1));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
            TimeListener timeListener = new TimeListener();
            this.rbAtOpenDay = new JRadioButton(Messages.getString("EventPropertiesDialogEx.OBD"));
            this.rbAtOpenDay.addActionListener(timeListener);
            this.rbAtOpenDay.setMnemonic(79);
            this.rbAtCloseDay = new JRadioButton(Messages.getString("EventPropertiesDialogEx.COB"));
            this.rbAtCloseDay.addActionListener(timeListener);
            this.rbAtCloseDay.setMnemonic(67);
            this.rbDuringDay = new JRadioButton(Messages.getString("EventPropertiesDialogEx.WhenConvenientDuringDay"));
            this.rbDuringDay.addActionListener(timeListener);
            this.rbDuringDay.setMnemonic(68);
            this.rbAtSpecifiedTime = new JRadioButton(Messages.getString("EventPropertiesDialogEx.AtSpecifiedTime"));
            this.rbAtSpecifiedTime.addActionListener(timeListener);
            this.rbAtSpecifiedTime.setMnemonic(83);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbAtOpenDay);
            buttonGroup.add(this.rbAtCloseDay);
            buttonGroup.add(this.rbDuringDay);
            buttonGroup.add(this.rbAtSpecifiedTime);
            jPanel2.add(this.rbAtOpenDay);
            jPanel2.add(this.rbAtCloseDay);
            jPanel2.add(this.rbDuringDay);
            jPanel2.add(this.rbAtSpecifiedTime);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel(new BorderLayout(30, 30));
            jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("EventPropertiesDialogEx.Time")));
            JPanel jPanel4 = new JPanel(new GridLayout(0, 2));
            JPanel jPanel5 = new JPanel(new GridLayout(0, 2));
            TimeFreqListener timeFreqListener = new TimeFreqListener();
            this.rbAt = new JRadioButton(Messages.getString("EventPropertiesDialogEx.At"));
            this.rbAt.addActionListener(timeFreqListener);
            this.rbAt.setMnemonic(65);
            this.rbEveryTime = new JRadioButton(Messages.getString("EventPropertiesDialogEx.Every"));
            this.rbEveryTime.addActionListener(timeFreqListener);
            this.rbEveryTime.setMnemonic(69);
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbAt);
            buttonGroup.add(this.rbEveryTime);
            jPanel5.add(this.rbAt);
            jPanel5.add(this.rbEveryTime);
            jPanel4.add(jPanel5);
            this.lbTimeFrequency = new JLabel(LB_FREQUENCY);
            this.ifTimeFreq = new JIntegerField();
            JPanel jPanel6 = new JPanel(new BorderLayout(20, 20));
            jPanel6.add((Component)this.lbTimeFrequency, "West");
            jPanel6.add(this.ifTimeFreq);
            jPanel4.add((Component)jPanel6, "East");
            this.setTimeFreq();
            jPanel3.add((Component)jPanel4, "North");
            JPanel jPanel7 = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel8 = new JPanel(new GridLayout(0, 2, 10, 10));
            this.lbHour = new JLabel(LB_HOUR);
            this.lbHour.setPreferredSize(this.lbTimeFrequency.getPreferredSize());
            this.ifHour = new JIntegerField();
            this.ifHour.setFont(this.ifHour.getFont().deriveFont(0));
            this.ifHour.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    String string = EventPropertiesDialogEx.this.ifHour.getText();
                    if (!"".equalsIgnoreCase(string)) {
                        if (EventPropertiesDialogEx.this.ifHour.getIntValue() > 31) {
                            EventPropertiesDialogEx.this.ifHour.setValue(0L);
                            JOptionPane.showMessageDialog(EventPropertiesDialogEx.this, Messages.getString("EventPropertiesDialogEx.HourValueMustBePositiveInteger"));
                            EventPropertiesDialogEx.this.ifHour.grabFocus();
                        }
                    } else {
                        EventPropertiesDialogEx.this.ifHour.setValue(0L);
                    }
                }
            });
            jPanel8.add(this.createRow(this.lbHour, this.ifHour));
            this.lbMinute = new JLabel(LB_MINUTE);
            this.lbMinute.setPreferredSize(this.lbTimeFrequency.getPreferredSize());
            this.ifMinute = new JIntegerField();
            this.ifMinute.setFont(this.ifMinute.getFont().deriveFont(0));
            this.ifMinute.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    String string = EventPropertiesDialogEx.this.ifMinute.getText();
                    if (!"".equalsIgnoreCase(string)) {
                        if (EventPropertiesDialogEx.this.ifMinute.getIntValue() > 31) {
                            EventPropertiesDialogEx.this.ifMinute.setValue(0L);
                            JOptionPane.showMessageDialog(EventPropertiesDialogEx.this, Messages.getString("EventPropertiesDialogEx.MinuteValueMustBePositiveInteger"));
                            EventPropertiesDialogEx.this.ifMinute.grabFocus();
                        }
                    } else {
                        EventPropertiesDialogEx.this.ifMinute.setValue(0L);
                    }
                }
            });
            jPanel8.add(this.createRow(this.lbMinute, this.ifMinute));
            jPanel7.add((Component)jPanel8, "North");
            jPanel3.add((Component)jPanel7, "Center");
            jPanel.add(jPanel3);
            this.pnTimes.add(jPanel);
        }
        return this.pnTimes;
    }

    private void setTimeFreq() {
        this.ifTimeFreq.setEnabled(this.rbAt.isSelected());
        this.lbTimeFrequency.setEnabled(this.rbAt.isSelected());
    }

    private void enableTimePanel() {
        boolean bl = this.rbAtSpecifiedTime.isSelected();
        this.rbAt.setEnabled(bl);
        this.rbEveryTime.setEnabled(bl);
        this.ifTimeFreq.setEnabled(bl);
        this.lbTimeFrequency.setEnabled(bl);
        this.ifHour.setEnabled(bl);
        this.ifMinute.setEnabled(bl);
        this.lbHour.setEnabled(bl);
        this.lbMinute.setEnabled(bl);
    }

    private void enableTimePage() {
        boolean bl = this.event.getEventType() == 1;
        this.rbAtOpenDay.setEnabled(bl);
        this.rbAtCloseDay.setEnabled(bl);
        this.rbDuringDay.setEnabled(bl);
        this.rbAtSpecifiedTime.setEnabled(bl);
        this.enableTimePanel();
    }

    private void enableDaysPage() {
        boolean bl = this.event.getEventType() == 1;
        this.rbEvery.setEnabled(bl);
        this.rbOn.setEnabled(bl);
        this.lbDayOfWeek.setEnabled(bl);
        this.cbDayOfWeek.setEnabled(bl);
        this.lbDayOfMonth.setEnabled(bl);
        this.ifDayOfMonth.setEnabled(bl);
        this.lbMonth.setEnabled(bl);
        this.cbMonth.setEnabled(bl);
        this.rbFirst.setEnabled(bl);
        this.rbSecond.setEnabled(bl);
        this.rbThird.setEnabled(bl);
        this.rbFourth.setEnabled(bl);
        this.rbAll.setEnabled(bl);
        this.lbYear.setEnabled(bl);
        this.ifYear.setEnabled(bl);
        this.rbFiscal.setEnabled(bl);
        this.rbCalendar.setEnabled(bl);
        this.setFrequency();
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class TimeFreqListener
    implements ActionListener {
        private TimeFreqListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EventPropertiesDialogEx.this.setTimeFreq();
        }
    }

    private class TimeListener
    implements ActionListener {
        private TimeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EventPropertiesDialogEx.this.enableTimePanel();
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton == EventPropertiesDialogEx.this.rbAtSpecifiedTime) {
                EventPropertiesDialogEx.this.timesWhenRun = 4;
            } else if (jRadioButton == EventPropertiesDialogEx.this.rbAtCloseDay) {
                EventPropertiesDialogEx.this.timesWhenRun = 2;
            } else if (jRadioButton == EventPropertiesDialogEx.this.rbDuringDay) {
                EventPropertiesDialogEx.this.timesWhenRun = 3;
            } else {
                EventPropertiesDialogEx.this.timesWhenRun = 1;
            }
        }
    }

    private class QuarterListener
    implements ActionListener {
        private QuarterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton == EventPropertiesDialogEx.this.rbFirst) {
                EventPropertiesDialogEx.this.quarter = 1;
            } else if (jRadioButton == EventPropertiesDialogEx.this.rbSecond) {
                EventPropertiesDialogEx.this.quarter = 2;
            } else if (jRadioButton == EventPropertiesDialogEx.this.rbThird) {
                EventPropertiesDialogEx.this.quarter = 3;
            } else if (jRadioButton == EventPropertiesDialogEx.this.rbFourth) {
                EventPropertiesDialogEx.this.quarter = 4;
            } else {
                EventPropertiesDialogEx.this.quarter = 0;
            }
        }
    }

    private class DayListener
    implements ActionListener {
        private DayListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EventPropertiesDialogEx.this.setFrequency();
        }
    }

    private class ProcessTableModel
    extends AbstractTableModel {
        private ProcessTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return EventPropertiesDialogEx.this.pList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("EventPropertiesDialogEx.Processes");
            }
            if (n == 1) {
                return Messages.getString("EventPropertiesDialogEx.Synonym");
            }
            if (n == 2) {
                return Messages.getString("EventPropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Process process = (Process)EventPropertiesDialogEx.this.pList.get(n);
            if (n2 == 0) {
                return process.getName();
            }
            if (n2 == 1) {
                return process.getSynonym();
            }
            if (n2 == 2) {
                return process.getProcessTypeName();
            }
            return new Integer(n * n2);
        }
    }
}

