/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectElementsDialog
extends JDialog
implements AbstractEditorConstants {
    private List aList;
    private List allElements;
    private JList selectedAttributesList;
    private JList allAttributesList;
    private DefaultListModel allAttributesModel;
    private DefaultListModel selectedAttributesModel;
    private JButton btnAddAttributes;
    private JButton btnRemoveAttributes;
    protected JPanel generalPanel;
    public boolean cancel = true;

    public SelectElementsDialog(ApplicationView applicationView, List list, List list2) {
        super(applicationView.getFrame());
        this.setModal(true);
        this.aList = list2;
        this.allElements = list;
        this.setTitle(Messages.getString("SelectElementsDialog.SelectElements"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SelectElementsDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.allAttributesModel = new DefaultListModel();
        this.selectedAttributesModel = new DefaultListModel();
        this.init();
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(BTN_CANCEL);
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void init() {
        this.initAllAttributesList();
        this.initAttributesButtons();
        this.initSelectedAttributesList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator iterator = this.aList.iterator();
        while (iterator.hasNext()) {
            this.selectedAttributesModel.addElement(new ElementItem(iterator.next()));
        }
        for (Object e : this.allElements) {
            if (this.aList.contains(e)) continue;
            this.allAttributesModel.addElement(new ElementItem(e));
        }
    }

    private void initAllAttributesList() {
        JPanel jPanel = new JPanel();
        this.allAttributesList = new JList(this.allAttributesModel);
        ListSelectionModel listSelectionModel = this.allAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allAttributesList);
        jScrollPane.setPreferredSize(new Dimension(220, 300));
        jPanel.add(jScrollPane);
        this.generalPanel.add((Component)jPanel, "West");
    }

    private void initSelectedAttributesList() {
        JPanel jPanel = new JPanel();
        this.selectedAttributesList = new JList(this.selectedAttributesModel);
        ListSelectionModel listSelectionModel = this.selectedAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedAttributesList);
        jScrollPane.setPreferredSize(new Dimension(220, 300));
        jPanel.add(jScrollPane);
        this.generalPanel.add((Component)jPanel, "East");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initAttributesButtons() {
        JPanel jPanel = new JPanel();
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAddAttributes = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddAttributes.addActionListener(new AddColumnsActionListener());
        this.btnAddAttributes.setEnabled(false);
        this.btnAddAttributes.setToolTipText(Messages.getString("SelectElementsDialog.Add"));
        this.btnRemoveAttributes = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveAttributes.setEnabled(false);
        this.btnRemoveAttributes.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveAttributes.setToolTipText(Messages.getString("SelectElementsDialog.Remove"));
        jToolBar.add(this.btnAddAttributes);
        jToolBar.add(this.btnRemoveAttributes);
        jPanel.add(jToolBar);
        jPanel.setPreferredSize(new Dimension(32, 300));
        this.generalPanel.add((Component)jPanel, "Center");
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (SelectElementsDialog.this.selectedAttributesList.getSelectedIndex() == -1) {
                    SelectElementsDialog.this.btnRemoveAttributes.setEnabled(false);
                } else {
                    SelectElementsDialog.this.btnRemoveAttributes.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (SelectElementsDialog.this.allAttributesList.getSelectedIndex() == -1) {
                    SelectElementsDialog.this.btnAddAttributes.setEnabled(false);
                } else {
                    SelectElementsDialog.this.btnAddAttributes.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SelectElementsDialog.this.selectedAttributesModel.isEmpty()) {
                Object[] objectArray = SelectElementsDialog.this.selectedAttributesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SelectElementsDialog.this.allAttributesModel.contains(object)) continue;
                    SelectElementsDialog.this.allAttributesModel.addElement(object);
                    SelectElementsDialog.this.selectedAttributesModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SelectElementsDialog.this.allAttributesModel.isEmpty()) {
                Object[] objectArray = SelectElementsDialog.this.allAttributesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SelectElementsDialog.this.selectedAttributesModel.contains(object)) continue;
                    SelectElementsDialog.this.selectedAttributesModel.addElement(object);
                    SelectElementsDialog.this.allAttributesModel.removeElement(object);
                }
            }
        }
    }

    private class ElementItem {
        private Object element = null;

        public ElementItem(Object object) {
            this.element = object;
        }

        public Object getElement() {
            return this.element;
        }

        public String toString() {
            if (this.element != null) {
                if (this.element instanceof DesignObject) {
                    return ((DesignObject)this.element).getLongName();
                }
                return this.element.toString();
            }
            return "";
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectElementsDialog.this.cancel = true;
            SelectElementsDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectElementsDialog.this.cancel = false;
            SelectElementsDialog.this.aList.clear();
            for (int i = 0; i < SelectElementsDialog.this.selectedAttributesModel.size(); ++i) {
                ElementItem elementItem = (ElementItem)SelectElementsDialog.this.selectedAttributesModel.getElementAt(i);
                SelectElementsDialog.this.aList.add(elementItem.getElement());
            }
            SelectElementsDialog.this.dispose();
        }
    }
}

