/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SQLAttribute;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;

public class SQLDimensionPropertiesDialog
extends JDialog {
    private SQLAccessToAW.SQLDimension sqlDim;
    private SQLAccessToAW.SQLDimension origDim;
    private JTabbedPane tabbedPane = new JTabbedPane();
    JPanel contentPane;
    JPanel attributesTab = new JPanel();
    JPanel attributesPanel = new JPanel();
    JPanel levelPanel = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    TitledBorder titledBorder2;
    JScrollPane levelList;
    JCheckBox chbLevelName = new JCheckBox();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JCheckBox chbShortDescription = new JCheckBox();
    JCheckBox chbLongDescription = new JCheckBox();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JCheckBox chbDimensionColumn = new JCheckBox();
    String BTN_OK = Messages.getString("SQLDimensionPropertiesDialog.OK");
    String BTN_APPLY = Messages.getString("SQLDimensionPropertiesDialog.Apply");
    String BTN_CANCEL = Messages.getString("SQLDimensionPropertiesDialog.Cancel");
    private JButton bnCancel;
    String KEY_ESCAPE = "ESCAPE";
    private List selDescAttrs;
    private List allDescAttrs;
    private List selHiers;
    private List allHiers;
    private JTable attributeTable;
    private JTable hiersTable;
    private SQLAccessToAW.SQLHierarchy currentSQLHier;
    private JList dimLevelsList;
    private DefaultListModel selectedLevelsModel;
    private List predefinedAttrs = new ArrayList();
    JScrollPane attrSCRPane;
    JList attrJList;
    JPanel jPanel1 = new JPanel();
    JPanel dimHiersPanel = new JPanel();
    JPanel hiersPane = new JPanel();
    JPanel hierDetailPane = new JPanel();
    Border border11;
    TitledBorder titledBorder11;
    Border border22;
    TitledBorder titledBorder22;
    JScrollPane levelList2 = new JScrollPane();
    JPanel hlistPane = new JPanel();
    JPanel jPanel3 = new JPanel();
    JLabel lbAttribute = new JLabel();
    JCheckBox chbRollup = new JCheckBox();
    JComboBox cbAttribute = new JComboBox();
    TitledBorder titledBorder33;
    TitledBorder titledBorder44;
    GridBagLayout gridBagLayout11 = new GridBagLayout();
    GridBagLayout gridBagLayout22 = new GridBagLayout();
    GridBagLayout gridBagLayout33 = new GridBagLayout();
    GridBagLayout gridBagLayout44 = new GridBagLayout();
    BorderLayout borderLayout11 = new BorderLayout();
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SQLDimensionPropertiesDialog.this.bnCancel.doClick();
        }
    };

    public SQLDimensionPropertiesDialog(ApplicationView applicationView, SQLAccessToAW.SQLDimension sQLDimension) {
        super(applicationView.getFrame());
        this.origDim = sQLDimension;
        SQLAccessToAW sQLAccessToAW = sQLDimension.getSqlawObject();
        sQLAccessToAW.getClass();
        this.sqlDim = sQLAccessToAW.new SQLAccessToAW.SQLDimension(sQLDimension.getDimension(), sQLDimension.getSqlawObject());
        this.origDim.makeCopyTo(this.sqlDim);
        this.setModal(true);
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.tabbedPane.setPreferredSize(new Dimension(355, 470));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(this.BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setMnemonic(79);
        this.getRootPane().setDefaultButton(jButton);
        this.bnCancel = new JButton(this.BTN_CANCEL);
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setPreferredSize(this.bnCancel.getPreferredSize());
        jPanel.add(jButton);
        jPanel.add(this.bnCancel);
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(this.KEY_ESCAPE), this.KEY_ESCAPE);
        jComponent.getActionMap().put(this.KEY_ESCAPE, this.escape);
        this.getContentPane().add((Component)jPanel, "South");
        this.initProperties();
        this.pack();
        this.centerOnScreen(this);
        this.setResizable(false);
    }

    public void centerOnScreen(JDialog jDialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jDialog.getSize();
        Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 3);
        jDialog.setLocation(point);
    }

    private void initProperties() {
        this.makePredefinedAttrList(this.sqlDim);
        this.selDescAttrs = this.sqlDim.getSelectedDescriptiveAttributes();
        this.allDescAttrs = this.sqlDim.getAllDescriptiveAttributes();
        this.selHiers = this.sqlDim.getSelectedSQLHierarhies();
        this.allHiers = this.sqlDim.getAllSQLHierarchies();
        if (this.allHiers.size() > 0) {
            this.currentSQLHier = (SQLAccessToAW.SQLHierarchy)this.allHiers.get(0);
        }
        this.initAttributes2();
        this.initHierarchies();
        this.chbDimensionColumn.setSelected(this.sqlDim.isSelectedDimensionID());
        this.chbLevelName.setSelected(this.sqlDim.isSelectedLevelNameAttr());
        this.chbShortDescription.setSelected(this.sqlDim.isSelectedShortDescAttr());
        this.chbLongDescription.setSelected(this.sqlDim.isSelectedLongDescAttr());
        if (this.allHiers.size() > 0) {
            this.hiersTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        ArrayList<SQLAttribute> arrayList = new ArrayList<SQLAttribute>();
        arrayList.add(null);
        arrayList.add(this.sqlDim.getShortDescAttr());
        arrayList.add(this.sqlDim.getLongDescAttr());
        arrayList.addAll(this.allDescAttrs);
        this.cbAttribute.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.cbAttribute.setSelectedItem(this.currentSQLHier.getLabelAttribute());
        this.chbRollup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLDimensionPropertiesDialog.this.cbAttribute.setEnabled(SQLDimensionPropertiesDialog.this.chbRollup.isSelected());
                SQLDimensionPropertiesDialog.this.dimLevelsList.setEnabled(SQLDimensionPropertiesDialog.this.chbRollup.isSelected());
                SQLDimensionPropertiesDialog.this.currentSQLHier.setRollupForm(SQLDimensionPropertiesDialog.this.chbRollup.isSelected());
            }
        });
        this.cbAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLAttribute sQLAttribute = (SQLAttribute)SQLDimensionPropertiesDialog.this.cbAttribute.getSelectedItem();
                SQLDimensionPropertiesDialog.this.currentSQLHier.setLabelAttribute(sQLAttribute);
            }
        });
        this.cbAttribute.setEnabled(this.chbRollup.isSelected());
        this.dimLevelsList.setEnabled(this.chbRollup.isSelected());
    }

    private void initAttributes2() {
        this.attrJList = new JList(new DefaultListModel());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                Rectangle rectangle = jList.getCellBounds(n, n);
                Object e = jList.getModel().getElementAt(n);
                if (e != null && e instanceof AttrSelection && rectangle.contains(mouseEvent.getPoint())) {
                    AttrSelection attrSelection = (AttrSelection)e;
                    boolean bl = attrSelection.selected;
                    attrSelection.selected = !bl;
                    jList.repaint(rectangle);
                }
            }
        };
        this.attrJList.setCellRenderer(new AttributesCBCellRenderer());
        this.attrJList.addMouseListener(mouseAdapter);
        this.attrJList.setListData(this.predefinedAttrs.toArray());
        int n = 85;
        if (this.sqlDim.getDimension().isTimeDimension()) {
            n = 122;
        }
        this.attributeTable = new JTable(new AttributesTableModel());
        this.border1 = new EtchedBorder(0);
        this.titledBorder1 = new TitledBorder(new EtchedBorder(0), Messages.getString("SQLDimensionPropertiesDialog.PredefinedAttributes"));
        this.border2 = new EtchedBorder(0);
        this.titledBorder2 = new TitledBorder(new EtchedBorder(0), Messages.getString("SQLDimensionPropertiesDialog.DescriptiveAttributes"));
        this.attributesTab.setLayout(this.gridBagLayout1);
        this.attributesPanel.setBorder(this.titledBorder1);
        this.attributesPanel.setLayout(this.gridBagLayout2);
        this.levelPanel.setBorder(this.titledBorder2);
        this.levelPanel.setLayout(this.gridBagLayout3);
        this.levelList = new JScrollPane();
        this.attrSCRPane = new JScrollPane();
        this.attributesTab.setPreferredSize(new Dimension(305, 426));
        this.chbLevelName.setText(Messages.getString("SQLDimensionPropertiesDialog.LevelName"));
        this.chbShortDescription.setText(Messages.getString("SQLDimensionPropertiesDialog.ShortDescription"));
        this.chbLongDescription.setText(Messages.getString("SQLDimensionPropertiesDialog.LongDescription"));
        this.chbDimensionColumn.setText(Messages.getString("SQLDimensionPropertiesDialog.DimensionColumn"));
        this.attributesTab.add((Component)this.attributesPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(16, 12, 0, 14), 57, 4));
        this.attributesTab.add((Component)this.levelPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 11, 14), 4, 4));
        this.levelPanel.add((Component)this.levelList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 4, 8, 5), 256, 246));
        this.levelList.getViewport().add((Component)this.attributeTable, null);
        this.attributesPanel.add((Component)this.attrSCRPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 4, 8, 5), 120, n));
        this.attrSCRPane.getViewport().add((Component)this.attrJList, null);
        this.tabbedPane.add(Messages.getString("SQLDimensionPropertiesDialog.Attributes"), this.attributesTab);
    }

    private void initHierarchies() {
        this.hiersTable = new JTable(new HiersTableModel());
        this.hiersTable.getSelectionModel().addListSelectionListener(new HierSelectionListener());
        this.border11 = new EtchedBorder(0);
        this.titledBorder11 = new TitledBorder(this.border11, Messages.getString("SQLDimensionPropertiesDialog.DimensionHierarchies"));
        this.border22 = new EtchedBorder(0);
        this.titledBorder22 = new TitledBorder(new EtchedBorder(0), Messages.getString("SQLDimensionPropertiesDialog.ShowHierarchyLevels"));
        this.titledBorder33 = new TitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("SQLDimensionPropertiesDialog.Levels"));
        this.titledBorder44 = new TitledBorder("");
        this.dimHiersPanel.setLayout(this.gridBagLayout11);
        this.dimHiersPanel.setPreferredSize(new Dimension(305, 426));
        this.hiersPane.setBorder(this.titledBorder11);
        this.hiersPane.setLayout(this.gridBagLayout22);
        this.hierDetailPane.setBorder(this.titledBorder22);
        this.hierDetailPane.setLayout(this.gridBagLayout33);
        this.hlistPane.setLayout(this.borderLayout11);
        this.lbAttribute.setText(Messages.getString("SQLDimensionPropertiesDialog.LabelAttribute"));
        this.jPanel3.setLayout(this.gridBagLayout44);
        this.chbRollup.setText(Messages.getString("SQLDimensionPropertiesDialog.RollupForm"));
        this.jPanel3.setBorder(this.titledBorder44);
        this.levelList2.setBorder(this.titledBorder33);
        this.hierDetailPane.add((Component)this.levelList2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(13, 10, 2, 7), 222, 106));
        this.hierDetailPane.add((Component)this.jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 7), 5, 8));
        this.jPanel3.add((Component)this.chbRollup, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 9, 4));
        this.jPanel3.add((Component)this.lbAttribute, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 13, 0), 24, 0));
        this.jPanel3.add((Component)this.cbAttribute, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 13, 5), 100, 0));
        this.dimHiersPanel.add((Component)this.hiersPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(16, 12, 0, 9), 6, 5));
        this.dimHiersPanel.add((Component)this.hierDetailPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(11, 12, 14, 9), 7, 4));
        this.hiersPane.add((Component)this.hlistPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 4, 5, 6), 241, 90));
        JScrollPane jScrollPane = new JScrollPane(this.hiersTable);
        this.hlistPane.add(jScrollPane);
        this.initDimLevelsList();
        this.tabbedPane.add(Messages.getString("SQLDimensionPropertiesDialog.Hierarchies"), this.dimHiersPanel);
    }

    private void initDimLevelsList() {
        this.selectedLevelsModel = new DefaultListModel();
        this.dimLevelsList = new JList(this.selectedLevelsModel);
        this.levelList2.getViewport().add((Component)this.dimLevelsList, null);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!SQLDimensionPropertiesDialog.this.dimLevelsList.isEnabled()) {
                    return;
                }
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                Rectangle rectangle = jList.getCellBounds(n, n);
                Object e = jList.getModel().getElementAt(n);
                if (e != null && SQLDimensionPropertiesDialog.this.currentSQLHier != null && e instanceof Level && rectangle.contains(mouseEvent.getPoint())) {
                    Level level = (Level)e;
                    boolean bl = SQLDimensionPropertiesDialog.this.currentSQLHier.isLevelSelected(level);
                    SQLDimensionPropertiesDialog.this.currentSQLHier.setLevelSelection(level, !bl);
                    jList.repaint(rectangle);
                }
            }
        };
        this.dimLevelsList.setCellRenderer(new CBCellRenderer());
        this.dimLevelsList.addMouseListener(mouseAdapter);
    }

    public String getCaption() {
        return MessageFormat.format(Messages.getString("SQLDimensionPropertiesDialog.AttributesHierarchiesForDimension"), this.sqlDim.getDimension().getName());
    }

    private void setProperties() {
        for (AttrSelection attrSelection : this.predefinedAttrs) {
            if (SQLAccessToAW.ATTR_TYPE_SHORT_DESC.equals(attrSelection.type)) {
                this.sqlDim.setSelectedShortDescAttr(attrSelection.selected);
            } else if (SQLAccessToAW.ATTR_TYPE_LONG_DESC.equals(attrSelection.type)) {
                this.sqlDim.setSelectedLongDescAttr(attrSelection.selected);
            } else if (SQLAccessToAW.ATTR_TYPE_LEVEL_NAME.equals(attrSelection.type)) {
                this.sqlDim.setSelectedLevelNameAttr(attrSelection.selected);
            } else if (SQLAccessToAW.ATTR_TYPE_DIMENSION_ID.equals(attrSelection.type)) {
                this.sqlDim.setSelectedDimensionID(attrSelection.selected);
            }
            if (!this.sqlDim.getDimension().isTimeDimension()) continue;
            if (SQLAccessToAW.ATTR_TYPE_END_DATE.equals(attrSelection.type)) {
                this.sqlDim.setSelectedEndDate(attrSelection.selected);
                continue;
            }
            if (!SQLAccessToAW.ATTR_TYPE_TIME_SPAN.equals(attrSelection.type)) continue;
            this.sqlDim.setSelectedTimeSpan(attrSelection.selected);
        }
        this.sqlDim.makeCopyTo(this.origDim);
    }

    private void enableHierDetails(boolean bl) {
        this.cbAttribute.setEnabled(bl && this.chbRollup.isSelected());
        this.dimLevelsList.setEnabled(bl && this.chbRollup.isSelected());
        this.chbRollup.setEnabled(bl);
    }

    private void makePredefinedAttrList(SQLAccessToAW.SQLDimension sQLDimension) {
        this.predefinedAttrs.clear();
        AttrSelection attrSelection = new AttrSelection();
        attrSelection.selected = sQLDimension.isSelectedShortDescAttr();
        attrSelection.type = sQLDimension.getShortDescAttr().getType();
        this.predefinedAttrs.add(attrSelection);
        attrSelection = new AttrSelection();
        attrSelection.selected = sQLDimension.isSelectedLongDescAttr();
        attrSelection.type = sQLDimension.getLongDescAttr().getType();
        this.predefinedAttrs.add(attrSelection);
        if (sQLDimension.getDimension().isTimeDimension()) {
            attrSelection = new AttrSelection();
            attrSelection.selected = sQLDimension.isSelectedEndDate();
            attrSelection.type = sQLDimension.getEndDateAttr().getType();
            this.predefinedAttrs.add(attrSelection);
            attrSelection = new AttrSelection();
            attrSelection.selected = sQLDimension.isSelectedTimeSpan();
            attrSelection.type = sQLDimension.getTimeSpanAttr().getType();
            this.predefinedAttrs.add(attrSelection);
        }
        attrSelection = new AttrSelection();
        attrSelection.selected = sQLDimension.isSelectedLevelNameAttr();
        attrSelection.type = sQLDimension.getLevelNameAttr().getType();
        this.predefinedAttrs.add(attrSelection);
        attrSelection = new AttrSelection();
        attrSelection.selected = sQLDimension.isSelectedDimensionID();
        attrSelection.type = sQLDimension.getDimensionIDAttr().getType();
        this.predefinedAttrs.add(attrSelection);
    }

    class AttrSelection {
        boolean selected;
        String type;

        AttrSelection() {
        }

        public String toString() {
            return this.type;
        }
    }

    public class HierSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = ((ListSelectionModel)listSelectionEvent.getSource()).getAnchorSelectionIndex();
            if (n != -1 && SQLDimensionPropertiesDialog.this.currentSQLHier != null) {
                SQLAccessToAW.SQLHierarchy sQLHierarchy = (SQLAccessToAW.SQLHierarchy)SQLDimensionPropertiesDialog.this.allHiers.get(n);
                SQLDimensionPropertiesDialog.this.currentSQLHier = sQLHierarchy;
                Boolean bl = (Boolean)SQLDimensionPropertiesDialog.this.hiersTable.getModel().getValueAt(n, 1);
                boolean bl2 = bl;
                SQLDimensionPropertiesDialog.this.dimLevelsList.setListData(sQLHierarchy.getHierarchy().getLevels().toArray());
                SQLDimensionPropertiesDialog.this.cbAttribute.setSelectedItem(SQLDimensionPropertiesDialog.this.currentSQLHier.getLabelAttribute());
                SQLDimensionPropertiesDialog.this.chbRollup.setSelected(SQLDimensionPropertiesDialog.this.currentSQLHier.isRollupForm());
                SQLDimensionPropertiesDialog.this.enableHierDetails(bl2);
            }
        }
    }

    class AttributesCBCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        AttributesCBCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            AttrSelection attrSelection = (AttrSelection)object;
            this.setSelected(attrSelection.selected);
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
            this.setOpaque(true);
            return this;
        }
    }

    class CBCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CBCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            Level level = (Level)object;
            this.setSelected(SQLDimensionPropertiesDialog.this.currentSQLHier.isLevelSelected(level));
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
            this.setOpaque(true);
            return this;
        }
    }

    private class HiersTableModel
    extends AbstractTableModel {
        private HiersTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SQLDimensionPropertiesDialog.this.allHiers.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SQLDimensionPropertiesDialog.Hierarchy");
            }
            if (n == 1) {
                return Messages.getString("SQLDimensionPropertiesDialog.UseIt");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1 && object instanceof Boolean) {
                SQLAccessToAW.SQLHierarchy sQLHierarchy = (SQLAccessToAW.SQLHierarchy)SQLDimensionPropertiesDialog.this.allHiers.get(n);
                boolean bl = (Boolean)object;
                if (bl) {
                    if (!SQLDimensionPropertiesDialog.this.selHiers.contains(sQLHierarchy)) {
                        SQLDimensionPropertiesDialog.this.selHiers.add(sQLHierarchy);
                    }
                } else {
                    SQLDimensionPropertiesDialog.this.selHiers.remove(sQLHierarchy);
                }
                SQLDimensionPropertiesDialog.this.enableHierDetails(bl);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SQLAccessToAW.SQLHierarchy sQLHierarchy = (SQLAccessToAW.SQLHierarchy)SQLDimensionPropertiesDialog.this.allHiers.get(n);
            if (n2 == 0) {
                return sQLHierarchy.getHierarchy().getName();
            }
            if (n2 == 1) {
                return new Boolean(SQLDimensionPropertiesDialog.this.selHiers.contains(sQLHierarchy));
            }
            return null;
        }
    }

    private class AttributesTableModel
    extends AbstractTableModel {
        private AttributesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SQLDimensionPropertiesDialog.this.allDescAttrs.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SQLDimensionPropertiesDialog.Level");
            }
            if (n == 1) {
                return Messages.getString("SQLDimensionPropertiesDialog.Attribute");
            }
            if (n == 2) {
                return Messages.getString("SQLDimensionPropertiesDialog.UseIt");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2 && object instanceof Boolean) {
                SQLAttribute sQLAttribute = (SQLAttribute)SQLDimensionPropertiesDialog.this.allDescAttrs.get(n);
                boolean bl = (Boolean)object;
                if (bl) {
                    if (!SQLDimensionPropertiesDialog.this.selDescAttrs.contains(sQLAttribute)) {
                        SQLDimensionPropertiesDialog.this.selDescAttrs.add(sQLAttribute);
                    }
                } else {
                    SQLDimensionPropertiesDialog.this.selDescAttrs.remove(sQLAttribute);
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SQLAttribute sQLAttribute = (SQLAttribute)SQLDimensionPropertiesDialog.this.allDescAttrs.get(n);
            if (n2 == 0) {
                return sQLAttribute.getLevel().getName();
            }
            if (n2 == 1) {
                return sQLAttribute.getSlowChangingAttribute().getName();
            }
            if (n2 == 2) {
                return new Boolean(SQLDimensionPropertiesDialog.this.selDescAttrs.contains(sQLAttribute));
            }
            return null;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SQLDimensionPropertiesDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SQLDimensionPropertiesDialog.this.setProperties();
            SQLDimensionPropertiesDialog.this.dispose();
        }
    }
}

