/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SQLDimensionPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SQLStatementsDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectElementsDialog;

public class SQLAccessToAWPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private SQLAccessToAW sqlAccessToAW;
    private SQLAccessToAW origin;
    private JTextField tfObjTypeName;
    private JTextField tfTableTypeName;
    private JTextField tfAWName;
    private Slice slice;
    private JCheckBox chGenerateGIDs;
    private JCheckBox chUseObjectTypes;
    private JCheckBox chUseModel;
    private Cube cube;
    private JButton btnSQL;
    private JCheckBox chUseRowtoCell;
    private JButton btnAddSL;
    private JButton btnRemoveSL;
    private JTable dimsTable;
    private List selectedDimensions;
    private List allDimensions;
    private JTable sTable;
    private JButton btnProperties;
    private JButton btnAdd;
    private JButton btnRemove;
    private List selectedMeasureWrappers;
    private List allMeasureWrappers;
    private JPanel pnDimensions;
    private JPanel pnMeasures;

    public SQLAccessToAWPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.AWName"));
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfAWName = new JTextField("");
        this.tfAWName.setPreferredSize(this.getDefaultSize());
        this.tfAWName.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfAWName));
        JLabel jLabel2 = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.IncludeGIDs"));
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.chGenerateGIDs = new JCheckBox();
        this.chGenerateGIDs.setPreferredSize(this.getDefaultSize());
        this.chGenerateGIDs.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.chGenerateGIDs));
        JLabel jLabel3 = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.UseObjectTypes"));
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.chUseObjectTypes = new JCheckBox();
        this.chUseObjectTypes.setPreferredSize(this.getDefaultSize());
        this.chUseObjectTypes.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.chUseObjectTypes));
        JLabel jLabel4 = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.ObjectTypeName"));
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.tfObjTypeName = new JTextField("");
        this.tfObjTypeName.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.tfObjTypeName));
        JLabel jLabel5 = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.TableTypeName"));
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.tfTableTypeName = new JTextField("");
        this.tfTableTypeName.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.tfTableTypeName));
        JLabel jLabel6 = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.UseModelClause"));
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.chUseModel = new JCheckBox();
        this.chUseModel.setEnabled(false);
        this.chUseModel.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.chUseModel));
        JLabel jLabel7 = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.IncludeRowToCell"));
        jLabel7.setPreferredSize(this.getDefaultSize());
        this.chUseRowtoCell = new JCheckBox();
        this.chUseRowtoCell.setEnabled(false);
        this.chUseRowtoCell.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel7, this.chUseRowtoCell));
        this.tfObjTypeName.setEnabled(this.chUseObjectTypes.isSelected());
        this.tfTableTypeName.setEnabled(this.chUseObjectTypes.isSelected());
        this.chUseObjectTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLAccessToAWPropertiesDialogEx.this.enableControls();
            }
        });
        JLabel jLabel8 = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.SQLStatements"));
        jLabel8.setPreferredSize(this.getDefaultSize());
        this.btnSQL = new JButton(Messages.getString("SQLAccessToAWPropertiesDialogEx.SQL"));
        this.btnSQL.setPreferredSize(this.getDefaultSize());
        this.btnSQL.setHorizontalAlignment(0);
        this.addRowToGeneralPanel(this.createRow(jLabel8, this.btnSQL));
        this.btnSQL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setName(SQLAccessToAWPropertiesDialogEx.this.tfName.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setComment(SQLAccessToAWPropertiesDialogEx.this.taComments.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setNotes(SQLAccessToAWPropertiesDialogEx.this.taNotes.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setDescription(SQLAccessToAWPropertiesDialogEx.this.taDescription.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setGenerateGIDs(SQLAccessToAWPropertiesDialogEx.this.chGenerateGIDs.isSelected());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setUseObjectType(SQLAccessToAWPropertiesDialogEx.this.chUseObjectTypes.isSelected());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setObjectADTName(SQLAccessToAWPropertiesDialogEx.this.tfObjTypeName.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setTableADTName(SQLAccessToAWPropertiesDialogEx.this.tfTableTypeName.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.getSqlDimensionDefinitions().clear();
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.getSqlDimensionDefinitions().addAll(SQLAccessToAWPropertiesDialogEx.this.selectedDimensions);
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setAWName(SQLAccessToAWPropertiesDialogEx.this.tfAWName.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setUseRowToCellColumn(SQLAccessToAWPropertiesDialogEx.this.chUseRowtoCell.isSelected());
                if (SQLAccessToAWPropertiesDialogEx.this.slice != null) {
                    SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.getMeasureWrappers().clear();
                    SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.getMeasureWrappers().addAll(SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers);
                } else {
                    SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.getMeasures().clear();
                    SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.getMeasures().addAll(SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers);
                }
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.verifyDefinitions();
                SQLStatementsDialog sQLStatementsDialog = new SQLStatementsDialog(SQLAccessToAWPropertiesDialogEx.this.getAppView(), SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW, !SQLAccessToAWPropertiesDialogEx.this.isEditable());
                sQLStatementsDialog.show();
            }
        });
    }

    private void enableControls() {
        if (this.isEditable()) {
            this.tfObjTypeName.setEnabled(this.chUseObjectTypes.isSelected());
            this.tfTableTypeName.setEnabled(this.chUseObjectTypes.isSelected());
            if (this.chUseObjectTypes.isSelected()) {
                String string = this.tfObjTypeName.getText().trim();
                if ("".equals(string)) {
                    this.tfObjTypeName.setText(this.tfName.getText() + "_row");
                }
                if ("".equals(string = this.tfTableTypeName.getText().trim())) {
                    this.tfTableTypeName.setText(this.tfName.getText() + "_table");
                }
            }
        }
    }

    @Override
    public String getCaption() {
        return Messages.getString("SQLAccessToAWPropertiesDialogEx.SQLAccessOracleAW");
    }

    @Override
    protected String getHelpIndex() {
        return "SQL_ACCESS_TO_ORACLE_AW_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof SQLAccessToAW) {
            this.origin = (SQLAccessToAW)designObject;
            this.origin.verifyDefinitions();
            this.slice = this.origin.getSlice();
            this.cube = this.origin.getCube();
            this.sqlAccessToAW = this.origin.makeCopy();
            this.initDefaults(false);
            this.taDescription.setText(this.sqlAccessToAW.getDescription());
            this.tfAWName.setText(this.sqlAccessToAW.getAWName());
            this.chGenerateGIDs.setSelected(this.sqlAccessToAW.isGenerateGIDs());
            this.chUseObjectTypes.setSelected(this.sqlAccessToAW.isUseObjectType());
            this.tfObjTypeName.setText(this.sqlAccessToAW.getObjectADTName());
            this.tfTableTypeName.setText(this.sqlAccessToAW.getTableADTName());
            this.chUseModel.setSelected(this.sqlAccessToAW.isUseModelClause());
            this.chUseRowtoCell.setSelected(this.sqlAccessToAW.isUseRowToCellColumn());
            this.selectedDimensions.addAll(this.sqlAccessToAW.getSqlDimensionDefinitions());
            this.allDimensions.addAll(this.sqlAccessToAW.getAllSQLDimensions());
            if (this.slice != null) {
                this.selectedMeasureWrappers.addAll(this.sqlAccessToAW.getMeasureWrappers());
                this.allMeasureWrappers.addAll(this.sqlAccessToAW.getAllMeasureWrappers());
            } else {
                this.selectedMeasureWrappers.addAll(this.sqlAccessToAW.getMeasures());
                this.allMeasureWrappers.addAll(this.sqlAccessToAW.getAllMeasures());
            }
            this.enableControls();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.sqlAccessToAW.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.sqlAccessToAW.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getDimensionsAndAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasuresPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDescriptionPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.sqlAccessToAW.setName(this.tfName.getText());
        this.sqlAccessToAW.setComment(this.taComments.getText());
        this.sqlAccessToAW.setNotes(this.taNotes.getText());
        this.sqlAccessToAW.setDescription(this.taDescription.getText());
        this.sqlAccessToAW.setGenerateGIDs(this.chGenerateGIDs.isSelected());
        this.sqlAccessToAW.setUseObjectType(this.chUseObjectTypes.isSelected());
        this.sqlAccessToAW.setObjectADTName(this.tfObjTypeName.getText());
        this.sqlAccessToAW.setTableADTName(this.tfTableTypeName.getText());
        this.sqlAccessToAW.getSqlDimensionDefinitions().clear();
        this.sqlAccessToAW.getSqlDimensionDefinitions().addAll(this.selectedDimensions);
        this.sqlAccessToAW.setAWName(this.tfAWName.getText());
        this.sqlAccessToAW.setUseRowToCellColumn(this.chUseRowtoCell.isSelected());
        if (this.slice != null) {
            this.sqlAccessToAW.getMeasureWrappers().clear();
            this.sqlAccessToAW.getMeasureWrappers().addAll(this.selectedMeasureWrappers);
        } else {
            this.sqlAccessToAW.getMeasures().clear();
            this.sqlAccessToAW.getMeasures().addAll(this.selectedMeasureWrappers);
        }
        this.sqlAccessToAW.makeCopyTo(this.origin);
        this.origin.verifyDefinitions();
        SQLAccessToAWPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.sqlAccessToAW.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.sqlAccessToAW.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    protected JPanel getDimensionsAndAttributesPanel() {
        if (this.pnDimensions == null) {
            this.pnDimensions = this.createPage(Messages.getString("SQLAccessToAWPropertiesDialogEx.DimensionsAndAttributes"));
            this.selectedDimensions = new ArrayList();
            this.allDimensions = new ArrayList();
            this.dimsTable = new JTable(new DimensionsTableModel());
            this.dimsTable.setSelectionMode(0);
            this.dimsTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = SQLAccessToAWPropertiesDialogEx.this.dimsTable.getSelectedRow()) != -1 && SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size() > 0 && n < SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size()) {
                        SQLAccessToAW.SQLDimension sQLDimension = (SQLAccessToAW.SQLDimension)SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.get(n);
                        SQLDimensionPropertiesDialog sQLDimensionPropertiesDialog = new SQLDimensionPropertiesDialog(SQLAccessToAWPropertiesDialogEx.this.getAppView(), sQLDimension);
                        sQLDimensionPropertiesDialog.show();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.dimsTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SQLAccessToAWPropertiesDialogEx.this.dimsTable.getSelectedRow();
                    if (n != -1 && SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size() > 0 && n < SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size()) {
                        SQLAccessToAW.SQLDimension sQLDimension = (SQLAccessToAW.SQLDimension)SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.get(n);
                        SQLDimensionPropertiesDialog sQLDimensionPropertiesDialog = new SQLDimensionPropertiesDialog(SQLAccessToAWPropertiesDialogEx.this.getAppView(), sQLDimension);
                        sQLDimensionPropertiesDialog.show();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                this.btnAddSL = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAddSL.setToolTipText(BTN_ADD);
                this.btnAddSL.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SelectElementsDialog selectElementsDialog = new SelectElementsDialog(SQLAccessToAWPropertiesDialogEx.this.getAppView(), SQLAccessToAWPropertiesDialogEx.this.allDimensions, SQLAccessToAWPropertiesDialogEx.this.selectedDimensions);
                        selectElementsDialog.show();
                        SQLAccessToAWPropertiesDialogEx.this.dimsTable.updateUI();
                    }
                });
                this.btnRemoveSL = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveSL.setToolTipText(BTN_REMOVE);
                this.btnRemoveSL.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = SQLAccessToAWPropertiesDialogEx.this.dimsTable.getSelectedRow();
                        if (n != -1 && SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size() > 0 && n < SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size()) {
                            SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.remove(n);
                            SQLAccessToAWPropertiesDialogEx.this.dimsTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnAddSL);
                jToolBar.add(this.btnRemoveSL);
            }
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnDimensions.add(jPanel2);
        }
        return this.pnDimensions;
    }

    protected JPanel getMeasuresPanel() {
        if (this.pnMeasures == null) {
            this.pnMeasures = this.createPage(Messages.getString("SQLAccessToAWPropertiesDialogEx.25"));
            this.selectedMeasureWrappers = new ArrayList();
            this.allMeasureWrappers = new ArrayList();
            this.sTable = new JTable(new MeasureWrappersModel());
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = SQLAccessToAWPropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && n < SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                        ModelIDObject modelIDObject = null;
                        if (SQLAccessToAWPropertiesDialogEx.this.slice != null) {
                            Slice.MeasureWrapper measureWrapper = (Slice.MeasureWrapper)SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.get(n);
                            modelIDObject = (Measure)SQLAccessToAWPropertiesDialogEx.this.slice.getMultidimensionalDesign().getMeasureSet().getObjectByID(measureWrapper.getMeasure().getObjectID());
                        } else if (SQLAccessToAWPropertiesDialogEx.this.cube != null) {
                            modelIDObject = (Measure)SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.get(n);
                            modelIDObject = (Measure)SQLAccessToAWPropertiesDialogEx.this.cube.getMultidimensionalDesign().getMeasureSet().getObjectByID(modelIDObject.getObjectID());
                        }
                        if (modelIDObject != null && !modelIDObject.isDialogVisible()) {
                            ((Measure)modelIDObject).showModal = true;
                            ((Measure)modelIDObject).showPropertyDialog();
                        }
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.sTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SQLAccessToAWPropertiesDialogEx.this.sTable.getSelectedRow();
                    if (n != -1 && SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && n < SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                        ModelIDObject modelIDObject = null;
                        if (SQLAccessToAWPropertiesDialogEx.this.slice != null) {
                            Slice.MeasureWrapper measureWrapper = (Slice.MeasureWrapper)SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.get(n);
                            modelIDObject = (Measure)SQLAccessToAWPropertiesDialogEx.this.slice.getMultidimensionalDesign().getMeasureSet().getObjectByID(measureWrapper.getMeasure().getObjectID());
                        } else if (SQLAccessToAWPropertiesDialogEx.this.cube != null) {
                            modelIDObject = (Measure)SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.get(n);
                            modelIDObject = (Measure)SQLAccessToAWPropertiesDialogEx.this.cube.getMultidimensionalDesign().getMeasureSet().getObjectByID(modelIDObject.getObjectID());
                        }
                        if (modelIDObject != null && !modelIDObject.isDialogVisible()) {
                            ((Measure)modelIDObject).showModal = true;
                            ((Measure)modelIDObject).showPropertyDialog();
                        }
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ArrayList arrayList = new ArrayList();
                        arrayList.addAll(SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers);
                        SelectElementsDialog selectElementsDialog = new SelectElementsDialog(SQLAccessToAWPropertiesDialogEx.this.getAppView(), SQLAccessToAWPropertiesDialogEx.this.allMeasureWrappers, SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers);
                        selectElementsDialog.show();
                        SQLAccessToAWPropertiesDialogEx.this.sTable.updateUI();
                    }
                });
                this.btnRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = SQLAccessToAWPropertiesDialogEx.this.sTable.getSelectedRow();
                        if (n != -1 && SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && n < SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                            SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.remove(n);
                            SQLAccessToAWPropertiesDialogEx.this.sTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnAdd);
                jToolBar.add(this.btnRemove);
            }
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnMeasures.add(jPanel2);
        }
        return this.pnMeasures;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class MeasureWrappersModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SQLAccessToAWPropertiesDialogEx.Measure"), Messages.getString("SQLAccessToAWPropertiesDialogEx.AggregateFunction"), Messages.getString("SQLAccessToAWPropertiesDialogEx.MeasureAlias")};

        @Override
        public int getColumnCount() {
            if (SQLAccessToAWPropertiesDialogEx.this.slice != null) {
                return this.COL_NAMES.length;
            }
            return 1;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            if (SQLAccessToAWPropertiesDialogEx.this.slice != null) {
                return this.COL_NAMES[n];
            }
            return this.COL_NAMES[0];
        }

        @Override
        public int getRowCount() {
            return SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (SQLAccessToAWPropertiesDialogEx.this.slice != null) {
                Slice.MeasureWrapper measureWrapper = (Slice.MeasureWrapper)SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.get(n);
                if (n2 == 0) {
                    return measureWrapper.getMeasure().getName();
                }
                if (n2 == 1) {
                    return measureWrapper.getAggrFunction().name;
                }
                if (n2 == 2) {
                    return measureWrapper.getAggrFunction().measureAlias;
                }
                return "";
            }
            Measure measure = (Measure)SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.get(n);
            return measure.getName();
        }
    }

    private class DimensionsTableModel
    extends AbstractTableModel {
        private DimensionsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SQLAccessToAWPropertiesDialogEx.Dimension");
            }
            if (n == 1) {
                return Messages.getString("SQLAccessToAWPropertiesDialogEx.UseDimensionColumn");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!SQLAccessToAWPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1 && object instanceof Boolean) {
                SQLAccessToAW.SQLDimension sQLDimension = (SQLAccessToAW.SQLDimension)SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.get(n);
                sQLDimension.setSelectedDimensionID((Boolean)object);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SQLAccessToAW.SQLDimension sQLDimension = (SQLAccessToAW.SQLDimension)SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.get(n);
            if (n2 == 0) {
                return sQLDimension.getDimension().getName();
            }
            if (n2 == 1) {
                return new Boolean(sQLDimension.isSelectedDimensionID());
            }
            return null;
        }
    }
}

