/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PresummarizedLevelsDialog
extends JDialog
implements AbstractEditorConstants {
    private List inputList;
    private List dimensions;
    private JList dimLevelsList;
    private JList dimensionsList;
    private DefaultListModel dimensionsModel;
    private DefaultListModel selectedLevelsModel;
    protected JPanel generalPanel;
    private List selectedLevels;
    public boolean cancel = true;

    public PresummarizedLevelsDialog(ApplicationView applicationView, List list, List list2, String string) {
        super(applicationView.getFrame());
        this.setModal(true);
        this.selectedLevels = new ArrayList();
        this.selectedLevels.addAll(list2);
        this.inputList = list2;
        this.dimensions = list;
        this.setTitle(string);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PresummarizedLevelsDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.dimensionsModel = new DefaultListModel();
        this.selectedLevelsModel = new DefaultListModel();
        this.init();
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(BTN_CANCEL);
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void init() {
        this.initDimensionsList();
        this.initDimLevelsList();
        this.fillLists();
    }

    private void fillLists() {
        for (Object e : this.dimensions) {
            this.dimensionsModel.addElement(e);
        }
        if (this.dimensions.size() > 0) {
            Object e;
            e = this.dimensions.get(0);
            this.fillLevelsList((oracle.dbtools.crest.model.design.multidimensional.Dimension)e);
        }
    }

    private void initDimensionsList() {
        JPanel jPanel = new JPanel();
        this.dimensionsList = new JList(this.dimensionsModel);
        ListSelectionModel listSelectionModel = this.dimensionsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.dimensionsList);
        jScrollPane.setPreferredSize(new Dimension(220, 300));
        jPanel.add(jScrollPane);
        this.generalPanel.add((Component)jPanel, "West");
    }

    private void initDimLevelsList() {
        JPanel jPanel = new JPanel();
        this.dimLevelsList = new JList(this.selectedLevelsModel);
        JScrollPane jScrollPane = new JScrollPane(this.dimLevelsList);
        jScrollPane.setPreferredSize(new Dimension(220, 300));
        jPanel.add(jScrollPane);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                Rectangle rectangle = jList.getCellBounds(n, n);
                Object e = jList.getModel().getElementAt(n);
                if (e != null && e instanceof Level && rectangle.contains(mouseEvent.getPoint())) {
                    if (PresummarizedLevelsDialog.this.selectedLevels.indexOf(e) > -1) {
                        PresummarizedLevelsDialog.this.selectedLevels.remove(e);
                    } else {
                        PresummarizedLevelsDialog.this.selectedLevels.add(e);
                    }
                    jList.repaint(rectangle);
                }
            }
        };
        this.dimLevelsList.setCellRenderer(new CBCellRenderer());
        this.dimLevelsList.addMouseListener(mouseAdapter);
        this.generalPanel.add((Component)jPanel, "East");
    }

    private void fillLevelsList(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        this.dimLevelsList.setListData(dimension.getAllLevels().toArray());
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    class CBCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CBCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            this.setSelected(PresummarizedLevelsDialog.this.selectedLevels.indexOf(object) > -1);
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
            this.setOpaque(true);
            return this;
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting() && PresummarizedLevelsDialog.this.dimensionsList.getSelectedIndex() > -1) {
                oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)PresummarizedLevelsDialog.this.dimensions.get(PresummarizedLevelsDialog.this.dimensionsList.getSelectedIndex());
                if (dimension.getBaseLevel() != null && !dimension.getBaseLevel().isValueBasedHierarchy()) {
                    PresummarizedLevelsDialog.this.fillLevelsList(dimension);
                } else {
                    PresummarizedLevelsDialog.this.dimLevelsList.setListData(new Object[0]);
                    PresummarizedLevelsDialog.this.dimLevelsList.updateUI();
                }
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PresummarizedLevelsDialog.this.cancel = true;
            PresummarizedLevelsDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PresummarizedLevelsDialog.this.cancel = false;
            PresummarizedLevelsDialog.this.inputList.clear();
            PresummarizedLevelsDialog.this.inputList.addAll(PresummarizedLevelsDialog.this.selectedLevels);
            PresummarizedLevelsDialog.this.dispose();
        }
    }
}

