/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;

public class HierarchyPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private Hierarchy hierarchy;
    private JCheckBox chValueBased;
    private JTable levelsTable;
    private List levelsList;
    private JTable linksTable;
    private List linksList;
    private JCheckBox chRaggedHier;
    private JCheckBox chDefaultdHier;
    private JPanel pnLevels;
    private JPanel pnLinks;

    public HierarchyPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_VALUE_BASED);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.chValueBased = new JCheckBox();
        this.chValueBased.setPreferredSize(this.getDefaultSize());
        this.chValueBased.setEnabled(false);
        this.chValueBased.setToolTipText(Messages.getString("HierarchyPropertiesDialogEx.FirstAttachedLevel"));
        this.addRowToGeneralPanel(this.createRow(jLabel, this.chValueBased));
        JLabel jLabel2 = new JLabel(Messages.getString("HierarchyPropertiesDialogEx.RaggedHierarchy"));
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.chRaggedHier = new JCheckBox();
        this.chRaggedHier.setPreferredSize(this.getDefaultSize());
        this.chRaggedHier.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.chRaggedHier));
        JLabel jLabel3 = new JLabel(Messages.getString("HierarchyPropertiesDialogEx.DefaultHierarchy"));
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.chDefaultdHier = new JCheckBox();
        this.chDefaultdHier.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.chDefaultdHier));
    }

    @Override
    public String getCaption() {
        return Messages.getString("HierarchyPropertiesDialogEx.HierarchyProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "HIERARCHY_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Hierarchy) {
            this.hierarchy = (Hierarchy)designObject;
            this.initDefaults(false);
            this.taDescription.setText(this.hierarchy.getDescription());
            this.chValueBased.setSelected(this.hierarchy.isValueBasedHierarchy());
            this.chRaggedHier.setSelected(this.hierarchy.isRaggedHierarchy());
            this.chDefaultdHier.setSelected(this.hierarchy.isDefaultHierarchy());
            this.levelsList.addAll(this.hierarchy.getLevels());
            this.linksList.addAll(this.hierarchy.getLinks());
            this.initOracleNames();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.hierarchy.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.hierarchy.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.levelsList = new ArrayList();
        this.linksList = new ArrayList();
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getLevelsPanel());
        this.addToTree(defaultMutableTreeNode, this.getLinksPanel());
        this.addToTree(defaultMutableTreeNode, this.getOracleNamesPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDescriptionPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.hierarchy.setName(this.tfName.getText());
        this.hierarchy.setComment(this.taComments.getText());
        this.hierarchy.setNotes(this.taNotes.getText());
        this.hierarchy.setDescription(this.taDescription.getText());
        this.hierarchy.setDefaultHierarchy(this.chDefaultdHier.isSelected());
        this.setOracleNames();
        this.setResponsibleParties();
        this.setDocuments();
        HierarchyPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.hierarchy.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.hierarchy.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    protected JPanel getLevelsPanel() {
        if (this.pnLevels == null) {
            this.pnLevels = this.createPage(Messages.getString("HierarchyPropertiesDialogEx.Levels"));
            this.levelsTable = new JTable(new LevelTableModel());
            this.levelsTable.setSelectionMode(0);
            this.levelsTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = HierarchyPropertiesDialogEx.this.levelsTable.getSelectedRow()) != -1 && HierarchyPropertiesDialogEx.this.levelsList.size() > 0 && n < HierarchyPropertiesDialogEx.this.levelsList.size()) {
                        Level level = (Level)HierarchyPropertiesDialogEx.this.levelsList.get(n);
                        level.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.levelsTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = HierarchyPropertiesDialogEx.this.levelsTable.getSelectedRow();
                    if (n != -1 && HierarchyPropertiesDialogEx.this.levelsList.size() > 0 && n < HierarchyPropertiesDialogEx.this.levelsList.size()) {
                        Level level = (Level)HierarchyPropertiesDialogEx.this.levelsList.get(n);
                        level.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnLevels.add(jPanel2);
        }
        return this.pnLevels;
    }

    protected JPanel getLinksPanel() {
        if (this.pnLinks == null) {
            this.pnLinks = this.createPage(Messages.getString("HierarchyPropertiesDialogEx.RollupLinks"));
            this.linksTable = new JTable(new LinkTableModel());
            this.linksTable.setSelectionMode(0);
            this.linksTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = HierarchyPropertiesDialogEx.this.linksTable.getSelectedRow()) != -1 && HierarchyPropertiesDialogEx.this.linksList.size() > 0 && n < HierarchyPropertiesDialogEx.this.linksList.size()) {
                        RollupLink rollupLink = (RollupLink)HierarchyPropertiesDialogEx.this.linksList.get(n);
                        rollupLink.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.linksTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = HierarchyPropertiesDialogEx.this.linksTable.getSelectedRow();
                    if (n != -1 && HierarchyPropertiesDialogEx.this.linksList.size() > 0 && n < HierarchyPropertiesDialogEx.this.linksList.size()) {
                        RollupLink rollupLink = (RollupLink)HierarchyPropertiesDialogEx.this.linksList.get(n);
                        rollupLink.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnLinks.add(jPanel2);
        }
        return this.pnLinks;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class LinkTableModel
    extends AbstractTableModel {
        private LinkTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return HierarchyPropertiesDialogEx.this.linksList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("HierarchyPropertiesDialogEx.RollupLinks");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            RollupLink rollupLink = (RollupLink)HierarchyPropertiesDialogEx.this.linksList.get(n);
            if (n2 == 0) {
                return rollupLink.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class LevelTableModel
    extends AbstractTableModel {
        private LevelTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return HierarchyPropertiesDialogEx.this.levelsList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("HierarchyPropertiesDialogEx.Levels");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Level level = (Level)HierarchyPropertiesDialogEx.this.levelsList.get(n);
            if (n2 == 0) {
                return level.getName();
            }
            return new Integer(n * n2);
        }
    }
}

