/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;

public class FEJoinPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private FactEntitiesJoin feJoin;
    private JComboBox cbLeftEntity;
    private JComboBox cbRightEntity;
    private JComboBox cbExistingRelation;
    private JComboBox cbCardinality;
    private List entities;
    private JComboBox cbDominant;
    private Entity cLeftEnt;
    private Entity cRightEnt;
    private List lcolumns;
    private List rcolumns;
    private JComboBox lcombo;
    private JComboBox rcombo;
    private JTable scTable;
    private JButton btnAdd;
    private JButton btnRemove;
    private JPanel pnAttributePairs;
    public boolean isApplied = false;

    public FEJoinPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject, List list) {
        super(applicationView, designObject);
        this.entities = list;
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(Messages.getString("FEJoinPropertiesDialogEx.LeftEntityL"));
        jLabel.setPreferredSize(this.getDefaultSize());
        this.cbLeftEntity = new JComboBox();
        this.cbLeftEntity.setPreferredSize(this.getDefaultSize());
        this.cbLeftEntity.setEnabled(this.isEditable());
        this.cbLeftEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FEJoinPropertiesDialogEx.this.updateRelationCombo();
                Entity entity = (Entity)FEJoinPropertiesDialogEx.this.cbLeftEntity.getSelectedItem();
                if (entity != null) {
                    FEJoinPropertiesDialogEx.this.lcombo.setModel(new DefaultComboBoxModel<ContainedObject>(entity.getElements()));
                } else {
                    FEJoinPropertiesDialogEx.this.lcombo.removeAllItems();
                }
                FEJoinPropertiesDialogEx.this.lcolumns.clear();
                FEJoinPropertiesDialogEx.this.rcolumns.clear();
                FEJoinPropertiesDialogEx.this.scTable.updateUI();
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel, this.cbLeftEntity));
        JLabel jLabel2 = new JLabel(Messages.getString("FEJoinPropertiesDialogEx.RightEntityL"));
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.cbRightEntity = new JComboBox();
        this.cbRightEntity.setPreferredSize(this.getDefaultSize());
        this.cbRightEntity.setEnabled(this.isEditable());
        this.cbRightEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FEJoinPropertiesDialogEx.this.updateRelationCombo();
                Entity entity = (Entity)FEJoinPropertiesDialogEx.this.cbRightEntity.getSelectedItem();
                if (entity != null) {
                    FEJoinPropertiesDialogEx.this.rcombo.setModel(new DefaultComboBoxModel<ContainedObject>(entity.getElements()));
                } else {
                    FEJoinPropertiesDialogEx.this.rcombo.removeAllItems();
                }
                FEJoinPropertiesDialogEx.this.lcolumns.clear();
                FEJoinPropertiesDialogEx.this.rcolumns.clear();
                FEJoinPropertiesDialogEx.this.scTable.updateUI();
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.cbRightEntity));
        JLabel jLabel3 = new JLabel(Messages.getString("FEJoinPropertiesDialogEx.ExistingRelation"));
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbExistingRelation = new JComboBox();
        this.cbExistingRelation.setPreferredSize(this.getDefaultSize());
        this.cbExistingRelation.setEnabled(this.isEditable());
        this.cbExistingRelation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FEJoinPropertiesDialogEx.this.updateCardinality();
                FEJoinPropertiesDialogEx.this.updateColumnsData();
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.cbExistingRelation));
        JLabel jLabel4 = new JLabel(Messages.getString("FEJoinPropertiesDialogEx.Cardinality"));
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.cbCardinality = new JComboBox<String>(FactEntitiesJoin.POSSIBLE_CARDINALITY);
        this.cbCardinality.setPreferredSize(this.getDefaultSize());
        this.cbCardinality.setEnabled(this.isEditable());
        this.cbCardinality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FEJoinPropertiesDialogEx.this.updateCardinality();
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.cbCardinality));
        JLabel jLabel5 = new JLabel(Messages.getString("FEJoinPropertiesDialogEx.DominantRole"));
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.cbDominant = new JComboBox<String>(FactEntitiesJoin.POSSIBLE_CARDINALITY);
        this.cbDominant.setPreferredSize(this.getDefaultSize());
        this.cbDominant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FEJoinPropertiesDialogEx.this.updateColumnsData();
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.cbDominant));
    }

    private void updateRelationCombo() {
        Entity entity = (Entity)this.cbRightEntity.getSelectedItem();
        Entity entity2 = (Entity)this.cbLeftEntity.getSelectedItem();
        if (entity2 != this.cLeftEnt || entity != this.cRightEnt) {
            if (entity2 != null && entity != null) {
                List list = entity2.getAllRelationsTo(entity);
                if (list.size() > 0) {
                    list.add(0, null);
                    this.cbExistingRelation.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
                } else {
                    this.cbExistingRelation.removeAllItems();
                }
            } else {
                this.cbExistingRelation.removeAllItems();
            }
            this.cLeftEnt = entity2;
            this.cRightEnt = entity;
            this.updateCardinality();
            this.updateColumnsData();
        }
    }

    private void updateColumnsData() {
        if (this.isEditable()) {
            if (this.cLeftEnt != null & this.cRightEnt != null) {
                Relation relation = (Relation)this.cbExistingRelation.getSelectedItem();
                if (relation != null) {
                    this.btnAdd.setEnabled(false);
                    this.btnRemove.setEnabled(false);
                    this.fillColumns(relation);
                } else {
                    this.btnAdd.setEnabled(true);
                    this.btnRemove.setEnabled(true);
                }
            } else {
                this.btnAdd.setEnabled(false);
                this.btnRemove.setEnabled(false);
            }
        }
    }

    private void fillColumns(Relation relation) {
        if (relation != null) {
            String string = (String)this.cbCardinality.getSelectedItem();
            if (FactEntitiesJoin.CARD_ONE_TO_MANY.equalsIgnoreCase(string)) {
                ContainedObject[] containedObjectArray;
                ContainedObject[] containedObjectArray2;
                this.lcolumns.clear();
                this.rcolumns.clear();
                if (this.cLeftEnt.getPK() != null && (containedObjectArray2 = this.cRightEnt.getAllElementsGeneratedBy(relation.getObjectID())).length == (containedObjectArray = this.cLeftEnt.getPK().getElements()).length) {
                    for (int i = 0; i < containedObjectArray.length; ++i) {
                        this.lcolumns.add(containedObjectArray[i]);
                        this.rcolumns.add(containedObjectArray2[i]);
                    }
                }
            } else if (FactEntitiesJoin.CARD_MANY_TO_ONE.equalsIgnoreCase(string)) {
                this.lcolumns.clear();
                this.rcolumns.clear();
                if (this.cRightEnt.getPK() != null) {
                    ContainedObject[] containedObjectArray = this.cLeftEnt.getAllElementsGeneratedBy(relation.getObjectID());
                    ContainedObject[] containedObjectArray3 = this.cRightEnt.getPK().getElements();
                    if (containedObjectArray3.length == containedObjectArray.length) {
                        for (int i = 0; i < containedObjectArray.length; ++i) {
                            this.lcolumns.add(containedObjectArray[i]);
                            this.rcolumns.add(containedObjectArray3[i]);
                        }
                    }
                }
            } else if (FactEntitiesJoin.CARD_ONE_TO_ONE.equalsIgnoreCase(string)) {
                Entity entity = (Entity)this.cbDominant.getSelectedItem();
                if (entity == this.cLeftEnt) {
                    ContainedObject[] containedObjectArray;
                    ContainedObject[] containedObjectArray4;
                    this.lcolumns.clear();
                    this.rcolumns.clear();
                    if (this.cLeftEnt.getPK() != null && (containedObjectArray4 = this.cRightEnt.getAllElementsGeneratedBy(relation.getObjectID())).length == (containedObjectArray = this.cLeftEnt.getPK().getElements()).length) {
                        for (int i = 0; i < containedObjectArray.length; ++i) {
                            this.lcolumns.add(containedObjectArray[i]);
                            this.rcolumns.add(containedObjectArray4[i]);
                        }
                    }
                } else if (entity == this.cRightEnt) {
                    this.lcolumns.clear();
                    this.rcolumns.clear();
                    if (this.cRightEnt.getPK() != null) {
                        ContainedObject[] containedObjectArray = this.cLeftEnt.getAllElementsGeneratedBy(relation.getObjectID());
                        ContainedObject[] containedObjectArray5 = this.cRightEnt.getPK().getElements();
                        if (containedObjectArray5.length == containedObjectArray.length) {
                            for (int i = 0; i < containedObjectArray.length; ++i) {
                                this.lcolumns.add(containedObjectArray[i]);
                                this.rcolumns.add(containedObjectArray5[i]);
                            }
                        }
                    }
                }
            }
        }
        this.scTable.updateUI();
    }

    private void updateCardinality() {
        Relation relation = (Relation)this.cbExistingRelation.getSelectedItem();
        if (relation != null) {
            this.cbCardinality.setEnabled(false);
            String string = FactEntitiesJoin.getCardinalityOf(relation, this.cLeftEnt, this.cRightEnt);
            this.cbCardinality.setSelectedItem(string);
        } else {
            this.cbCardinality.setEnabled(false);
            this.cbCardinality.setSelectedItem(FactEntitiesJoin.CARD_ONE_TO_ONE);
        }
        this.updateDominant();
    }

    private void updateDominant() {
        Entity entity = (Entity)this.cbRightEntity.getSelectedItem();
        Entity entity2 = (Entity)this.cbLeftEntity.getSelectedItem();
        if (entity2 != null && entity != null) {
            if (this.cbExistingRelation.getSelectedItem() != null && FactEntitiesJoin.CARD_ONE_TO_ONE.equalsIgnoreCase((String)this.cbCardinality.getSelectedItem())) {
                Entity[] entityArray = new Entity[]{entity2, entity};
                this.cbDominant.setModel(new DefaultComboBoxModel<Entity>(entityArray));
                this.cbDominant.setEnabled(this.isEditable());
            } else {
                this.cbDominant.setEnabled(false);
                this.cbDominant.removeAllItems();
            }
        } else {
            this.cbDominant.setEnabled(false);
            this.cbDominant.removeAllItems();
        }
    }

    @Override
    public String getCaption() {
        return Messages.getString("FEJoinPropertiesDialogEx.JoinProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "JOIN_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof FactEntitiesJoin) {
            this.feJoin = (FactEntitiesJoin)designObject;
            this.initDefaults(false);
            this.fillComboItems(this.entities.toArray(), this.cbLeftEntity, true);
            this.fillComboItems(this.entities.toArray(), this.cbRightEntity, true);
            this.cbLeftEntity.setSelectedItem(this.feJoin.getLeftEntity());
            this.cbRightEntity.setSelectedItem(this.feJoin.getRightEntity());
            this.cbExistingRelation.setSelectedItem(this.feJoin.getUsedRelation());
            this.cLeftEnt = this.feJoin.getLeftEntity();
            this.cRightEnt = this.feJoin.getRightEntity();
            if (this.feJoin.getUsedRelation() == null) {
                this.cbCardinality.setSelectedItem(this.feJoin.getCardinality());
                this.lcolumns.addAll(this.feJoin.getLeftAttributes());
                this.rcolumns.addAll(this.feJoin.getRightAttributes());
            }
            this.cbDominant.setSelectedItem(this.feJoin.getDominantEntity());
            this.updateColumnsData();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.feJoin.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.feJoin.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.lcolumns = new ArrayList();
        this.rcolumns = new ArrayList();
        this.lcombo = new JComboBox();
        this.rcombo = new JComboBox();
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getAttributePairsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.feJoin.setName(this.tfName.getText());
        this.feJoin.setComment(this.taComments.getText());
        this.feJoin.setNotes(this.taNotes.getText());
        this.feJoin.setLeftEntity((Entity)this.cbLeftEntity.getSelectedItem());
        this.feJoin.setRightEntity((Entity)this.cbRightEntity.getSelectedItem());
        this.feJoin.setUsedRelation((Relation)this.cbExistingRelation.getSelectedItem());
        this.feJoin.setCardinality((String)this.cbCardinality.getSelectedItem());
        this.feJoin.setDominantEntity((Entity)this.cbDominant.getSelectedItem());
        this.feJoin.getLeftAttributes().clear();
        this.feJoin.getLeftAttributes().addAll(this.lcolumns);
        this.feJoin.getRightAttributes().clear();
        this.feJoin.getRightAttributes().addAll(this.rcolumns);
        this.isApplied = true;
        FEJoinPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.feJoin.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.feJoin.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    private void updateJTable(JTable jTable) {
        int n = jTable.getEditingRow();
        int n2 = jTable.getEditingColumn();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n, n2).stopCellEditing();
        }
        jTable.updateUI();
    }

    protected JPanel getAttributePairsPanel() {
        if (this.pnAttributePairs == null) {
            JComponent jComponent;
            this.pnAttributePairs = this.createPage(Messages.getString("FEJoinPropertiesDialogEx.AttributePairs"));
            JoinsTableModel joinsTableModel = new JoinsTableModel();
            this.scTable = new JTable(joinsTableModel);
            this.scTable.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.scTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                this.btnAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(Messages.getString("FEJoinPropertiesDialogEx.AddPairOfAttributes"));
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FEJoinPropertiesDialogEx.this.lcolumns.add(null);
                        FEJoinPropertiesDialogEx.this.rcolumns.add(null);
                        FEJoinPropertiesDialogEx.this.updateJTable(FEJoinPropertiesDialogEx.this.scTable);
                        FEJoinPropertiesDialogEx.this.scTable.updateUI();
                    }
                });
                this.btnRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = FEJoinPropertiesDialogEx.this.scTable.getSelectedRow();
                        if (n != -1 && FEJoinPropertiesDialogEx.this.lcolumns.size() > 0 && n < FEJoinPropertiesDialogEx.this.lcolumns.size()) {
                            int n2 = FEJoinPropertiesDialogEx.this.scTable.getEditingColumn();
                            int n3 = FEJoinPropertiesDialogEx.this.scTable.getEditingRow();
                            if (n3 >= 0 && n2 >= 0) {
                                FEJoinPropertiesDialogEx.this.scTable.getCellEditor(n3, n2).stopCellEditing();
                            }
                            FEJoinPropertiesDialogEx.this.lcolumns.remove(n);
                            FEJoinPropertiesDialogEx.this.rcolumns.remove(n);
                            FEJoinPropertiesDialogEx.this.updateJTable(FEJoinPropertiesDialogEx.this.scTable);
                            FEJoinPropertiesDialogEx.this.scTable.updateUI();
                        }
                    }
                });
                jComponent = new JToolBar(0);
                ((JToolBar)jComponent).setFloatable(false);
                jComponent.add(this.btnAdd);
                jComponent.add(this.btnRemove);
                jPanel.add(jComponent);
            }
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnAttributePairs.add(jComponent);
            TableColumn tableColumn = null;
            block4: for (int i = 0; i < 2; ++i) {
                tableColumn = this.scTable.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        tableColumn.setCellEditor(new DefaultCellEditor(this.lcombo));
                        continue block4;
                    }
                    case 1: {
                        tableColumn.setCellEditor(new DefaultCellEditor(this.rcombo));
                    }
                }
            }
        }
        return this.pnAttributePairs;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class JoinsTableModel
    extends AbstractTableModel {
        private JoinsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return FEJoinPropertiesDialogEx.this.lcolumns.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                if (FEJoinPropertiesDialogEx.this.cLeftEnt != null) {
                    return FEJoinPropertiesDialogEx.this.cLeftEnt.getName();
                }
                return Messages.getString("FEJoinPropertiesDialogEx.LeftEntity");
            }
            if (n == 1) {
                if (FEJoinPropertiesDialogEx.this.cLeftEnt != null) {
                    return FEJoinPropertiesDialogEx.this.cRightEnt.getName();
                }
                return Messages.getString("FEJoinPropertiesDialogEx.RightEntity");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!FEJoinPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return FEJoinPropertiesDialogEx.this.cbExistingRelation.getSelectedItem() == null;
        }

        public Class getColumnClass(int n) {
            return JComboBox.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                Attribute attribute = (Attribute)FEJoinPropertiesDialogEx.this.lcolumns.get(n);
                return attribute;
            }
            if (n2 == 1) {
                Attribute attribute = (Attribute)FEJoinPropertiesDialogEx.this.rcolumns.get(n);
                return attribute;
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                FEJoinPropertiesDialogEx.this.lcolumns.set(n, object);
            } else if (n2 == 1) {
                FEJoinPropertiesDialogEx.this.rcolumns.set(n, object);
            }
            super.setValueAt(object, n, n2);
        }
    }
}

