/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.impact.ImpA_Relation;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class RelationPropertiesDialogEx
extends LogicalObjectPropertiesDialog {
    private Relation relation;
    private JTextField tfLongName;
    private JPanel pnCardinality;
    private JTextField tfNameOnSource;
    private JComboBox cbSourceEntity;
    private JComboBox cbSourceCardinality;
    private JCheckBox chSourceOptional;
    private JComboBox cbSourceEntitySynonym;
    private Entity oldSource;
    private JTextField tfNameOnTarget;
    private JComboBox cbTargetEntity;
    private JComboBox cbTargetCardinality;
    private JCheckBox chTargetOptional;
    private JComboBox cbTargetEntitySynonym;
    private Entity oldTarget;
    private JComboBox cbDominantRole;
    private JComboBox cbDeleteRule;
    private JCheckBox chIdentifying;
    private JTree tree;
    private Entity noneEntity;
    private JPanel pnAttributes;
    private List<Attribute> attributesList;
    private DesignObject obj;
    private static final String ATTRIBUTES_TAB_NAME = Messages.getString("RelationPropertiesDialogEx.Attributes");
    private static final Logger LOGGER = new Logger(RelationPropertiesDialogEx.class);

    public RelationPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.obj = designObject;
    }

    @Override
    public String getCaption() {
        return Messages.getString("RelationPropertiesDialogEx.RelationProperties");
    }

    @Override
    protected int getMinimumWidth() {
        return 800;
    }

    @Override
    protected int getMinimumHeight() {
        return 480;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Relation) {
            this.relation = (Relation)designObject;
            this.noneEntity = this.relation.getNONEEntity();
            this.initDefaults();
            this.oldSource = this.relation.getSourceEntity();
            this.oldTarget = this.relation.getTargetEntity();
            this.tfLongName.setText(this.relation.toString());
            this.tfNameOnSource.setText(this.relation.getNameOnSource());
            this.fillComboItems(Relation.getCardinalityChoices(), this.cbTargetCardinality, false);
            this.cbTargetCardinality.setSelectedItem(this.relation.getTargetCardinality());
            this.chSourceOptional.setSelected(this.relation.isOptionalSource());
            this.cbTargetCardinality.addActionListener(this.setDominantRoleState());
            this.fillComboItems(Relation.getCardinalityChoices(), this.cbSourceCardinality, false);
            this.cbSourceCardinality.setSelectedItem(this.relation.getSourceCardinality());
            this.cbSourceCardinality.addActionListener(this.setDominantRoleState());
            this.tfNameOnTarget.setText(this.relation.getNameOnTarget());
            this.chTargetOptional.setSelected(this.relation.isOptionalTarget());
            this.fillComboItems(this.getDesignObject().getDesign().getLogicalDesign().getEntitySet().toArray(), this.cbSourceEntity, false);
            this.cbSourceEntity.setSelectedItem(this.oldSource);
            this.cbSourceEntity.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RelationPropertiesDialogEx.this.cbSourceEntitySynonym.removeAllItems();
                    RelationPropertiesDialogEx.this.fillSourceSynonymComboBox();
                }
            });
            this.fillComboItems(this.getDesignObject().getDesign().getLogicalDesign().getEntitySet().toArray(), this.cbTargetEntity, false);
            this.cbTargetEntity.setSelectedItem(this.oldTarget);
            this.cbTargetEntity.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RelationPropertiesDialogEx.this.cbTargetEntitySynonym.removeAllItems();
                    RelationPropertiesDialogEx.this.fillTargetSynonymComboBox();
                }
            });
            DesignPartView designPartView = this.getAppView().getCurrentDPV();
            if (this.relation.getSourceEntity().getDesignPart() != designPartView.getDesignPart()) {
                designPartView = this.relation.getSourceEntity().getDesignPart().getMainView();
            }
            this.fillSourceSynonymComboBox();
            designPartView = this.getAppView().getCurrentDPV();
            if (this.relation.getTargetEntity().getDesignPart() != designPartView.getDesignPart()) {
                designPartView = this.relation.getTargetEntity().getDesignPart().getMainView();
            }
            this.fillTargetSynonymComboBox();
            this.fillComboItems(this.relation.initDominatRole(), this.cbDominantRole, false);
            if (this.relation.getDominantRole() != null) {
                this.cbDominantRole.setSelectedItem(this.relation.getDominantRole());
            } else {
                this.cbDominantRole.setSelectedItem(this.noneEntity);
            }
            this.cbDominantRole.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RelationPropertiesDialogEx.this.relation.setDominantRole((Entity)RelationPropertiesDialogEx.this.cbDominantRole.getSelectedItem());
                    RelationPropertiesDialogEx.this.setIdentifyingVisible(RelationPropertiesDialogEx.this.isIdentifyingVisible());
                    RelationPropertiesDialogEx.this.enableOptionality();
                }
            });
            this.chIdentifying.setSelected(this.relation.isIdentifying());
            this.chIdentifying.setEnabled(this.isIdentifyingVisible());
            this.chIdentifying.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RelationPropertiesDialogEx.this.enableOptionality();
                }
            });
            this.enableOptionality();
            this.setDomainRoleVisible(this.isDominantRoleVisible());
            this.fillComboItems(FKIndexAssociation.OPTIONAL_CHILD_DELETE_RULES, this.cbDeleteRule, false);
            this.cbDeleteRule.setSelectedItem(this.relation.getDeleteRule());
            this.initAttributes();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.relation.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.relation.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        Object object;
        boolean bl = this.chIdentifying.isSelected();
        if (bl) {
            object = (Relation.Cardinality)this.cbSourceCardinality.getSelectedItem();
            Iterator iterator = (Relation.Cardinality)this.cbTargetCardinality.getSelectedItem();
            Object object2 = null;
            Entity entity = null;
            if (((Relation.Cardinality)object).getValue() == 0) {
                entity = (Entity)this.cbSourceEntity.getSelectedItem();
                object2 = (Entity)this.cbTargetEntity.getSelectedItem();
            } else if (((Relation.Cardinality)((Object)iterator)).getValue() == 0) {
                entity = (Entity)this.cbTargetEntity.getSelectedItem();
                object2 = (Entity)this.cbSourceEntity.getSelectedItem();
            } else {
                object2 = (Entity)this.cbDominantRole.getSelectedItem();
                if (object2 == (entity = (Entity)this.cbTargetEntity.getSelectedItem())) {
                    entity = (Entity)this.cbSourceEntity.getSelectedItem();
                }
            }
            if (entity == object2) {
                String string = Messages.getString("RelationPropertiesDialogEx.RecursiveRelationship");
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, Messages.getString("RelationPropertiesDialogEx.RelationChange"), 2);
                this.chIdentifying.setSelected(false);
                this.chTargetOptional.setEnabled(true);
                this.chSourceOptional.setEnabled(true);
            } else {
                boolean bl2 = ((Entity)object2).hasRelPathTo(entity);
                if (bl2) {
                    String string = Messages.getString("RelationPropertiesDialogEx.CiclicReferenceCreated");
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, Messages.getString("RelationPropertiesDialogEx.RelationChange"), 2);
                    this.chIdentifying.setSelected(false);
                    this.chTargetOptional.setEnabled(true);
                    this.chSourceOptional.setEnabled(true);
                }
            }
        }
        if (!this.oldSource.equals(this.cbSourceEntity.getSelectedItem()) || !this.oldTarget.equals(this.cbTargetEntity.getSelectedItem())) {
            object = this.createRelation((TVEntity)this.cbSourceEntitySynonym.getSelectedItem(), (TVEntity)this.cbTargetEntitySynonym.getSelectedItem());
            this.relation.remove();
            this.oldSource = ((Relation)object).getSourceEntity();
            this.oldTarget = ((Relation)object).getTargetEntity();
            this.setDesignObject((DesignObject)object);
            this.relation.copy((DesignObject)object);
            this.relation = object;
        } else {
            object = this.relation;
        }
        try {
            ((Relation)object).setName(this.tfName.getText());
            ((ModelIDObject)object).setComment(this.taComments.getText());
            ((ModelIDObject)object).setCommentInRDBMS(this.taCommentsInRDBMS.getText());
            ((ModelIDObject)object).setNotes(this.taNotes.getText());
            ((Relation)object).setNameOnSource(this.tfNameOnSource.getText());
            ((Relation)object).setFireCardinalityChange(false);
            ((Relation)object).setOptionalSource(this.chSourceOptional.isSelected());
            ((Relation)object).setSourceCardinality(this.cbSourceCardinality.getSelectedItem());
            ((Relation)object).setNameOnTarget(this.tfNameOnTarget.getText());
            ((Relation)object).setOptionalTarget(this.chTargetOptional.isSelected());
            if (this.cbDominantRole.getSelectedItem().equals(this.noneEntity)) {
                this.relation.setDominantRole(null);
            } else {
                this.relation.setDominantRole((Entity)this.cbDominantRole.getSelectedItem());
            }
            ((Relation)object).setIdentifying(this.chIdentifying.isSelected());
            ((Relation)object).setDeleteRule((String)this.cbDeleteRule.getSelectedItem());
            ((Relation)object).setFireCardinalityChange(true);
            ((Relation)object).setTargetCardinality(this.cbTargetCardinality.getSelectedItem());
            ((Relation)object).setSourceTV((TVEntity)this.cbSourceEntitySynonym.getSelectedItem());
            ((Relation)object).setTargetTV((TVEntity)this.cbTargetEntitySynonym.getSelectedItem());
            this.setEngineering();
            this.setMeasurements();
            this.setChangeRequests();
            this.setResponsibleParties();
            this.setDocuments();
            this.tfLongName.setText(this.relation.toString());
            for (Object object2 : ((Relation)object).getAllTVRelations()) {
                ((TVRelation)object2).resetEdgeParams();
                ((TVRelation)object2).displayLabels();
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error setting Relation's properties!", exception);
        }
        RelationPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.relation.clearProperties();
        for (Object object2 : this.dynamicPropertiesList) {
            this.relation.setProperty(((DynamicProperty)object2).getName(), ((DynamicProperty)object2).getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getCardinalityPanel());
        this.addToTree(defaultMutableTreeNode, this.getEngineeringPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsInRDBMSPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getImpactAnalysisPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
        this.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                String string;
                if (treeSelectionEvent.getOldLeadSelectionPath() != null && (string = ((JPanel)((DefaultMutableTreeNode)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent()).getUserObject()).getName()).equals(ATTRIBUTES_TAB_NAME)) {
                    RelationPropertiesDialogEx.this.initAttributes();
                }
            }
        });
    }

    @Override
    protected String getHelpIndex() {
        return "RELATION_PROPERTIES_DIALOG";
    }

    protected JPanel getCardinalityPanel() {
        if (this.pnCardinality == null) {
            this.pnCardinality = this.createPage(Messages.getString("RelationPropertiesDialogEx.General"));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_NAME);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.getDefaultSize());
            this.tfName.setEnabled(this.isEditable());
            JLabel jLabel2 = new JLabel(LB_LONG_NAME);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.tfLongName = new JTextField();
            this.tfLongName.setPreferredSize(this.getDefaultSize());
            this.tfLongName.setEditable(false);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jLabel, "West");
            jPanel3.add((Component)this.tfName, "Center");
            jPanel2.add(jPanel3);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add((Component)jLabel2, "West");
            jPanel4.add((Component)this.tfLongName, "Center");
            jPanel2.add(jPanel4);
            JPanel jPanel5 = new JPanel(new BorderLayout());
            jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 0, 3, 0));
            JPanel jPanel6 = new JPanel(new BorderLayout());
            JPanel jPanel7 = new JPanel(new GridLayout(1, 2));
            JPanel jPanel8 = new JPanel(new GridLayout(0, 1, 10, 10));
            jPanel8.setBorder(BorderFactory.createTitledBorder(Messages.getString("RelationPropertiesDialogEx.SourceCardinality")));
            JPanel jPanel9 = new JPanel(new GridLayout(0, 1, 10, 10));
            jPanel9.setBorder(BorderFactory.createTitledBorder(Messages.getString("RelationPropertiesDialogEx.TargetCardinality")));
            this.initLeftPanel(jPanel8);
            this.initRightPanel(jPanel9);
            jPanel7.add(jPanel8);
            jPanel7.add(jPanel9);
            jPanel6.add((Component)jPanel7, "North");
            JPanel jPanel10 = new JPanel(new BorderLayout());
            JPanel jPanel11 = new JPanel(new GridLayout(3, 3, 10, 10));
            JLabel jLabel3 = new JLabel(LB_DOMINANT);
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.cbDominantRole = new JComboBox();
            this.cbDominantRole.setPreferredSize(this.getDefaultSize());
            JPanel jPanel12 = new JPanel(new BorderLayout());
            jPanel12.add((Component)jLabel3, "West");
            jPanel12.add((Component)this.cbDominantRole, "Center");
            jPanel11.add(jPanel12);
            jPanel11.add(new JPanel());
            JLabel jLabel4 = new JLabel(LB_IDENTIFYING);
            jLabel4.setPreferredSize(this.getDefaultSize());
            this.chIdentifying = new JCheckBox();
            this.chIdentifying.setPreferredSize(this.getDefaultSize());
            JPanel jPanel13 = new JPanel(new BorderLayout());
            jPanel13.add((Component)jLabel4, "West");
            jPanel13.add((Component)this.chIdentifying, "Center");
            jPanel11.add(jPanel13);
            jPanel11.add(new JPanel());
            JLabel jLabel5 = new JLabel(LB_DELETE_RULE);
            jLabel5.setPreferredSize(this.getDefaultSize());
            this.cbDeleteRule = new JComboBox();
            this.cbDeleteRule.setPreferredSize(this.getDefaultSize());
            jLabel5.setToolTipText(DELETE_RULE_TIP);
            this.cbDeleteRule.setToolTipText(DELETE_RULE_TIP);
            jPanel12 = new JPanel(new BorderLayout());
            jPanel12.add((Component)jLabel5, "West");
            jPanel12.add((Component)this.cbDeleteRule, "Center");
            jPanel11.add(jPanel12);
            jPanel11.add(new JPanel());
            jPanel10.add(jPanel11);
            jPanel5.add((Component)jPanel6, "North");
            JPanel jPanel14 = new JPanel(new BorderLayout());
            jPanel14.setBorder(BorderFactory.createEmptyBorder(5, 0, 3, 0));
            jPanel14.add((Component)jPanel10, "North");
            jPanel5.add((Component)jPanel14, "Center");
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)jPanel5, "Center");
            this.pnCardinality.add(jPanel);
        }
        return this.pnCardinality;
    }

    private void initLeftPanel(JPanel jPanel) {
        JLabel jLabel = new JLabel(LB_SOURCE);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.cbSourceEntity = new JComboBox();
        this.cbSourceEntity.setPreferredSize(this.getDefaultSize());
        this.cbSourceEntity.setEnabled(true);
        jPanel.add(this.createRow(jLabel, this.cbSourceEntity));
        JLabel jLabel2 = new JLabel(LB_NAME_ON_SOURCE);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfNameOnSource = new JTextField();
        this.tfNameOnSource.setPreferredSize(this.getDefaultSize());
        jPanel.add(this.createRow(jLabel2, this.tfNameOnSource));
        JLabel jLabel3 = new JLabel(LB_SOURCE_ENTITY_SYNONYM);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbSourceEntitySynonym = new JComboBox();
        this.cbSourceEntitySynonym.setPreferredSize(this.getDefaultSize());
        jPanel.add(this.createRow(jLabel3, this.cbSourceEntitySynonym));
        JLabel jLabel4 = new JLabel(LB_TARGET_CARDINALITY);
        jLabel4.setPreferredSize(this.getDefaultSize());
        jLabel4.setToolTipText(Messages.getString("RelationPropertiesDialogEx.DefinesTargetSingleMultiple"));
        this.cbTargetCardinality = new JComboBox();
        this.cbTargetCardinality.setPreferredSize(this.getDefaultSize());
        this.cbTargetCardinality.setToolTipText(jLabel4.getToolTipText());
        jPanel.add(this.createRow(jLabel4, this.cbTargetCardinality));
        JLabel jLabel5 = new JLabel(LB_SOURCE_OPTIONAL);
        jLabel5.setPreferredSize(this.getDefaultSize());
        jLabel5.setToolTipText(Messages.getString("RelationPropertiesDialogEx.DefinesSourceOptionalMandatory"));
        this.chSourceOptional = new JCheckBox();
        this.chSourceOptional.setPreferredSize(this.getDefaultSize());
        this.chSourceOptional.setToolTipText(jLabel5.getToolTipText());
        jPanel.add(this.createRow(jLabel5, this.chSourceOptional));
    }

    private ActionListener setDominantRoleState() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RelationPropertiesDialogEx.this.setDomainRoleVisible(RelationPropertiesDialogEx.this.isDominantRoleVisible());
                RelationPropertiesDialogEx.this.setIdentifyingVisible(RelationPropertiesDialogEx.this.isIdentifyingVisible());
                RelationPropertiesDialogEx.this.enableOptionality();
            }
        };
    }

    public boolean isDominantRoleVisible() {
        Relation.Cardinality cardinality;
        Relation.Cardinality cardinality2 = (Relation.Cardinality)this.cbSourceCardinality.getSelectedItem();
        if (cardinality2.equals(cardinality = (Relation.Cardinality)this.cbTargetCardinality.getSelectedItem()) && cardinality2.getValue() != 0) {
            Object object;
            Object object2 = this.cbSourceEntity.getSelectedItem();
            return object2 != (object = this.cbTargetEntity.getSelectedItem());
        }
        return false;
    }

    public void setDomainRoleVisible(boolean bl) {
        this.cbDominantRole.setEnabled(bl);
    }

    private boolean isIdentifyingVisible() {
        boolean bl;
        boolean bl2;
        Relation.Cardinality cardinality;
        Relation.Cardinality cardinality2 = (Relation.Cardinality)this.cbSourceCardinality.getSelectedItem();
        if (!cardinality2.equals(cardinality = (Relation.Cardinality)this.cbTargetCardinality.getSelectedItem()) || cardinality2.equals(cardinality) && cardinality2.getValue() != 0 && !this.cbDominantRole.getSelectedItem().equals(this.noneEntity) && this.isDominantRoleVisible()) {
            return true;
        }
        if (cardinality2.getValue() == 1 && cardinality.getValue() == 1 && (bl2 = this.chSourceOptional.isSelected()) != (bl = this.chTargetOptional.isSelected())) {
            return true;
        }
        this.chIdentifying.setSelected(false);
        return false;
    }

    private void setIdentifyingVisible(boolean bl) {
        this.chIdentifying.setEnabled(bl);
    }

    private void initRightPanel(JPanel jPanel) {
        JLabel jLabel = new JLabel(LB_TARGET);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.cbTargetEntity = new JComboBox();
        this.cbTargetEntity.setPreferredSize(this.getDefaultSize());
        this.cbTargetEntity.setEnabled(true);
        jPanel.add(this.createRow(jLabel, this.cbTargetEntity));
        JLabel jLabel2 = new JLabel(LB_NAME_ON_TARGET);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfNameOnTarget = new JTextField();
        this.tfNameOnTarget.setPreferredSize(this.getDefaultSize());
        jPanel.add(this.createRow(jLabel2, this.tfNameOnTarget));
        JLabel jLabel3 = new JLabel(LB_TARGET_ENTITY_SYNONYM);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbTargetEntitySynonym = new JComboBox();
        this.cbTargetEntitySynonym.setPreferredSize(this.getDefaultSize());
        jPanel.add(this.createRow(jLabel3, this.cbTargetEntitySynonym));
        JLabel jLabel4 = new JLabel(LB_SOURCE_CARDINALITY);
        jLabel4.setPreferredSize(this.getDefaultSize());
        jLabel4.setToolTipText(Messages.getString("RelationPropertiesDialogEx.DefinesSourceSingleMultiple"));
        this.cbSourceCardinality = new JComboBox();
        this.cbSourceCardinality.setPreferredSize(this.getDefaultSize());
        this.cbSourceCardinality.setToolTipText(jLabel4.getToolTipText());
        jPanel.add(this.createRow(jLabel4, this.cbSourceCardinality));
        JLabel jLabel5 = new JLabel(LB_TARGET_OPTIONAL);
        jLabel5.setPreferredSize(this.getDefaultSize());
        jLabel5.setToolTipText(Messages.getString("RelationPropertiesDialogEx.DefinesTargetOptionalMandatory"));
        this.chTargetOptional = new JCheckBox();
        this.chTargetOptional.setPreferredSize(this.getDefaultSize());
        this.chTargetOptional.setToolTipText(jLabel5.getToolTipText());
        jPanel.add(this.createRow(jLabel5, this.chTargetOptional));
    }

    private void enableOptionality() {
        boolean bl = this.chIdentifying.isSelected();
        if (!bl) {
            this.chTargetOptional.setEnabled(true);
            this.chSourceOptional.setEnabled(true);
        } else {
            Relation.Cardinality cardinality;
            Relation.Cardinality cardinality2 = (Relation.Cardinality)this.cbSourceCardinality.getSelectedItem();
            if (!cardinality2.equals(cardinality = (Relation.Cardinality)this.cbTargetCardinality.getSelectedItem())) {
                if (cardinality2.getValue() == 0) {
                    this.chSourceOptional.setEnabled(false);
                    this.chSourceOptional.setSelected(false);
                } else {
                    this.chTargetOptional.setEnabled(false);
                    this.chTargetOptional.setSelected(false);
                }
            } else {
                Entity entity = (Entity)this.cbDominantRole.getSelectedItem();
                if (entity == this.relation.getTargetEntity()) {
                    this.chSourceOptional.setEnabled(false);
                    this.chSourceOptional.setSelected(false);
                    this.chTargetOptional.setEnabled(true);
                } else {
                    this.chTargetOptional.setEnabled(false);
                    this.chTargetOptional.setSelected(false);
                    this.chSourceOptional.setEnabled(true);
                }
            }
        }
    }

    protected void updateToolbar(MDBAction mDBAction) {
        JToolBar jToolBar = this.getAppView().getDPVLogical().getController().getJToolBar();
        Component[] componentArray = jToolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof AbstractButton)) continue;
            AbstractButton abstractButton = (AbstractButton)component;
            if (mDBAction.getClass() == abstractButton.getAction().getClass()) {
                abstractButton.setSelected(true);
                continue;
            }
            abstractButton.setSelected(false);
        }
    }

    private Relation createRelation(TVEntity tVEntity, TVEntity tVEntity2) {
        Relation relation = this.getDesignObject().getDesign().getLogicalDesign().createRelation(0);
        relation.setSourceEntity((Entity)tVEntity.getModel());
        relation.setTargetEntity((Entity)tVEntity2.getModel());
        relation.setSourceTV(tVEntity);
        relation.setTargetTV(tVEntity2);
        relation.addToAllDPVs();
        ((TVRelation)relation.getTopView()).addConnection();
        return relation;
    }

    private void fillSourceSynonymComboBox() {
        DesignPartView designPartView = this.getAppView().getCurrentDPV();
        Entity entity = (Entity)this.cbSourceEntity.getSelectedItem();
        ArrayList arrayList = new ArrayList();
        if (entity.getViewsForDPV(designPartView) != null) {
            arrayList.addAll(entity.getViewsForDPV(designPartView));
            this.fillComboItems(arrayList.toArray(), this.cbSourceEntitySynonym, false);
        }
        this.cbSourceEntitySynonym.setSelectedItem(this.relation.getSourceTV(designPartView));
    }

    private void fillTargetSynonymComboBox() {
        DesignPartView designPartView = this.getAppView().getCurrentDPV();
        Entity entity = (Entity)this.cbTargetEntity.getSelectedItem();
        ArrayList arrayList = new ArrayList();
        if (entity.getViewsForDPV(designPartView) != null) {
            arrayList.addAll(entity.getViewsForDPV(designPartView));
            this.fillComboItems(arrayList.toArray(), this.cbTargetEntitySynonym, false);
        }
        this.cbTargetEntitySynonym.setSelectedItem(this.relation.getTargetTV(designPartView));
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel jPanel = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                Object object;
                if (mouseEvent.getClickCount() == 2 && (object = (treePath = RelationPropertiesDialogEx.this.tree.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject modelIDObject = ((ModelIdObjectSelection)object).getObject();
                    if (modelIDObject != null) {
                        mouseEvent.consume();
                        modelIDObject.showPropertyDialog();
                    } else {
                        if (RelationPropertiesDialogEx.this.tree.isCollapsed(treePath)) {
                            RelationPropertiesDialogEx.this.tree.expandPath(treePath);
                        } else {
                            RelationPropertiesDialogEx.this.tree.collapsePath(treePath);
                        }
                        mouseEvent.consume();
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign compareTreeNavigationDesign = new CompareTreeNavigationDesign(new ImpA_Relation(this.relation, null, true), false);
        ImpactTreeRenderer impactTreeRenderer = new ImpactTreeRenderer();
        this.tree.setModel(compareTreeNavigationDesign);
        this.tree.setCellRenderer(impactTreeRenderer);
        return this.tree;
    }

    protected JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = this.createPage(Messages.getString("RelationPropertiesDialogEx.Attributes"));
            this.attributesList = new ArrayList<Attribute>();
            JTable jTable = new JTable(new AttributesModel());
            jTable.setSelectionMode(0);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(new JScrollPane(jTable));
            this.pnAttributes.add(jPanel);
        }
        return this.pnAttributes;
    }

    private void initAttributes() {
        ContainedObject[] containedObjectArray;
        this.attributesList.clear();
        Entity entity = this.relation.getTargetEntity();
        if (entity != null) {
            containedObjectArray = entity.getAllElementsGeneratedBy(this.relation.getObjectID());
            for (int i = 0; i < containedObjectArray.length; ++i) {
                this.attributesList.add((Attribute)containedObjectArray[i]);
            }
        }
        if ((containedObjectArray = this.relation.getSourceEntity()) != null && entity != containedObjectArray) {
            ContainedObject[] containedObjectArray2 = containedObjectArray.getAllElementsGeneratedBy(this.relation.getObjectID());
            for (int i = 0; i < containedObjectArray2.length; ++i) {
                this.attributesList.add((Attribute)containedObjectArray2[i]);
            }
        }
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    @Override
    protected void onCancel() {
        if (this.obj.showForFirstTime()) {
            try {
                this.obj.remove();
            }
            catch (Exception exception) {
                LOGGER.error("Error when removing relation!", exception);
            }
        }
    }

    public class AttributesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return RelationPropertiesDialogEx.this.attributesList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("RelationPropertiesDialogEx.Entity");
            }
            if (n == 1) {
                return Messages.getString("RelationPropertiesDialogEx.Attribute");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ((Attribute)RelationPropertiesDialogEx.this.attributesList.get(n)).getParent();
            }
            return ((Attribute)RelationPropertiesDialogEx.this.attributesList.get(n)).getName();
        }
    }
}

