/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.NamingOptionsHolderPanel;
import oracle.dbtools.crest.swingui.editor.logical.Messages;

public class LogicalModelDialogEx
extends ModelPropertiesDialogEx {
    private JPanel entPanel;
    private JPanel attrPanel;
    private JPanel viewPanel;
    private JTree tree;
    private NamingOptionsHolderPanel entOptionsPanel;
    private NamingOptionsHolderPanel attrOptionsPanel;
    private NamingOptionsHolderPanel viewOptionsPanel;

    public LogicalModelDialogEx(ApplicationView applicationView, ModelIDObject modelIDObject) {
        super(applicationView, modelIDObject);
    }

    @Override
    protected int getMinimumWidth() {
        return 960;
    }

    @Override
    public void initProperties(ModelIDObject modelIDObject) {
        this.model = modelIDObject;
        this.tfName.setText(this.model.getName());
        this.tfName.setEnabled(false);
        this.taComments.setText(this.model.getComment());
        this.taNotes.setText(this.model.getNotes());
        this.tfObjectID.setText(this.model.getObjectID());
        this.tfCreationTime.setText(this.model.getCreationTime());
        this.tfCreator.setText(this.model.getCreator().getName());
        this.tfLastChangedBy.setText(this.model.getChanger().getName());
        this.tfLastChangedTime.setText(this.model.getChangeTime());
        this.entOptionsPanel.init();
        this.attrOptionsPanel.init();
        this.viewOptionsPanel.init();
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
            this.chbVisible.setSelected(((DesignPart)this.model).isMainViewVisible());
            this.initResponsibleParties();
            this.initDocuments();
        } else if (this.model instanceof DesignPartViewPlaceHolder && ((DesignPartViewPlaceHolder)this.model).getDesignPartView() != null && ((DesignPartViewPlaceHolder)this.model).getDesignPartView().isMasterDPV()) {
            this.chbVisible.setSelected(((DesignPartViewPlaceHolder)this.model).getVisible());
        } else {
            this.chbVisible.setEnabled(false);
        }
    }

    @Override
    protected String getHelpIndex() {
        return "LOGICAL_MODEL_PROPERTIES_DIALOG";
    }

    @Override
    protected void setProperties() {
        if (!this.readonlyName) {
            this.model.setName(this.tfName.getText());
        }
        this.model.setComment(this.taComments.getText());
        this.model.setNotes(this.taNotes.getText());
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
            ((DesignPart)this.model).setMainViewVisible(this.chbVisible.isSelected());
            this.setResponsibleParties();
            this.setDocuments();
        } else if (this.model instanceof DesignPartViewPlaceHolder && ((DesignPartViewPlaceHolder)this.model).getDesignPartView() != null && ((DesignPartViewPlaceHolder)this.model).getDesignPartView().isMasterDPV()) {
            ((DesignPartViewPlaceHolder)this.model).setVisible(this.chbVisible.isSelected());
        }
        ((LogicalDesign)this.model).getNamingOptionsHolderList().clear();
        this.entOptionsPanel.setHolderValues();
        this.attrOptionsPanel.setHolderValues();
        this.viewOptionsPanel.setHolderValues();
        ((LogicalDesign)this.model).getNamingOptionsHolderList().add(this.entOptionsPanel.getNamingOptionsHolder().copy());
        ((LogicalDesign)this.model).getNamingOptionsHolderList().add(this.attrOptionsPanel.getNamingOptionsHolder().copy());
        ((LogicalDesign)this.model).getNamingOptionsHolderList().add(this.viewOptionsPanel.getNamingOptionsHolder().copy());
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null && ((DesignPart)this.model).getMainView().isVisible()) {
            ((DesignPart)this.model).getMainView().getWorkSpace().repaint();
        }
    }

    private JPanel getEntOptionsPanel() {
        if (this.entPanel == null) {
            this.entPanel = this.createPage(Messages.getString("LogicalModelDialogEx.Entity"));
            this.entOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(Entity.class), true);
            this.entPanel.add((Component)this.entOptionsPanel, "West");
        }
        return this.entPanel;
    }

    private JPanel getAttrOptionsPanel() {
        if (this.attrPanel == null) {
            this.attrPanel = this.createPage(Messages.getString("LogicalModelDialogEx.Attribute"));
            this.attrOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(Attribute.class), true);
            this.attrPanel.add((Component)this.attrOptionsPanel, "West");
        }
        return this.attrPanel;
    }

    private JPanel getViewOptionsPanel() {
        if (this.viewPanel == null) {
            this.viewPanel = this.createPage(Messages.getString("LogicalModelDialogEx.View"));
            this.viewOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(EntityView.class), true);
            this.viewPanel.add((Component)this.viewOptionsPanel, "West");
        }
        return this.viewPanel;
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 160;
    }

    @Override
    public JTree getTree() {
        if (this.tree == null) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("");
            this.tree = new JTree(defaultMutableTreeNode);
            this.tree.setCellRenderer(new ModelPropertiesDialogEx.TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(Messages.getString("LogicalModelDialogEx.NamingOptions"));
            this.addToTree(defaultMutableTreeNode2, this.getEntOptionsPanel());
            this.addToTree(defaultMutableTreeNode2, this.getAttrOptionsPanel());
            this.addToTree(defaultMutableTreeNode2, this.getViewOptionsPanel());
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
            this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
            if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
                this.chbVisible.setSelected(((DesignPart)this.model).isMainViewVisible());
                this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
                this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
            }
            this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
        }
        return this.tree;
    }

    private NamingOptionsHolder getNamingOptionsHolderFor(Class clazz) {
        for (NamingOptionsHolder namingOptionsHolder : ((LogicalDesign)this.model).getNamingOptionsHolderList()) {
            if (!namingOptionsHolder.getClassName().equals(clazz)) continue;
            return namingOptionsHolder.copy();
        }
        return new NamingOptionsHolder(clazz);
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)LogicalModelDialogEx.this.tree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof Component) {
                LogicalModelDialogEx.this.cardLayout.show(LogicalModelDialogEx.this.getMainPanel(), ((Component)object).getName());
            } else if (defaultMutableTreeNode.getFirstLeaf() != null && (object = defaultMutableTreeNode.getFirstLeaf().getUserObject()) instanceof Component) {
                LogicalModelDialogEx.this.cardLayout.show(LogicalModelDialogEx.this.getMainPanel(), ((Component)object).getName());
            }
        }
    }
}

