/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.ide.Ide;

public class KeyPropertiesDialogEx
extends LogicalObjectPropertiesDialog {
    private static final String ATTRIBUTES_AND_RELATIONS_TAB_NAME = Messages.getString("KeyPropertiesDialogEx.AttributesAndRelations");
    private CandidateKey key;
    private List<Attribute> attributesList;
    private JTextField tfSynonym;
    private JTextField tfLongName;
    private JComboBox cbState;
    private JPanel pnAttributes;
    private JButton btnAddAttributes;
    private JButton btnRemoveAttributes;
    private AllAttributesModel allAttributesModel;
    private DefaultListModel selectedAttributesModel;
    private JPanel panelAttributes;
    private JList selectedAttributesList;
    private JList allAttributesList;
    private JButton btnUp;
    private JButton btnDown;
    private JTree tree;

    public KeyPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    public KeyPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog, applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("KeyPropertiesDialogEx.KeyProperties");
    }

    @Override
    protected int getMinimumWidth() {
        return 630;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof CandidateKey) {
            Object object;
            Object object2;
            Object object3;
            this.key = (CandidateKey)designObject;
            this.initDefaults(false);
            this.tfSynonym.setText(this.key.getSynonym());
            this.tfLongName.setText(this.key.getLongName());
            this.cbState.setSelectedItem(this.translate(this.key.getKeyState(), KEY_STATES_INTERNAL, KEY_STATES_DISPLAY));
            Entity entity = (Entity)this.key.getContainerObject();
            if (entity != null) {
                object3 = entity.getPKProviderRelations();
                object2 = this.key.getNewElementsCollection().toArray();
                for (int i = 0; i < ((Object[])object2).length; ++i) {
                    DesignObject designObject2;
                    Attribute attribute;
                    if (object2[i] instanceof Relation && object3.contains(object2[i])) {
                        if (this.selectedAttributesModel.contains(object2[i])) continue;
                        this.selectedAttributesModel.addElement(object2[i]);
                        continue;
                    }
                    object = object2[i];
                    if (object instanceof Attribute && (attribute = (Attribute)object).isFKAttribute() && (designObject2 = attribute.getGenerator()) != null && designObject2 instanceof Relation) {
                        object = designObject2;
                    }
                    if (this.selectedAttributesModel.contains(object)) continue;
                    this.selectedAttributesModel.addElement(object2[i]);
                }
                this.updateAllattributes((List)object3);
                this.cbState.setEnabled(!this.isIdentifying(entity));
                if (entity.getHierarchicalParent() != null) {
                    this.cbState.setSelectedItem(UNIQUE_KEY);
                    this.cbState.setEnabled(false);
                }
            }
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            object3 = this.key.getPropertyNames();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                String string = this.key.getProperty((String)object2);
                object = new DynamicProperty((String)object2, string);
                this.dynamicPropertiesList.add(object);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private void updateAllattributes(List list) {
        Object object = this.cbState.getSelectedItem();
        boolean bl = false;
        if (PRIMARY_KEY.equals(object)) {
            bl = true;
        }
        this.allAttributesModel.removeAllElements();
        for (Attribute designObject : this.attributesList) {
            if (this.selectedAttributesModel.contains(designObject)) continue;
            if (bl) {
                if (designObject.getNullsAllowed() || designObject.isFKAttribute()) continue;
                this.allAttributesModel.addElement(designObject);
                continue;
            }
            if (designObject.isFKAttribute()) continue;
            this.allAttributesModel.addElement(designObject);
        }
        for (int i = 0; i < list.size(); ++i) {
            Relation relation = (Relation)list.get(i);
            if (this.selectedAttributesModel.contains(relation) || this.allAttributesModel.contains(relation)) continue;
            int[] nArray = relation.getPKProviderEndPoint();
            for (int j = 0; j < nArray.length; ++j) {
                Entity entity = relation.getEntity(nArray[j]);
                if (entity == this.key.getContainerWithKeyObject() && relation.getSourceEntity() != relation.getTargetEntity()) continue;
                this.allAttributesModel.addElement(relation);
            }
        }
    }

    public boolean isIdentifying(Entity entity) {
        if (entity.hasPK() && entity.getPK().hasFKAttribute()) {
            Attribute attribute = entity.getPK().getFKAttribute();
            return attribute.getRelation().isIdentifying();
        }
        return false;
    }

    @Override
    protected void setProperties() {
        Object object;
        int n;
        ArrayList arrayList = new ArrayList(this.key.getNewElementsCollection());
        this.key.setName(this.tfName.getText());
        this.key.setComment(this.taComments.getText());
        this.key.setNotes(this.taNotes.getText());
        this.key.setSynonym(this.tfSynonym.getText());
        Object[] objectArray = this.selectedAttributesModel.toArray();
        this.key.setColumnsState(false);
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(this.key.getNewElementsCollection());
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            arrayList2.remove(object2);
        }
        for (Object object2 : arrayList2) {
            if (!(object2 instanceof DesignObject)) continue;
            this.key.removeElement((DesignObject)object2);
        }
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n];
            if (!(object instanceof DesignObject)) continue;
            this.key.addElement((DesignObject)object);
        }
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n];
            if (!(object instanceof DesignObject)) continue;
            this.key.moveElementToIndex((DesignObject)object, n);
        }
        this.key.setKeyState(this.translate((String)this.cbState.getSelectedItem(), KEY_STATES_DISPLAY, KEY_STATES_INTERNAL));
        if (!((Object)arrayList).equals(this.key.getNewElementsCollection())) {
            this.key.updateElementsCollection();
        }
        this.setEngineering();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.tfLongName.setText(this.key.getLongName());
        KeyPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.key.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.key.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
    }

    public void setAttributesList(List list) {
        this.attributesList = list;
    }

    public List getAttributesList() {
        return this.attributesList;
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getEngineeringPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getImpactAnalysisPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
        this.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                String string;
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null && (string = ((JPanel)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()).getName()).equals(ATTRIBUTES_AND_RELATIONS_TAB_NAME)) {
                    KeyPropertiesDialogEx.this.allAttributesModel.filter();
                }
            }
        });
    }

    @Override
    protected String getHelpIndex() {
        return "KEY_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_SYNOMYM);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfSynonym));
        JLabel jLabel2 = new JLabel(LB_LONG_NAME);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfLongName));
        JLabel jLabel3 = new JLabel(LB_STATE);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbState = new JComboBox<String>(KEY_STATES_DISPLAY);
        this.cbState.setPreferredSize(this.getDefaultSize());
        this.cbState.setMaximumRowCount(8);
        this.cbState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Entity entity = (Entity)KeyPropertiesDialogEx.this.key.getContainerObject();
                if (entity != null) {
                    List list = entity.getPKProviderRelations();
                    KeyPropertiesDialogEx.this.updateAllattributes(list);
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.cbState));
    }

    protected JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = this.createPage(ATTRIBUTES_AND_RELATIONS_TAB_NAME);
            this.panelAttributes = new JPanel();
            BoxLayout boxLayout = new BoxLayout(this.panelAttributes, 2);
            this.panelAttributes.setLayout(boxLayout);
            this.pnAttributes.add(this.panelAttributes);
            this.initAllAttributesList();
            this.initAttributesButtons();
            this.initSelectedAttributesList();
        }
        return this.pnAttributes;
    }

    private void initAllAttributesList() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.allAttributesModel = new AllAttributesModel();
        this.allAttributesList = new JList(this.allAttributesModel);
        this.allAttributesList.setCellRenderer(new AllAttributesRelationsRenderer());
        ListSelectionModel listSelectionModel = this.allAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allAttributesList);
        jScrollPane.setPreferredSize(new Dimension(145, 220));
        jPanel.add(jScrollPane);
        this.panelAttributes.add(jPanel);
    }

    private void initSelectedAttributesList() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.selectedAttributesModel = new DefaultListModel();
        this.selectedAttributesList = new JList(this.selectedAttributesModel);
        ListSelectionModel listSelectionModel = this.selectedAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedAttributesList);
        jScrollPane.setPreferredSize(new Dimension(145, 220));
        jPanel.add(jScrollPane);
        this.panelAttributes.add(jPanel);
    }

    private void initAttributesButtons() {
        JPanel jPanel = new JPanel();
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAddAttributes = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddAttributes.addActionListener(new AddColumnsActionListener());
        this.btnAddAttributes.setEnabled(false);
        this.btnAddAttributes.setToolTipText(BTN_ADD);
        this.btnRemoveAttributes = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveAttributes.setEnabled(false);
        this.btnRemoveAttributes.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveAttributes.setToolTipText(BTN_REMOVE);
        this.btnUp = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
        this.btnUp.setToolTipText(Messages.getString("KeyPropertiesDialogEx.MoveUp"));
        this.btnUp.addActionListener(new MoveUpAction());
        this.btnDown = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
        this.btnDown.setToolTipText(Messages.getString("KeyPropertiesDialogEx.MoveDown"));
        this.btnDown.addActionListener(new MoveDownAction());
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
        jToolBar.add(this.btnAddAttributes);
        jToolBar.add(this.btnRemoveAttributes);
        jToolBar.add(this.btnUp);
        jToolBar.add(this.btnDown);
        jPanel.add(jToolBar);
        this.panelAttributes.add(jPanel);
    }

    public boolean moveToIndex(Object object, int n) {
        if (this.selectedAttributesModel.contains(object) && this.selectedAttributesModel.size() > n && n >= 0) {
            this.selectedAttributesModel.removeElement(object);
            this.selectedAttributesModel.add(n, object);
            return true;
        }
        return false;
    }

    private boolean couldBeCyclic(Relation relation) {
        if (relation.getSourceEntity() == relation.getTargetEntity()) {
            return true;
        }
        if (this.key.getContainerWithKeyObject() == relation.getSourceEntity()) {
            return relation.getTargetEntity().hasFK_Rel_PathTo(relation.getSourceEntity());
        }
        return relation.getSourceEntity().hasFK_Rel_PathTo(relation.getTargetEntity());
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel jPanel = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                Object object;
                if (mouseEvent.getClickCount() == 2 && (object = (treePath = KeyPropertiesDialogEx.this.tree.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject modelIDObject = ((ModelIdObjectSelection)object).getObject();
                    if (modelIDObject != null) {
                        mouseEvent.consume();
                        modelIDObject.showPropertyDialog();
                    } else {
                        if (KeyPropertiesDialogEx.this.tree.isCollapsed(treePath)) {
                            KeyPropertiesDialogEx.this.tree.expandPath(treePath);
                        } else {
                            KeyPropertiesDialogEx.this.tree.collapsePath(treePath);
                        }
                        mouseEvent.consume();
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign compareTreeNavigationDesign = new CompareTreeNavigationDesign(new ImpA_KeyObject(this.key, null, true), false);
        ImpactTreeRenderer impactTreeRenderer = new ImpactTreeRenderer();
        this.tree.setModel(compareTreeNavigationDesign);
        this.tree.setCellRenderer(impactTreeRenderer);
        return this.tree;
    }

    @Override
    protected boolean canExit() {
        if (super.canExit()) {
            return this.checkRequiredProperties();
        }
        return false;
    }

    protected boolean checkRequiredProperties() {
        if (this.selectedAttributesModel.isEmpty()) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("EntityPropertiesDialogEx.IncompleteUIDdefinition"), this.key.getName()), Messages.getString("EntityPropertiesDialogEx.UIDColumnsAssignment"), 0);
            return false;
        }
        return true;
    }

    protected boolean canBeUsed(Attribute attribute) {
        Datatype datatype = attribute.getDataType();
        String string = datatype.getName();
        return !(datatype instanceof StructuredType) && !(datatype instanceof CollectionType) && LogicalDatatype.canBeUsedForPK(string);
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class AllAttributesModel
    extends DefaultListModel {
        private AllAttributesModel() {
        }

        public void filter() {
            for (Attribute attribute : KeyPropertiesDialogEx.this.getAttributesList()) {
                if (KeyPropertiesDialogEx.this.canBeUsed(attribute)) continue;
                super.removeElement(attribute);
            }
        }
    }

    class AllAttributesRelationsRenderer
    extends JLabel
    implements ListCellRenderer {
        AllAttributesRelationsRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object.toString());
            this.setOpaque(true);
            if (bl) {
                this.setBackground(KeyPropertiesDialogEx.this.selectedAttributesList.getSelectionBackground());
                if (object instanceof Relation) {
                    if (KeyPropertiesDialogEx.this.key.isPK() && KeyPropertiesDialogEx.this.couldBeCyclic((Relation)object)) {
                        this.setForeground(Color.RED);
                    } else {
                        this.setForeground(Color.WHITE);
                    }
                } else {
                    this.setForeground(Color.WHITE);
                }
            } else {
                this.setBackground(KeyPropertiesDialogEx.this.selectedAttributesList.getBackground());
                if (object instanceof Relation) {
                    if (KeyPropertiesDialogEx.this.key.isPK() && KeyPropertiesDialogEx.this.couldBeCyclic((Relation)object)) {
                        this.setForeground(Color.RED);
                    } else {
                        this.setForeground(KeyPropertiesDialogEx.this.selectedAttributesList.getForeground());
                    }
                } else {
                    this.setForeground(KeyPropertiesDialogEx.this.selectedAttributesList.getForeground());
                }
            }
            return this;
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!KeyPropertiesDialogEx.this.selectedAttributesModel.isEmpty()) {
                Object[] objectArray = KeyPropertiesDialogEx.this.selectedAttributesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (KeyPropertiesDialogEx.this.allAttributesModel.contains(object)) continue;
                    KeyPropertiesDialogEx.this.allAttributesModel.addElement(object);
                    KeyPropertiesDialogEx.this.selectedAttributesModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!KeyPropertiesDialogEx.this.allAttributesModel.isEmpty()) {
                Object[] objectArray = KeyPropertiesDialogEx.this.allAttributesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (KeyPropertiesDialogEx.this.selectedAttributesModel.contains(object)) continue;
                    KeyPropertiesDialogEx.this.selectedAttributesModel.addElement(object);
                    KeyPropertiesDialogEx.this.allAttributesModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (KeyPropertiesDialogEx.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (KeyPropertiesDialogEx.this.selectedAttributesList.getSelectedIndex() == -1) {
                    KeyPropertiesDialogEx.this.btnRemoveAttributes.setEnabled(false);
                    KeyPropertiesDialogEx.this.btnUp.setEnabled(false);
                    KeyPropertiesDialogEx.this.btnDown.setEnabled(false);
                } else {
                    KeyPropertiesDialogEx.this.btnRemoveAttributes.setEnabled(true);
                    KeyPropertiesDialogEx.this.btnUp.setEnabled(true);
                    KeyPropertiesDialogEx.this.btnDown.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (KeyPropertiesDialogEx.this.isEditable()) {
                Object e = KeyPropertiesDialogEx.this.allAttributesList.getSelectedValue();
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (KeyPropertiesDialogEx.this.allAttributesList.getSelectedIndex() == -1) {
                        KeyPropertiesDialogEx.this.btnAddAttributes.setEnabled(false);
                    } else if (!(e instanceof Relation) || KeyPropertiesDialogEx.this.key.isPK() && e instanceof Relation && !KeyPropertiesDialogEx.this.couldBeCyclic((Relation)e) || !KeyPropertiesDialogEx.this.key.isPK()) {
                        KeyPropertiesDialogEx.this.btnAddAttributes.setEnabled(true);
                    } else {
                        KeyPropertiesDialogEx.this.btnAddAttributes.setEnabled(false);
                    }
                }
            }
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = KeyPropertiesDialogEx.this.selectedAttributesList.getSelectedIndices();
            if (nArray.length > 0 && (n = nArray[nArray.length - 1]) < KeyPropertiesDialogEx.this.selectedAttributesModel.size() - 1) {
                for (int i = nArray.length - 1; i > -1; --i) {
                    n = nArray[i];
                    Object e = KeyPropertiesDialogEx.this.selectedAttributesModel.get(n);
                    KeyPropertiesDialogEx.this.moveToIndex(e, n + 1);
                    nArray[i] = n + 1;
                }
                KeyPropertiesDialogEx.this.selectedAttributesList.setSelectedIndices(nArray);
                KeyPropertiesDialogEx.this.selectedAttributesList.updateUI();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = KeyPropertiesDialogEx.this.selectedAttributesList.getSelectedIndices();
            if (nArray.length > 0 && (n = nArray[0]) > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    n = nArray[i];
                    Object e = KeyPropertiesDialogEx.this.selectedAttributesModel.get(n);
                    KeyPropertiesDialogEx.this.moveToIndex(e, n - 1);
                    nArray[i] = n - 1;
                }
                KeyPropertiesDialogEx.this.selectedAttributesList.setSelectedIndices(nArray);
                KeyPropertiesDialogEx.this.selectedAttributesList.updateUI();
            }
        }
    }
}

