/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_EntityView;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.designrules.DRViewCaseType;
import oracle.dbtools.crest.model.designrules.DRViewMaxNameLength;
import oracle.dbtools.crest.model.designrules.DRViewValidCharacters;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.logical.EntityViewBuilder;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QueryBuilderPanel;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.gui.swing.JLNComboBox;
import oracle.dbtools.crest.util.gui.swing.LNComboTableCellRenderer;

public class EntityViewPropertiesDialogEx
extends LogicalObjectPropertiesDialog {
    private EntityView entityView;
    private JButton btnQueryBuilder;
    private JComboBox cbBaseOnStructuredType;
    private JComboBox cbType;
    private JDialog builder;
    private StructuredType st_type;
    protected JTextArea userDefinedSQL;
    private JPanel pnElementComments;
    private JPanel pnReferenceElements;
    private JPanel pnUserDefinedSQL;
    private JTable tbElements;
    private JTextArea taElementComments;
    private List lsElements;
    private ColumnTable sTable;
    private List sList;
    private JTree tree;
    private JComboBox cbSubViews;
    private int currentElement;

    public EntityViewPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("EntityViewPropertiesDialogEx.ViewProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof EntityView) {
            Object object;
            Object object2;
            String string;
            this.entityView = (EntityView)designObject;
            this.initDefaults();
            this.fillComboItems(this.getStructuredTypes().toArray(), this.cbBaseOnStructuredType, true);
            this.cbBaseOnStructuredType.setSelectedItem(this.entityView.getBasedOnStructuredType());
            this.cbType.setSelectedItem(this.entityView.getViewType());
            if (this.entityView.isBST()) {
                this.st_type = this.entityView.getBasedOnStructuredType();
                this.userDefinedSQL.setText(this.entityView.getUserDefinedSQL());
            }
            if (this.btnQueryBuilder != null) {
                this.btnQueryBuilder.setEnabled(this.isEditable() && this.st_type == null);
            }
            this.enablePanels(this.st_type != null);
            this.updateElementsList();
            this.updateColumnList();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.entityView.getPropertyNames();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                object2 = this.entityView.getProperty(string);
                object = new DynamicProperty(string, (String)object2);
                this.dynamicPropertiesList.add(object);
            }
            this.dynamicPropertiesTable.updateUI();
            string = this.entityView.getUseObjectsOnlyFrom();
            object2 = null;
            this.cbSubViews.addItem(this.entityView.getDesignPart().getMainView());
            object = this.entityView.getDesignPart().getDesignSubviews().iterator();
            while (object.hasNext()) {
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)object.next();
                DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
                this.cbSubViews.addItem(designPartView);
                if (string.length() <= 0 || !designPartView.getDPVId().equalsIgnoreCase(string)) continue;
                object2 = designPartView;
            }
            if (object2 != null) {
                this.cbSubViews.setSelectedItem(object2);
            }
        }
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DRViewMaxNameLength(), this.entityView);
        this.checkDesignRule(new DRViewCaseType(), this.entityView);
        this.checkDesignRule(new DRViewValidCharacters(), this.entityView);
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 210;
    }

    private void updateElementsList() {
        this.currentElement = -1;
        this.taElementComments.setText("");
        this.taElementComments.setEnabled(false);
        ContainedObject[] containedObjectArray = this.entityView.getElements();
        List<ContainedObject> list = Arrays.asList(containedObjectArray);
        for (int i = this.lsElements.size() - 1; i >= 0; --i) {
            ElementHelper object = (ElementHelper)this.lsElements.get(i);
            if (list.contains(object.getElement())) continue;
            this.lsElements.remove(i);
        }
        for (AbstractViewElement abstractViewElement : list) {
            if (this.listContainsElement(abstractViewElement)) continue;
            ElementHelper elementHelper = new ElementHelper(abstractViewElement);
            this.lsElements.add(elementHelper);
        }
        this.tbElements.updateUI();
        this.tbElements.clearSelection();
    }

    @Override
    protected void showComponent(Component component) {
        this.setPreviousSelectedElement();
        super.showComponent(component);
    }

    private boolean listContainsElement(AbstractViewElement abstractViewElement) {
        for (ElementHelper elementHelper : this.lsElements) {
            if (elementHelper.getElement() != abstractViewElement) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setProperties() {
        this.entityView.setName(this.tfName.getText());
        this.entityView.setComment(this.taComments.getText());
        this.entityView.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.entityView.setNotes(this.taNotes.getText());
        this.entityView.setBasedOnStructuredType((StructuredType)this.cbBaseOnStructuredType.getSelectedItem());
        if (this.entityView.isBST()) {
            this.entityView.setUserDefinedSQL(this.userDefinedSQL.getText());
        }
        this.entityView.setViewType((String)this.cbType.getSelectedItem());
        for (int i = 0; i < this.sTable.getRowCount(); ++i) {
            Object object = (AttributeView)this.sTable.getModel().getValueAt(i, 0);
            Entity entity = (Entity)((JLNComboBox)this.sTable.getModel().getValueAt(i, 1)).getSelectedItem();
            if (entity != null) {
                ((ContainedObject)object).setScopeId(entity.getObjectID());
                continue;
            }
            ((ContainedObject)object).setScopeId(null);
        }
        if (this.cbSubViews.getSelectedIndex() > 0) {
            this.entityView.setUseObjectsOnlyFrom(((DesignPartView)this.cbSubViews.getSelectedItem()).getDPVId());
        } else {
            this.entityView.setUseObjectsOnlyFrom("");
        }
        this.setEngineering();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        EntityViewPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.entityView.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.entityView.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
        this.checkNamingOptions();
        this.applyElementsComments();
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getElementCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getReferenceElementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getUserDefinedSQLPanel());
        this.addToTree(defaultMutableTreeNode, this.getEngineeringPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsInRDBMSPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getImpactAnalysisPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "LOGICAL_VIEW_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(Messages.getString("EntityViewPropertiesDialogEx.QueryBuilder"));
        jLabel.setPreferredSize(this.getDefaultSize());
        this.btnQueryBuilder = new JButton(BTN_QUERY);
        this.btnQueryBuilder.setHorizontalAlignment(2);
        this.btnQueryBuilder.setPreferredSize(this.getDefaultSize());
        this.btnQueryBuilder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryBuilderPanel queryBuilderPanel = new QueryBuilderPanel(EntityViewPropertiesDialogEx.this.entityView);
                DesignPartView designPartView = null;
                if (EntityViewPropertiesDialogEx.this.cbSubViews.getSelectedIndex() > 0) {
                    designPartView = (DesignPartView)EntityViewPropertiesDialogEx.this.cbSubViews.getSelectedItem();
                }
                queryBuilderPanel.getDialog(EntityViewPropertiesDialogEx.this.getAppView(), false, designPartView).setVisible(true);
                EntityViewPropertiesDialogEx.this.updateElementsList();
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel, this.btnQueryBuilder));
        JLabel jLabel2 = new JLabel(LB_BASED_ON_STRUCTURED_TYPE);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.cbBaseOnStructuredType = new JComboBox();
        this.cbBaseOnStructuredType.setPreferredSize(this.getDefaultSize());
        this.cbBaseOnStructuredType.setMaximumRowCount(8);
        this.cbBaseOnStructuredType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = EntityViewPropertiesDialogEx.this.cbBaseOnStructuredType.getSelectedItem();
                EntityViewPropertiesDialogEx.this.st_type = (StructuredType)object;
                if (EntityViewPropertiesDialogEx.this.btnQueryBuilder != null) {
                    EntityViewPropertiesDialogEx.this.btnQueryBuilder.setEnabled(EntityViewPropertiesDialogEx.this.isEditable() && EntityViewPropertiesDialogEx.this.st_type == null);
                }
                EntityViewPropertiesDialogEx.this.enablePanels(EntityViewPropertiesDialogEx.this.st_type != null);
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.cbBaseOnStructuredType));
        JLabel jLabel3 = new JLabel(Messages.getString("EntityViewPropertiesDialogEx.UseObjectsFrom"));
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbSubViews = new JComboBox();
        this.cbSubViews.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.cbSubViews));
        JLabel jLabel4 = new JLabel(LB_VIEW_TYPE);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.cbType = new JComboBox<String>(EntityView.VIEW_TYPES);
        this.cbType.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.cbType));
    }

    private void enablePanels(boolean bl) {
        this.userDefinedSQL.setEnabled(bl);
        this.sTable.setEnabled(bl);
    }

    private List getStructuredTypes() {
        ArrayList<StructuredType> arrayList = new ArrayList<StructuredType>();
        Iterator iterator = this.entityView.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            if (!structuredType.isInstantiable()) continue;
            arrayList.add(structuredType);
        }
        return arrayList;
    }

    public JDialog getBuilder() {
        if (this.builder == null) {
            this.builder = new EntityViewBuilder(this.entityView).getDialog(this.getAppView());
            return this.builder;
        }
        return this.builder;
    }

    private void setElementSelected() {
        int n;
        if (this.currentElement > -1) {
            this.setPreviousSelectedElement();
        }
        if ((n = this.tbElements.getSelectedRow()) != -1 && this.lsElements.size() > 0 && n < this.lsElements.size()) {
            this.currentElement = n;
            ElementHelper elementHelper = (ElementHelper)this.lsElements.get(n);
            this.taElementComments.setEnabled(true);
            this.taElementComments.setText(elementHelper.getComments());
        }
    }

    protected JPanel getElementCommentsPanel() {
        if (this.pnElementComments == null) {
            this.currentElement = -1;
            this.pnElementComments = this.createPage(PANEL_ELEMENT_COMMENTS);
            this.tbElements = new JTable(new ElementsModel());
            this.tbElements.setSelectionMode(0);
            this.tbElements.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    EntityViewPropertiesDialogEx.this.setElementSelected();
                }
            });
            this.tbElements.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (EntityViewPropertiesDialogEx.this.lsElements.isEmpty()) {
                        EntityViewPropertiesDialogEx.this.taElementComments.setText("");
                        EntityViewPropertiesDialogEx.this.taElementComments.setEnabled(false);
                    } else {
                        EntityViewPropertiesDialogEx.this.taElementComments.setEnabled(true);
                        EntityViewPropertiesDialogEx.this.setElementSelected();
                    }
                }
            });
            this.lsElements = new ArrayList();
            this.pnElementComments.add((Component)new JScrollPane(this.tbElements), "Center");
            this.taElementComments = new JTextArea();
            this.taElementComments.setLineWrap(true);
            this.taElementComments.setWrapStyleWord(true);
            this.taElementComments.setPreferredSize(new Dimension(300, 100));
            this.pnElementComments.add((Component)new JScrollPane(this.taElementComments), "South");
        }
        return this.pnElementComments;
    }

    protected JPanel getReferenceElementsPanel() {
        if (this.pnReferenceElements == null) {
            this.pnReferenceElements = this.createPage(PANEL_REFERENCE_ELEMENTS);
            this.sTable = new ColumnTable();
            this.sList = new ArrayList();
            this.sTable.setSelectionMode(0);
            this.pnReferenceElements.add(new JScrollPane(this.sTable));
        }
        return this.pnReferenceElements;
    }

    private void updateColumnList() {
        this.sList.clear();
        this.sTable.clearTable();
        for (AttributeView attributeView : this.entityView.getRefColumns()) {
            if (this.sList.contains(attributeView)) continue;
            this.sList.add(attributeView);
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(attributeView);
            JLNComboBox jLNComboBox = new JLNComboBox(this.getScopeEntitites(attributeView));
            jLNComboBox.setSelectedItem(attributeView.getScope());
            vector.addElement(jLNComboBox);
            Object[] objectArray = vector.toArray();
            ((ComboModel)this.sTable.getModel()).addRow(objectArray);
        }
        this.sTable.updateUI();
    }

    private Object[] getScopeEntitites(AttributeView attributeView) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        arrayList.add(null);
        if (attributeView.getStructuredType() != null) {
            Iterator iterator = ((LogicalDesign)this.entityView.getDesignPart()).getEntitySet().iterator();
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                if (!entity.isBST() || !attributeView.getStructuredType().isParentOf(entity.getBasedOnStructuredType())) continue;
                arrayList.add(entity);
            }
        }
        return arrayList.toArray();
    }

    protected JPanel getUserDefinedSQLPanel() {
        if (this.pnUserDefinedSQL == null) {
            this.pnUserDefinedSQL = this.createPage(PANEL_USER_DEFINED_SQL);
            this.userDefinedSQL = new JTextArea();
            this.pnUserDefinedSQL.add(new JScrollPane(this.userDefinedSQL));
        }
        return this.pnUserDefinedSQL;
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel jPanel = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                Object object;
                if (mouseEvent.getClickCount() == 2 && (object = (treePath = EntityViewPropertiesDialogEx.this.tree.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject modelIDObject = ((ModelIdObjectSelection)object).getObject();
                    if (modelIDObject != null) {
                        mouseEvent.consume();
                        modelIDObject.showPropertyDialog();
                    } else {
                        if (EntityViewPropertiesDialogEx.this.tree.isCollapsed(treePath)) {
                            EntityViewPropertiesDialogEx.this.tree.expandPath(treePath);
                        } else {
                            EntityViewPropertiesDialogEx.this.tree.collapsePath(treePath);
                        }
                        mouseEvent.consume();
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign compareTreeNavigationDesign = new CompareTreeNavigationDesign(new ImpA_EntityView(this.entityView, null), false);
        ImpactTreeRenderer impactTreeRenderer = new ImpactTreeRenderer();
        this.tree.setModel(compareTreeNavigationDesign);
        this.tree.setCellRenderer(impactTreeRenderer);
        return this.tree;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private void setPreviousSelectedElement() {
        if (this.currentElement > -1) {
            ElementHelper elementHelper = (ElementHelper)this.lsElements.get(this.currentElement);
            elementHelper.setComments(this.taElementComments.getText());
        }
    }

    private void applyElementsComments() {
        this.setPreviousSelectedElement();
        for (ElementHelper elementHelper : this.lsElements) {
            elementHelper.applyComments();
        }
    }

    public class ElementHelper {
        AbstractViewElement element;
        String comments;

        public ElementHelper(AbstractViewElement abstractViewElement) {
            this.element = abstractViewElement;
            this.comments = abstractViewElement.getCommentInRDBMS();
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String string) {
            this.comments = string;
        }

        public AbstractViewElement getElement() {
            return this.element;
        }

        public String getName() {
            return this.element.getName();
        }

        public String getRefContainerName() {
            if (this.element.getReferencedContainer() != null) {
                return this.element.getReferencedContainer().getName();
            }
            return "";
        }

        public void applyComments() {
            this.element.setCommentInRDBMS(this.comments);
        }
    }

    class ComboTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox combo;

        ComboTableCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.combo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.combo = (JComboBox)object;
            this.combo.setOpaque(true);
            return this.combo;
        }
    }

    class ColumnTable
    extends JTable {
        ComboModel dataModel;

        public ColumnTable() {
            this.dataModel = new ComboModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return super.getCellRenderer(n, n2);
            }
            return new LNComboTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ComboTableCellEditor();
        }
    }

    public class ComboModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("EntityViewPropertiesDialogEx.Attribute");
            }
            if (n == 1) {
                return Messages.getString("EntityViewPropertiesDialogEx.Entity");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!EntityViewPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return n2 != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    public class ElementsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return EntityViewPropertiesDialogEx.this.lsElements.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("EntityViewPropertiesDialogEx.Attribute");
            }
            if (n == 1) {
                return Messages.getString("EntityViewPropertiesDialogEx.ReferencedContainer");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ElementHelper elementHelper = (ElementHelper)EntityViewPropertiesDialogEx.this.lsElements.get(n);
            if (n2 == 0) {
                return elementHelper.getName();
            }
            if (n2 == 1) {
                return elementHelper.getRefContainerName();
            }
            return new Integer(n * n2);
        }
    }
}

