/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.ApplyAttributesNamingStandards;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractNamingStandards;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.options.Settings;

public class AttributesNamingStandards
extends AbstractNamingStandards {
    protected JCheckBox chbPrimaryIdentifier;
    protected JCheckBox chbRelationAttributes;
    protected Entity entity;
    protected LogicalDesign logical;
    protected ApplyAttributesNamingStandards applyAttributesNamingStandards;

    public AttributesNamingStandards(ApplicationView applicationView, LogicalDesign logicalDesign) {
        super(applicationView);
        this.logical = logicalDesign;
    }

    public AttributesNamingStandards(ApplicationView applicationView, Entity entity) {
        super(applicationView);
        this.entity = entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void apply() {
        Settings settings = this.getApplicationView().getSettings();
        settings.loadDLSettings(this.getDesign().getDesignLevelSettings());
        this.applyAttributesNamingStandards = new ApplyAttributesNamingStandards(settings, this.chbPrimaryIdentifier.isSelected(), this.chbRelationAttributes.isSelected());
        if (settings.isKeepFKNamesSynchronized() && this.chbRelationAttributes.isSelected()) {
            MessageDialogs.showWarningMessage(Messages.getString("ApplyAttributesNamingStandards.KeepAsNameOfOriginatingAttribute"));
        }
        if (this.logical != null) {
            try {
                ApplicationView.canLogging = false;
                Set<Attribute> set = this.getFirstLevelAttributes();
                for (Attribute attribute : set) {
                    this.applyAttributesNamingStandards(attribute);
                }
            }
            finally {
                ApplicationView.canLogging = true;
                this.logical.sortCollections();
            }
        } else {
            this.applyAttributesNamingStandards.apply(this.entity);
        }
    }

    protected void applyAttributesNamingStandards(Attribute attribute) {
        Entity entity = (Entity)attribute.getParent();
        this.applyAttributesNamingStandards.apply(entity);
        for (Attribute attribute2 : this.getReferencingAttributes(attribute)) {
            this.applyAttributesNamingStandards(attribute2);
        }
    }

    protected Set<Attribute> getReferencingAttributes(Attribute attribute) {
        HashSet<Attribute> hashSet = new HashSet<Attribute>();
        Iterator iterator = this.logical.getAttributeSet().iterator();
        while (iterator.hasNext()) {
            Attribute attribute2 = (Attribute)iterator.next();
            if (attribute2.getDelegate() != attribute) continue;
            hashSet.add(attribute2);
        }
        return hashSet;
    }

    protected Set<Attribute> getAllFKAttributes() {
        HashSet<Attribute> hashSet = new HashSet<Attribute>();
        Iterator iterator = this.logical.getAttributeSet().iterator();
        while (iterator.hasNext()) {
            hashSet.add((Attribute)iterator.next());
        }
        return hashSet;
    }

    private Set<Attribute> getFirstLevelAttributes() {
        HashSet<Attribute> hashSet = new HashSet<Attribute>();
        Iterator iterator = this.logical.getAttributeSet().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.isFKAttribute() || attribute.getDelegate().isFKAttribute()) continue;
            hashSet.add(attribute);
        }
        return hashSet;
    }

    @Override
    protected String getDialogTitle() {
        return Messages.getString("AttributesNamingStandards.ApplyNamingStandards");
    }

    @Override
    protected Dimension getDialogPreferredSize() {
        return new Dimension(300, 100);
    }

    @Override
    protected JPanel initGeneralPanel() {
        JPanel jPanel = super.initGeneralPanel();
        this.chbPrimaryIdentifier = new JCheckBox(Messages.getString("AttributesNamingStandards.PrimaryIdentifier"), true);
        this.chbRelationAttributes = new JCheckBox(Messages.getString("AttributesNamingStandards.RelationAttributes"), true);
        this.generalPanelContents.add(this.chbPrimaryIdentifier);
        this.generalPanelContents.add(this.chbRelationAttributes);
        return jPanel;
    }

    @Override
    public Design getDesign() {
        if (this.logical != null) {
            return this.logical.getDesign();
        }
        if (this.entity != null) {
            return this.entity.getDesign();
        }
        return super.getDesign();
    }
}

