/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.logical.Messages;

public class ArcPropertiesDialogEx
extends AbstractPropertiesDialog {
    private Arc arc;
    private JTextField tfEntity;
    private JPanel pnRelations;
    private List rList;
    private JTable rTable;

    public ArcPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ArcPropertiesDialogEx.ArcProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "ARC_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Arc) {
            Object object;
            this.arc = (Arc)designObject;
            this.initDefaults(false);
            this.tfEntity.setText(this.arc.getEntity().getName());
            Object[] objectArray = this.arc.getRelations().toArray();
            Arrays.sort(objectArray, new RelationComparator());
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                this.rList.add(object);
            }
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.arc.getPropertyNames();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string = this.arc.getProperty((String)object);
                DynamicProperty dynamicProperty = new DynamicProperty((String)object, string);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_ENTITY);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfEntity = new JTextField();
        this.tfEntity.setPreferredSize(this.getDefaultSize());
        this.tfEntity.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfEntity));
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getRelationsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.arc.setName(this.tfName.getText());
        this.arc.setComment(this.taComments.getText());
        this.arc.setNotes(this.taNotes.getText());
        ArcPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.arc.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.arc.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    protected JPanel getRelationsPanel() {
        if (this.pnRelations == null) {
            this.pnRelations = this.createPage(Messages.getString("ArcPropertiesDialogEx.Relations"));
            this.rList = new ArrayList();
            this.rTable = new JTable(new RelationModel());
            this.rTable.setSelectionMode(0);
            this.rTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Relation relation;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ArcPropertiesDialogEx.this.rTable.getSelectedRow()) != -1 && ArcPropertiesDialogEx.this.rList.size() > 0 && n < ArcPropertiesDialogEx.this.rList.size() && !(relation = (Relation)ArcPropertiesDialogEx.this.rList.get(n)).isDialogVisible()) {
                        relation.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.rTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Relation relation;
                    int n = ArcPropertiesDialogEx.this.rTable.getSelectedRow();
                    if (n != -1 && ArcPropertiesDialogEx.this.rList.size() > 0 && n < ArcPropertiesDialogEx.this.rList.size() && !(relation = (Relation)ArcPropertiesDialogEx.this.rList.get(n)).isDialogVisible()) {
                        relation.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnRelations.add(jPanel2);
        }
        return this.pnRelations;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    public class RelationModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ArcPropertiesDialogEx.this.rList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ArcPropertiesDialogEx.RelationName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Relation relation = (Relation)ArcPropertiesDialogEx.this.rList.get(n);
            if (n2 == 0) {
                return relation.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class RelationComparator
    implements Comparator {
        private RelationComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Relation)object).getName().compareTo(((Relation)object2).getName());
        }
    }
}

