/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.swingui.editor.datatypes.SelectDataTypeDialog;

public class MethodPropertiesDialogEx
extends AbstractPropertiesDialog {
    private Method method;
    private JCheckBox chConstructor;
    private JCheckBox chOverriding;
    private JComboBox cbOverrided;
    private JButton bnDataType;
    private MethodParam temp;
    private JTable pTable;
    private List pList;
    private int counter = 0;
    private JPanel pnParameters;
    private JPanel pnBody;
    private JTextArea taBody;

    public MethodPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    public MethodPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog, applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("MethodPropertiesDialogEx.MethodProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Method) {
            this.method = (Method)designObject;
            this.initDefaults(false);
            this.chConstructor.setSelected(this.method.isConstructor());
            this.chOverriding.setSelected(this.method.isOverriding());
            this.fillComboItems(this.getInheritedMethods(), this.cbOverrided, true);
            this.cbOverrided.setSelectedItem(this.method.getOverridedMethod());
            this.bnDataType.setText(this.method.getReturnValue() != null ? this.method.getReturnValue().getDataType() : "NO RETURN");
            if (this.method.getReturnValue() != null) {
                this.temp = new MethodParam(this.method.getDesignPart());
                this.method.getReturnValue().copyDataType(this.temp);
            }
            this.pList.addAll(this.method.getParameters());
            this.taBody.setText(this.method.getBody());
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.method.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.method.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        MethodPropertiesDialogEx.stopCellEditing(this.pTable);
        MethodPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.method.setName(this.tfName.getText());
        this.method.setComment(this.taComments.getText());
        this.method.setNotes(this.taNotes.getText());
        this.method.setConstructor(this.chConstructor.isSelected());
        this.method.setOverriding(this.chOverriding.isSelected());
        this.method.setOverridedMethod((Method)this.cbOverrided.getSelectedItem());
        this.method.setBody(this.taBody.getText());
        this.method.setReturnValue(this.temp);
        Object[] objectArray = this.method.getParameters().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.pList.contains(objectArray[i])) continue;
            this.method.removeParameter((MethodParam)objectArray[i]);
        }
        Iterator iterator = this.pList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object = (MethodParam)iterator.next();
            this.method.addParameter(n, (MethodParam)object);
            ++n;
        }
        this.method.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.method.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getParametersPanel());
        this.addToTree(defaultMutableTreeNode, this.getBodyPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "METHOD_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_CONSTRUCTOR);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.chConstructor = new JCheckBox();
        this.chConstructor.setPreferredSize(this.getDefaultSize());
        this.chConstructor.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.chConstructor));
        JLabel jLabel2 = new JLabel(LB_OVERRIDING);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.chOverriding = new JCheckBox();
        this.chOverriding.setPreferredSize(this.getDefaultSize());
        this.chOverriding.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.chOverriding));
        JLabel jLabel3 = new JLabel(LB_OVERRIDED_METHOD);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbOverrided = new JComboBox();
        this.cbOverrided.setPreferredSize(this.getDefaultSize());
        this.cbOverrided.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.cbOverrided));
        JLabel jLabel4 = new JLabel(LB_RETURN_VALUE);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.bnDataType = new JButton();
        this.bnDataType.setPreferredSize(this.getDefaultSize());
        this.bnDataType.setHorizontalAlignment(2);
        this.bnDataType.setEnabled(this.isEditable());
        this.bnDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MethodParam methodParam = new MethodParam(MethodPropertiesDialogEx.this.method.getDesignPart());
                if (MethodPropertiesDialogEx.this.temp != null) {
                    MethodPropertiesDialogEx.this.temp.copyDataType(methodParam);
                }
                SelectDataTypeDialog selectDataTypeDialog = new SelectDataTypeDialog(MethodPropertiesDialogEx.this.getAppView(), methodParam, MethodPropertiesDialogEx.this.bnDataType);
                selectDataTypeDialog.initProperties(false);
                int n = selectDataTypeDialog.showDialog();
                if (n == 1) {
                    if (MethodPropertiesDialogEx.this.temp == null) {
                        MethodPropertiesDialogEx.this.temp = new MethodParam(MethodPropertiesDialogEx.this.method.getDesignPart());
                    }
                    methodParam.copyDataType(MethodPropertiesDialogEx.this.temp);
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.bnDataType));
    }

    private Object[] getInheritedMethods() {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (StructuredType structuredType = this.method.getStructuredType().getParentType(); structuredType != null; structuredType = structuredType.getParentType()) {
            for (int i = 0; i < structuredType.getMethods().length; ++i) {
                arrayList.add(structuredType.getMethod(i));
            }
        }
        return arrayList.toArray();
    }

    protected String generateName() {
        String string = Messages.getString("MethodPropertiesDialogEx.Arg");
        int n = 0;
        int n2 = this.pList.size();
        if (n2 != 0) {
            n = this.counter = n2 + 1;
        } else {
            ++this.counter;
            n = this.counter;
        }
        String string2 = string.concat(Integer.toString(n));
        while (this.attributeExists(string2)) {
            n = ++this.counter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean attributeExists(String string) {
        for (int i = 0; i < this.pList.size(); ++i) {
            MethodParam methodParam = (MethodParam)this.pList.get(i);
            if (!string.equalsIgnoreCase(methodParam.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean moveToIndex(DesignObject designObject, int n) {
        if (this.pList.contains(designObject) && this.pList.size() > n && n >= 0) {
            this.pList.remove(designObject);
            this.pList.add(n, designObject);
            return true;
        }
        return false;
    }

    protected JPanel getParametersPanel() {
        if (this.pnParameters == null) {
            JComponent jComponent;
            this.pnParameters = this.createPage(Messages.getString("MethodPropertiesDialogEx.Parameters"));
            this.pList = new ArrayList();
            this.pTable = new JTable(new ParamModel());
            this.pTable.setSelectionMode(0);
            this.pTable.getColumnModel().getColumn(1).setCellEditor(new DatatypeEditor());
            JScrollPane jScrollPane = new JScrollPane(this.pTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MethodParam methodParam = new MethodParam(MethodPropertiesDialogEx.this.method.getDesignPart());
                        methodParam.setName(MethodPropertiesDialogEx.this.generateName());
                        methodParam.setDesign(MethodPropertiesDialogEx.this.method.getDesign());
                        MethodPropertiesDialogEx.this.pList.add(methodParam);
                        MethodPropertiesDialogEx.this.pTable.updateUI();
                    }
                });
                JButton jButton = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton.setToolTipText(BTN_REMOVE);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = MethodPropertiesDialogEx.this.pTable.getSelectedRow();
                        if (n != -1 && MethodPropertiesDialogEx.this.pList.size() > 0 && n < MethodPropertiesDialogEx.this.pList.size()) {
                            MethodPropertiesDialogEx.this.pList.remove(n);
                            MethodPropertiesDialogEx.this.pTable.updateUI();
                        }
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_MOVE_UP);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = MethodPropertiesDialogEx.this.pTable.getSelectedRow();
                        if (n > -1 && n < MethodPropertiesDialogEx.this.pList.size()) {
                            DesignObject designObject = (DesignObject)MethodPropertiesDialogEx.this.pList.get(n);
                            MethodPropertiesDialogEx.this.moveToIndex(designObject, n - 1);
                            MethodPropertiesDialogEx.this.pTable.changeSelection(n - 1, 0, false, false);
                            MethodPropertiesDialogEx.this.pTable.updateUI();
                        }
                    }
                });
                JButton jButton3 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
                jButton3.setToolTipText(BTN_MOVE_DOWN);
                jButton3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = MethodPropertiesDialogEx.this.pTable.getSelectedRow();
                        if (n > -1 && n < MethodPropertiesDialogEx.this.pList.size()) {
                            DesignObject designObject = (DesignObject)MethodPropertiesDialogEx.this.pList.get(n);
                            MethodPropertiesDialogEx.this.moveToIndex(designObject, n + 1);
                            MethodPropertiesDialogEx.this.pTable.changeSelection(n + 1, 0, false, false);
                            MethodPropertiesDialogEx.this.pTable.updateUI();
                        }
                    }
                });
                JToolBar jToolBar = new JToolBar(0);
                jToolBar.setFloatable(false);
                jToolBar.add(jComponent);
                jToolBar.add(jButton);
                jToolBar.add(jButton2);
                jToolBar.add(jButton3);
                jPanel.add(jToolBar);
            }
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnParameters.add(jComponent);
        }
        return this.pnParameters;
    }

    protected JPanel getBodyPanel() {
        if (this.pnBody == null) {
            this.pnBody = this.createPage(Messages.getString("MethodPropertiesDialogEx.Body"));
            this.taBody = new JTextArea();
            this.taBody.setEnabled(this.isEditable());
            this.pnBody.add(new JScrollPane(this.taBody));
        }
        return this.pnBody;
    }

    public class DatatypeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        protected static final String EDIT = "edit";
        JButton button = new JButton();
        MethodParam param;

        public DatatypeEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.param = (MethodParam)object;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.param;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                MethodParam methodParam = new MethodParam(MethodPropertiesDialogEx.this.method.getDesignPart());
                this.param.copyDataType(methodParam);
                SelectDataTypeDialog selectDataTypeDialog = new SelectDataTypeDialog(MethodPropertiesDialogEx.this.getAppView(), methodParam, MethodPropertiesDialogEx.this.bnDataType);
                selectDataTypeDialog.initProperties(false);
                int n = selectDataTypeDialog.showDialog();
                if (n == 1) {
                    methodParam.copyDataType(this.param);
                }
                this.fireEditingStopped();
            }
        }
    }

    private class ParamModel
    extends AbstractTableModel {
        private ParamModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return MethodPropertiesDialogEx.this.pList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("MethodPropertiesDialogEx.Name");
            }
            if (n == 1) {
                return Messages.getString("MethodPropertiesDialogEx.Datatype");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return MethodPropertiesDialogEx.this.isEditable();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                MethodParam methodParam = (MethodParam)MethodPropertiesDialogEx.this.pList.get(n);
                methodParam.setName(String.valueOf(object));
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            MethodParam methodParam = (MethodParam)MethodPropertiesDialogEx.this.pList.get(n);
            if (n2 == 0) {
                return methodParam.getName();
            }
            if (n2 == 1) {
                return methodParam;
            }
            return new Integer(n * n2);
        }
    }
}

