/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractDatatypePropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class DistinctTypePropertiesDialogEx
extends AbstractDatatypePropertiesDialog {
    private DistinctType distinctType;
    private JComboBox cbLogicalType;
    private JTextField ifSize;
    private JIntegerField ifPrecision;
    private JIntegerField ifScale;
    private TreeMap typesRDBMSSites = new TreeMap();
    private int precisionDefaultValueInt;
    private int scaleDefaultValue;
    private String sizeDefaultValue;

    public DistinctTypePropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DistinctTypePropertiesDialogEx.DistinctTypeProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof DistinctType) {
            int n;
            int n2;
            this.distinctType = (DistinctType)designObject;
            this.initDefaults();
            this.fillComboItems(this.getDesignObject().getDesign().getLogicalDatatypeSet().toArray(), this.cbLogicalType, false);
            this.cbLogicalType.setSelectedItem(this.distinctType.getLogicalDataType());
            String string = this.distinctType.getSize();
            if (string != null && !string.equals("")) {
                this.ifSize.setText(string);
            }
            if ((n2 = this.distinctType.getPrecision()) > 0) {
                this.ifPrecision.setValue((long)n2);
            }
            if ((n = this.distinctType.getScale()) > 0) {
                this.ifScale.setValue((long)n);
            }
            this.initType();
            this.initUsedInAttributes(this.distinctType, (short)2);
            this.initUsedInColumns();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.distinctType.getPropertyNames();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = this.distinctType.getProperty(string2);
                DynamicProperty dynamicProperty = new DynamicProperty(string2, string3);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.distinctType.setName(this.tfName.getText());
        this.distinctType.setComment(this.taComments.getText());
        this.distinctType.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.distinctType.setNotes(this.taNotes.getText());
        this.distinctType.setLogicalDataType((LogicalDatatype)this.cbLogicalType.getSelectedItem());
        this.distinctType.setSize(String.valueOf(this.ifSize.getText()));
        this.distinctType.setPrecision(this.ifPrecision.getIntValue());
        this.distinctType.setScale(this.ifScale.getIntValue());
        Map map = ((LogicalDatatype)this.cbLogicalType.getSelectedItem()).getLTDefaultValues();
        String string = (String)map.get("precision_default_value");
        this.precisionDefaultValueInt = string != "" && string != null ? new Integer((String)map.get("precision_default_value")) : 0;
        this.sizeDefaultValue = (String)map.get("size_default_value");
        String string2 = (String)map.get("scale_default_value");
        this.scaleDefaultValue = string2 != "" && string2 != null ? new Integer((String)map.get("scale_default_value")) : 0;
        try {
            if (!this.ifSize.getText().equals(this.sizeDefaultValue)) {
                this.distinctType.setSize(this.ifSize.getText());
            } else {
                this.distinctType.setSize("");
            }
        }
        catch (Exception exception) {
            this.distinctType.setSize("");
        }
        try {
            if (this.ifPrecision.getIntValue() != this.precisionDefaultValueInt || this.ifScale.getIntValue() != this.scaleDefaultValue) {
                this.distinctType.setPrecision(this.ifPrecision.getIntValue());
                this.distinctType.setScale(this.ifScale.getIntValue());
            } else {
                this.distinctType.setPrecision(0);
                this.distinctType.setScale(0);
            }
        }
        catch (Exception exception) {
            this.distinctType.setPrecision(0);
            this.distinctType.setScale(0);
        }
        this.setResponsibleParties();
        this.setDocuments();
        DistinctTypePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.distinctType.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.distinctType.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    private void initType() {
        LogicalDatatype logicalDatatype = this.distinctType.getLogicalDataType();
        if (logicalDatatype != null) {
            Map map = logicalDatatype.getToPhysical();
            MDDataType mDDataType = logicalDatatype.createDataType(this.distinctType.getSelectedRDBMSType().getName(), map);
            if (mDDataType instanceof MDImplicitSized) {
                this.ifSize.setEnabled(false);
                this.ifPrecision.setEnabled(false);
                this.ifScale.setEnabled(false);
            } else if (mDDataType instanceof MDPackedSized) {
                this.ifSize.setText("");
                this.ifSize.setEnabled(false);
                try {
                    if (this.distinctType.getPrecision() != 0) {
                        this.ifPrecision.setValue((long)this.distinctType.getPrecision());
                    } else if (mDDataType.getPrecision() != 0) {
                        this.ifPrecision.setValue(mDDataType.getPrecision() > 0 ? Integer.valueOf(mDDataType.getPrecision()) : null);
                    }
                    mDDataType.getPrecision();
                    this.ifPrecision.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifPrecision.setEnabled(false);
                }
                try {
                    if (this.distinctType.getScale() != 0) {
                        this.ifScale.setValue(this.distinctType.getScale() > 0 ? Integer.valueOf(this.distinctType.getScale()) : null);
                    } else if (mDDataType.getScale() != 0) {
                        this.ifScale.setValue(mDDataType.getScale() > 0 ? Integer.valueOf(mDDataType.getScale()) : null);
                    }
                    mDDataType.getScale();
                    this.ifScale.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifScale.setEnabled(false);
                }
            } else {
                try {
                    if (!this.distinctType.getSize().equalsIgnoreCase("")) {
                        this.ifSize.setText(this.distinctType.getSize());
                    } else if (!mDDataType.getSize().equalsIgnoreCase("0")) {
                        this.ifSize.setText(mDDataType.getSize());
                    }
                    mDDataType.getSize();
                    this.ifSize.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifSize.setEnabled(false);
                }
                try {
                    if (this.distinctType.getPrecision() != 0) {
                        this.ifPrecision.setValue(this.distinctType.getPrecision() > 0 ? Integer.valueOf(this.distinctType.getPrecision()) : null);
                    } else if (mDDataType.getPrecision() != 0) {
                        this.ifPrecision.setValue(mDDataType.getPrecision() > 0 ? Integer.valueOf(mDDataType.getPrecision()) : null);
                    }
                    mDDataType.getPrecision();
                    this.ifPrecision.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifPrecision.setEnabled(false);
                }
                try {
                    if (this.distinctType.getScale() != 0) {
                        this.ifScale.setValue(this.distinctType.getScale() > 0 ? Integer.valueOf(this.distinctType.getScale()) : null);
                    } else if (mDDataType.getScale() != 0) {
                        this.ifScale.setValue(mDDataType.getScale() > 0 ? Integer.valueOf(mDDataType.getScale()) : null);
                    }
                    mDDataType.getScale();
                    this.ifScale.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifScale.setEnabled(false);
                }
            }
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsInRDBMSPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getUsedInPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "DISTINCTTYPE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        Object object;
        Iterator iterator = this.getDesignObject().getDesign().getDefaultRDBMSTypeSet().iterator();
        while (iterator.hasNext()) {
            object = (RDBMSType)iterator.next();
            this.typesRDBMSSites.put(((RDBMSType)object).getType(), ((RDBMSType)object).getName());
        }
        object = new JLabel(LB_LOGICAL_TYPE);
        ((JComponent)object).setPreferredSize(this.getDefaultSize());
        this.cbLogicalType = new JComboBox();
        this.cbLogicalType.setPreferredSize(this.getDefaultSize());
        this.cbLogicalType.setMaximumRowCount(20);
        this.cbLogicalType.addActionListener(new DatatypeListener());
        this.cbLogicalType.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow((Component)object, this.cbLogicalType));
        JLabel jLabel = new JLabel(LB_SIZE);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.ifSize = new JTextField();
        this.ifSize.setPreferredSize(this.getDefaultSize());
        this.ifSize.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.ifSize));
        JLabel jLabel2 = new JLabel(LB_PRECISION);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.ifPrecision = new JIntegerField();
        this.ifPrecision.setPreferredSize(this.getDefaultSize());
        this.ifPrecision.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.ifPrecision));
        JLabel jLabel3 = new JLabel(LB_SCALE);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.ifScale = new JIntegerField();
        this.ifScale.setPreferredSize(this.getDefaultSize());
        this.ifScale.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.ifScale));
    }

    private void updateType() {
        this.ifSize.setText("");
        this.ifPrecision.setText("");
        this.ifScale.setText("");
        LogicalDatatype logicalDatatype = (LogicalDatatype)this.cbLogicalType.getSelectedItem();
        if (logicalDatatype != null) {
            Map map = logicalDatatype.getLTDefaultValues();
            String string = (String)map.get("precision_default_value");
            this.precisionDefaultValueInt = string != "" && string != null ? new Integer((String)map.get("precision_default_value")) : 0;
            String string2 = (String)map.get("scale_default_value");
            this.scaleDefaultValue = string2 != "" && string2 != null ? new Integer((String)map.get("scale_default_value")) : 0;
            Map map2 = logicalDatatype.getToPhysical();
            MDDataType mDDataType = logicalDatatype.createDataType(this.distinctType.getSelectedRDBMSType().getName(), map2);
            if (mDDataType instanceof MDImplicitSized) {
                this.ifSize.setEnabled(false);
                this.ifPrecision.setEnabled(false);
                this.ifScale.setEnabled(false);
            } else if (mDDataType instanceof MDPackedSized) {
                this.ifSize.setText("");
                this.ifSize.setEnabled(false);
                try {
                    if (mDDataType.getPrecision() != 0) {
                        this.ifPrecision.setValue((long)mDDataType.getPrecision());
                    } else {
                        this.ifPrecision.setValue(this.precisionDefaultValueInt > 0 ? Integer.valueOf(this.precisionDefaultValueInt) : null);
                    }
                    this.ifPrecision.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifPrecision.setEnabled(false);
                }
                try {
                    if (mDDataType.getScale() != 0) {
                        this.ifScale.setValue((long)mDDataType.getScale());
                    } else {
                        this.ifScale.setValue(this.scaleDefaultValue > 0 ? Integer.valueOf(this.scaleDefaultValue) : null);
                    }
                    this.ifScale.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifScale.setEnabled(false);
                }
            } else {
                try {
                    if (!mDDataType.getSize().equalsIgnoreCase("0")) {
                        this.ifSize.setText(mDDataType.getSize());
                    }
                    this.ifSize.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifSize.setEnabled(false);
                }
                try {
                    if (mDDataType.getPrecision() != 0) {
                        this.ifPrecision.setValue((long)mDDataType.getPrecision());
                    }
                    this.ifPrecision.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifPrecision.setEnabled(false);
                }
                try {
                    if (mDDataType.getScale() != 0) {
                        this.ifScale.setValue((long)mDDataType.getScale());
                    }
                    this.ifScale.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifScale.setEnabled(false);
                }
            }
        }
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class DatatypeListener
    implements ActionListener {
        private DatatypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DistinctTypePropertiesDialogEx.this.updateType();
        }
    }
}

