/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;

public class UrlPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfUrl;
    private BIResourceLocator url;
    private JTable cTable;
    private List cList;
    private JPanel pnContacts;

    public UrlPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    public UrlPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog, applicationView, designObject);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_URL);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfUrl = new JTextField();
        this.tfUrl.setPreferredSize(this.getDefaultSize());
        this.tfUrl.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfUrl));
    }

    @Override
    public String getCaption() {
        return Messages.getString("UrlPropertiesDialogEx.ResourceLocatorProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof BIResourceLocator) {
            this.url = (BIResourceLocator)designObject;
            this.tfName.setText(this.url.getName());
            this.tfUrl.setText(this.url.getUrl());
            this.cList.addAll(this.url.getContacts());
            this.taComments.setText(this.url.getComment());
            this.tfObjectID.setText(this.url.getObjectID());
            this.tfCreationTime.setText(this.url.getCreationTime());
            this.tfCreator.setText(this.url.getCreator().getName());
            this.tfDesign.setText(this.url.getOwnerDesignName());
            if (this.url.getGenerator() != null) {
                this.tfGeneratorName.setText(this.url.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.url.getChanger().getName());
            this.tfLastChangedTime.setText(this.url.getChangeTime());
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.url.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.url.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.url.setName(this.tfName.getText());
        this.url.setComment(this.taComments.getText());
        this.url.setUrl(this.tfUrl.getText());
        UrlPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.url.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.url.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getContactsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "URL_PROPERTIES_DIALOG";
    }

    private JPanel getContactsPanel() {
        if (this.pnContacts == null) {
            this.pnContacts = this.createPage(Messages.getString("UrlPropertiesDialogEx.Contacts"));
            this.cList = new ArrayList();
            this.cTable = new JTable(new ContactTableModel());
            this.cTable.setSelectionMode(0);
            this.cTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = UrlPropertiesDialogEx.this.cTable.getSelectedRow()) != -1 && UrlPropertiesDialogEx.this.cList.size() > 0 && n < UrlPropertiesDialogEx.this.cList.size()) {
                        DesignObject designObject = (DesignObject)UrlPropertiesDialogEx.this.cList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.cTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("UrlPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = UrlPropertiesDialogEx.this.cTable.getSelectedRow();
                    if (n != -1 && UrlPropertiesDialogEx.this.cList.size() > 0 && n < UrlPropertiesDialogEx.this.cList.size()) {
                        DesignObject designObject = (DesignObject)UrlPropertiesDialogEx.this.cList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 180));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnContacts.add(jPanel2);
        }
        return this.pnContacts;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class ContactTableModel
    extends AbstractTableModel {
        private ContactTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return UrlPropertiesDialogEx.this.cList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("UrlPropertiesDialogEx.Contacts");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)UrlPropertiesDialogEx.this.cList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }
}

