/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;

public class LocationPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfType;
    private JTextField tfAddress;
    private JTextField tfCity;
    private JTextField tfPostCode;
    private JTextField tfArea;
    private JTextField tfCountry;
    private BILocation location;
    private JTable cTable;
    private List cList;
    private JPanel pnContacts;

    public LocationPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    public LocationPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog, applicationView, designObject);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_LOCATION_TYPE);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfType = new JTextField();
        this.tfType.setPreferredSize(this.getDefaultSize());
        this.tfType.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfType));
        JLabel jLabel2 = new JLabel(LB_ADDRESS);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfAddress = new JTextField();
        this.tfAddress.setPreferredSize(this.getDefaultSize());
        this.tfAddress.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfAddress));
        JLabel jLabel3 = new JLabel(LB_CITY);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.tfCity = new JTextField();
        this.tfCity.setPreferredSize(this.getDefaultSize());
        this.tfCity.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.tfCity));
        JLabel jLabel4 = new JLabel(LB_POST_CODE);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.tfPostCode = new JTextField();
        this.tfPostCode.setPreferredSize(this.getDefaultSize());
        this.tfPostCode.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.tfPostCode));
        JLabel jLabel5 = new JLabel(LB_AREA);
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.tfArea = new JTextField();
        this.tfArea.setPreferredSize(this.getDefaultSize());
        this.tfArea.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.tfArea));
        JLabel jLabel6 = new JLabel(LB_COUNTRY);
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.tfCountry = new JTextField();
        this.tfCountry.setPreferredSize(this.getDefaultSize());
        this.tfCountry.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.tfCountry));
    }

    @Override
    public String getCaption() {
        return Messages.getString("LocationPropertiesDialogEx.LocationProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof BILocation) {
            this.location = (BILocation)designObject;
            this.tfName.setText(this.location.getName());
            this.tfType.setText(this.location.getLocationType());
            this.tfAddress.setText(this.location.getAddress());
            this.tfCity.setText(this.location.getCity());
            this.tfPostCode.setText(this.location.getPostCode());
            this.tfArea.setText(this.location.getArea());
            this.tfCountry.setText(this.location.getCountry());
            this.cList.addAll(this.location.getContacts());
            this.taComments.setText(this.location.getComment());
            this.tfObjectID.setText(this.location.getObjectID());
            this.tfCreationTime.setText(this.location.getCreationTime());
            this.tfCreator.setText(this.location.getCreator().getName());
            this.tfDesign.setText(this.location.getOwnerDesignName());
            if (this.location.getGenerator() != null) {
                this.tfGeneratorName.setText(this.location.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.location.getChanger().getName());
            this.tfLastChangedTime.setText(this.location.getChangeTime());
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.location.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.location.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.location.setName(this.tfName.getText());
        this.location.setComment(this.taComments.getText());
        this.location.setLocationType(this.tfType.getText());
        this.location.setAddress(this.tfAddress.getText());
        this.location.setCity(this.tfCity.getText());
        this.location.setPostCode(this.tfPostCode.getText());
        this.location.setArea(this.tfArea.getText());
        this.location.setCountry(this.tfCountry.getText());
        LocationPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.location.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.location.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getContactsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "LOCATION_PROPERTIES_DIALOG";
    }

    private JPanel getContactsPanel() {
        if (this.pnContacts == null) {
            this.pnContacts = this.createPage(Messages.getString("LocationPropertiesDialogEx.Contacts"));
            this.cList = new ArrayList();
            this.cTable = new JTable(new ContactTableModel());
            this.cTable.setSelectionMode(0);
            this.cTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = LocationPropertiesDialogEx.this.cTable.getSelectedRow()) != -1 && LocationPropertiesDialogEx.this.cList.size() > 0 && n < LocationPropertiesDialogEx.this.cList.size()) {
                        DesignObject designObject = (DesignObject)LocationPropertiesDialogEx.this.cList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.cTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("LocationPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = LocationPropertiesDialogEx.this.cTable.getSelectedRow();
                    if (n != -1 && LocationPropertiesDialogEx.this.cList.size() > 0 && n < LocationPropertiesDialogEx.this.cList.size()) {
                        DesignObject designObject = (DesignObject)LocationPropertiesDialogEx.this.cList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 210));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnContacts.add(jPanel2);
        }
        return this.pnContacts;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class ContactTableModel
    extends AbstractTableModel {
        private ContactTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return LocationPropertiesDialogEx.this.cList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("LocationPropertiesDialogEx.Contacts");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)LocationPropertiesDialogEx.this.cList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }
}

