/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;

public class DocumentPropertiesDialogEx
extends AbstractPropertiesDialog {
    private BIDocument document;
    private JTextField tfReference;
    private JTextField tfType;
    private JComboBox cbParent;
    private List elmList;
    private JTable elmTable;
    private JPanel pnElements;
    private JTable refTable = null;

    public DocumentPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    public DocumentPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject, JTable jTable) {
        super(dialog, applicationView, designObject);
        this.refTable = jTable;
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_REFERENCE);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfReference = new JTextField();
        this.tfReference.setPreferredSize(this.getDefaultSize());
        this.tfReference.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfReference));
        JLabel jLabel2 = new JLabel(LB_TYPE);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfType = new JTextField();
        this.tfType.setPreferredSize(this.getDefaultSize());
        this.tfType.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfType));
        JLabel jLabel3 = new JLabel(LB_PARENT_DOCUMENT);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbParent = new JComboBox();
        this.cbParent.setFont(this.cbParent.getFont().deriveFont(0));
        this.cbParent.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.cbParent));
    }

    @Override
    public String getCaption() {
        return Messages.getString("DocumentPropertiesDialogEx.DocumentProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof BIDocument) {
            Object object;
            this.document = (BIDocument)designObject;
            this.tfName.setText(this.document.getName());
            this.taComments.setText(this.document.getComment());
            this.tfObjectID.setText(this.document.getObjectID());
            this.tfCreationTime.setText(this.document.getCreationTime());
            this.tfCreator.setText(this.document.getCreator().getName());
            this.tfDesign.setText(this.document.getOwnerDesignName());
            if (this.document.getGenerator() != null) {
                this.tfGeneratorName.setText(this.document.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.document.getChanger().getName());
            this.tfLastChangedTime.setText(this.document.getChangeTime());
            this.elmList.addAll(this.document.getElements());
            this.tfReference.setText(this.document.getReference());
            this.tfType.setText(this.document.getType());
            ArrayList<BIDocument> arrayList = new ArrayList<BIDocument>();
            Iterator iterator = this.document.getDesign().getBusinessInfoDesign().getDocumentSet().iterator();
            while (iterator.hasNext()) {
                object = (BIDocument)iterator.next();
                if (object == this.document || this.hasThisDocumentAsAncestor((BIDocument)object)) continue;
                arrayList.add((BIDocument)object);
            }
            this.fillComboItems(arrayList.toArray(), this.cbParent, true);
            this.cbParent.setSelectedItem(this.document.getParentDocument());
            this.dynamicPropertiesList.clear();
            object = this.document.getPropertyNames();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = this.document.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private boolean hasThisDocumentAsAncestor(BIDocument bIDocument) {
        BIDocument bIDocument2 = bIDocument.getParentDocument();
        if (bIDocument2 == null) {
            return false;
        }
        if (bIDocument2 == this.document) {
            return true;
        }
        return this.hasThisDocumentAsAncestor(bIDocument2);
    }

    @Override
    protected void setProperties() {
        this.document.setName(this.tfName.getText());
        this.document.setComment(this.taComments.getText());
        this.document.setReference(this.tfReference.getText());
        this.document.setType(this.tfType.getText());
        this.document.setParentDocument((BIDocument)this.cbParent.getSelectedItem());
        if (this.refTable != null) {
            this.refTable.updateUI();
        }
        DocumentPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.document.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.document.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getElementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "DOCUMENT_PROPERTIES_DIALOG";
    }

    private JPanel getElementsPanel() {
        if (this.pnElements == null) {
            this.pnElements = this.createPage(Messages.getString("DocumentPropertiesDialogEx.Elements"));
            this.elmList = new ArrayList();
            this.elmTable = new JTable(new ElementTableModel());
            this.elmTable.setSelectionMode(0);
            this.elmTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = DocumentPropertiesDialogEx.this.elmTable.getSelectedRow()) != -1 && DocumentPropertiesDialogEx.this.elmList.size() > 0 && n < DocumentPropertiesDialogEx.this.elmList.size()) {
                        DesignObject designObject = (DesignObject)DocumentPropertiesDialogEx.this.elmList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.elmTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("DocumentPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = DocumentPropertiesDialogEx.this.elmTable.getSelectedRow();
                    if (n != -1 && DocumentPropertiesDialogEx.this.elmList.size() > 0 && n < DocumentPropertiesDialogEx.this.elmList.size()) {
                        DesignObject designObject = (DesignObject)DocumentPropertiesDialogEx.this.elmList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 180));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnElements.add(jPanel2);
        }
        return this.pnElements;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class ElementTableModel
    extends AbstractTableModel {
        private ElementTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return DocumentPropertiesDialogEx.this.elmList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DocumentPropertiesDialogEx.Elements");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)DocumentPropertiesDialogEx.this.elmList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }
}

