/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.util.MessageDialogs;

public abstract class AbstractAddObjectDialog
extends JDialog
implements AbstractEditorConstants {
    private Design design;
    protected List sList;
    private JPanel generalPanel;
    private List allList = new ArrayList();
    private JTable allTable;
    private JRadioButton rbNew;
    private JRadioButton rbAll;
    private JButton bnCancel;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractAddObjectDialog.this.bnCancel.doClick();
        }
    };

    public AbstractAddObjectDialog(ApplicationView applicationView, Design design, List list) {
        super(applicationView.getFrame());
        this.setModal(true);
        this.design = design;
        this.sList = list;
        this.setTitle(this.getAddObjectString());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AbstractAddObjectDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getSelectObjectString()));
        RadioListener radioListener = new RadioListener();
        this.rbNew = new JRadioButton(this.getNewObjectString());
        this.rbNew.addActionListener(radioListener);
        this.rbNew.setMnemonic(78);
        this.rbAll = new JRadioButton(this.getAvailableObjectsString());
        this.rbAll.addActionListener(radioListener);
        this.rbAll.setMnemonic(65);
        this.rbNew.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNew);
        buttonGroup.add(this.rbAll);
        jPanel.add(this.rbNew);
        jPanel.add(this.rbAll);
        this.generalPanel.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getAllObjectsString()));
        this.allList.addAll(this.getAllObjects());
        this.allTable = new JTable(new AllObjectsModel());
        this.allTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.allTable);
        jScrollPane.setPreferredSize(new Dimension(240, 220));
        jPanel2.add(jScrollPane);
        this.generalPanel.add(jPanel2);
        this.enableControls(!this.rbNew.isSelected());
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setMnemonic(79);
        this.bnCancel = new JButton(BTN_CANCEL);
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel3.add(jButton);
        jPanel3.add(this.bnCancel);
        this.getContentPane().add((Component)jPanel3, "South");
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escapeAction);
        this.pack();
        this.centerOnScreen(this);
        this.setResizable(false);
    }

    protected abstract String getAddObjectString();

    protected abstract String getSelectObjectString();

    protected abstract String getNewObjectString();

    protected abstract String getAvailableObjectsString();

    protected abstract String getAllObjectsString();

    public Design getDesign() {
        return this.design;
    }

    protected abstract List getAllObjects();

    protected abstract String getColumnCaption();

    private void enableControls(boolean bl) {
        this.allTable.setEnabled(bl);
        this.allTable.clearSelection();
        if (!bl) {
            this.allTable.setBackground(Color.LIGHT_GRAY);
        } else {
            this.allTable.setBackground(Color.WHITE);
        }
    }

    protected abstract DesignObject createObject();

    public void centerOnScreen(JDialog jDialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jDialog.getSize();
        Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        jDialog.setLocation(point);
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractAddObjectDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AbstractAddObjectDialog.this.rbNew.isSelected()) {
                AbstractAddObjectDialog.this.sList.add(AbstractAddObjectDialog.this.createObject());
            } else {
                int n = AbstractAddObjectDialog.this.allTable.getSelectedRow();
                if (n != -1 && AbstractAddObjectDialog.this.allList.size() > 0 && n < AbstractAddObjectDialog.this.allList.size()) {
                    AbstractAddObjectDialog.this.sList.add(AbstractAddObjectDialog.this.allList.get(n));
                }
            }
            AbstractAddObjectDialog.this.dispose();
        }
    }

    private class AllObjectsModel
    extends AbstractTableModel {
        private AllObjectsModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractAddObjectDialog.this.allList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return AbstractAddObjectDialog.this.getColumnCaption();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)AbstractAddObjectDialog.this.allList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractAddObjectDialog.this.enableControls(!AbstractAddObjectDialog.this.rbNew.isSelected());
        }
    }
}

