/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class TextEditDialog
extends CustomDialog {
    private JEditorPane editorPane;
    private JPanel buttonsPanel;
    private JDialog dialog;
    private String oldText;
    private String editedText;
    private boolean readOnly = false;
    private Dialog parent;

    public TextEditDialog(Dialog dialog, ApplicationView applicationView, String string, boolean bl) {
        super(applicationView);
        this.parent = dialog;
        this.oldText = string;
        this.editedText = string;
        this.readOnly = bl;
        this.editorPane = this.getEditorPane();
        this.initProperties();
        JScrollPane jScrollPane = new JScrollPane(this.editorPane);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel = this.getButtonPanel();
        this.add((Component)jPanel, "South");
    }

    public void initProperties() {
        this.editorPane.setText(this.oldText);
    }

    public void setProperties() {
        this.editedText = this.editorPane.getText();
    }

    public JEditorPane getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = new JEditorPane();
            this.editorPane.setContentType("text/plain");
            this.editorPane.setPreferredSize(new Dimension(500, 300));
            this.editorPane.setEditable(!this.readOnly);
        }
        return this.editorPane;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonsPanel == null) {
            JButton jButton;
            this.buttonsPanel = new JPanel();
            if (!this.readOnly) {
                jButton = new JButton(Messages.getString("TextEditDialog.OK"));
                jButton.setMnemonic(79);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TextEditDialog.this.setProperties();
                        TextEditDialog.this.close();
                    }
                });
                jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonsPanel.add(jButton);
            }
            jButton = new JButton(this.readOnly ? Messages.getString("TextEditDialog.Close") : Messages.getString("TextEditDialog.Cancel"));
            jButton.setMnemonic(67);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TextEditDialog.this.close();
                }
            });
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonsPanel.add(jButton);
        }
        return this.buttonsPanel;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parent);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setTitle(Messages.getString("TextEditDialog.EditConstraint"));
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public String getText() {
        return this.editedText;
    }

    public void setText(String string) {
        this.editedText = string;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }
}

