/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.TableModel;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.editor.relational.ColumnGroupsTableModel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class TFCellEditor
extends DefaultCellEditor
implements FocusListener {
    private static final long serialVersionUID = -1238416927237741284L;
    private JTextField tf;
    private String val;
    private JTable tab;

    public TFCellEditor(JTextField jTextField) {
        super(jTextField);
        this.tf = jTextField;
        jTextField.addFocusListener(this);
        super.setClickCountToStart(1);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.tf.setText(object.toString());
        this.tf.selectAll();
        this.tf.setBorder(null);
        this.val = this.tf.getText();
        this.tab = jTable;
        return this.tf;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.tf.selectAll();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean stopCellEditing() {
        JTextField jTextField = (JTextField)this.getComponent();
        String string = jTextField.getText().trim();
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(null, Messages.getString("TablePropertiesDialogEx.NameNotNull"), Messages.getString("TFCellEditor.TFCellEditor.Warning"), 2);
            jTextField.setText(this.val);
            jTextField.setBorder(new LineBorder(Color.black));
            jTextField.requestFocusInWindow();
            return false;
        }
        TableModel tableModel = this.tab.getModel();
        if (tableModel instanceof ColumnGroupsTableModel) {
            int n = 0;
            for (Table.ColumnGroup columnGroup : ((ColumnGroupsTableModel)this.tab.getModel()).getColumnGroupList()) {
                if (!columnGroup.getName().equals(string) || string.equals(this.val)) continue;
                ++n;
                JOptionPane.showMessageDialog(null, Messages.getString("TablePropertiesDialogEx.ColumnGrNameExists"), Messages.getString("TFCellEditor.TFCellEditor.Warning"), 2);
                jTextField.setText(this.val);
                jTextField.setBorder(new LineBorder(Color.black));
                jTextField.requestFocusInWindow();
                return false;
            }
        }
        return super.stopCellEditing();
    }
}

