/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectRelationalModelDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private DefaultListModel listModel;
    private JList list;
    private RelationalDesign result = null;
    private JButton bnOK;
    private ApplicationView appView;
    private JComboBox cbDesigns;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectRelationalModelDialog.this.result = null;
            SelectRelationalModelDialog.this.dispose();
        }
    };

    public SelectRelationalModelDialog(ApplicationView applicationView) {
        super(applicationView.getFrame(), Messages.getString("SelectRelationalModelDialog.SelectRelationalModel"), true);
        this.appView = applicationView;
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        this.updateRelationalModels();
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        jComponent.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setResizable(false);
        CommonUtil.centerOnScreen(this);
    }

    private JPanel init() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setPreferredSize(new Dimension(280, 230));
        jPanel2.add((Component)this.initDesignList(), "North");
        jPanel2.add((Component)this.initRMList(), "Center");
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel initDesignList() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(Messages.getString("SelectRelationalModelDialog.SelectDesign"));
        jPanel.add((Component)jLabel, "North");
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.cbDesigns = new JComboBox<Object>(this.appView.getDesigns().toArray());
        this.cbDesigns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectRelationalModelDialog.this.updateRelationalModels();
            }
        });
        jPanel.add((Component)this.cbDesigns, "Center");
        jPanel.add((Component)new JPanel(), "South");
        return jPanel;
    }

    private void updateRelationalModels() {
        this.listModel.clear();
        this.bnOK.setEnabled(false);
        Design design = (Design)this.cbDesigns.getSelectedItem();
        if (design != null) {
            Iterator iterator = design.getRelationalDesigns().iterator();
            while (iterator.hasNext()) {
                this.listModel.addElement(iterator.next());
            }
        }
        this.list.updateUI();
    }

    private JPanel initRMList() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(Messages.getString("SelectRelationalModelDialog.SelectRelationalModel1"));
        jPanel.add((Component)jLabel, "North");
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SelectRelationalModelDialog.this.result = (RelationalDesign)SelectRelationalModelDialog.this.list.getSelectedValue();
                if (mouseEvent.getClickCount() == 2) {
                    SelectRelationalModelDialog.this.dispose();
                }
                SelectRelationalModelDialog.this.bnOK.setEnabled(SelectRelationalModelDialog.this.result != null);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = listSelectionEvent.getValueIsAdjusting();
                if (!bl) {
                    JList jList = (JList)listSelectionEvent.getSource();
                    int n = jList.getSelectedIndex();
                    SelectRelationalModelDialog.this.bnOK.setEnabled(n >= 0);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    public JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(Messages.getString("JListDialog.OK"));
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectRelationalModelDialog.this.result = (RelationalDesign)SelectRelationalModelDialog.this.list.getSelectedValue();
                if (SelectRelationalModelDialog.this.result != null) {
                    SelectRelationalModelDialog.this.appView.setCurrentDesign(SelectRelationalModelDialog.this.result.getDesign());
                }
                SelectRelationalModelDialog.this.dispose();
            }
        });
        this.bnOK.setEnabled(this.list.getSelectedValue() != null);
        this.getRootPane().setDefaultButton(this.bnOK);
        jPanel.add(this.bnOK);
        JButton jButton = new JButton(Messages.getString("JListDialog.Cancel"));
        jButton.setMnemonic(67);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectRelationalModelDialog.this.result = null;
                SelectRelationalModelDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    public RelationalDesign getResult() {
        return this.result;
    }

    public static RelationalDesign showDialog(ApplicationView applicationView) {
        SelectRelationalModelDialog selectRelationalModelDialog = new SelectRelationalModelDialog(applicationView);
        selectRelationalModelDialog.setVisible(true);
        return selectRelationalModelDialog.getResult();
    }
}

