/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectObjectsDialog
extends CustomDialog {
    private JDialog dialog;
    private List allObjects;
    private List selectedObjects;
    private JPanel generalPanel;
    private String title;
    private JList selectedObjectsList;
    private JList allObjectsList;
    private DefaultListModel allObjectsModel;
    private DefaultListModel selectedObjectsModel;
    private JButton btnAdd;
    private JButton btnRemove;
    private boolean cancelled = false;

    public SelectObjectsDialog(ApplicationView applicationView, List list, List list2, String string) {
        super(applicationView);
        this.allObjects = list;
        this.selectedObjects = list2;
        this.title = string;
        this.generalPanel = new JPanel(new BorderLayout());
        this.allObjectsModel = new DefaultListModel();
        this.selectedObjectsModel = new DefaultListModel();
        this.init();
        this.add((Component)this.generalPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private void init() {
        this.initAllObjectsList();
        this.initButtons();
        this.initSelectedObjectsList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator iterator = this.selectedObjects.iterator();
        while (iterator.hasNext()) {
            this.selectedObjectsModel.addElement(iterator.next());
        }
        for (Object e : this.allObjects) {
            if (this.selectedObjects.contains(e)) continue;
            this.allObjectsModel.addElement(e);
        }
    }

    private void initAllObjectsList() {
        JPanel jPanel = new JPanel();
        this.allObjectsList = new JList(this.allObjectsModel);
        ListSelectionModel listSelectionModel = this.allObjectsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllObjectsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allObjectsList);
        jScrollPane.setPreferredSize(new Dimension(220, 300));
        jPanel.add(jScrollPane);
        this.generalPanel.add((Component)jPanel, "West");
    }

    private void initSelectedObjectsList() {
        JPanel jPanel = new JPanel();
        this.selectedObjectsList = new JList(this.selectedObjectsModel);
        ListSelectionModel listSelectionModel = this.selectedObjectsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedObjectsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedObjectsList);
        jScrollPane.setPreferredSize(new Dimension(220, 300));
        jPanel.add(jScrollPane);
        this.generalPanel.add((Component)jPanel, "East");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initButtons() {
        JPanel jPanel = new JPanel();
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAdd.addActionListener(new AddActionListener());
        this.btnAdd.setEnabled(false);
        this.btnAdd.setToolTipText(Messages.getString("SelectObjectsDialog.Add"));
        this.btnRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new RemoveActionListener());
        this.btnRemove.setToolTipText(Messages.getString("SelectObjectsDialog.Remove"));
        jToolBar.add(this.btnAdd);
        jToolBar.add(this.btnRemove);
        jPanel.add(jToolBar);
        jPanel.setPreferredSize(new Dimension(32, 300));
        this.generalPanel.add((Component)jPanel, "Center");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().show();
        return !this.cancelled;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.title);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private void setProperties() {
        this.selectedObjects.clear();
        for (int i = 0; i < this.selectedObjectsModel.size(); ++i) {
            this.selectedObjects.add(this.selectedObjectsModel.getElementAt(i));
        }
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(Messages.getString("SelectObjectsDialog.OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectObjectsDialog.this.setProperties();
                SelectObjectsDialog.this.cancelled = false;
                SelectObjectsDialog.this.close();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("SelectObjectsDialog.Cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectObjectsDialog.this.selectedObjects.clear();
                SelectObjectsDialog.this.cancelled = true;
                SelectObjectsDialog.this.close();
            }
        });
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private class SelectedObjectsListSelectionHandler
    implements ListSelectionListener {
        private SelectedObjectsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (SelectObjectsDialog.this.selectedObjectsList.getSelectedIndex() == -1) {
                    SelectObjectsDialog.this.btnRemove.setEnabled(false);
                } else {
                    SelectObjectsDialog.this.btnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllObjectsListSelectionHandler
    implements ListSelectionListener {
        private AllObjectsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (SelectObjectsDialog.this.allObjectsList.getSelectedIndex() == -1) {
                    SelectObjectsDialog.this.btnAdd.setEnabled(false);
                } else {
                    SelectObjectsDialog.this.btnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SelectObjectsDialog.this.selectedObjectsModel.isEmpty()) {
                Object[] objectArray = SelectObjectsDialog.this.selectedObjectsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SelectObjectsDialog.this.allObjectsModel.contains(object)) continue;
                    SelectObjectsDialog.this.allObjectsModel.addElement(object);
                    SelectObjectsDialog.this.selectedObjectsModel.removeElement(object);
                }
            }
        }
    }

    private class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SelectObjectsDialog.this.allObjectsModel.isEmpty()) {
                Object[] objectArray = SelectObjectsDialog.this.allObjectsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SelectObjectsDialog.this.selectedObjectsModel.contains(object)) continue;
                    SelectObjectsDialog.this.selectedObjectsModel.addElement(object);
                    SelectObjectsDialog.this.allObjectsModel.removeElement(object);
                }
            }
        }
    }
}

