/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectExportDialog
extends CustomDialog {
    private JDialog dialog;
    private String title;
    private Design design;
    private JPanel generalPanel;
    private boolean cancelled = false;
    private List expObjects = new ArrayList();
    private List designParts = new ArrayList();
    private JTable expTable;

    public SelectExportDialog(ApplicationView applicationView, String string) {
        super(applicationView);
        this.design = applicationView.getCurrentDesign();
        this.title = string;
        this.generalPanel = new JPanel(new BorderLayout());
        this.init();
        this.add((Component)this.generalPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private void init() {
        this.buildExpLists();
        this.expTable = new JTable(new ExportModel());
        this.expTable.setDefaultRenderer(Object.class, new ExportRenderer());
        TableColumn tableColumn = this.expTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn.setMaxWidth(60);
        tableColumn.setMinWidth(50);
        tableColumn = this.expTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(90);
        tableColumn.setMaxWidth(100);
        tableColumn.setMinWidth(50);
        JScrollPane jScrollPane = new JScrollPane(this.expTable);
        jScrollPane.setPreferredSize(new Dimension(500, 410));
        this.generalPanel.add(jScrollPane);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.title);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(true);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(Messages.getString("SelectExportDialog.OK"));
        jButton.setMnemonic(79);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectExportDialog.this.cancelled = false;
                SelectExportDialog.this.close();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("SelectExportDialog.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectExportDialog.this.cancelled = true;
                SelectExportDialog.this.close();
            }
        });
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return !this.cancelled;
    }

    private void buildExpLists() {
        DesignPart designPart;
        this.expObjects.clear();
        this.designParts.clear();
        ExpObject expObject = new ExpObject(this.design.getLogicalDesign());
        this.expObjects.add(expObject);
        this.designParts.add(expObject);
        this.addSVtoList(expObject, this.design.getLogicalDesign());
        Iterator iterator = this.design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            designPart = (RelationalDesign)iterator.next();
            expObject = new ExpObject(designPart);
            this.expObjects.add(expObject);
            this.designParts.add(expObject);
            this.addSVtoList(expObject, designPart);
        }
        expObject = new ExpObject(this.design.getDataTypesDesign());
        this.expObjects.add(expObject);
        this.designParts.add(expObject);
        expObject = new ExpObject(this.design.getProcessModel());
        this.expObjects.add(expObject);
        this.designParts.add(expObject);
        iterator = this.design.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            designPart = (MultidimensionalDesign)iterator.next();
            expObject = new ExpObject(designPart);
            this.expObjects.add(expObject);
            this.designParts.add(expObject);
        }
        expObject = new ExpObject(this.design.getBusinessInfoDesign());
        this.expObjects.add(expObject);
        this.designParts.add(expObject);
    }

    private void addSVtoList(ExpObject expObject, DesignPart designPart) {
        Iterator iterator = designPart.getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            ExpObject expObject2 = new ExpObject(designPartViewPlaceHolder);
            expObject2.parent = expObject;
            this.expObjects.add(expObject2);
        }
    }

    public List getDesignParts() {
        return this.designParts;
    }

    public class ExportRenderer
    extends DefaultTableCellRenderer {
        Color color = new Color(204, 255, 255);

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            Color color2;
            ExpObject expObject = (ExpObject)SelectExportDialog.this.expObjects.get(n);
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 2 && expObject.isDesignPart()) {
                color2 = Color.LIGHT_GRAY;
                color = Color.WHITE;
            } else {
                color2 = Color.WHITE;
                color = Color.BLACK;
            }
            component.setBackground(color2);
            component.setForeground(color);
            return component;
        }
    }

    public class ExpObject {
        public boolean selected = false;
        private boolean isDesignPart = false;
        ModelIDObject object;
        List subViews = new ArrayList();
        ExpObject parent;
        String type;

        ExpObject(ModelIDObject modelIDObject) {
            this.object = modelIDObject;
            if (modelIDObject instanceof DesignPart) {
                this.isDesignPart = true;
            }
        }

        public boolean isDesignPart() {
            return this.isDesignPart;
        }

        String getDesignPartType(ModelIDObject modelIDObject) {
            if (modelIDObject instanceof LogicalDesign) {
                return Messages.getString("SelectExportDialog.Logical");
            }
            if (modelIDObject instanceof RelationalDesign) {
                return Messages.getString("SelectExportDialog.Relational");
            }
            if (modelIDObject instanceof DataTypesDesign) {
                return Messages.getString("SelectExportDialog.DataTypes");
            }
            if (modelIDObject instanceof MultidimensionalDesign) {
                return Messages.getString("SelectExportDialog.MultiDimensional");
            }
            if (modelIDObject instanceof ProcessModel) {
                return Messages.getString("SelectExportDialog.Process");
            }
            if (modelIDObject instanceof BusinessInfoDesign) {
                return Messages.getString("SelectExportDialog.BusinessInfo");
            }
            return " ";
        }

        String getType() {
            if (this.isDesignPart) {
                return this.getDesignPartType(this.object);
            }
            if (this.object instanceof DesignPartViewPlaceHolder) {
                DesignPart designPart = ((DesignPartViewPlaceHolder)this.object).getDesignPart();
                return this.getDesignPartType(designPart) + "/SV";
            }
            return "/SV";
        }

        public List getSubViews() {
            return this.subViews;
        }

        public String toString() {
            return this.object.getName();
        }

        public ModelIDObject getObject() {
            return this.object;
        }
    }

    private class ExportModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SelectExportDialog.Selected"), Messages.getString("SelectExportDialog.ModelType"), Messages.getString("SelectExportDialog.ModelSubview")};

        private ExportModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return SelectExportDialog.this.expObjects.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 <= 0;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                ExpObject expObject = (ExpObject)SelectExportDialog.this.expObjects.get(n);
                if (object instanceof Boolean) {
                    expObject.selected = (Boolean)object;
                    if (expObject.parent != null) {
                        if (expObject.selected) {
                            if (!expObject.parent.subViews.contains(expObject)) {
                                expObject.parent.subViews.add(expObject);
                            }
                        } else {
                            expObject.parent.subViews.remove(expObject);
                        }
                    }
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ExpObject expObject = (ExpObject)SelectExportDialog.this.expObjects.get(n);
            if (n2 == 1) {
                return expObject.getType();
            }
            if (n2 == 2) {
                if (expObject.isDesignPart()) {
                    return expObject.object.getName();
                }
                return "     " + expObject.object.getName();
            }
            if (n2 == 0) {
                return expObject.selected;
            }
            return new Integer(n * n2);
        }
    }
}

