/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectAttributesDialog
extends JDialog
implements AbstractEditorConstants {
    private List aList;
    private JList selectedAttributesList;
    private JList allAttributesList;
    private DefaultListModel allAttributesModel;
    private DefaultListModel selectedAttributesModel;
    private JButton btnAddAttributes;
    private JButton btnRemoveAttributes;
    protected JPanel generalPanel;
    private ContainerObject selectedEntity;

    public SelectAttributesDialog(ApplicationView applicationView, List list, ContainerObject containerObject) {
        super(applicationView.getFrame());
        this.selectedEntity = containerObject;
        this.setModal(true);
        this.aList = list;
        this.setTitle(Messages.getString("SelectAttributesDialog.SelectAttributes"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SelectAttributesDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.allAttributesModel = new DefaultListModel();
        this.selectedAttributesModel = new DefaultListModel();
        this.init(applicationView);
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(BTN_CANCEL);
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    public SelectAttributesDialog(ApplicationView applicationView, List list) {
        super(applicationView.getFrame());
        this.setModal(true);
        this.aList = list;
        this.setTitle(Messages.getString("SelectAttributesDialog.SelectAttributes"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SelectAttributesDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.allAttributesModel = new DefaultListModel();
        this.selectedAttributesModel = new DefaultListModel();
        this.init(applicationView);
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(BTN_CANCEL);
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void init(ApplicationView applicationView) {
        this.initAllAttributesList();
        this.initAttributesButtons();
        this.initSelectedAttributesList();
        this.fillLists(applicationView);
    }

    private void fillLists(ApplicationView applicationView) {
        AttributeItem attributeItem;
        HashMap<ContainedObject, AttributeItem> hashMap = new HashMap<ContainedObject, AttributeItem>();
        ArrayList arrayList = new ArrayList();
        if (this.selectedEntity != null) {
            if (this.selectedEntity instanceof Entity) {
                arrayList.addAll(((Entity)this.selectedEntity).getHierarchicalAttributes());
            } else {
                arrayList.addAll(this.selectedEntity.getElementsCollection());
            }
        } else {
            applicationView.getCurrentDesign().getLogicalDesign().getAttributeSet().addAllElementsTo(arrayList);
        }
        Collections.sort(arrayList, ModelObjectSet.LONG_NAME_COMPARATOR);
        for (ContainedObject containedObject : arrayList) {
            attributeItem = new AttributeItem(containedObject);
            hashMap.put(containedObject, attributeItem);
            this.allAttributesModel.addElement(attributeItem);
        }
        Collections.sort(this.aList, ModelObjectSet.LONG_NAME_COMPARATOR);
        for (ContainedObject containedObject : this.aList) {
            attributeItem = (AttributeItem)hashMap.get(containedObject);
            if (attributeItem == null) continue;
            this.allAttributesModel.removeElement(attributeItem);
            this.selectedAttributesModel.addElement(attributeItem);
        }
    }

    private void initAllAttributesList() {
        JPanel jPanel = new JPanel();
        this.allAttributesList = new JList(this.allAttributesModel);
        ListSelectionModel listSelectionModel = this.allAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allAttributesList);
        jScrollPane.setPreferredSize(new Dimension(220, 300));
        jPanel.add(jScrollPane);
        this.generalPanel.add((Component)jPanel, "West");
    }

    private void initSelectedAttributesList() {
        JPanel jPanel = new JPanel();
        this.selectedAttributesList = new JList(this.selectedAttributesModel);
        ListSelectionModel listSelectionModel = this.selectedAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedAttributesList);
        jScrollPane.setPreferredSize(new Dimension(220, 300));
        jPanel.add(jScrollPane);
        this.generalPanel.add((Component)jPanel, "East");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initAttributesButtons() {
        JPanel jPanel = new JPanel();
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAddAttributes = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddAttributes.addActionListener(new AddColumnsActionListener());
        this.btnAddAttributes.setEnabled(false);
        this.btnAddAttributes.setToolTipText(Messages.getString("SelectAttributesDialog.Add"));
        this.btnRemoveAttributes = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveAttributes.setEnabled(false);
        this.btnRemoveAttributes.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveAttributes.setToolTipText(Messages.getString("SelectAttributesDialog.Remove"));
        jToolBar.add(this.btnAddAttributes);
        jToolBar.add(this.btnRemoveAttributes);
        jPanel.add(jToolBar);
        jPanel.setPreferredSize(new Dimension(32, 300));
        this.generalPanel.add((Component)jPanel, "Center");
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (SelectAttributesDialog.this.selectedAttributesList.getSelectedIndex() == -1) {
                    SelectAttributesDialog.this.btnRemoveAttributes.setEnabled(false);
                } else {
                    SelectAttributesDialog.this.btnRemoveAttributes.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (SelectAttributesDialog.this.allAttributesList.getSelectedIndex() == -1) {
                    SelectAttributesDialog.this.btnAddAttributes.setEnabled(false);
                } else {
                    SelectAttributesDialog.this.btnAddAttributes.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SelectAttributesDialog.this.selectedAttributesModel.isEmpty()) {
                Object[] objectArray = SelectAttributesDialog.this.selectedAttributesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SelectAttributesDialog.this.allAttributesModel.contains(object)) continue;
                    SelectAttributesDialog.this.allAttributesModel.addElement(object);
                    SelectAttributesDialog.this.selectedAttributesModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SelectAttributesDialog.this.allAttributesModel.isEmpty()) {
                Object object;
                int n;
                Object[] objectArray = SelectAttributesDialog.this.allAttributesList.getSelectedValues();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (n = 0; n < objectArray.length; ++n) {
                    object = objectArray[n];
                    if (SelectAttributesDialog.this.selectedAttributesModel.contains(object)) continue;
                    arrayList.add(object);
                    SelectAttributesDialog.this.allAttributesModel.removeElement(object);
                }
                for (n = 0; n < SelectAttributesDialog.this.selectedAttributesModel.size(); ++n) {
                    object = (AttributeItem)SelectAttributesDialog.this.selectedAttributesModel.getElementAt(n);
                    arrayList.add(object);
                }
                Collections.sort(arrayList);
                SelectAttributesDialog.this.selectedAttributesModel.removeAllElements();
                for (n = 0; n < arrayList.size(); ++n) {
                    SelectAttributesDialog.this.selectedAttributesModel.addElement(arrayList.get(n));
                }
            }
        }
    }

    private class AttributeItem
    implements Comparable {
        private ContainedObject attribute = null;

        public AttributeItem(ContainedObject containedObject) {
            this.attribute = containedObject;
        }

        public ContainedObject getAttribute() {
            return this.attribute;
        }

        public String toString() {
            if (this.attribute != null) {
                return this.attribute.getLongName();
            }
            return "";
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(object.toString());
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectAttributesDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectAttributesDialog.this.aList.clear();
            for (int i = 0; i < SelectAttributesDialog.this.selectedAttributesModel.size(); ++i) {
                AttributeItem attributeItem = (AttributeItem)SelectAttributesDialog.this.selectedAttributesModel.getElementAt(i);
                SelectAttributesDialog.this.aList.add(attributeItem.getAttribute());
            }
            Collections.sort(SelectAttributesDialog.this.aList, ModelObjectSet.LONG_NAME_COMPARATOR);
            SelectAttributesDialog.this.dispose();
        }
    }
}

