/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.undo.NoteUpdateEdit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class NoteEditor
extends CustomDialog
implements AbstractEditorConstants {
    private JEditorPane editorPane;
    private JPanel buttonPanel;
    private Note note;
    private JDialog dialog;

    public NoteEditor(ApplicationView applicationView) {
        super(applicationView);
    }

    public NoteEditor(ApplicationView applicationView, Note note) {
        super(applicationView);
        this.note = note;
        this.editorPane = this.getEditorPane();
        this.initProperties(note);
        JScrollPane jScrollPane = new JScrollPane(this.editorPane);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel = this.getButtonPanel();
        this.add((Component)jPanel, "South");
    }

    public String getCaption() {
        return Messages.getString("NoteEditor.Note");
    }

    private void setProperties() {
        NoteUpdateEdit noteUpdateEdit = new NoteUpdateEdit(this.note, this.editorPane.getText());
        noteUpdateEdit.end();
        noteUpdateEdit.applyUpdates();
        this.note.getDesignPart().postUndoableEdit(noteUpdateEdit);
    }

    protected JEditorPane getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = new JEditorPane();
            this.editorPane.setContentType("text/plain");
            this.editorPane.setPreferredSize(new Dimension(500, 300));
            this.editorPane.setEnabled(this.isEditable());
        }
        return this.editorPane;
    }

    public void initProperties(Note note) {
        this.editorPane.setText(note.getText());
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            JButton jButton;
            this.buttonPanel = new JPanel();
            if (this.isEditable()) {
                jButton = new JButton(Messages.getString("NoteEditor.OK"));
                jButton.setCursor(Cursor.getPredefinedCursor(12));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        NoteEditor.this.setProperties();
                        NoteEditor.this.close();
                    }
                });
                jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(jButton);
            }
            jButton = new JButton(this.isEditable() ? Messages.getString("NoteEditor.Cancel") : Messages.getString("NoteEditor.Close"));
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (NoteEditor.this.note.showForFirstTime()) {
                        NoteEditor.this.note.remove(false);
                    }
                    NoteEditor.this.close();
                }
            });
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(jButton);
        }
        return this.buttonPanel;
    }

    protected JPanel initMainPanel() {
        return null;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        if (this.note.showModal || this.note.showForFirstTime()) {
            ((JDialog)this.getDialog()).setModal(true);
        }
        this.getDialog().show();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.getCaption());
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }
}

