/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.exceptions.EmptyFieldException;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class NewRepositoryDesignDialog
extends CustomDialog
implements AbstractEditorConstants {
    private String name;
    private String description = "";
    private JDialog dialog;
    private JPanel buttonPanel;
    private JTextField tfName;
    private JTextField tfDescription;
    private Dimension defaultLBSize = new Dimension(70, 20);
    private Dimension defaultSize = new Dimension(200, 20);

    public NewRepositoryDesignDialog(ApplicationView applicationView, String string) {
        super(applicationView);
        this.name = string;
        this.add((Component)this.initMainPanel(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("NewRepositoryDesignDialog.SetDesignDetails"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    protected JPanel createRow(Component component, Component component2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(component, "West");
        jPanel.add(component2, "Center");
        return jPanel;
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    private JPanel initMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(290, 70));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 10, 10));
        JLabel jLabel = new JLabel(LB_NAME);
        jLabel.setPreferredSize(this.defaultLBSize);
        this.tfName = new JTextField(this.name);
        this.tfName.setPreferredSize(this.defaultSize);
        jPanel3.add(this.createRow(jLabel, this.tfName));
        JLabel jLabel2 = new JLabel(LB_DESCRIPTION);
        jLabel2.setPreferredSize(this.defaultLBSize);
        this.tfDescription = new JTextField(this.description);
        this.tfDescription.setPreferredSize(this.defaultSize);
        jPanel3.add(this.createRow(jLabel2, this.tfDescription));
        jPanel2.add((Component)jPanel3, "North");
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            JButton jButton = new JButton(Messages.getString("DesignPropertiesDialog.OK"));
            jButton.setMnemonic(79);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        if ("".equalsIgnoreCase(NewRepositoryDesignDialog.this.tfName.getText())) {
                            NewRepositoryDesignDialog.this.tfName.requestFocus();
                            throw new EmptyFieldException(Messages.getString("NewRepositoryDesignDialog.NotEmptyName"));
                        }
                        NewRepositoryDesignDialog.this.name = NewRepositoryDesignDialog.this.tfName.getText();
                        NewRepositoryDesignDialog.this.description = NewRepositoryDesignDialog.this.tfDescription.getText();
                        NewRepositoryDesignDialog.this.close();
                    }
                    catch (EmptyFieldException emptyFieldException) {
                        JOptionPane.showMessageDialog(NewRepositoryDesignDialog.this, emptyFieldException.getMessage(), Messages.getString("NewRepositoryDesignDialog.Error"), 0);
                    }
                }
            });
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(jButton);
            JButton jButton2 = new JButton(Messages.getString("NewRepositoryDesignDialog.Cancel"));
            jButton2.setMnemonic(67);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewRepositoryDesignDialog.this.close();
                }
            });
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(jButton2);
        }
        return this.buttonPanel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

