/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class LogicalTypeDialog
extends JDialog {
    private ApplicationView view;
    private ContainedObjectWithDomain object;
    private JPanel buttonPanel;
    private JPanel general;
    private JButton bnLogicalType;
    private String selectedRdbmsSite;
    private JComboBox cbLogicalType;
    private JTextField tfSize;
    private JIntegerField tfPrecision;
    private JIntegerField tfScale;
    private JComboBox cbUnits;
    protected static final int FIELD_WIDTH = 10;
    private static final String EMPTY_STRING = "";
    private boolean readOnly = false;
    private boolean usePreferredList = false;

    public LogicalTypeDialog(ApplicationView applicationView, ContainedObjectWithDomain containedObjectWithDomain, JButton jButton, String string, boolean bl) {
        super(applicationView.getFrame());
        this.usePreferredList = bl;
        this.view = applicationView;
        this.object = containedObjectWithDomain;
        this.bnLogicalType = jButton;
        this.selectedRdbmsSite = string;
        this.setTitle(Messages.getString("LogicalTypeDialog.LogicalType"));
        this.general = new JPanel(new SpringLayout());
        this.general.setBorder(BorderFactory.createEtchedBorder(0));
        this.initGeneral();
        this.initProperties();
        this.getContentPane().add((Component)this.general, "Center");
        this.setDefaultCloseOperation(2);
        JPanel jPanel = this.getButtonPanel();
        this.getContentPane().add((Component)jPanel, "South");
        this.general.setPreferredSize(new Dimension(350, 140));
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        CommonUtil.centerOnScreen(this);
    }

    public LogicalTypeDialog(ApplicationView applicationView, ContainedObjectWithDomain containedObjectWithDomain, String string, boolean bl) {
        super(applicationView.getFrame());
        this.usePreferredList = bl;
        this.view = applicationView;
        this.object = containedObjectWithDomain;
        this.selectedRdbmsSite = string;
        this.readOnly = true;
        this.setTitle(Messages.getString("LogicalTypeDialog.LogicalType"));
        this.general = new JPanel(new SpringLayout());
        this.general.setBorder(BorderFactory.createEtchedBorder(0));
        this.initGeneral();
        this.initProperties();
        this.cbLogicalType.setEnabled(false);
        this.tfSize.setEnabled(false);
        this.tfPrecision.setEnabled(false);
        this.tfScale.setEnabled(false);
        this.cbUnits.setEnabled(false);
        this.getContentPane().add((Component)this.general, "Center");
        this.setDefaultCloseOperation(2);
        JPanel jPanel = this.getButtonPanel();
        this.getContentPane().add((Component)jPanel, "South");
        this.general.setPreferredSize(new Dimension(340, 140));
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        CommonUtil.centerOnScreen(this);
    }

    private void initGeneral() {
        this.initSize();
        this.initLogicalType();
        this.initPrecision();
        this.initScale();
    }

    private void initLogicalType() {
        JLabel jLabel = new JLabel(Messages.getString("LogicalTypeDialog.LogicalTypeL"));
        this.general.add(jLabel);
        this.cbLogicalType = new JComboBox<Object>(this.object.getDesign().getLogicalDatatypeSet().toArray());
        this.general.add(this.cbLogicalType);
        this.cbLogicalType.setBackground(Color.WHITE);
        this.cbLogicalType.setFont(new Font(this.cbLogicalType.getFont().getName(), 0, this.cbLogicalType.getFont().getSize()));
        this.cbLogicalType.setPreferredSize(new Dimension(210, 20));
        this.cbLogicalType.setMaximumRowCount(30);
        this.cbLogicalType.addActionListener(new DatatypeListener());
        this.setLabelConstraints(jLabel, 15);
        this.setObjectConstraints(this.cbLogicalType, 15);
    }

    private void initSize() {
        JLabel jLabel = new JLabel(Messages.getString("LogicalTypeDialog.SizeL"));
        this.general.add(jLabel);
        this.tfSize = new JTextField();
        this.tfSize.setColumns(10);
        this.general.add(this.tfSize);
        this.setLabelConstraints(jLabel, 45);
        this.setObjectConstraints(this.tfSize, 45);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        if (this.object.getContainer().getSelectedRDBMSType().getType() > 5 && this.object.getContainer().getSelectedRDBMSType().getType() < 10) {
            jLabel = new JLabel(Messages.getString("LogicalTypeDialog.Units"));
            this.general.add(jLabel);
            this.general.add(this.cbUnits);
            this.setObjectConstraints(jLabel, 230, 47);
            this.setObjectConstraints(this.cbUnits, 290, 45);
        }
    }

    private void initPrecision() {
        JLabel jLabel = new JLabel(Messages.getString("LogicalTypeDialog.PrecisionL"));
        this.general.add(jLabel);
        this.tfPrecision = new JIntegerField();
        this.tfPrecision.setColumns(10);
        this.general.add(this.tfPrecision);
        this.setLabelConstraints(jLabel, 75);
        this.setObjectConstraints(this.tfPrecision, 75);
    }

    private void initScale() {
        JLabel jLabel = new JLabel(Messages.getString("LogicalTypeDialog.ScaleL"));
        this.general.add(jLabel);
        this.tfScale = new JIntegerField();
        this.tfScale.setColumns(10);
        this.general.add(this.tfScale);
        this.setLabelConstraints(jLabel, 105);
        this.setObjectConstraints(this.tfScale, 105);
    }

    public void initProperties() {
        LogicalDatatype logicalDatatype = this.object.getLogicalDatatype();
        Map map = logicalDatatype.getToPhysical();
        MDDataType mDDataType = logicalDatatype.createDataType(this.selectedRdbmsSite, map);
        this.cbLogicalType.removeAllItems();
        Iterator iterator = this.usePreferredList ? this.view.getSettings().getPreferredLogicaltypes().iterator() : this.object.getDesign().getLogicalDatatypeSet().iterator();
        while (iterator.hasNext()) {
            this.cbLogicalType.addItem(iterator.next());
        }
        this.cbLogicalType.setSelectedItem(this.object.getLogicalDatatype());
        if (mDDataType instanceof MDImplicitSized) {
            this.tfSize.setText(EMPTY_STRING);
            this.tfSize.setEnabled(false);
            this.cbUnits.setSelectedIndex(0);
            this.cbUnits.setEnabled(false);
            this.tfPrecision.setText(EMPTY_STRING);
            this.tfPrecision.setEnabled(false);
            this.tfScale.setText(EMPTY_STRING);
            this.tfScale.setEnabled(false);
        } else if (mDDataType instanceof MDPackedSized) {
            this.tfSize.setText(EMPTY_STRING);
            this.tfSize.setEnabled(false);
            this.cbUnits.setSelectedIndex(0);
            this.cbUnits.setEnabled(false);
            try {
                if (!this.object.getPrecision().equalsIgnoreCase(EMPTY_STRING)) {
                    this.tfPrecision.setText(this.object.getPrecision());
                } else if (mDDataType.getPrecision() != 0) {
                    this.tfPrecision.setText(EMPTY_STRING + mDDataType.getPrecision());
                }
                mDDataType.getPrecision();
                this.tfPrecision.setEnabled(true);
            }
            catch (Exception exception) {
                this.tfPrecision.setEnabled(false);
            }
            try {
                if (!this.object.getScale().equalsIgnoreCase(EMPTY_STRING)) {
                    this.tfScale.setText(this.object.getScale());
                } else if (mDDataType.getScale() != 0) {
                    this.tfScale.setText(EMPTY_STRING + mDDataType.getScale());
                }
                mDDataType.getScale();
                this.tfScale.setEnabled(true);
            }
            catch (Exception exception) {
                this.tfScale.setEnabled(false);
            }
        } else {
            try {
                if (!this.object.getSize().equalsIgnoreCase(EMPTY_STRING)) {
                    String string = this.object.getSize();
                    String[] stringArray = string.split(" ");
                    this.tfSize.setText(stringArray[0]);
                    if (stringArray.length == 2) {
                        this.cbUnits.setSelectedItem(stringArray[1]);
                    }
                } else if (!mDDataType.getSize().equalsIgnoreCase("0")) {
                    String string = mDDataType.getSize();
                    String[] stringArray = string.split(" ");
                    this.tfSize.setText(stringArray[0]);
                    if (stringArray.length == 2) {
                        this.cbUnits.setSelectedItem(stringArray[1]);
                    }
                }
                mDDataType.getSize();
                this.tfSize.setEnabled(true);
                this.cbUnits.setEnabled(true);
            }
            catch (Exception exception) {
                this.tfSize.setText(EMPTY_STRING);
                this.tfSize.setEnabled(false);
                this.cbUnits.setSelectedIndex(0);
                this.cbUnits.setEnabled(false);
            }
            try {
                if (!this.object.getPrecision().equalsIgnoreCase(EMPTY_STRING)) {
                    this.tfPrecision.setText(this.object.getPrecision());
                } else if (mDDataType.getPrecision() != 0) {
                    this.tfPrecision.setText(EMPTY_STRING + mDDataType.getPrecision());
                }
                mDDataType.getPrecision();
                this.tfPrecision.setEnabled(true);
            }
            catch (Exception exception) {
                this.tfPrecision.setText(EMPTY_STRING);
                this.tfPrecision.setEnabled(false);
            }
            try {
                if (!this.object.getScale().equalsIgnoreCase(EMPTY_STRING)) {
                    this.tfScale.setText(this.object.getScale());
                } else if (mDDataType.getScale() != 0) {
                    this.tfScale.setText(EMPTY_STRING + mDDataType.getScale());
                }
                mDDataType.getScale();
                this.tfScale.setEnabled(true);
            }
            catch (Exception exception) {
                this.tfScale.setText(EMPTY_STRING);
                this.tfScale.setEnabled(false);
            }
        }
    }

    private void setProperties() {
        this.object.setLogicalDatatype((LogicalDatatype)this.cbLogicalType.getSelectedItem());
        if (this.cbUnits.getSelectedIndex() > 0) {
            this.object.setDataTypeParameter("size", this.tfSize.getText() + ' ' + this.cbUnits.getSelectedItem());
        } else {
            this.object.setDataTypeParameter("size", this.tfSize.getText());
        }
        this.object.setDataTypeParameter("precision", this.tfPrecision.getText());
        this.object.setDataTypeParameter("scale", this.tfScale.getText());
        if (this.bnLogicalType != null) {
            StringBuffer stringBuffer = new StringBuffer(this.cbLogicalType.getSelectedItem().toString());
            boolean bl = false;
            boolean bl2 = false;
            if (!this.tfSize.getText().equalsIgnoreCase(EMPTY_STRING) && !this.tfSize.getText().equalsIgnoreCase("0") || !this.tfPrecision.getText().equalsIgnoreCase(EMPTY_STRING) && !this.tfPrecision.getText().equalsIgnoreCase("0") || !this.tfScale.getText().equalsIgnoreCase(EMPTY_STRING) && !this.tfScale.getText().equalsIgnoreCase("0")) {
                bl = true;
            }
            if (bl) {
                stringBuffer.append(" (");
            }
            if (!this.tfSize.getText().equalsIgnoreCase(EMPTY_STRING) && !this.tfSize.getText().equalsIgnoreCase("0") && (this.tfScale.getText().equalsIgnoreCase(EMPTY_STRING) || this.tfScale.getText().equalsIgnoreCase("0"))) {
                stringBuffer.append(this.tfSize.getText());
                bl2 = true;
            }
            if (!this.tfPrecision.getText().equalsIgnoreCase(EMPTY_STRING) && !this.tfPrecision.getText().equalsIgnoreCase("0")) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.tfPrecision.getText());
                bl2 = true;
            }
            if (!this.tfScale.getText().equalsIgnoreCase(EMPTY_STRING) && !this.tfScale.getText().equalsIgnoreCase("0")) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.tfScale.getText());
            }
            if (bl) {
                stringBuffer.append(')');
            }
            this.bnLogicalType.setText(stringBuffer.toString());
        }
    }

    protected void setLabelConstraints(JLabel jLabel, int n) {
        SpringLayout.Constraints constraints = this.getGeneralLayout().getConstraints(jLabel);
        constraints.setX(Spring.constant(10));
        constraints.setY(Spring.constant(n));
    }

    protected void setObjectConstraints(Component component, int n) {
        SpringLayout.Constraints constraints = this.getGeneralLayout().getConstraints(component);
        constraints.setX(Spring.constant(125));
        constraints.setY(Spring.constant(n));
    }

    protected void setObjectConstraints(Component component, int n, int n2) {
        SpringLayout.Constraints constraints = this.getGeneralLayout().getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            Object object;
            this.buttonPanel = new JPanel();
            if (!this.readOnly) {
                object = new JButton(Messages.getString("LogicalTypeDialog.OK"));
                ((AbstractButton)object).setMnemonic(79);
                ((Component)object).setCursor(Cursor.getPredefinedCursor(12));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        LogicalTypeDialog.this.setProperties();
                        LogicalTypeDialog.this.dispose();
                    }
                });
                ((JComponent)object).setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add((Component)object);
            }
            object = this.readOnly ? Messages.getString("LogicalTypeDialog.Close") : Messages.getString("LogicalTypeDialog.Cancel");
            JButton jButton = new JButton((String)object);
            jButton.setMnemonic(67);
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogicalTypeDialog.this.dispose();
                }
            });
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(jButton);
        }
        return this.buttonPanel;
    }

    private class DatatypeListener
    implements ActionListener {
        private DatatypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogicalTypeDialog.this.tfSize.setText(LogicalTypeDialog.EMPTY_STRING);
            LogicalTypeDialog.this.tfPrecision.setText(LogicalTypeDialog.EMPTY_STRING);
            LogicalTypeDialog.this.tfScale.setText(LogicalTypeDialog.EMPTY_STRING);
            LogicalTypeDialog.this.cbUnits.setSelectedIndex(0);
            LogicalTypeDialog.this.cbUnits.setEnabled(false);
            if (LogicalTypeDialog.this.cbLogicalType.getSelectedItem() != null) {
                LogicalDatatype logicalDatatype = (LogicalDatatype)LogicalTypeDialog.this.cbLogicalType.getSelectedItem();
                Map map = logicalDatatype.getToPhysical();
                MDDataType mDDataType = logicalDatatype.createDataType(LogicalTypeDialog.this.selectedRdbmsSite, map);
                if (mDDataType instanceof MDImplicitSized) {
                    LogicalTypeDialog.this.tfSize.setText(LogicalTypeDialog.EMPTY_STRING);
                    LogicalTypeDialog.this.tfSize.setEnabled(false);
                    LogicalTypeDialog.this.tfPrecision.setText(LogicalTypeDialog.EMPTY_STRING);
                    LogicalTypeDialog.this.tfPrecision.setEnabled(false);
                    LogicalTypeDialog.this.tfScale.setText(LogicalTypeDialog.EMPTY_STRING);
                    LogicalTypeDialog.this.tfScale.setEnabled(false);
                } else if (mDDataType instanceof MDPackedSized) {
                    LogicalTypeDialog.this.tfSize.setText(LogicalTypeDialog.EMPTY_STRING);
                    LogicalTypeDialog.this.tfSize.setEnabled(false);
                    try {
                        if (mDDataType.getPrecision() != 0) {
                            LogicalTypeDialog.this.tfPrecision.setText(LogicalTypeDialog.EMPTY_STRING + mDDataType.getPrecision());
                        }
                        LogicalTypeDialog.this.tfPrecision.setEnabled(true);
                    }
                    catch (Exception exception) {
                        LogicalTypeDialog.this.tfPrecision.setEnabled(false);
                    }
                    try {
                        if (mDDataType.getScale() != 0) {
                            LogicalTypeDialog.this.tfScale.setText(LogicalTypeDialog.EMPTY_STRING + mDDataType.getScale());
                        }
                        LogicalTypeDialog.this.tfScale.setEnabled(true);
                    }
                    catch (Exception exception) {
                        LogicalTypeDialog.this.tfScale.setEnabled(false);
                    }
                } else {
                    try {
                        if (mDDataType.hasSize()) {
                            if (!mDDataType.getSize().equalsIgnoreCase("0")) {
                                String string = mDDataType.getSize();
                                String[] stringArray = string.split(" ");
                                LogicalTypeDialog.this.tfSize.setText(stringArray[0]);
                                if (stringArray.length == 2) {
                                    LogicalTypeDialog.this.cbUnits.setSelectedItem(stringArray[1]);
                                }
                            } else {
                                LogicalTypeDialog.this.tfSize.setText(LogicalTypeDialog.EMPTY_STRING);
                            }
                            LogicalTypeDialog.this.tfSize.setEnabled(true);
                            LogicalTypeDialog.this.cbUnits.setEnabled(true);
                        } else {
                            LogicalTypeDialog.this.tfSize.setEnabled(false);
                            LogicalTypeDialog.this.cbUnits.setEnabled(false);
                        }
                    }
                    catch (Exception exception) {
                        LogicalTypeDialog.this.tfSize.setEnabled(false);
                        LogicalTypeDialog.this.cbUnits.setEnabled(false);
                    }
                    try {
                        if (mDDataType.hasPrecision()) {
                            if (mDDataType.getPrecision() != 0) {
                                LogicalTypeDialog.this.tfPrecision.setText(LogicalTypeDialog.EMPTY_STRING + mDDataType.getPrecision());
                            }
                            LogicalTypeDialog.this.tfPrecision.setEnabled(true);
                        } else {
                            LogicalTypeDialog.this.tfPrecision.setEnabled(false);
                        }
                    }
                    catch (Exception exception) {
                        LogicalTypeDialog.this.tfPrecision.setEnabled(false);
                    }
                    try {
                        if (mDDataType.hasScale()) {
                            if (mDDataType.getScale() != 0) {
                                LogicalTypeDialog.this.tfScale.setText(LogicalTypeDialog.EMPTY_STRING + mDDataType.getScale());
                            }
                            LogicalTypeDialog.this.tfScale.setEnabled(true);
                        } else {
                            LogicalTypeDialog.this.tfScale.setEnabled(false);
                        }
                    }
                    catch (Exception exception) {
                        LogicalTypeDialog.this.tfScale.setEnabled(false);
                    }
                }
            }
        }
    }
}

