/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.OverlayLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.admin.domains.AVTEditor;
import oracle.dbtools.crest.swingui.admin.domains.CECheckConstraint;
import oracle.dbtools.crest.swingui.admin.domains.ValueListEditorEx;
import oracle.dbtools.crest.swingui.editor.AbstractDatatypePropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.editor.SelectUsedInDialog;
import oracle.dbtools.crest.util.gui.swing.JTextFieldLimited;

public class DomainPropertiesDialogEx
extends AbstractDatatypePropertiesDialog {
    private static final String EMPTY_VALUE = "";
    private Domain domain;
    private JTextField tfSynonym;
    private JTextField tfLongName;
    private JTextField tfFileName;
    private JComboBox cbLogDataType;
    private JComboBox cbUnits;
    private JTextField tfSize;
    private JTextField tfPrecision;
    private JTextField tfScale;
    private JComboBox cbDefaultValue;
    private JTextField tfDefaultValue;
    private JTextField tfUnitOfMeasure;
    private JButton btnConstraint;
    private JButton btnAVT;
    private JButton btnValueList;
    private CECheckConstraint checkEditor = null;
    private ValueListEditorEx valuesEditor = null;

    public DomainPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DomainPropertiesDialogEx.DomainProperties");
    }

    @Override
    protected int getMinimumHeight() {
        return 560;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Domain) {
            Object object;
            Object object2;
            this.domain = (Domain)designObject;
            this.initDefaults(false);
            this.tfSynonym.setText(this.domain.getSynonym());
            this.tfLongName.setText(this.domain.getLongName());
            this.tfFileName.setText(this.domain.getFileName());
            Iterator iterator = this.domain.getDesign().getLogicalDatatypeSet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                this.cbLogDataType.addItem(object2);
            }
            this.cbLogDataType.setSelectedItem(this.domain.getLogicalDatatype());
            object2 = this.domain.getDataTypeParameter("size");
            if (object2 != null && ((String)object2).length() > 0) {
                object = ((String)object2).split(" ");
                this.tfSize.setText(object[0]);
                if (((String[])object).length == 2) {
                    this.cbUnits.setSelectedItem(object[1]);
                }
            }
            this.tfPrecision.setText(this.domain.getDataTypeParameter("precision"));
            this.tfScale.setText(this.domain.getDataTypeParameter("scale"));
            this.tfUnitOfMeasure.setText(this.domain.getUnitOfMeasure());
            this.setDefaultValueUI();
            if (!this.isEditable()) {
                this.tfSize.setEditable(false);
                this.tfPrecision.setEditable(false);
                this.tfScale.setEditable(false);
                this.tfUnitOfMeasure.setEditable(false);
                this.tfDefaultValue.setEditable(false);
                this.cbDefaultValue.setEditable(false);
                this.cbUnits.setEnabled(false);
                this.btnConstraint.setEnabled(this.domain.getCheck() != null);
                this.btnAVT.setEnabled(!this.domain.getAVTs().isEmpty());
                this.btnValueList.setEnabled(this.domain.getValueList() != null);
            }
            this.initUsedInAttributes(this.domain, (short)0);
            this.initUsedInColumns();
            this.initUsedInObjectAttributes();
            this.dynamicPropertiesList.clear();
            iterator = this.domain.getPropertyNames();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string = this.domain.getProperty((String)object);
                DynamicProperty dynamicProperty = new DynamicProperty((String)object, string);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        Object object;
        this.domain.setName(this.tfName.getText());
        this.tfName.setText(this.domain.getName());
        this.domain.setSynonym(this.tfSynonym.getText());
        this.domain.setComment(this.taComments.getText());
        LogicalDatatype logicalDatatype = (LogicalDatatype)this.cbLogDataType.getSelectedItem();
        String string = this.tfSize.getText().trim();
        if (string.length() > 0 && ((String)(object = (String)this.cbUnits.getSelectedItem())).length() > 0) {
            string = string + " " + (String)object;
        }
        this.domain.setDataTypeParameter("size", string);
        this.domain.setDataTypeParameter("precision", this.tfPrecision.getText());
        this.domain.setDataTypeParameter("scale", this.tfScale.getText());
        this.domain.setLogicalDatatype(logicalDatatype);
        this.domain.setUnitOfMeasure(this.tfUnitOfMeasure.getText());
        if (this.cbDefaultValue.isVisible()) {
            this.domain.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
        } else {
            this.domain.setDefaultValue(this.tfDefaultValue.getText());
        }
        DomainPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.domain.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.domain.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.taNotes = new JTextArea();
        this.addToTree(defaultMutableTreeNode, this.getUsedInPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    public JPanel initAttributesPanel() {
        return super.initAttributesPanel();
    }

    @Override
    public JPanel createUsedInPanel(JTable jTable, MouseAdapter mouseAdapter, ActionListener actionListener) {
        return this.createUsedInPanel(jTable, mouseAdapter, actionListener, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new SelectUsedInDialog(DomainPropertiesDialogEx.this.getAppView(), DomainPropertiesDialogEx.this.domain, DomainPropertiesDialogEx.this.tabbedPaneUsedIn.getSelectedIndex()).showDialog();
                DomainPropertiesDialogEx.this.initUsedInAttributes(DomainPropertiesDialogEx.this.domain, (short)0);
                DomainPropertiesDialogEx.this.attrTable.updateUI();
                DomainPropertiesDialogEx.this.initUsedInColumns();
                DomainPropertiesDialogEx.this.columnsTable.updateUI();
                DomainPropertiesDialogEx.this.initUsedInObjectAttributes();
                DomainPropertiesDialogEx.this.objAttrTable.updateUI();
            }
        });
    }

    @Override
    protected String getHelpIndex() {
        return "DOMAIN_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_SYNOMYM);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfSynonym));
        JLabel jLabel2 = new JLabel(LB_LONG_NAME);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfLongName));
        JLabel jLabel3 = new JLabel(LB_FILENAME);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.tfFileName = new JTextField();
        this.tfFileName.setPreferredSize(this.getDefaultSize());
        this.tfFileName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.tfFileName));
        JLabel jLabel4 = new JLabel(LB_LOGICAL_TYPE);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.cbLogDataType = new JComboBox();
        this.cbLogDataType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbLogDataType.setMaximumRowCount(20);
        this.cbLogDataType.addActionListener(new DatatypeListener());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.cbLogDataType));
        JLabel jLabel5 = new JLabel(LB_SIZE);
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.tfSize = new JTextField();
        this.tfSize.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.tfSize));
        JLabel jLabel6 = new JLabel(LB_UNITS);
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.cbUnits.setPreferredSize(this.tfName.getPreferredSize());
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.cbUnits));
        JLabel jLabel7 = new JLabel(LB_PRECISION);
        jLabel7.setPreferredSize(this.getDefaultSize());
        this.tfPrecision = new JTextField();
        this.tfPrecision.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel7, this.tfPrecision));
        JLabel jLabel8 = new JLabel(LB_SCALE);
        jLabel8.setPreferredSize(this.getDefaultSize());
        this.tfScale = new JTextField();
        this.tfScale.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel8, this.tfScale));
        JLabel jLabel9 = new JLabel(LB_UNIT_OF_MEASURE);
        jLabel9.setPreferredSize(this.getDefaultSize());
        this.tfUnitOfMeasure = new JTextFieldLimited(30);
        this.tfUnitOfMeasure.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel9, this.tfUnitOfMeasure));
        JLabel jLabel10 = new JLabel(LB_DEFAULT_VALUE);
        jLabel10.setPreferredSize(this.getDefaultSize());
        JPanel jPanel = new JPanel();
        OverlayLayout overlayLayout = new OverlayLayout(jPanel);
        jPanel.setLayout(overlayLayout);
        this.cbDefaultValue = new JComboBox();
        this.cbDefaultValue.setPreferredSize(this.tfName.getPreferredSize());
        this.cbDefaultValue.setMaximumRowCount(20);
        this.cbDefaultValue.setVisible(false);
        jPanel.add(this.cbDefaultValue);
        this.tfDefaultValue = new JTextField();
        this.tfDefaultValue.setPreferredSize(this.getDefaultSize());
        this.tfDefaultValue.setVisible(true);
        jPanel.add(this.tfDefaultValue);
        this.addRowToGeneralPanel(this.createRow(jLabel10, jPanel));
        JLabel jLabel11 = new JLabel(LB_CHECK_CONSTRAINT);
        jLabel11.setPreferredSize(this.getDefaultSize());
        this.btnConstraint = new JButton(BTN_VIEW);
        this.btnConstraint.setPreferredSize(this.getDefaultSize());
        this.btnConstraint.setHorizontalAlignment(2);
        this.btnConstraint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DomainPropertiesDialogEx.this.isEditable()) {
                    if (DomainPropertiesDialogEx.this.domain.getCheck() == null) {
                        CheckConstraint checkConstraint = new CheckConstraint();
                        DomainPropertiesDialogEx.this.domain.setCheck(checkConstraint);
                    }
                    if (DomainPropertiesDialogEx.this.domain.getCheck().getDesign() == null) {
                        DomainPropertiesDialogEx.this.domain.getCheck().setDesign(DomainPropertiesDialogEx.this.domain.getDesign());
                    }
                    if (DomainPropertiesDialogEx.this.checkEditor == null) {
                        DomainPropertiesDialogEx.this.checkEditor = new CECheckConstraint((Dialog)DomainPropertiesDialogEx.this, DomainPropertiesDialogEx.this.getAppView());
                    }
                    DomainPropertiesDialogEx.this.checkEditor.configureEditComponentFor(DomainPropertiesDialogEx.this.domain.getCheck());
                    DomainPropertiesDialogEx.this.checkEditor.doEditing(DomainPropertiesDialogEx.this.domain.getCheck());
                } else if (DomainPropertiesDialogEx.this.domain.getCheck() != null && DomainPropertiesDialogEx.this.domain.getCheck().getDesign() != null) {
                    if (DomainPropertiesDialogEx.this.checkEditor == null) {
                        DomainPropertiesDialogEx.this.checkEditor = new CECheckConstraint((Dialog)DomainPropertiesDialogEx.this, DomainPropertiesDialogEx.this.getAppView(), true);
                    }
                    DomainPropertiesDialogEx.this.checkEditor.configureEditComponentFor(DomainPropertiesDialogEx.this.domain.getCheck());
                    DomainPropertiesDialogEx.this.checkEditor.doEditing(DomainPropertiesDialogEx.this.domain.getCheck());
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel11, this.btnConstraint));
        JLabel jLabel12 = new JLabel(LB_RANGES);
        jLabel12.setPreferredSize(this.getDefaultSize());
        this.btnAVT = new JButton(LB_VALUES);
        this.btnAVT.setPreferredSize(this.getDefaultSize());
        this.btnAVT.setHorizontalAlignment(2);
        this.btnAVT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AVTEditor aVTEditor = new AVTEditor((Dialog)DomainPropertiesDialogEx.this, !DomainPropertiesDialogEx.this.isEditable());
                aVTEditor.configureEditComponentFor(DomainPropertiesDialogEx.this.domain, (LogicalDatatype)DomainPropertiesDialogEx.this.cbLogDataType.getSelectedItem());
                aVTEditor.doEditing(DomainPropertiesDialogEx.this.domain);
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel12, this.btnAVT));
        JLabel jLabel13 = new JLabel(LB_VALUE_LIST);
        jLabel13.setPreferredSize(this.getDefaultSize());
        this.btnValueList = new JButton(LB_VALUES);
        this.btnValueList.setPreferredSize(this.getDefaultSize());
        this.btnValueList.setHorizontalAlignment(2);
        this.btnValueList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DomainPropertiesDialogEx.this.isEditable()) {
                    if (DomainPropertiesDialogEx.this.domain.getValueList() == null) {
                        ConstraintEnumeration constraintEnumeration = new ConstraintEnumeration();
                        DomainPropertiesDialogEx.this.domain.setValueList(constraintEnumeration);
                    }
                    if (DomainPropertiesDialogEx.this.valuesEditor == null) {
                        DomainPropertiesDialogEx.this.valuesEditor = new ValueListEditorEx(DomainPropertiesDialogEx.this);
                    }
                    DomainPropertiesDialogEx.this.valuesEditor.configureEditComponentFor(DomainPropertiesDialogEx.this.domain.getValueList());
                    DomainPropertiesDialogEx.this.valuesEditor.doEditing(DomainPropertiesDialogEx.this.domain);
                } else if (DomainPropertiesDialogEx.this.domain.getValueList() != null) {
                    if (DomainPropertiesDialogEx.this.valuesEditor == null) {
                        DomainPropertiesDialogEx.this.valuesEditor = new ValueListEditorEx((Dialog)DomainPropertiesDialogEx.this, true);
                    }
                    DomainPropertiesDialogEx.this.valuesEditor.configureEditComponentFor(DomainPropertiesDialogEx.this.domain.getValueList());
                    DomainPropertiesDialogEx.this.valuesEditor.doEditing(DomainPropertiesDialogEx.this.domain);
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel13, this.btnValueList));
    }

    private void setDefaultValueUI() {
        if (this.domain != null) {
            Object[] objectArray = null;
            if (this.domain.getValueList() != null && !this.domain.getValueList().isEmpty()) {
                objectArray = this.domain.getValues().toArray();
            }
            if (objectArray != null) {
                Object[] objectArray2 = new Object[objectArray.length + 1];
                objectArray2[0] = EMPTY_VALUE;
                int n = 0;
                String string = this.domain.getDefaultValue();
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i + 1] = objectArray[i];
                    if (string == null || !string.equals(objectArray[i].toString())) continue;
                    n = i + 1;
                }
                this.cbDefaultValue.setModel(new DefaultComboBoxModel<Object>(objectArray2));
                this.cbDefaultValue.setSelectedIndex(n);
                this.cbDefaultValue.setVisible(true);
                this.tfDefaultValue.setVisible(false);
            } else {
                this.tfDefaultValue.setText(this.domain.getDefaultValue());
                this.tfDefaultValue.setVisible(true);
                this.cbDefaultValue.setVisible(false);
            }
        } else {
            this.tfDefaultValue.setVisible(true);
            this.cbDefaultValue.setVisible(false);
        }
    }

    @Override
    protected boolean isEditable() {
        return this.getDesignObject().getDesign().isLoadFromDB() && this.getDesignObject().isCheckedOut() && this.getDesignObject().isCheckedOutByMe();
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class DatatypeListener
    implements ActionListener {
        private DatatypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DomainPropertiesDialogEx.this.tfSize.setText(DomainPropertiesDialogEx.EMPTY_VALUE);
            DomainPropertiesDialogEx.this.tfPrecision.setText(DomainPropertiesDialogEx.EMPTY_VALUE);
            DomainPropertiesDialogEx.this.tfScale.setText(DomainPropertiesDialogEx.EMPTY_VALUE);
            DomainPropertiesDialogEx.this.cbUnits.setSelectedIndex(0);
            LogicalDatatype logicalDatatype = (LogicalDatatype)DomainPropertiesDialogEx.this.cbLogDataType.getSelectedItem();
            Map map = logicalDatatype.getToPhysical();
            MDDataType mDDataType = logicalDatatype.createDataType(DomainPropertiesDialogEx.this.domain.getSelectedRDBMSType().getName(), map);
            if (mDDataType instanceof MDImplicitSized) {
                DomainPropertiesDialogEx.this.tfSize.setEnabled(false);
                DomainPropertiesDialogEx.this.cbUnits.setEnabled(false);
                DomainPropertiesDialogEx.this.tfPrecision.setEnabled(false);
                DomainPropertiesDialogEx.this.tfScale.setEnabled(false);
            } else if (mDDataType instanceof MDPackedSized) {
                DomainPropertiesDialogEx.this.tfSize.setEnabled(false);
                DomainPropertiesDialogEx.this.cbUnits.setEnabled(false);
                try {
                    if (mDDataType.getPrecision() != 0) {
                        DomainPropertiesDialogEx.this.tfPrecision.setText(DomainPropertiesDialogEx.EMPTY_VALUE + mDDataType.getPrecision());
                    }
                    DomainPropertiesDialogEx.this.tfPrecision.setEnabled(true);
                }
                catch (Exception exception) {
                    DomainPropertiesDialogEx.this.tfPrecision.setEnabled(false);
                }
                try {
                    if (mDDataType.getScale() != 0) {
                        DomainPropertiesDialogEx.this.tfScale.setText(DomainPropertiesDialogEx.EMPTY_VALUE + mDDataType.getScale());
                    }
                    DomainPropertiesDialogEx.this.tfScale.setEnabled(true);
                }
                catch (Exception exception) {
                    DomainPropertiesDialogEx.this.tfScale.setEnabled(false);
                }
            } else {
                try {
                    if (mDDataType.hasSize()) {
                        String string = mDDataType.getSize();
                        if (!string.equals("0")) {
                            String[] stringArray = string.split(" ");
                            DomainPropertiesDialogEx.this.tfSize.setText(stringArray[0]);
                        } else {
                            DomainPropertiesDialogEx.this.tfSize.setText(DomainPropertiesDialogEx.EMPTY_VALUE);
                        }
                        DomainPropertiesDialogEx.this.tfSize.setEnabled(true);
                        DomainPropertiesDialogEx.this.cbUnits.setEnabled(true);
                    } else {
                        DomainPropertiesDialogEx.this.tfSize.setEnabled(false);
                        DomainPropertiesDialogEx.this.cbUnits.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    DomainPropertiesDialogEx.this.tfSize.setEnabled(false);
                    DomainPropertiesDialogEx.this.cbUnits.setEnabled(false);
                }
                try {
                    if (mDDataType.hasPrecision()) {
                        if (mDDataType.getPrecision() != 0) {
                            DomainPropertiesDialogEx.this.tfPrecision.setText(DomainPropertiesDialogEx.EMPTY_VALUE + mDDataType.getPrecision());
                        }
                        DomainPropertiesDialogEx.this.tfPrecision.setEnabled(true);
                    } else {
                        DomainPropertiesDialogEx.this.tfPrecision.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    DomainPropertiesDialogEx.this.tfPrecision.setEnabled(false);
                }
                try {
                    if (mDDataType.hasScale()) {
                        if (mDDataType.getScale() != 0) {
                            DomainPropertiesDialogEx.this.tfScale.setText(DomainPropertiesDialogEx.EMPTY_VALUE + mDDataType.getScale());
                        }
                        DomainPropertiesDialogEx.this.tfScale.setEnabled(true);
                    } else {
                        DomainPropertiesDialogEx.this.tfScale.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    DomainPropertiesDialogEx.this.tfScale.setEnabled(false);
                }
            }
        }
    }
}

