/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.exceptions.EmptyFieldException;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DesignPropertiesDialog
extends CustomDialog
implements AbstractEditorConstants {
    private JDialog dialog;
    private JPanel pnGeneral;
    private JPanel buttonPanel;
    private Design design;
    protected JTextField tfName;
    protected JTextArea taComments;
    protected JTextArea taNotes;
    protected JTextField tfComment;
    protected JTextField tfObjectID;
    protected JTextField tfCreator;
    protected JTextField tfCreationTime;
    protected JTextField tfLastChangedBy;
    protected JTextField tfLastChangedTime;
    private Dimension defaultSize = new Dimension(150, 20);
    private JPanel pnMain;
    protected CardLayout cardLayout = new CardLayout(10, 10);
    private JPanel pnComments;
    private JPanel pnNotes;
    private JPanel pnSummary;
    private JTree tree;

    public DesignPropertiesDialog(ApplicationView applicationView, Design design) {
        super(applicationView);
        this.design = design;
        JScrollPane jScrollPane = new JScrollPane(this.getTree());
        jScrollPane.setMinimumSize(new Dimension(150, 0));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, this.getMainPanel());
        jSplitPane.setDividerLocation(150);
        jSplitPane.setDividerSize(3);
        this.add((Component)jSplitPane, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    @Override
    protected void close() {
        Rectangle rectangle = new Rectangle(this.getDialog().getLocation(), this.getDialog().getSize());
        this.design.getAppView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.design.setDialogVisible(false, null);
        this.getDialog().dispose();
    }

    protected int getMinimumWidth() {
        return 600;
    }

    protected int getMinimumHeight() {
        return 400;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), MessageFormat.format(Messages.getString("DesignPropertiesDialog.DesignProperties"), this.design.getName()));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = DesignPropertiesDialog.this.dialog.getWidth();
                    int n2 = DesignPropertiesDialog.this.dialog.getHeight();
                    n = Math.max(DesignPropertiesDialog.this.getMinimumWidth(), n);
                    n2 = Math.max(DesignPropertiesDialog.this.getMinimumHeight(), n2);
                    DesignPropertiesDialog.this.dialog.setSize(n, n2);
                }
            });
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            Rectangle rectangle = this.design.getAppView().getSettings().getDialogSettings(this.getClass().getName());
            if (rectangle == null) {
                this.dialog.setSize(this.getMinimumWidth(), this.getMinimumHeight());
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                this.dialog.setSize(rectangle.getSize());
                this.dialog.setLocation(rectangle.getLocation());
            }
        }
        return this.dialog;
    }

    public void showDialog() {
        this.design.setDialogVisible(true, (JDialog)this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "DESIGN_PROPERTIES_DIALOG";
    }

    public JPanel getMainPanel() {
        if (this.pnMain == null) {
            this.pnMain = new JPanel(this.cardLayout);
            this.pnMain.setMinimumSize(new Dimension(400, 0));
        }
        return this.pnMain;
    }

    protected JTree getTree() {
        if (this.tree == null) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("");
            this.tree = new JTree(defaultMutableTreeNode);
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.initTree(defaultMutableTreeNode);
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
        }
        return this.tree;
    }

    protected void addToTree(DefaultMutableTreeNode defaultMutableTreeNode, JPanel jPanel) {
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(jPanel));
        this.getMainPanel().add((Component)jPanel, jPanel.getName());
    }

    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    protected JPanel getCommentsPanel() {
        if (this.pnComments == null) {
            this.pnComments = this.createPage(Messages.getString("DesignPropertiesDialog.Comments"));
            this.taComments = new JTextArea();
            this.taComments.setEnabled(this.isEditable());
            this.pnComments.add(new JScrollPane(this.taComments));
        }
        return this.pnComments;
    }

    protected JPanel getNotesPanel() {
        if (this.pnNotes == null) {
            this.pnNotes = this.createPage(Messages.getString("DesignPropertiesDialog.Notes"));
            this.taNotes = new JTextArea();
            this.taNotes.setEnabled(this.isEditable());
            this.pnNotes.add(new JScrollPane(this.taNotes));
        }
        return this.pnNotes;
    }

    protected JPanel getSummaryPanel() {
        if (this.pnSummary == null) {
            this.pnSummary = this.createPage(Messages.getString("DesignPropertiesDialog.Summary"));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_OBJECT_ID);
            jLabel.setPreferredSize(this.defaultSize);
            this.tfObjectID = new JTextField();
            this.tfObjectID.setPreferredSize(this.defaultSize);
            this.tfObjectID.setEditable(false);
            jPanel2.add(this.createRow(jLabel, this.tfObjectID));
            JLabel jLabel2 = new JLabel(LB_CREATOR);
            jLabel2.setPreferredSize(this.defaultSize);
            this.tfCreator = new JTextField();
            this.tfCreator.setPreferredSize(this.defaultSize);
            this.tfCreator.setEditable(false);
            jPanel2.add(this.createRow(jLabel2, this.tfCreator));
            JLabel jLabel3 = new JLabel(LB_CREATION_TIME);
            jLabel3.setPreferredSize(this.defaultSize);
            this.tfCreationTime = new JTextField();
            this.tfCreationTime.setPreferredSize(this.defaultSize);
            this.tfCreationTime.setEditable(false);
            jPanel2.add(this.createRow(jLabel3, this.tfCreationTime));
            JLabel jLabel4 = new JLabel(LB_LAST_CHANGED_BY);
            jLabel4.setPreferredSize(this.defaultSize);
            this.tfLastChangedBy = new JTextField();
            this.tfLastChangedBy.setPreferredSize(this.defaultSize);
            this.tfLastChangedBy.setEditable(false);
            jPanel2.add(this.createRow(jLabel4, this.tfLastChangedBy));
            JLabel jLabel5 = new JLabel(LB_LAST_CHANGED_TIME);
            jLabel5.setPreferredSize(this.defaultSize);
            this.tfLastChangedTime = new JTextField();
            this.tfLastChangedTime.setPreferredSize(this.defaultSize);
            this.tfLastChangedTime.setEditable(false);
            jPanel2.add(this.createRow(jLabel5, this.tfLastChangedTime));
            jPanel.add((Component)jPanel2, "North");
            this.pnSummary.add((Component)jPanel, "Center");
        }
        return this.pnSummary;
    }

    protected JPanel createPage(String string) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 10));
        jPanel.setName(string);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        jPanel2.setBackground(Color.WHITE);
        JLabel jLabel = new JLabel("<html><body><b>" + string + "</b>" + "</body>" + "</html>");
        jPanel2.add(jLabel);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    protected JPanel createRow(Component component, Component component2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(component, "West");
        jPanel.add(component2, "Center");
        return jPanel;
    }

    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("DesignPropertiesDialog.General"));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_NAME);
            jLabel.setPreferredSize(this.defaultSize);
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.defaultSize);
            this.tfName.setEnabled(false);
            jPanel2.add(this.createRow(jLabel, this.tfName));
            jPanel.add((Component)jPanel2, "North");
            this.pnGeneral.add((Component)jPanel, "Center");
        }
        return this.pnGeneral;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            JButton jButton;
            JButton jButton2;
            this.buttonPanel = new JPanel(new FlowLayout(2));
            if (this.isEditable()) {
                jButton2 = new JButton(Messages.getString("DesignPropertiesDialog.OK"));
                jButton2.setMnemonic(79);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            DesignPropertiesDialog.this.setProperties();
                            DesignPropertiesDialog.this.close();
                            DesignPropertiesDialog.this.design.setDirty(true);
                        }
                        catch (EmptyFieldException emptyFieldException) {
                            JOptionPane.showMessageDialog(DesignPropertiesDialog.this, emptyFieldException.getMessage(), Messages.getString("DesignPropertiesDialog.Error"), 0);
                        }
                    }
                });
                jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(jButton2);
                jButton = new JButton(Messages.getString("DesignPropertiesDialog.Apply"));
                jButton.setMnemonic(65);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            DesignPropertiesDialog.this.setProperties();
                            DesignPropertiesDialog.this.design.setDirty(true);
                        }
                        catch (EmptyFieldException emptyFieldException) {
                            JOptionPane.showMessageDialog(DesignPropertiesDialog.this, emptyFieldException.getMessage(), Messages.getString("DesignPropertiesDialog.Error"), 0);
                        }
                    }
                });
                jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(jButton);
            }
            jButton2 = new JButton(this.isEditable() ? Messages.getString("DesignPropertiesDialog.Cancel") : Messages.getString("DesignPropertiesDialog.Close"));
            jButton2.setMnemonic(67);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DesignPropertiesDialog.this.close();
                }
            });
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton = new JButton(this.getHelpAction());
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton.setMnemonic(72);
            this.buttonPanel.add(jButton2);
            this.buttonPanel.add(jButton);
        }
        return this.buttonPanel;
    }

    public void initProperties() {
        this.tfName.setText(this.design.getName());
        this.taComments.setText(this.design.getComment());
        this.taNotes.setText(this.design.getNotes());
        this.tfObjectID.setText(this.design.getDesignID());
        this.tfCreationTime.setText(this.design.getCreationTime());
        this.tfCreator.setText(this.design.getCreator().getName());
        this.tfLastChangedBy.setText(this.design.getChanger().getName());
        this.tfLastChangedTime.setText(this.design.getChangeTime());
    }

    private void setProperties() throws EmptyFieldException {
        this.design.setComment(this.taComments.getText());
        this.design.setNotes(this.taNotes.getText());
    }

    @Override
    protected boolean isEditable() {
        if (this.design.isReadOnly()) {
            return false;
        }
        return !ApplicationView.IS_VIEWER;
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)DesignPropertiesDialog.this.tree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof Component) {
                DesignPropertiesDialog.this.cardLayout.show(DesignPropertiesDialog.this.getMainPanel(), ((Component)object).getName());
            }
        }
    }

    public class TreeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(null);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getUserObject() instanceof Component) {
                Component component = (Component)defaultMutableTreeNode.getUserObject();
                this.setText(component.getName());
            }
            return this;
        }
    }
}

