/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.LogicalTypeDialog;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DatatypeDialog
extends CustomDialog {
    private JDialog dialog;
    private ContainedObjectWithDomain object;
    private JPanel buttonPanel;
    private JPanel general;
    private JButton bnLogicalType;
    private ButtonGroup bGroup;
    private JRadioButton rbDomain;
    private JRadioButton rbLogicalType;
    private JRadioButton rbDistinctType;
    private JRadioButton rbStructuredType;
    private JComboBox cbDomain;
    private JComboBox cbDistinctType;
    private JComboBox cbStructuredType;
    private JCheckBox chbReference;
    private JRadioButton rbCollectionType;
    private JComboBox cbCollectionType;
    private static int DEFAULT_COMBO_MAX_ROW_COUNT = 8;
    private static Dimension dim = new Dimension(150, 20);
    private Dialog parent;

    public DatatypeDialog(Dialog dialog, ApplicationView applicationView, ContainedObjectWithDomain containedObjectWithDomain, JButton jButton) {
        super(applicationView);
        this.parent = dialog;
        this.object = containedObjectWithDomain;
        this.general = new JPanel(new SpringLayout());
        this.general.setBorder(BorderFactory.createEtchedBorder(0));
        this.initGeneral();
        this.add((Component)this.general, "Center");
        JPanel jPanel = this.getButtonPanel();
        this.add((Component)jPanel, "South");
        this.general.setPreferredSize(new Dimension(350, 195));
    }

    private void initGeneral() {
        this.bGroup = new ButtonGroup();
        if (this.object != null) {
            this.initDomain();
        }
        this.initLogicalType();
        this.initDistinctType();
        this.initStructuredType();
        this.initCollectionType();
    }

    private void initDomain() {
        this.rbDomain = new JRadioButton(Messages.getString("DatatypeDialog.Domain"));
        this.rbDomain.addActionListener(new RadioListener());
        this.bGroup.add(this.rbDomain);
        this.general.add(this.rbDomain);
        this.setObjectConstraints(this.rbDomain, 10, 15);
        this.cbDomain = new JComboBox();
        this.cbDomain.setPreferredSize(dim);
        this.cbDomain.setMaximumRowCount(DEFAULT_COMBO_MAX_ROW_COUNT);
        this.cbDomain.setBackground(Color.WHITE);
        this.general.add(this.cbDomain);
        this.setObjectConstraints(this.cbDomain, 180, 15);
    }

    private void initLogicalType() {
        this.rbLogicalType = new JRadioButton(Messages.getString("DatatypeDialog.LogicalType"));
        this.rbLogicalType.addActionListener(new RadioListener());
        this.bGroup.add(this.rbLogicalType);
        this.general.add(this.rbLogicalType);
        this.setObjectConstraints(this.rbLogicalType, 10, 45);
        this.bnLogicalType = new JButton(Messages.getString("DatatypeDialog.Logical"));
        this.bnLogicalType.setPreferredSize(dim);
        this.bnLogicalType.setHorizontalAlignment(0);
        this.general.add(this.bnLogicalType);
        this.setObjectConstraints(this.bnLogicalType, 180, 45);
    }

    private void initDistinctType() {
        this.rbDistinctType = new JRadioButton(Messages.getString("DatatypeDialog.DistinctType"));
        this.rbDistinctType.addActionListener(new RadioListener());
        this.bGroup.add(this.rbDistinctType);
        this.general.add(this.rbDistinctType);
        this.setObjectConstraints(this.rbDistinctType, 10, 75);
        this.cbDistinctType = new JComboBox();
        this.cbDistinctType.setPreferredSize(dim);
        this.cbDistinctType.setMaximumRowCount(DEFAULT_COMBO_MAX_ROW_COUNT);
        this.cbDistinctType.setBackground(Color.WHITE);
        this.general.add(this.cbDistinctType);
        this.setObjectConstraints(this.cbDistinctType, 180, 75);
    }

    private void initCollectionType() {
        this.rbCollectionType = new JRadioButton(Messages.getString("DatatypeDialog.CollectionType"));
        this.rbCollectionType.addActionListener(new RadioListener());
        this.bGroup.add(this.rbCollectionType);
        this.general.add(this.rbCollectionType);
        this.setObjectConstraints(this.rbCollectionType, 10, 105);
        this.cbCollectionType = new JComboBox();
        this.cbCollectionType.setPreferredSize(dim);
        this.cbCollectionType.setMaximumRowCount(DEFAULT_COMBO_MAX_ROW_COUNT);
        this.cbCollectionType.setBackground(Color.WHITE);
        this.general.add(this.cbCollectionType);
        this.setObjectConstraints(this.cbCollectionType, 180, 105);
    }

    private void initStructuredType() {
        this.rbStructuredType = new JRadioButton(Messages.getString("DatatypeDialog.StructuredType"));
        this.rbStructuredType.addActionListener(new RadioListener());
        this.bGroup.add(this.rbStructuredType);
        this.general.add(this.rbStructuredType);
        this.setObjectConstraints(this.rbStructuredType, 10, 135);
        this.cbStructuredType = new JComboBox();
        this.cbStructuredType.setPreferredSize(dim);
        this.cbStructuredType.setMaximumRowCount(DEFAULT_COMBO_MAX_ROW_COUNT);
        this.cbStructuredType.setBackground(Color.WHITE);
        this.general.add(this.cbStructuredType);
        this.setObjectConstraints(this.cbStructuredType, 180, 135);
        this.chbReference = new JCheckBox(Messages.getString("DatatypeDialog.Reference"));
        this.general.add(this.chbReference);
        this.setObjectConstraints(this.chbReference, 175, 165);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            JButton jButton = new JButton(Messages.getString("DatatypeDialog.OK"));
            jButton.setMnemonic(79);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DatatypeDialog.this.setProperties();
                    DatatypeDialog.this.close();
                }
            });
            JButton jButton2 = new JButton(Messages.getString("DatatypeDialog.Cancel"));
            jButton2.setMnemonic(67);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DatatypeDialog.this.close();
                }
            });
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            JButton jButton3 = new JButton(this.getHelpAction());
            jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton3.setMnemonic(72);
            this.buttonPanel.add(jButton);
            this.buttonPanel.add(jButton2);
            this.buttonPanel.add(jButton3);
        }
        return this.buttonPanel;
    }

    protected void setObjectConstraints(Component component, int n, int n2) {
        SpringLayout.Constraints constraints = this.getGeneralLayout().getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    public void initProperties(final boolean bl) {
        Iterator iterator;
        this.cbDomain.removeAllItems();
        this.cbDistinctType.removeAllItems();
        this.cbStructuredType.removeAllItems();
        this.cbCollectionType.removeAllItems();
        if (bl) {
            iterator = this.getApplicationView().getSettings().getPrefDomains().iterator();
            while (iterator.hasNext()) {
                this.cbDomain.addItem(iterator.next());
            }
        } else {
            iterator = this.object.getDesign().getDomainSet().iterator();
            while (iterator.hasNext()) {
                this.cbDomain.addItem(iterator.next());
            }
        }
        this.cbDomain.setSelectedItem(this.object.getDomain());
        StringBuffer stringBuffer = new StringBuffer(this.object.getLogicalDatatype().toString());
        boolean bl2 = false;
        boolean bl3 = false;
        if (!this.object.getLogicalDatatype().toString().equalsIgnoreCase("UNKNOWN")) {
            try {
                if (!("".equalsIgnoreCase(this.object.getSize()) && "".equalsIgnoreCase(this.object.getPrecision()) && "".equalsIgnoreCase(this.object.getScale()))) {
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl2) {
                stringBuffer.append(" (");
            }
            try {
                if (!"".equalsIgnoreCase(this.object.getSize()) && ("".equalsIgnoreCase(this.object.getScale()) || "0".equalsIgnoreCase(this.object.getScale()))) {
                    stringBuffer.append(this.object.getSize());
                    bl3 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!"".equalsIgnoreCase(this.object.getPrecision())) {
                    if (bl3) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.object.getPrecision());
                    bl3 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!"".equalsIgnoreCase(this.object.getScale())) {
                    if (bl3) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.object.getScale());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl2) {
                stringBuffer.append(')');
            }
        }
        this.bnLogicalType.setText(stringBuffer.toString());
        this.bnLogicalType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogicalTypeDialog logicalTypeDialog = new LogicalTypeDialog(DatatypeDialog.this.getApplicationView(), DatatypeDialog.this.object, DatatypeDialog.this.bnLogicalType, DatatypeDialog.this.object.getSelectedRDBMSType().getName(), bl);
                logicalTypeDialog.setVisible(true);
            }
        });
        iterator = this.object.getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
        while (iterator.hasNext()) {
            this.cbDistinctType.addItem(iterator.next());
        }
        iterator = this.object.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            this.cbStructuredType.addItem(iterator.next());
        }
        iterator = this.object.getDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
        while (iterator.hasNext()) {
            this.cbCollectionType.addItem(iterator.next());
        }
        if (this.object.getUse() == 0) {
            this.cbDomain.setEnabled(true);
            this.bnLogicalType.setEnabled(false);
            this.cbDistinctType.setEnabled(false);
            this.cbCollectionType.setEnabled(false);
            this.cbStructuredType.setEnabled(false);
            this.chbReference.setEnabled(false);
            this.chbReference.setSelected(false);
            this.rbDomain.setSelected(true);
        } else if (this.object.getUse() == 1) {
            this.cbDomain.setEnabled(false);
            this.bnLogicalType.setEnabled(true);
            this.cbDistinctType.setEnabled(false);
            this.cbCollectionType.setEnabled(false);
            this.cbStructuredType.setEnabled(false);
            this.chbReference.setEnabled(false);
            this.chbReference.setSelected(false);
            this.rbLogicalType.setSelected(true);
        } else if (this.object.getUse() == 2) {
            this.cbDomain.setEnabled(false);
            this.bnLogicalType.setEnabled(false);
            this.cbDistinctType.setEnabled(true);
            this.cbCollectionType.setEnabled(false);
            this.cbStructuredType.setEnabled(false);
            this.chbReference.setEnabled(false);
            this.chbReference.setSelected(false);
            this.rbDistinctType.setSelected(true);
            this.cbDistinctType.setSelectedItem(this.object.getDistinctType());
        } else if (this.object.getUse() == 3) {
            this.cbDomain.setEnabled(false);
            this.bnLogicalType.setEnabled(false);
            this.cbDistinctType.setEnabled(false);
            this.cbStructuredType.setEnabled(true);
            this.cbCollectionType.setEnabled(false);
            this.chbReference.setEnabled(true);
            this.chbReference.setSelected(this.object.isReference());
            this.rbStructuredType.setSelected(true);
            this.cbStructuredType.setSelectedItem(this.object.getStructuredType());
        } else if (this.object.getUse() == 4) {
            this.cbDomain.setEnabled(false);
            this.bnLogicalType.setEnabled(false);
            this.cbDistinctType.setEnabled(false);
            this.cbCollectionType.setEnabled(true);
            this.cbStructuredType.setEnabled(false);
            this.chbReference.setEnabled(false);
            this.chbReference.setSelected(false);
            this.rbCollectionType.setSelected(true);
            this.cbCollectionType.setSelectedItem(this.object.getCollectionType());
        }
    }

    private void setProperties() {
        if (this.rbDomain.isSelected()) {
            this.object.setUse((short)0);
            this.object.setDomain((Domain)this.cbDomain.getSelectedItem());
            this.object.setReference(false);
        } else if (this.rbLogicalType.isSelected()) {
            this.object.setUse((short)1);
            this.object.setReference(false);
        } else if (this.rbDistinctType.isSelected() && this.cbDistinctType.getSelectedItem() != null) {
            this.object.setUse((short)2);
            this.object.setDistinctType((DistinctType)this.cbDistinctType.getSelectedItem());
            this.object.setReference(false);
        } else if (this.rbStructuredType.isSelected() && this.cbStructuredType.getSelectedItem() != null) {
            this.object.setUse((short)3);
            this.object.setStructuredType((StructuredType)this.cbStructuredType.getSelectedItem());
            this.object.setReference(this.chbReference.isSelected());
        } else if (this.rbCollectionType.isSelected() && this.cbCollectionType.getSelectedItem() != null) {
            this.object.setUse((short)4);
            this.object.setCollectionType((CollectionType)this.cbCollectionType.getSelectedItem());
            this.object.setReference(false);
        } else {
            this.object.setUse((short)0);
            this.object.setDomain((Domain)this.cbDomain.getSelectedItem());
            this.object.setReference(false);
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parent, Messages.getString("DatatypeDialog.SetDatatype"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "DATATYPE_DIALOG";
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DatatypeDialog.this.rbDomain.isSelected()) {
                DatatypeDialog.this.cbDomain.setEnabled(true);
                DatatypeDialog.this.bnLogicalType.setEnabled(false);
                DatatypeDialog.this.cbDistinctType.setEnabled(false);
                DatatypeDialog.this.cbCollectionType.setEnabled(false);
                DatatypeDialog.this.cbStructuredType.setEnabled(false);
                DatatypeDialog.this.chbReference.setSelected(false);
                DatatypeDialog.this.chbReference.setEnabled(false);
            } else if (DatatypeDialog.this.rbLogicalType.isSelected()) {
                DatatypeDialog.this.cbDomain.setEnabled(false);
                DatatypeDialog.this.bnLogicalType.setEnabled(true);
                DatatypeDialog.this.cbDistinctType.setEnabled(false);
                DatatypeDialog.this.cbCollectionType.setEnabled(false);
                DatatypeDialog.this.cbStructuredType.setEnabled(false);
                DatatypeDialog.this.chbReference.setSelected(false);
                DatatypeDialog.this.chbReference.setEnabled(false);
            } else if (DatatypeDialog.this.rbDistinctType.isSelected()) {
                DatatypeDialog.this.cbDomain.setEnabled(false);
                DatatypeDialog.this.bnLogicalType.setEnabled(false);
                DatatypeDialog.this.cbDistinctType.setEnabled(true);
                DatatypeDialog.this.cbCollectionType.setEnabled(false);
                DatatypeDialog.this.cbStructuredType.setEnabled(false);
                DatatypeDialog.this.chbReference.setSelected(false);
                DatatypeDialog.this.chbReference.setEnabled(false);
            } else if (DatatypeDialog.this.rbStructuredType.isSelected()) {
                DatatypeDialog.this.cbDomain.setEnabled(false);
                DatatypeDialog.this.bnLogicalType.setEnabled(false);
                DatatypeDialog.this.cbDistinctType.setEnabled(false);
                DatatypeDialog.this.cbCollectionType.setEnabled(false);
                DatatypeDialog.this.cbStructuredType.setEnabled(true);
                DatatypeDialog.this.chbReference.setEnabled(true);
            } else if (DatatypeDialog.this.rbCollectionType.isSelected()) {
                DatatypeDialog.this.cbDomain.setEnabled(false);
                DatatypeDialog.this.bnLogicalType.setEnabled(false);
                DatatypeDialog.this.cbDistinctType.setEnabled(false);
                DatatypeDialog.this.cbCollectionType.setEnabled(true);
                DatatypeDialog.this.cbStructuredType.setEnabled(false);
                DatatypeDialog.this.chbReference.setEnabled(false);
                DatatypeDialog.this.chbReference.setSelected(false);
            }
        }
    }
}

