/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class ChangeRequestPropertiesDialog
extends AbstractPropertiesDialog {
    private ChangeRequest request;
    private JComboBox cbStatus;
    private JCheckBox chbCompleted;
    private DateFormat datFormat = new SimpleDateFormat(MDConfiguration.getDefaultInstance().get("dateonlyformat"));
    private Date datDefault = new Date();
    private JCheckBox chRequestDate;
    private CalendarPopupButton cpbRequestDate;
    private CalendarPanel cpRequestDate;
    private Date dRequestDate;
    private JCheckBox chCompletionDate;
    private CalendarPopupButton cpbCompletionDate;
    private CalendarPanel cpCompletionDate;
    private Date dCompletionDate;
    private JPanel pnReason;
    private JTextArea taReason;
    private JPanel pnImplDesc;
    private JTextArea taImplDesc;
    private JPanel pnReferencedObjects;
    private JTable tbReferencedObjects;
    private List lsReferencedObjects;
    private JTable refTable = null;

    public ChangeRequestPropertiesDialog(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    public ChangeRequestPropertiesDialog(Dialog dialog, ApplicationView applicationView, DesignObject designObject, JTable jTable) {
        super(dialog, applicationView, designObject);
        this.refTable = jTable;
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(Messages.getString("ChangeRequestPropertiesDialog.Status"));
        jLabel.setPreferredSize(this.getDefaultSize());
        this.cbStatus = new JComboBox<String>(ChangeRequest.STATUS_STATES_DISPLAY);
        this.cbStatus.setFont(this.cbStatus.getFont().deriveFont(0));
        this.cbStatus.setPreferredSize(this.getDefaultSize());
        this.cbStatus.setEnabled(this.isEditable());
        this.cbStatus.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel, this.cbStatus));
        JLabel jLabel2 = new JLabel(Messages.getString("ChangeRequestPropertiesDialog.Completed"));
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.chbCompleted = new JCheckBox();
        this.chbCompleted.setPreferredSize(this.getDefaultSize());
        this.chbCompleted.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.chbCompleted));
        this.chRequestDate = new JCheckBox(Messages.getString("ChangeRequestPropertiesDialog.RequestDate"));
        this.chRequestDate.setPreferredSize(this.getDefaultSize());
        this.chRequestDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChangeRequestPropertiesDialog.this.chRequestDate.isSelected()) {
                    ChangeRequestPropertiesDialog.this.cpbRequestDate.setEnabled(true);
                    if (!"".equals(ChangeRequestPropertiesDialog.this.request.getRequestDate())) {
                        ChangeRequestPropertiesDialog.this.cpbRequestDate.setText(ChangeRequestPropertiesDialog.this.request.getRequestDate());
                        try {
                            ChangeRequestPropertiesDialog.this.dRequestDate = ChangeRequestPropertiesDialog.this.datFormat.parse(ChangeRequestPropertiesDialog.this.request.getRequestDate());
                        }
                        catch (ParseException parseException) {
                            ChangeRequestPropertiesDialog.this.dRequestDate = null;
                        }
                    } else {
                        ChangeRequestPropertiesDialog.this.cpbRequestDate.setText("");
                        ChangeRequestPropertiesDialog.this.dRequestDate = null;
                    }
                    if (ChangeRequestPropertiesDialog.this.dRequestDate != null) {
                        ChangeRequestPropertiesDialog.this.cpRequestDate.setSelectedDate(ChangeRequestPropertiesDialog.this.dRequestDate);
                        ChangeRequestPropertiesDialog.this.cpRequestDate.makeDateVisible(ChangeRequestPropertiesDialog.this.dRequestDate);
                    }
                } else {
                    ChangeRequestPropertiesDialog.this.cpbRequestDate.setEnabled(false);
                    ChangeRequestPropertiesDialog.this.cpbRequestDate.setText("");
                    ChangeRequestPropertiesDialog.this.dRequestDate = null;
                }
            }
        });
        this.cpbRequestDate = new CalendarPopupButton();
        this.cpbRequestDate.setPreferredSize(this.getDefaultSize());
        this.cpbRequestDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChangeRequestPropertiesDialog.this.dRequestDate != null) {
                    ChangeRequestPropertiesDialog.this.cpRequestDate.setSelectedDate(ChangeRequestPropertiesDialog.this.dRequestDate);
                    ChangeRequestPropertiesDialog.this.cpRequestDate.makeDateVisible(ChangeRequestPropertiesDialog.this.dRequestDate);
                } else {
                    ChangeRequestPropertiesDialog.this.cpRequestDate.setSelectedDate(ChangeRequestPropertiesDialog.this.datDefault);
                    ChangeRequestPropertiesDialog.this.cpRequestDate.makeDateVisible(ChangeRequestPropertiesDialog.this.datDefault);
                }
            }
        });
        this.cpRequestDate = this.cpbRequestDate.getCalendarPanel();
        this.cpRequestDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equalsIgnoreCase("SELECTION_CHANGED_COMMAND")) {
                    Date[] dateArray = ChangeRequestPropertiesDialog.this.cpRequestDate.getSelectedDates();
                    if (dateArray.length > 0) {
                        ChangeRequestPropertiesDialog.this.dRequestDate = dateArray[0];
                        ChangeRequestPropertiesDialog.this.cpbRequestDate.setText(ChangeRequestPropertiesDialog.this.datFormat.format(dateArray[0]));
                    } else {
                        ChangeRequestPropertiesDialog.this.dRequestDate = null;
                        ChangeRequestPropertiesDialog.this.cpbRequestDate.setText("");
                    }
                }
            }
        });
        this.dRequestDate = null;
        this.addRowToGeneralPanel(this.createRow(this.chRequestDate, (Component)this.cpbRequestDate));
        this.chCompletionDate = new JCheckBox(Messages.getString("ChangeRequestPropertiesDialog.CompletionDate"));
        this.chCompletionDate.setPreferredSize(this.getDefaultSize());
        this.chCompletionDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChangeRequestPropertiesDialog.this.chCompletionDate.isSelected()) {
                    ChangeRequestPropertiesDialog.this.cpbCompletionDate.setEnabled(true);
                    if (!"".equals(ChangeRequestPropertiesDialog.this.request.getCompletionDate())) {
                        ChangeRequestPropertiesDialog.this.cpbCompletionDate.setText(ChangeRequestPropertiesDialog.this.request.getCompletionDate());
                        try {
                            ChangeRequestPropertiesDialog.this.dCompletionDate = ChangeRequestPropertiesDialog.this.datFormat.parse(ChangeRequestPropertiesDialog.this.request.getCompletionDate());
                        }
                        catch (ParseException parseException) {
                            ChangeRequestPropertiesDialog.this.dCompletionDate = null;
                        }
                    } else {
                        ChangeRequestPropertiesDialog.this.cpbCompletionDate.setText("");
                        ChangeRequestPropertiesDialog.this.dCompletionDate = null;
                    }
                    if (ChangeRequestPropertiesDialog.this.dCompletionDate != null) {
                        ChangeRequestPropertiesDialog.this.cpCompletionDate.setSelectedDate(ChangeRequestPropertiesDialog.this.dCompletionDate);
                        ChangeRequestPropertiesDialog.this.cpCompletionDate.makeDateVisible(ChangeRequestPropertiesDialog.this.dCompletionDate);
                    }
                } else {
                    ChangeRequestPropertiesDialog.this.cpbCompletionDate.setEnabled(false);
                    ChangeRequestPropertiesDialog.this.cpbCompletionDate.setText("");
                    ChangeRequestPropertiesDialog.this.dCompletionDate = null;
                }
            }
        });
        this.cpbCompletionDate = new CalendarPopupButton();
        this.cpbCompletionDate.setPreferredSize(this.getDefaultSize());
        this.cpbCompletionDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChangeRequestPropertiesDialog.this.dCompletionDate != null) {
                    ChangeRequestPropertiesDialog.this.cpCompletionDate.setSelectedDate(ChangeRequestPropertiesDialog.this.dCompletionDate);
                    ChangeRequestPropertiesDialog.this.cpCompletionDate.makeDateVisible(ChangeRequestPropertiesDialog.this.dCompletionDate);
                } else {
                    ChangeRequestPropertiesDialog.this.cpCompletionDate.setSelectedDate(ChangeRequestPropertiesDialog.this.datDefault);
                    ChangeRequestPropertiesDialog.this.cpCompletionDate.makeDateVisible(ChangeRequestPropertiesDialog.this.datDefault);
                }
            }
        });
        this.cpCompletionDate = this.cpbCompletionDate.getCalendarPanel();
        this.cpCompletionDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equalsIgnoreCase("SELECTION_CHANGED_COMMAND")) {
                    Date[] dateArray = ChangeRequestPropertiesDialog.this.cpCompletionDate.getSelectedDates();
                    if (dateArray.length > 0) {
                        ChangeRequestPropertiesDialog.this.dCompletionDate = dateArray[0];
                        ChangeRequestPropertiesDialog.this.cpbCompletionDate.setText(ChangeRequestPropertiesDialog.this.datFormat.format(dateArray[0]));
                    } else {
                        ChangeRequestPropertiesDialog.this.dCompletionDate = null;
                        ChangeRequestPropertiesDialog.this.cpbCompletionDate.setText("");
                    }
                }
            }
        });
        this.dCompletionDate = null;
        this.addRowToGeneralPanel(this.createRow(this.chCompletionDate, (Component)this.cpbCompletionDate));
    }

    @Override
    public String getCaption() {
        return Messages.getString("ChangeRequestPropertiesDialog.ChangeRequestProperties");
    }

    private JPanel getReasonPanel() {
        if (this.pnReason == null) {
            this.pnReason = this.createPage(Messages.getString("ChangeRequestPropertiesDialog.Reason"));
            this.taReason = new JTextArea();
            this.taReason.setEnabled(this.isEditable());
            this.taReason.setLineWrap(true);
            this.taReason.setWrapStyleWord(true);
            this.pnReason.add(new JScrollPane(this.taReason));
        }
        return this.pnReason;
    }

    private JPanel getImplementationNotePanel() {
        if (this.pnImplDesc == null) {
            this.pnImplDesc = this.createPage(Messages.getString("ChangeRequestPropertiesDialog.ImplementationNote"));
            this.taImplDesc = new JTextArea();
            this.taImplDesc.setEnabled(this.isEditable());
            this.taImplDesc.setLineWrap(true);
            this.taImplDesc.setWrapStyleWord(true);
            this.pnImplDesc.add(new JScrollPane(this.taImplDesc));
        }
        return this.pnImplDesc;
    }

    protected JPanel getReferencedObjectsPanel() {
        if (this.pnReferencedObjects == null) {
            this.pnReferencedObjects = this.createPage(Messages.getString("ChangeRequestPropertiesDialog.ReferencedObjects"));
            this.lsReferencedObjects = new ArrayList();
            this.tbReferencedObjects = new JTable(new ReferencedObjectsModel());
            this.tbReferencedObjects.setSelectionMode(0);
            this.pnReferencedObjects.add(new JScrollPane(this.tbReferencedObjects));
        }
        return this.pnReferencedObjects;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof ChangeRequest) {
            this.request = (ChangeRequest)designObject;
            this.tfName.setText(this.request.getName());
            this.cbStatus.setSelectedItem(this.translate(this.request.getStatus(), ChangeRequest.STATUS_STATES_INTERNAL, ChangeRequest.STATUS_STATES_DISPLAY));
            this.chbCompleted.setSelected(this.request.isCompleted());
            if (!"".equals(this.request.getRequestDate())) {
                this.chRequestDate.setSelected(true);
                this.cpbRequestDate.setEnabled(true);
                this.cpbRequestDate.setText(this.request.getRequestDate());
                try {
                    this.dRequestDate = this.datFormat.parse(this.request.getRequestDate());
                }
                catch (ParseException parseException) {
                    this.dRequestDate = null;
                }
                if (this.dRequestDate != null) {
                    this.cpRequestDate.setSelectedDate(this.dRequestDate);
                    this.cpRequestDate.makeDateVisible(this.dRequestDate);
                }
            } else {
                this.chRequestDate.setSelected(false);
                this.cpbRequestDate.setEnabled(false);
                this.cpbRequestDate.setText("");
                this.dRequestDate = null;
            }
            if (!"".equals(this.request.getCompletionDate())) {
                this.chCompletionDate.setSelected(true);
                this.cpbCompletionDate.setEnabled(true);
                this.cpbCompletionDate.setText(this.request.getCompletionDate());
                try {
                    this.dCompletionDate = this.datFormat.parse(this.request.getCompletionDate());
                }
                catch (ParseException parseException) {
                    this.dCompletionDate = null;
                }
                if (this.dCompletionDate != null) {
                    this.cpCompletionDate.setSelectedDate(this.dCompletionDate);
                    this.cpCompletionDate.makeDateVisible(this.dCompletionDate);
                }
            } else {
                this.chCompletionDate.setSelected(false);
                this.cpbCompletionDate.setEnabled(false);
                this.cpbCompletionDate.setText("");
                this.dCompletionDate = null;
            }
            this.taReason.setText(this.request.getReason());
            this.taComments.setText(this.request.getComment());
            this.taNotes.setText(this.request.getNotes());
            this.taImplDesc.setText(this.request.getImplDescription());
            this.lsReferencedObjects.addAll(this.request.getObjects());
            this.tfObjectID.setText(this.request.getObjectID());
            this.tfCreationTime.setText(this.request.getCreationTime());
            this.tfCreator.setText(this.request.getCreator().getName());
            this.tfDesign.setText(this.request.getOwnerDesignName());
            if (this.request.getGenerator() != null) {
                this.tfGeneratorName.setText(this.request.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.request.getChanger().getName());
            this.tfLastChangedTime.setText(this.request.getChangeTime());
        }
    }

    @Override
    protected void setProperties() {
        this.request.setName(this.tfName.getText());
        this.request.setStatus(this.translate((String)this.cbStatus.getSelectedItem(), ChangeRequest.STATUS_STATES_DISPLAY, ChangeRequest.STATUS_STATES_INTERNAL));
        this.request.setCompleted(this.chbCompleted.isSelected());
        this.request.setRequestDate(this.cpbRequestDate.getText());
        this.request.setCompletionDate(this.cpbCompletionDate.getText());
        this.request.setReason(this.taReason.getText());
        this.request.setComment(this.taComments.getText());
        this.request.setNotes(this.taNotes.getText());
        this.request.setImplDescription(this.taImplDesc.getText());
        if (this.refTable != null) {
            this.refTable.updateUI();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getReasonPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getImplementationNotePanel());
        this.addToTree(defaultMutableTreeNode, this.getReferencedObjectsPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "CHANGE_REQUEST_PROPERTIES_DIALOG";
    }

    private class ReferencedObjectsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ChangeRequestPropertiesDialog.this.lsReferencedObjects.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ChangeRequestPropertiesDialog.Object");
            }
            if (n == 1) {
                return Messages.getString("ChangeRequestPropertiesDialog.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)ChangeRequestPropertiesDialog.this.lsReferencedObjects.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            if (n2 == 1) {
                return designObject.getObjectTypeName();
            }
            return new Integer(n * n2);
        }
    }
}

