/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.AddChangeRequestDialog;
import oracle.dbtools.crest.swingui.editor.ChangeRequestPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.MeasurementPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddDocumentDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddPartyDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.DocumentPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.businessinfo.ResponsiblePartyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.relational.ColumnPropertiesDialogEx;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;

public abstract class AbstractPropertiesDialog
extends JDialog
implements AbstractEditorConstants,
TreeWillExpandListener {
    public static final String EMPTY_STRING = "";
    public static final String YES = Messages.getString("AbstractPropertiesDialog.YES");
    public static final String NO = Messages.getString("AbstractPropertiesDialog.NO");
    protected static final String[] YES_NO = new String[]{YES, NO};
    protected static final String[] YES_NO_INTERNAL = new String[]{"YES", "NO"};
    protected static final String[] EMPTY_STRING_YES_NO = new String[]{"", YES, NO};
    public static final String NONE = Messages.getString("AbstractPropertiesDialog.NONE");
    public static final String BTN_PROPERTIES = Messages.getString("AbstractPropertiesDialog.Properties");
    public static final String BTN_ADD = Messages.getString("AbstractPropertiesDialog.Add");
    public static final String BTN_REMOVE = Messages.getString("AbstractPropertiesDialog.Remove");
    public static final String BTN_MOVE_UP = Messages.getString("AbstractPropertiesDialog.MoveUp");
    public static final String BTN_MOVE_DOWN = Messages.getString("AbstractPropertiesDialog.MoveDown");
    protected static final int FIELD_WIDTH = OSEnvironment.isMacOS() ? 200 : 180;
    protected static final int FIELD_HEIGHT = 20;
    private static final String ATTRIBUTES_TAB = Messages.getString("AbstractPropertiesDialog.Attributes");
    private static final String COLUMNS_TAB = Messages.getString("AbstractPropertiesDialog.Columns");
    protected static final String IMPACT_ANALYSIS = Messages.getString("AbstractPropertiesDialog.ImpactAnalysis");
    protected boolean impAnInitialized = false;
    private ApplicationView appView;
    private DesignObject designObject;
    private JTabbedPane tabbedPane;
    protected JPanel pnButtons;
    protected JLabel lbName;
    protected JTextField tfName;
    private JButton bnCancel;
    private JTree tree;
    private JPanel pnMain;
    private CardLayout cardLayout = new CardLayout(10, 10);
    private JPanel pnGeneral;
    private JPanel pnComments;
    private JPanel pnCommentsInRDBMS;
    private JPanel pnNotes;
    private JPanel pnUsedIn;
    private JPanel pnSummary;
    private JPanel pnAttributes;
    private JPanel pnColumns;
    private JPanel pnDynamicProperties;
    protected JTextArea taComments;
    protected JTextArea taCommentsInRDBMS;
    protected JTextArea taNotes;
    protected JTextArea taUsedIn;
    private JPanel pnGeneralGrid;
    protected JPanel pnAdditionalPanel;
    private Dimension defaultSize = new Dimension(FIELD_WIDTH, 20);
    private int summaryPanelMinHeight = 460;
    private int summaryPanelMinWidth = 650;
    private JPanel pnSummaryGrid;
    protected JTextField tfComment;
    protected JTextField tfObjectID;
    protected JTextField tfCreator;
    protected JTextField tfCreationTime;
    protected JTextField tfLastChangedBy;
    protected JTextField tfLastChangedTime;
    protected JTextField tfGeneratorName;
    protected JTextField tfRepositoryOID;
    protected JTextField tfDesign;
    private int summaryCount = 8;
    private JPanel pnDataDictConnection;
    private JPanel pnDataDictSchema;
    private JPanel pnDataDictObject;
    private JPanel pnDDLFileName;
    protected JTextField tfDataDictConnection;
    protected JTextField tfDataDictSchema;
    protected JTextField tfDataDictObject;
    protected JTextField tfDDLFileName;
    private JPanel pnMeasurements;
    protected JTable mtable;
    protected List mList;
    private int mCounter = 0;
    private JPanel pnChangeRequests;
    protected JTable reqTable;
    protected List reqList;
    private JPanel pnResParties;
    protected JTable rpTable;
    protected List rpList;
    private JPanel pnDocuments;
    protected JTable docTable;
    protected List docList;
    private JPanel pnScript;
    private JTabbedPane tpane;
    protected JTextArea taBeforeDrop;
    protected JTextArea taBeforeCreate;
    protected JTextArea taAfterCreate;
    protected JTextArea taEndOfScript;
    protected JCheckBox chGenerateScript;
    protected String oldObjectStatus;
    private boolean oldGenerateInDDL;
    protected List<DynamicProperty> dynamicPropertiesList;
    protected JTable dynamicPropertiesTable;
    private int cgCounter = 0;
    private Action actF1 = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractPropertiesDialog.this.showHelp();
        }
    };
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractPropertiesDialog.this.bnCancel.doClick();
        }
    };

    public AbstractPropertiesDialog(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView.getFrame());
        this.init(applicationView, designObject);
    }

    public AbstractPropertiesDialog(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog);
        this.init(applicationView, designObject);
    }

    private void init(ApplicationView applicationView, DesignObject designObject) {
        this.designObject = designObject;
        this.appView = applicationView;
        this.oldObjectStatus = this.appView.getXMLTransformationManager().getFilteredXMLString(designObject);
        this.oldGenerateInDDL = designObject.isMarkedGenerate();
        this.initCaption(designObject.getName());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AbstractPropertiesDialog.this.onCancel();
                AbstractPropertiesDialog.this.designObject.setDialogVisible(false, null);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                AbstractPropertiesDialog.this.designObject.setDialogVisible(false, null);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = AbstractPropertiesDialog.this.getWidth();
                int n2 = AbstractPropertiesDialog.this.getHeight();
                n = Math.max(AbstractPropertiesDialog.this.getMinimumWidth(), n);
                n2 = Math.max(AbstractPropertiesDialog.this.getMinimumHeight(), n2);
                AbstractPropertiesDialog.this.setSize(n, n2);
            }
        });
        this.initLayout();
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escapeAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(112, 0, false);
        jComponent.getInputMap(n).put(keyStroke, "KEY_F1");
        jComponent.getActionMap().put("KEY_F1", this.actF1);
        this.pack();
        Rectangle rectangle = this.getAppView().getSettings().getDialogSettings(this.getClass().getName());
        if (rectangle == null) {
            int n2 = Math.max(this.getMinimumWidth(), this.summaryPanelMinWidth);
            int n3 = Math.max(this.getMinimumHeight(), this.summaryPanelMinHeight);
            this.setSize(n2, n3);
            CommonUtil.centerOnScreen(this);
        } else {
            this.setSize(rectangle.getSize());
            this.setLocation(rectangle.getLocation());
        }
    }

    protected void showHelp() {
        HelpManager.showTopic(this, this.getHelpIndex());
    }

    public abstract String getCaption();

    public abstract void initProperties(DesignObject var1);

    protected abstract void setProperties();

    protected abstract void initTree(DefaultMutableTreeNode var1);

    protected abstract String getHelpIndex();

    protected ApplicationView getAppView() {
        return this.appView;
    }

    protected DesignObject getDesignObject() {
        return this.designObject;
    }

    protected void setDesignObject(DesignObject designObject) {
        this.designObject = designObject;
    }

    protected void initCaption(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCaption()).append(" - ").append(string);
        this.setTitle(stringBuffer.toString());
    }

    protected void selectName() {
        this.tfName.requestFocus();
        this.tfName.selectAll();
    }

    @Override
    public void show() {
        if (this.designObject.showModal || this.designObject.showForFirstTime()) {
            this.setModal(true);
        }
        this.selectName();
        if (!this.isEditable()) {
            this.disableControls(this);
            this.getTree().requestFocus();
        }
        super.show();
        this.designObject.setDialogVisible(true, this);
    }

    private void disableControls(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component == this.getTree() || component == this.pnButtons || component instanceof JTable || component instanceof JButton || component instanceof JList || component instanceof JScrollPane) continue;
            if (!(component instanceof JTabbedPane) && !(component instanceof JLabel)) {
                component.setEnabled(false);
            }
            if (!(component instanceof Container)) continue;
            this.disableControls((Container)component);
        }
    }

    protected int getMinimumWidth() {
        return this.summaryPanelMinWidth;
    }

    protected int getMinimumHeight() {
        return this.summaryPanelMinHeight;
    }

    protected JPanel getMainPanel() {
        if (this.pnMain == null) {
            this.pnMain = new JPanel(this.cardLayout);
            this.pnMain.setMinimumSize(new Dimension(400, 0));
        }
        return this.pnMain;
    }

    protected void fillComboItems(Object[] objectArray, JComboBox jComboBox, boolean bl) {
        jComboBox.removeAllItems();
        if (bl) {
            jComboBox.addItem(null);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            jComboBox.addItem(objectArray[i]);
        }
    }

    protected JPanel createPage(String string) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 10));
        jPanel.setName(string);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        jPanel2.setBackground(Color.WHITE);
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension((int)jLabel.getPreferredSize().getWidth(), 22));
        jPanel2.add(jLabel);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    protected void addRowToGeneralPanel(JPanel jPanel) {
        this.pnGeneralGrid.add(jPanel);
    }

    protected void addRowToPanel(JPanel jPanel, String string, JComponent jComponent) {
        this.addRowToPanel(jPanel, string, jComponent, null);
    }

    protected void addRowToPanel(JPanel jPanel, String string, JComponent jComponent, String string2) {
        this.addRowToPanel(jPanel, string, jComponent, string2, null);
    }

    protected void addRowToPanel(JPanel jPanel, String string, JComponent jComponent, String string2, Object object) {
        JLabel jLabel = new JLabel(string);
        jLabel.setLabelFor(jComponent);
        jLabel.setPreferredSize(this.getDefaultSize());
        if (string2 != null) {
            jLabel.setToolTipText(string2);
            jComponent.setToolTipText(string2);
        }
        jPanel.add((Component)this.createRow(jLabel, jComponent), object);
    }

    protected Dimension getDefaultSize() {
        return this.defaultSize;
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("AbstractPropertiesDialog.General"));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            this.pnAdditionalPanel = new JPanel(new GridLayout(0, 1, 10, 10));
            this.lbName = new JLabel(LB_NAME);
            this.lbName.setPreferredSize(this.defaultSize);
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.defaultSize);
            this.tfName.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(this.lbName, this.tfName));
            jPanel.add((Component)this.pnGeneralGrid, "North");
            jPanel.add((Component)this.pnAdditionalPanel, "Center");
            this.pnGeneral.add((Component)jPanel, "Center");
        }
        return this.pnGeneral;
    }

    protected JPanel getCommentsPanel() {
        if (this.pnComments == null) {
            this.pnComments = this.createPage(Messages.getString("AbstractPropertiesDialog.Comments"));
            this.taComments = new JTextArea();
            this.taComments.setEnabled(this.isEditable());
            this.taComments.setLineWrap(true);
            this.taComments.setWrapStyleWord(true);
            this.pnComments.add(new JScrollPane(this.taComments));
        }
        return this.pnComments;
    }

    protected JPanel getCommentsInRDBMSPanel() {
        if (this.pnCommentsInRDBMS == null) {
            this.pnCommentsInRDBMS = this.createPage(Messages.getString("AbstractPropertiesDialog.CommentsInRDBMS"));
            this.taCommentsInRDBMS = new JTextArea();
            this.taCommentsInRDBMS.setEnabled(this.isEditable());
            this.taCommentsInRDBMS.setLineWrap(true);
            this.taCommentsInRDBMS.setWrapStyleWord(true);
            this.pnCommentsInRDBMS.add(new JScrollPane(this.taCommentsInRDBMS));
        }
        return this.pnCommentsInRDBMS;
    }

    protected JPanel getNotesPanel() {
        if (this.pnNotes == null) {
            this.pnNotes = this.createPage(Messages.getString("AbstractPropertiesDialog.Notes"));
            this.taNotes = new JTextArea();
            this.taNotes.setEnabled(this.isEditable());
            this.taNotes.setLineWrap(true);
            this.taNotes.setWrapStyleWord(true);
            this.pnNotes.add(new JScrollPane(this.taNotes));
        }
        return this.pnNotes;
    }

    protected JPanel getUsedInPanel() {
        if (this.pnUsedIn == null) {
            this.pnUsedIn = this.createPage(Messages.getString("AbstractPropertiesDialog.UsedIn"));
            this.taUsedIn = new JTextArea();
            this.taUsedIn.setEnabled(this.isEditable());
            this.pnUsedIn.add(new JScrollPane(this.taUsedIn));
            this.pnAttributes = new JPanel(new BorderLayout());
            this.pnColumns = new JPanel(new BorderLayout());
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab(ATTRIBUTES_TAB, this.pnAttributes);
            this.tabbedPane.addTab(COLUMNS_TAB, this.pnColumns);
            this.pnUsedIn.add(this.tabbedPane);
        }
        return this.pnUsedIn;
    }

    protected JPanel getSummaryPanel() {
        if (this.pnSummary == null) {
            this.pnSummary = this.createPage(Messages.getString("AbstractPropertiesDialog.Summary"));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.pnSummaryGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_OBJECT_ID);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.tfObjectID = new JTextField();
            this.tfObjectID.setPreferredSize(this.getDefaultSize());
            this.tfObjectID.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel, this.tfObjectID));
            JLabel jLabel2 = new JLabel(LB_CREATOR);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.tfCreator = new JTextField();
            this.tfCreator.setPreferredSize(this.getDefaultSize());
            this.tfCreator.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel2, this.tfCreator));
            JLabel jLabel3 = new JLabel(LB_CREATION_TIME);
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.tfCreationTime = new JTextField();
            this.tfCreationTime.setPreferredSize(this.getDefaultSize());
            this.tfCreationTime.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel3, this.tfCreationTime));
            JLabel jLabel4 = new JLabel(LB_LAST_CHANGED_BY);
            jLabel4.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedBy = new JTextField();
            this.tfLastChangedBy.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedBy.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel4, this.tfLastChangedBy));
            JLabel jLabel5 = new JLabel(LB_LAST_CHANGED_TIME);
            jLabel5.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedTime = new JTextField();
            this.tfLastChangedTime.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedTime.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel5, this.tfLastChangedTime));
            JLabel jLabel6 = new JLabel(LB_GENERATOR_NAME);
            jLabel6.setPreferredSize(this.getDefaultSize());
            this.tfGeneratorName = new JTextField();
            this.tfGeneratorName.setPreferredSize(this.getDefaultSize());
            this.tfGeneratorName.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel6, this.tfGeneratorName));
            JLabel jLabel7 = new JLabel(LB_DESIGN);
            jLabel7.setPreferredSize(this.getDefaultSize());
            this.tfDesign = new JTextField();
            this.tfDesign.setPreferredSize(this.getDefaultSize());
            this.tfDesign.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel7, this.tfDesign));
            JLabel jLabel8 = new JLabel(LB_REPOSITORY_OID);
            jLabel8.setPreferredSize(this.getDefaultSize());
            this.tfRepositoryOID = new JTextField();
            this.tfRepositoryOID.setPreferredSize(this.getDefaultSize());
            this.tfRepositoryOID.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel8, this.tfRepositoryOID));
            this.summaryCount = this.pnSummaryGrid.getComponentCount();
            JLabel jLabel9 = new JLabel(LB_SOURCE_DB_CONNECTION);
            jLabel9.setPreferredSize(this.getDefaultSize());
            this.tfDataDictConnection = new JTextField();
            this.tfDataDictConnection.setPreferredSize(this.getDefaultSize());
            this.tfDataDictConnection.setEditable(false);
            this.pnDataDictConnection = this.createRow(jLabel9, this.tfDataDictConnection);
            JLabel jLabel10 = new JLabel(LB_SOURCE_DB_SCHEMA);
            if (this instanceof ColumnPropertiesDialogEx) {
                jLabel10 = new JLabel(LB_SOURCE_DB_TABLE);
            }
            jLabel10.setPreferredSize(this.getDefaultSize());
            this.tfDataDictSchema = new JTextField();
            this.tfDataDictSchema.setPreferredSize(this.getDefaultSize());
            this.tfDataDictSchema.setEditable(false);
            this.pnDataDictSchema = this.createRow(jLabel10, this.tfDataDictSchema);
            JLabel jLabel11 = new JLabel(LB_SOURCE_DB_OBJECT);
            jLabel11.setPreferredSize(this.getDefaultSize());
            this.tfDataDictObject = new JTextField();
            this.tfDataDictObject.setPreferredSize(this.getDefaultSize());
            this.tfDataDictObject.setEditable(false);
            this.pnDataDictObject = this.createRow(jLabel11, this.tfDataDictObject);
            JLabel jLabel12 = new JLabel(LB_SOURCE_DDL_FILE);
            jLabel12.setPreferredSize(this.getDefaultSize());
            this.tfDDLFileName = new JTextField();
            this.tfDDLFileName.setPreferredSize(this.getDefaultSize());
            this.tfDDLFileName.setEditable(false);
            this.pnDDLFileName = this.createRow(jLabel12, this.tfDDLFileName);
            jPanel.add((Component)this.pnSummaryGrid, "North");
            this.pnSummary.add((Component)jPanel, "Center");
        }
        return this.pnSummary;
    }

    protected JPanel getDynamicPropertiesPanel() {
        if (this.pnDynamicProperties == null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            final JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            jButton2.setEnabled(false);
            this.pnDynamicProperties = this.createPage(Messages.getString("AbstractPropertiesDialog.DynamicProperties"));
            this.dynamicPropertiesList = new ArrayList<DynamicProperty>();
            this.dynamicPropertiesTable = new JTable(new DynamicPropertiesModel()){

                @Override
                public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                    super.changeSelection(n, n2, bl, bl2);
                    if (this.editCellAt(n, n2)) {
                        Component component = this.getEditorComponent();
                        component.requestFocusInWindow();
                    }
                }
            };
            this.dynamicPropertiesTable.setSelectionMode(0);
            this.dynamicPropertiesTable.setCellSelectionEnabled(true);
            ListSelectionModel listSelectionModel = this.dynamicPropertiesTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    String string = null;
                    int[] nArray = AbstractPropertiesDialog.this.dynamicPropertiesTable.getSelectedRows();
                    int[] nArray2 = AbstractPropertiesDialog.this.dynamicPropertiesTable.getSelectedColumns();
                    for (int i = 0; i < nArray.length; ++i) {
                        for (int j = 0; j < nArray2.length; ++j) {
                            string = (String)AbstractPropertiesDialog.this.dynamicPropertiesTable.getValueAt(nArray[i], nArray2[j]);
                            if (string != null) {
                                jButton2.setEnabled(true);
                                continue;
                            }
                            jButton2.setEnabled(false);
                        }
                    }
                }
            });
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            jPanel2.setPreferredSize(new Dimension(325, 35));
            jButton.setToolTipText(BTN_ADD);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractPropertiesDialog.this.createAndAddDynamicProperty(AbstractPropertiesDialog.this.generateDynamicProperyName(), AbstractPropertiesDialog.EMPTY_STRING);
                    AbstractPropertiesDialog.this.dynamicPropertiesTable.changeSelection(AbstractPropertiesDialog.this.dynamicPropertiesTable.getRowCount() - 1, 0, false, false);
                    AbstractPropertiesDialog.this.dynamicPropertiesTable.requestFocus();
                    AbstractPropertiesDialog.this.dynamicPropertiesTable.updateUI();
                }
            });
            jButton2.setToolTipText(BTN_REMOVE);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractPropertiesDialog.stopCellEditing(AbstractPropertiesDialog.this.dynamicPropertiesTable);
                    int n = AbstractPropertiesDialog.this.dynamicPropertiesTable.getSelectedRow();
                    if (n != -1) {
                        AbstractPropertiesDialog.this.dynamicPropertiesList.remove(n);
                        AbstractPropertiesDialog.this.dynamicPropertiesTable.updateUI();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            if (this.isEditable()) {
                jToolBar.addSeparator();
                jToolBar.add(jButton);
                jToolBar.add(jButton2);
            }
            jPanel2.add(jToolBar);
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)new JScrollPane(this.dynamicPropertiesTable), "Center");
            this.pnDynamicProperties.add((Component)jPanel, "Center");
        }
        return this.pnDynamicProperties;
    }

    protected JPanel createRow(Component component, Component component2) {
        return this.createRow(component, component2, false);
    }

    protected JPanel createRow(Component component, Component component2, boolean bl) {
        JPanel jPanel = new JPanel(new BorderLayout());
        if (bl) {
            jPanel.add(component, "Center");
            jPanel.add(component2, "East");
        } else {
            jPanel.add(component, "West");
            jPanel.add(component2, "Center");
        }
        return jPanel;
    }

    protected void showComponent(Component component) {
        String string = component.getName();
        if (IMPACT_ANALYSIS.equalsIgnoreCase(string) && !this.impAnInitialized) {
            this.initImpactAnalysisTreeModel();
            this.impAnInitialized = true;
        }
        this.cardLayout.show(this.getMainPanel(), string);
    }

    protected void addToTree(DefaultMutableTreeNode defaultMutableTreeNode, JPanel jPanel) {
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(jPanel));
        this.getMainPanel().add((Component)jPanel, jPanel.getName());
    }

    protected JTree getTree() {
        if (this.tree == null) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(EMPTY_STRING);
            this.tree = new JTree(defaultMutableTreeNode);
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.initTree(defaultMutableTreeNode);
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
            this.tree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\u001b') {
                        AbstractPropertiesDialog.this.bnCancel.doClick();
                    } else if (keyEvent.getKeyCode() == 112) {
                        AbstractPropertiesDialog.this.showHelp();
                    }
                }
            });
        }
        return this.tree;
    }

    private void close() {
        Rectangle rectangle = new Rectangle(this.getLocation(), this.getSize());
        this.getAppView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.dispose();
    }

    protected void onOK() {
        if (this.canExit()) {
            this.setProperties();
            if (this.oldGenerateInDDL != this.designObject.isMarkedGenerate()) {
                this.designObject.setMarkedGenerate(this.designObject.isMarkedGenerate());
            }
            String string = this.appView.getXMLTransformationManager().getFilteredXMLString(this.designObject);
            if (this.oldObjectStatus != null) {
                if (!this.oldObjectStatus.equals(string)) {
                    this.designObject.setDirty(true);
                }
            } else {
                this.designObject.setDirty(true);
            }
            this.designObject.setShowForFirstTime(false);
            this.close();
        }
    }

    protected void onApply() {
        if (this.canExit()) {
            this.setProperties();
            if (this.oldGenerateInDDL != this.designObject.isMarkedGenerate()) {
                this.designObject.setMarkedGenerate(this.designObject.isMarkedGenerate());
            }
            String string = this.appView.getXMLTransformationManager().getFilteredXMLString(this.designObject);
            if (this.oldObjectStatus != null) {
                if (!this.oldObjectStatus.equals(string)) {
                    this.designObject.setDirty(true);
                    this.oldObjectStatus = string;
                }
            } else {
                this.designObject.setDirty(true);
            }
            this.designObject.setShowForFirstTime(false);
            DesignPartView designPartView = this.designObject.getAppView().getCurrentDPV();
            if (designPartView != null) {
                for (TopView topView : this.designObject.getViewsForDPV(designPartView)) {
                    if (topView == null) continue;
                    Rectangle rectangle = topView.getBounds();
                    if (topView.getCellView() == null) continue;
                    rectangle = topView.getCellView().getBounds().getBounds();
                    designPartView.getWorkSpace().repaint(rectangle);
                }
            }
        }
    }

    protected void onCancel() {
        if (this.designObject.showForFirstTime()) {
            this.designObject.remove();
        }
    }

    protected boolean canExit() {
        if (StringUtilities.isNotEmpty(this.tfName.getText())) {
            return true;
        }
        MessageDialogs.showErrorMessage(this, Messages.getString("AbstractPropertiesDialog.NameCanNotBeEmpty"));
        this.tfName.requestFocus();
        return false;
    }

    protected void initLayout() {
        JButton jButton;
        JScrollPane jScrollPane = new JScrollPane(this.getTree());
        jScrollPane.setMinimumSize(new Dimension(this.getMinimumTreeWidth(), 0));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, this.getMainPanel());
        jSplitPane.setDividerLocation(this.getMinimumTreeWidth());
        jSplitPane.setDividerSize(3);
        FlowLayout flowLayout = new FlowLayout(2);
        this.pnButtons = new JPanel(flowLayout);
        String string = Messages.getString("AbstractPropertiesDialog.Close");
        if (this.isEditable()) {
            jButton = new JButton(new AbstractAction(Messages.getString("AbstractPropertiesDialog.OK")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractPropertiesDialog.this.onOK();
                }
            });
            jButton.setMnemonic(79);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.getRootPane().setDefaultButton(jButton);
            JButton jButton2 = new JButton(new AbstractAction(Messages.getString("AbstractPropertiesDialog.Apply")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractPropertiesDialog.this.onApply();
                }
            });
            jButton2.setMnemonic(65);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.pnButtons.add(jButton);
            this.pnButtons.add(jButton2);
            string = Messages.getString("AbstractPropertiesDialog.Cancel");
            this.addEditModeButtons();
        }
        this.bnCancel = new JButton(new AbstractAction(string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractPropertiesDialog.this.onCancel();
                AbstractPropertiesDialog.this.close();
            }
        });
        this.bnCancel.setMnemonic(67);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton = new JButton(new AbstractAction(Messages.getString("AbstractPropertiesDialog.Help")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractPropertiesDialog.this.showHelp();
            }
        });
        jButton.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.pnButtons.add(this.bnCancel);
        this.pnButtons.add(jButton);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)this.pnButtons, "South");
    }

    protected JPanel getMeasurementsPanel() {
        if (this.pnMeasurements == null) {
            this.pnMeasurements = this.createPage(Messages.getString("AbstractPropertiesDialog.Measurements"));
            this.mList = new ArrayList();
            MeasurementModel measurementModel = new MeasurementModel();
            this.mtable = new JTable(measurementModel);
            this.mtable.setSelectionMode(0);
            this.mtable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Measurement measurement;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = AbstractPropertiesDialog.this.mtable.getSelectedRow()) != -1 && AbstractPropertiesDialog.this.mList.size() > 0 && n < AbstractPropertiesDialog.this.mList.size() && !(measurement = (Measurement)AbstractPropertiesDialog.this.mList.get(n)).isDialogVisible()) {
                        MeasurementPropertiesDialog measurementPropertiesDialog = new MeasurementPropertiesDialog((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), measurement, AbstractPropertiesDialog.this.mtable);
                        measurementPropertiesDialog.initProperties(measurement);
                        measurementPropertiesDialog.setModal(((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime());
                        measurementPropertiesDialog.show();
                        AbstractPropertiesDialog.this.mtable.updateUI();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.mtable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Measurement measurement;
                    int n = AbstractPropertiesDialog.this.mtable.getSelectedRow();
                    if (n != -1 && AbstractPropertiesDialog.this.mList.size() > 0 && n < AbstractPropertiesDialog.this.mList.size() && !(measurement = (Measurement)AbstractPropertiesDialog.this.mList.get(n)).isDialogVisible()) {
                        MeasurementPropertiesDialog measurementPropertiesDialog = new MeasurementPropertiesDialog((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), measurement, AbstractPropertiesDialog.this.mtable);
                        measurementPropertiesDialog.initProperties(measurement);
                        measurementPropertiesDialog.setModal(((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime());
                        measurementPropertiesDialog.show();
                        AbstractPropertiesDialog.this.mtable.updateUI();
                    }
                }
            });
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            jButton2.setToolTipText(BTN_ADD);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Measurement measurement = new Measurement(AbstractPropertiesDialog.this.designObject.getDesignPart());
                    measurement.setName(AbstractPropertiesDialog.this.generateMeasurementName());
                    measurement.setDesign(AbstractPropertiesDialog.this.designObject.getDesign());
                    measurement.setObject(AbstractPropertiesDialog.this.designObject);
                    AbstractPropertiesDialog.this.mList.add(measurement);
                    AbstractPropertiesDialog.this.mtable.updateUI();
                }
            });
            final JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            jButton3.setToolTipText(BTN_REMOVE);
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AbstractPropertiesDialog.this.mtable.getSelectedRow();
                    if (n != -1 && AbstractPropertiesDialog.this.mList.size() > 0 && n < AbstractPropertiesDialog.this.mList.size()) {
                        AbstractPropertiesDialog.this.mList.remove(n);
                        AbstractPropertiesDialog.this.mtable.updateUI();
                    }
                }
            });
            this.mtable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (AbstractPropertiesDialog.this.mList.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            this.mtable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (AbstractPropertiesDialog.this.mList.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jToolBar.addSeparator();
                jToolBar.add(jButton2);
                jToolBar.add(jButton3);
            }
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)jScrollPane, "Center");
            this.pnMeasurements.add((Component)jPanel2, "Center");
            this.mtable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n;
                    if (AbstractPropertiesDialog.this.isEditable() && keyEvent.getKeyCode() == 127 && (n = AbstractPropertiesDialog.this.mtable.getSelectedRow()) != -1 && AbstractPropertiesDialog.this.mList.size() > 0 && n < AbstractPropertiesDialog.this.mList.size()) {
                        AbstractPropertiesDialog.this.mList.remove(n);
                        AbstractPropertiesDialog.this.mtable.updateUI();
                    }
                }
            });
        }
        return this.pnMeasurements;
    }

    protected String generateMeasurementName() {
        String string = Messages.getString("AbstractPropertiesDialog.Measurement");
        int n = 0;
        int n2 = this.mList.size();
        if (n2 != 0) {
            n = this.mCounter = n2 + 1;
        } else {
            ++this.mCounter;
            n = this.mCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.measurementExists(string2)) {
            n = ++this.mCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean measurementExists(String string) {
        for (int i = 0; i < this.mList.size(); ++i) {
            Measurement measurement = (Measurement)this.mList.get(i);
            if (!string.equalsIgnoreCase(measurement.getName())) continue;
            return true;
        }
        return false;
    }

    protected void initMeasurements() {
        this.mList.addAll(this.designObject.getMeasurements());
    }

    protected void setMeasurements() {
        this.setMeasurements(this.designObject);
    }

    protected void setMeasurements(DesignObject designObject) {
        Object object;
        int n;
        Object[] objectArray = this.mList.toArray();
        List list = designObject.getMeasurements();
        for (n = 0; n < list.size(); ++n) {
            object = (Measurement)list.get(n);
            if (this.mList.contains(object)) continue;
            designObject.removeMeasurement((Measurement)object);
        }
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n];
            if (!(object instanceof Measurement) || designObject.getMeasurements().contains(object)) continue;
            designObject.addMeasurement((Measurement)object);
        }
    }

    protected void initChangeRequests() {
        this.reqList.addAll(this.designObject.getRequests());
    }

    protected void setChangeRequests() {
        this.setChangeRequests(this.designObject);
    }

    protected void setChangeRequests(DesignObject designObject) {
        designObject.clearRequests();
        for (ChangeRequest changeRequest : this.reqList) {
            designObject.addRequest(changeRequest);
        }
    }

    protected JPanel getChangeRequestsPanel() {
        if (this.pnChangeRequests == null) {
            this.pnChangeRequests = this.createPage(Messages.getString("AbstractPropertiesDialog.ChangeRequests"));
            this.reqList = new ArrayList();
            this.reqTable = new JTable(new ChangeRequestModel());
            this.reqTable.setSelectionMode(0);
            this.reqTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = AbstractPropertiesDialog.this.reqTable.getSelectedRow()) != -1 && AbstractPropertiesDialog.this.reqList.size() > 0 && n < AbstractPropertiesDialog.this.reqList.size()) {
                        ChangeRequest changeRequest = (ChangeRequest)AbstractPropertiesDialog.this.reqList.get(n);
                        ChangeRequestPropertiesDialog changeRequestPropertiesDialog = new ChangeRequestPropertiesDialog((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), changeRequest, AbstractPropertiesDialog.this.reqTable);
                        changeRequestPropertiesDialog.initProperties(changeRequest);
                        changeRequestPropertiesDialog.setModal(((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime());
                        changeRequestPropertiesDialog.show();
                        AbstractPropertiesDialog.this.reqTable.updateUI();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.reqTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AbstractPropertiesDialog.this.reqTable.getSelectedRow();
                    if (n != -1 && AbstractPropertiesDialog.this.reqList.size() > 0 && n < AbstractPropertiesDialog.this.reqList.size()) {
                        ChangeRequest changeRequest = (ChangeRequest)AbstractPropertiesDialog.this.reqList.get(n);
                        ChangeRequestPropertiesDialog changeRequestPropertiesDialog = new ChangeRequestPropertiesDialog((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), changeRequest, AbstractPropertiesDialog.this.reqTable);
                        changeRequestPropertiesDialog.initProperties(changeRequest);
                        changeRequestPropertiesDialog.setModal(((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime());
                        changeRequestPropertiesDialog.show();
                        AbstractPropertiesDialog.this.reqTable.updateUI();
                    }
                }
            });
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            jButton2.setToolTipText(BTN_ADD);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddChangeRequestDialog addChangeRequestDialog = new AddChangeRequestDialog(AbstractPropertiesDialog.this.getAppView(), AbstractPropertiesDialog.this.designObject, AbstractPropertiesDialog.this.reqList);
                    addChangeRequestDialog.setVisible(true);
                    AbstractPropertiesDialog.this.reqTable.updateUI();
                }
            });
            final JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            jButton3.setToolTipText(BTN_REMOVE);
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AbstractPropertiesDialog.this.reqTable.getSelectedRow();
                    if (n != -1 && AbstractPropertiesDialog.this.reqList.size() > 0 && n < AbstractPropertiesDialog.this.reqList.size()) {
                        AbstractPropertiesDialog.this.reqList.remove(n);
                        AbstractPropertiesDialog.this.reqTable.updateUI();
                    }
                }
            });
            this.reqTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (AbstractPropertiesDialog.this.reqList.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            this.reqTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (AbstractPropertiesDialog.this.reqList.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jToolBar.addSeparator();
                jToolBar.add(jButton2);
                jToolBar.add(jButton3);
            }
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)jScrollPane, "Center");
            this.pnChangeRequests.add((Component)jPanel2, "Center");
            this.reqTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n;
                    if (AbstractPropertiesDialog.this.isEditable() && keyEvent.getKeyCode() == 127 && (n = AbstractPropertiesDialog.this.reqTable.getSelectedRow()) != -1 && AbstractPropertiesDialog.this.reqList.size() > 0 && n < AbstractPropertiesDialog.this.reqList.size()) {
                        AbstractPropertiesDialog.this.reqList.remove(n);
                        AbstractPropertiesDialog.this.reqTable.updateUI();
                    }
                }
            });
        }
        return this.pnChangeRequests;
    }

    protected void initResponsibleParties() {
        this.rpList.addAll(this.designObject.getResponsibleParties());
    }

    protected void setResponsibleParties() {
        this.setResponsibleParties(this.designObject);
    }

    protected void setResponsibleParties(DesignObject designObject) {
        designObject.clearResponsibleParties();
        for (BIResponsibleParty bIResponsibleParty : this.rpList) {
            designObject.addResponsibleParty(bIResponsibleParty);
        }
    }

    protected JPanel getResPartiesPanel() {
        if (this.pnResParties == null) {
            this.pnResParties = this.createPage(Messages.getString("AbstractPropertiesDialog.ResponsibleParties"));
            this.rpList = new ArrayList();
            this.rpTable = new JTable(new ResPartyModel());
            this.rpTable.setSelectionMode(0);
            this.rpTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = AbstractPropertiesDialog.this.rpTable.getSelectedRow()) != -1 && AbstractPropertiesDialog.this.rpList.size() > 0 && n < AbstractPropertiesDialog.this.rpList.size()) {
                        DesignObject designObject = (DesignObject)AbstractPropertiesDialog.this.rpList.get(n);
                        designObject.showModal = ((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime();
                        ResponsiblePartyPropertiesDialogEx responsiblePartyPropertiesDialogEx = new ResponsiblePartyPropertiesDialogEx((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), designObject, AbstractPropertiesDialog.this.rpTable);
                        responsiblePartyPropertiesDialogEx.initProperties(designObject);
                        responsiblePartyPropertiesDialogEx.show();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.rpTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AbstractPropertiesDialog.this.rpTable.getSelectedRow();
                    if (n != -1 && AbstractPropertiesDialog.this.rpList.size() > 0 && n < AbstractPropertiesDialog.this.rpList.size()) {
                        DesignObject designObject = (DesignObject)AbstractPropertiesDialog.this.rpList.get(n);
                        designObject.showModal = ((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime();
                        ResponsiblePartyPropertiesDialogEx responsiblePartyPropertiesDialogEx = new ResponsiblePartyPropertiesDialogEx((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), designObject, AbstractPropertiesDialog.this.rpTable);
                        responsiblePartyPropertiesDialogEx.initProperties(designObject);
                        responsiblePartyPropertiesDialogEx.show();
                    }
                }
            });
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            jButton2.setToolTipText(BTN_ADD);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddPartyDialog addPartyDialog = new AddPartyDialog(AbstractPropertiesDialog.this.getAppView(), AbstractPropertiesDialog.this.designObject.getDesign(), AbstractPropertiesDialog.this.rpList);
                    addPartyDialog.setVisible(true);
                    AbstractPropertiesDialog.this.rpTable.updateUI();
                }
            });
            final JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            jButton3.setToolTipText(BTN_REMOVE);
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AbstractPropertiesDialog.this.rpTable.getSelectedRow();
                    if (n != -1 && AbstractPropertiesDialog.this.rpList.size() > 0 && n < AbstractPropertiesDialog.this.rpList.size()) {
                        AbstractPropertiesDialog.this.rpList.remove(n);
                        AbstractPropertiesDialog.this.rpTable.updateUI();
                    }
                }
            });
            this.rpTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (AbstractPropertiesDialog.this.rpList.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            this.rpTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (AbstractPropertiesDialog.this.rpList.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jToolBar.addSeparator();
                jToolBar.add(jButton2);
                jToolBar.add(jButton3);
            }
            jPanel.add(jToolBar);
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)jScrollPane, "Center");
            this.pnResParties.add((Component)jPanel2, "Center");
            this.rpTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n;
                    if (AbstractPropertiesDialog.this.isEditable() && keyEvent.getKeyCode() == 127 && (n = AbstractPropertiesDialog.this.rpTable.getSelectedRow()) != -1 && AbstractPropertiesDialog.this.rpList.size() > 0 && n < AbstractPropertiesDialog.this.rpList.size()) {
                        AbstractPropertiesDialog.this.rpList.remove(n);
                        AbstractPropertiesDialog.this.rpTable.updateUI();
                    }
                }
            });
        }
        return this.pnResParties;
    }

    protected void initDefaults() {
        this.initDefaults(true);
    }

    protected void initDefaults(boolean bl) {
        this.tfName.setText(this.designObject.getName());
        this.taComments.setText(this.designObject.getComment());
        if (bl) {
            this.taCommentsInRDBMS.setText(this.designObject.getCommentInRDBMS());
        }
        this.taNotes.setText(this.designObject.getNotes());
        this.tfObjectID.setText(this.designObject.getObjectID());
        this.tfCreationTime.setText(this.designObject.getCreationTime());
        this.tfCreator.setText(this.designObject.getCreator().getName());
        this.tfDesign.setText(this.designObject.getOwnerDesignName());
        if (this.designObject.getGenerator() != null) {
            this.tfGeneratorName.setText(this.designObject.getGeneratorLongName());
        } else {
            this.tfGeneratorName.setText(NONE);
        }
        this.tfLastChangedBy.setText(this.designObject.getChanger().getName());
        this.tfLastChangedTime.setText(this.designObject.getChangeTime());
        if (this.designObject.getRepositoryOID() != null) {
            this.tfRepositoryOID.setText(this.designObject.getRepositoryOID());
        } else {
            this.tfRepositoryOID.setText(NONE);
        }
        this.initSummaryExtras();
    }

    protected void initSummaryExtras() {
        for (int i = this.pnSummaryGrid.getComponentCount(); i > this.summaryCount; --i) {
            this.pnSummaryGrid.remove(i - 1);
        }
        if (!EMPTY_STRING.equals(this.designObject.getSourceConnName())) {
            this.pnSummaryGrid.add(this.pnDataDictConnection);
            this.pnSummaryGrid.add(this.pnDataDictSchema);
            this.pnSummaryGrid.add(this.pnDataDictObject);
            this.tfDataDictConnection.setText(this.designObject.getSourceConnName());
            this.tfDataDictSchema.setText(this.designObject.getSourceObjSchema());
            this.tfDataDictObject.setText(this.designObject.getSourceObjName());
        }
        if (!EMPTY_STRING.equals(this.designObject.getSourceDDLFile())) {
            this.pnSummaryGrid.add(this.pnDDLFileName);
            this.tfDDLFileName.setText(this.designObject.getSourceDDLFile());
        }
        this.pnSummaryGrid.validate();
    }

    protected void initDocuments() {
        this.docList.addAll(this.designObject.getDocuments());
    }

    protected void setDocuments() {
        this.setDocuments(this.designObject);
    }

    protected void setDocuments(DesignObject designObject) {
        designObject.clearDocuments();
        for (BIDocument bIDocument : this.docList) {
            designObject.addDocument(bIDocument);
        }
    }

    protected JPanel getDocumentsPanel() {
        if (this.pnDocuments == null) {
            this.pnDocuments = this.createPage(Messages.getString("AbstractPropertiesDialog.Documents"));
            this.docList = new ArrayList();
            this.docTable = new JTable(new DocumentTableModel());
            this.docTable.setSelectionMode(0);
            this.docTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = AbstractPropertiesDialog.this.docTable.getSelectedRow()) != -1 && AbstractPropertiesDialog.this.docList.size() > 0 && n < AbstractPropertiesDialog.this.docList.size()) {
                        DesignObject designObject = (DesignObject)AbstractPropertiesDialog.this.docList.get(n);
                        designObject.showModal = ((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime();
                        DocumentPropertiesDialogEx documentPropertiesDialogEx = new DocumentPropertiesDialogEx((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), designObject, AbstractPropertiesDialog.this.docTable);
                        documentPropertiesDialogEx.initProperties(designObject);
                        documentPropertiesDialogEx.show();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.docTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AbstractPropertiesDialog.this.docTable.getSelectedRow();
                    if (n != -1 && AbstractPropertiesDialog.this.docList.size() > 0 && n < AbstractPropertiesDialog.this.docList.size()) {
                        DesignObject designObject = (DesignObject)AbstractPropertiesDialog.this.docList.get(n);
                        designObject.showModal = ((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime();
                        DocumentPropertiesDialogEx documentPropertiesDialogEx = new DocumentPropertiesDialogEx((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), designObject, AbstractPropertiesDialog.this.docTable);
                        documentPropertiesDialogEx.initProperties(designObject);
                        documentPropertiesDialogEx.show();
                    }
                }
            });
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            jButton2.setToolTipText(BTN_ADD);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddDocumentDialog addDocumentDialog = new AddDocumentDialog(AbstractPropertiesDialog.this.getAppView(), AbstractPropertiesDialog.this.designObject.getDesign(), AbstractPropertiesDialog.this.docList);
                    addDocumentDialog.setVisible(true);
                    AbstractPropertiesDialog.this.docTable.updateUI();
                }
            });
            final JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            jButton3.setToolTipText(BTN_REMOVE);
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AbstractPropertiesDialog.this.docTable.getSelectedRow();
                    if (n != -1 && AbstractPropertiesDialog.this.docList.size() > 0 && n < AbstractPropertiesDialog.this.docList.size()) {
                        AbstractPropertiesDialog.this.docList.remove(n);
                        AbstractPropertiesDialog.this.docTable.updateUI();
                    }
                }
            });
            this.docTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (AbstractPropertiesDialog.this.docList.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            this.docTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (AbstractPropertiesDialog.this.docList.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jToolBar.addSeparator();
                jToolBar.add(jButton2);
                jToolBar.add(jButton3);
            }
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)jScrollPane, "Center");
            this.pnDocuments.add((Component)jPanel2, "Center");
            this.docTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n;
                    if (AbstractPropertiesDialog.this.isEditable() && keyEvent.getKeyCode() == 127 && (n = AbstractPropertiesDialog.this.docTable.getSelectedRow()) != -1 && AbstractPropertiesDialog.this.docList.size() > 0 && n < AbstractPropertiesDialog.this.docList.size()) {
                        AbstractPropertiesDialog.this.docList.remove(n);
                        AbstractPropertiesDialog.this.docTable.updateUI();
                    }
                }
            });
        }
        return this.pnDocuments;
    }

    protected JPanel getScriptPanel() {
        if (this.pnScript == null) {
            this.pnScript = this.createPage(Messages.getString("AbstractPropertiesDialog.Scripts"));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.taBeforeDrop = new JTextArea();
            this.taBeforeDrop.setEnabled(this.isEditable());
            this.taBeforeCreate = new JTextArea();
            this.taBeforeCreate.setEnabled(this.isEditable());
            this.taAfterCreate = new JTextArea();
            this.taAfterCreate.setEnabled(this.isEditable());
            this.taEndOfScript = new JTextArea();
            this.taEndOfScript.setEnabled(this.isEditable());
            this.addTab(this.taBeforeDrop, Messages.getString("AbstractPropertiesDialog.BeforeDropRename"));
            this.addTab(this.taBeforeCreate, Messages.getString("AbstractPropertiesDialog.BeforeCreate"));
            this.addTab(this.taAfterCreate, Messages.getString("AbstractPropertiesDialog.AfterCreate"));
            this.addTab(this.taEndOfScript, Messages.getString("AbstractPropertiesDialog.EndOfScript"));
            jPanel.add((Component)this.tpane, "Center");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(LB_GENERATE);
            this.chGenerateScript = new JCheckBox();
            this.chGenerateScript.setPreferredSize(new Dimension(20, 20));
            this.chGenerateScript.setSelected(false);
            jPanel2.add((Component)this.chGenerateScript, "West");
            jPanel2.add(jLabel);
            jPanel.add((Component)jPanel2, "South");
            this.chGenerateScript.setEnabled(this.isEditable());
            this.pnScript.add(jPanel);
        }
        return this.pnScript;
    }

    private void addTab(JTextArea jTextArea, String string) {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
        }
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add(new JScrollPane(jTextArea));
        this.tpane.add((Component)jPanel, string);
    }

    protected int getMinimumTreeWidth() {
        return 190;
    }

    protected boolean isEditable() {
        if (this.getDesignObject().isReadOnly()) {
            return false;
        }
        if (ApplicationView.IS_VIEWER) {
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            return this.designObject.getDesignPart() instanceof LogicalDesign;
        }
        return true;
    }

    protected void addEditModeButtons() {
    }

    protected JTree initImpactAnalysisTreeModel() {
        return null;
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        ModelIdObjectSelection modelIdObjectSelection;
        Object object = treeExpansionEvent.getPath().getLastPathComponent();
        if (object instanceof ModelIdObjectSelection && !(modelIdObjectSelection = (ModelIdObjectSelection)object).isLoaded()) {
            modelIdObjectSelection.load();
        }
    }

    protected void checkDesignRule(DesignRule designRule, DesignObject designObject) {
        designRule.init();
        CheckResult checkResult = designRule.doCheck(designObject);
        if (!checkResult.isOk()) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), designObject.getName() + ": " + checkResult.getMessage(), Messages.getString("AbstractPropertiesDialog.NamingOptions"), 2);
        }
    }

    private DynamicProperty createAndAddDynamicProperty(String string, String string2) {
        DynamicProperty dynamicProperty = new DynamicProperty(EMPTY_STRING, EMPTY_STRING);
        dynamicProperty.setName(string);
        dynamicProperty.setValue(string2);
        this.getDynamicPropertiesList().add(dynamicProperty);
        return dynamicProperty;
    }

    public List getDynamicPropertiesList() {
        if (this.dynamicPropertiesList == null) {
            this.dynamicPropertiesList = new ArrayList<DynamicProperty>();
        }
        return this.dynamicPropertiesList;
    }

    protected String generateDynamicProperyName() {
        String string = "dynamicProperty";
        int n = 0;
        int n2 = this.dynamicPropertiesList.size();
        if (n2 != 0) {
            n = this.cgCounter = n2 + 1;
        } else {
            ++this.cgCounter;
            n = this.cgCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.dynamicProperyExists(string2)) {
            n = ++this.cgCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean dynamicProperyExists(String string) {
        for (int i = 0; i < this.dynamicPropertiesList.size(); ++i) {
            DynamicProperty dynamicProperty = this.dynamicPropertiesList.get(i);
            if (!string.equalsIgnoreCase(dynamicProperty.getName())) continue;
            return true;
        }
        return false;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    protected String translate(String string, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return stringArray2[i];
        }
        return EMPTY_STRING;
    }

    private class DynamicPropertiesModel
    extends AbstractTableModel {
        private DynamicPropertiesModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AbstractPropertiesDialog.this.dynamicPropertiesList.size();
        }

        public List<DynamicProperty> getDynamicPropertiesList() {
            return AbstractPropertiesDialog.this.dynamicPropertiesList;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractPropertiesDialog.PropertyName");
            }
            return Messages.getString("AbstractPropertiesDialog.PropertyValue");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DynamicProperty dynamicProperty = AbstractPropertiesDialog.this.dynamicPropertiesList.get(n);
            if (n2 == 0) {
                return dynamicProperty.getName();
            }
            if (n2 == 1) {
                return dynamicProperty.getValue();
            }
            return AbstractPropertiesDialog.EMPTY_STRING;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            DynamicProperty dynamicProperty = AbstractPropertiesDialog.this.dynamicPropertiesList.get(n);
            if (n2 == 0) {
                dynamicProperty.setName(object.toString());
            } else if (n2 == 1) {
                dynamicProperty.setValue(object.toString());
            }
        }
    }

    private class DocumentTableModel
    extends AbstractTableModel {
        private DocumentTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractPropertiesDialog.this.docList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractPropertiesDialog.Documents");
            }
            return AbstractPropertiesDialog.EMPTY_STRING;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)AbstractPropertiesDialog.this.docList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class ResPartyModel
    extends AbstractTableModel {
        private ResPartyModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractPropertiesDialog.this.rpList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractPropertiesDialog.ResponsibleParties");
            }
            return AbstractPropertiesDialog.EMPTY_STRING;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)AbstractPropertiesDialog.this.rpList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class ChangeRequestModel
    extends AbstractTableModel {
        private ChangeRequestModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractPropertiesDialog.this.reqList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractPropertiesDialog.ChangeRequests");
            }
            return AbstractPropertiesDialog.EMPTY_STRING;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ChangeRequest changeRequest = (ChangeRequest)AbstractPropertiesDialog.this.reqList.get(n);
            if (n2 == 0) {
                return changeRequest.getName();
            }
            return new Integer(n * n2);
        }
    }

    public class MeasurementModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractPropertiesDialog.this.mList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractPropertiesDialog.Measurements");
            }
            return AbstractPropertiesDialog.EMPTY_STRING;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Measurement measurement = (Measurement)AbstractPropertiesDialog.this.mList.get(n);
            if (n2 == 0) {
                return measurement.getName();
            }
            return null;
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)AbstractPropertiesDialog.this.tree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof Component) {
                AbstractPropertiesDialog.this.showComponent((Component)object);
            }
        }
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        TreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(null);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getUserObject() instanceof Component) {
                Component component = (Component)defaultMutableTreeNode.getUserObject();
                this.setText(component.getName());
            }
            return this;
        }
    }
}

