/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.CommonEditor;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AbstractFieldEditor
extends JDialog
implements AbstractEditorConstants {
    private JTextArea editorPane;
    private JPanel buttonPanel;
    private ModelIDObject desObject;
    private int fieldId;
    private CommonEditor editor;

    public AbstractFieldEditor(Dialog dialog, ApplicationView applicationView, ModelIDObject modelIDObject, int n, CommonEditor commonEditor) {
        super(dialog);
        this.init(applicationView, modelIDObject, n, commonEditor);
    }

    public AbstractFieldEditor(ApplicationView applicationView, ModelIDObject modelIDObject, int n, CommonEditor commonEditor) {
        super(applicationView.getFrame());
        this.init(applicationView, modelIDObject, n, commonEditor);
    }

    private void init(ApplicationView applicationView, ModelIDObject modelIDObject, int n, CommonEditor commonEditor) {
        this.desObject = modelIDObject;
        this.fieldId = n;
        this.editor = commonEditor;
        this.setTitle(this.getCaption());
        JScrollPane jScrollPane = new JScrollPane(this.getEditorPane());
        jScrollPane.setPreferredSize(new Dimension(550, 450));
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.initProperties();
        this.setDefaultCloseOperation(2);
        JPanel jPanel = this.getButtonPanel();
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
    }

    private void initProperties() {
        switch (this.fieldId) {
            case 1: {
                this.editorPane.setText(this.editor.getCommentField());
                this.editorPane.setCaretPosition(0);
                break;
            }
            case 2: {
                this.editorPane.setText(this.editor.getNotesField());
                this.editorPane.setCaretPosition(0);
                break;
            }
            case 4: {
                this.editorPane.setText(this.editor.getSynonymField());
                this.editorPane.setCaretPosition(0);
                break;
            }
        }
    }

    public String getCaption() {
        return Messages.getString("AbstractFieldEditor.Edit");
    }

    private void setProperties() {
        switch (this.fieldId) {
            case 1: {
                this.editor.setCommentField(this.editorPane.getText());
                break;
            }
            case 2: {
                this.editor.setNotesField(this.editorPane.getText());
                break;
            }
            case 4: {
                this.editor.setSynonymField(this.editorPane.getText());
                break;
            }
        }
    }

    protected JTextArea getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = new JTextArea();
            this.editorPane.setEnabled(this.isEditable());
        }
        return this.editorPane;
    }

    public void initProperties(Note note) {
        this.editorPane.setText(note.getText());
    }

    protected boolean isEditable() {
        if (ApplicationView.IS_VIEWER) {
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            if (this.desObject instanceof DesignObject) {
                return ((DesignObject)this.desObject).getDesignPart() instanceof LogicalDesign;
            }
            return false;
        }
        return true;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            JButton jButton;
            this.buttonPanel = new JPanel();
            String string = Messages.getString("AbstractFieldEditor.Close");
            if (this.isEditable()) {
                jButton = new JButton(Messages.getString("AbstractFieldEditor.OK"));
                jButton.setMnemonic(79);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AbstractFieldEditor.this.setProperties();
                        AbstractFieldEditor.this.dispose();
                    }
                });
                jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(jButton);
                string = Messages.getString("AbstractFieldEditor.Cancel");
            }
            jButton = new JButton(string);
            jButton.setMnemonic(67);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractFieldEditor.this.dispose();
                }
            });
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(jButton);
        }
        return this.buttonPanel;
    }
}

