/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignUtilities;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.Messages;

public abstract class AbstractDatatypePropertiesDialog
extends AbstractPropertiesDialog {
    private JPanel pnUsedIn;
    private JPanel pnAttributes;
    private JPanel pnColumns;
    private JPanel pnObjAttributes;
    protected JTable attrTable;
    protected JTable columnsTable;
    protected JTable objAttrTable;
    private List<DesignUtilities.AttributeRef> usedInAttributesList;
    private List<TypeElement> usedInObjAttributesList;
    private List<DesignUtilities.ColumnRef> usedInColumnsList;
    protected DesignObject datatypeObject;
    private short use;
    protected JTabbedPane tabbedPaneUsedIn;

    public AbstractDatatypePropertiesDialog(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
    }

    public AbstractDatatypePropertiesDialog(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog, applicationView, designObject);
    }

    @Override
    protected JPanel getUsedInPanel() {
        if (this.pnUsedIn == null) {
            this.pnUsedIn = this.createPage(Messages.getString("AbstractDatatypePropertiesDialog.UsedIn"));
            this.taUsedIn = new JTextArea();
            this.taUsedIn.setEnabled(super.isEditable());
            this.pnUsedIn.add(new JScrollPane(this.taUsedIn));
            this.usedInAttributesList = new ArrayList<DesignUtilities.AttributeRef>();
            this.usedInColumnsList = new ArrayList<DesignUtilities.ColumnRef>();
            this.usedInObjAttributesList = new ArrayList<TypeElement>();
            this.pnAttributes = this.initAttributesPanel();
            this.pnColumns = this.initColumnsPanel();
            this.pnObjAttributes = this.initObjAttributesPanel();
            this.tabbedPaneUsedIn = new JTabbedPane();
            this.tabbedPaneUsedIn.addTab(Messages.getString("AbstractDatatypePropertiesDialog.Attributes"), this.pnAttributes);
            this.tabbedPaneUsedIn.addTab(Messages.getString("AbstractDatatypePropertiesDialog.Columns"), this.pnColumns);
            this.tabbedPaneUsedIn.addTab(Messages.getString("AbstractDatatypePropertiesDialog.ObjAttributes"), this.pnObjAttributes);
            this.pnUsedIn.add(this.tabbedPaneUsedIn);
        }
        return this.pnUsedIn;
    }

    public JPanel createUsedInPanel(JTable jTable, MouseAdapter mouseAdapter, ActionListener actionListener) {
        return this.createUsedInPanel(jTable, mouseAdapter, actionListener, null);
    }

    public JPanel createUsedInPanel(final JTable jTable, MouseAdapter mouseAdapter, ActionListener actionListener, ActionListener actionListener2) {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new BorderLayout());
        jTable.setSelectionMode(0);
        jTable.addMouseListener(mouseAdapter);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(BTN_PROPERTIES);
        jButton.addActionListener(actionListener);
        jToolBar.add(jButton);
        jButton.setEnabled(false);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                jButton.setEnabled(jTable.getSelectedRow() > -1);
            }
        });
        if (super.isEditable() && actionListener2 != null) {
            jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            jComponent.setToolTipText(BTN_ADD);
            ((AbstractButton)jComponent).addActionListener(actionListener2);
            jToolBar.add(jComponent);
        }
        jPanel2.add(jToolBar);
        jComponent = new JPanel(new BorderLayout());
        jComponent.add((Component)jPanel2, "North");
        jComponent.add(new JScrollPane(jTable));
        jPanel.add(jComponent);
        return jPanel;
    }

    public JPanel initAttributesPanel() {
        this.attrTable = new JTable(new AttributeTableModel());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = AbstractDatatypePropertiesDialog.this.attrTable.getSelectedColumn();
                    int n2 = AbstractDatatypePropertiesDialog.this.attrTable.getSelectedRow();
                    if (n2 != -1 && AbstractDatatypePropertiesDialog.this.usedInAttributesList.size() > 0 && n2 < AbstractDatatypePropertiesDialog.this.usedInAttributesList.size()) {
                        DesignUtilities.AttributeRef attributeRef = (DesignUtilities.AttributeRef)AbstractDatatypePropertiesDialog.this.usedInAttributesList.get(n2);
                        if (n == 0) {
                            Entity entity = attributeRef.getEntity();
                            if (!entity.isDialogVisible()) {
                                entity.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                                entity.showPropertyDialog();
                            }
                        } else {
                            Attribute attribute = attributeRef.getAttribute();
                            if (!attribute.isDialogVisible()) {
                                attribute.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                                attribute.showPropertyDialog();
                            }
                        }
                    }
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractDatatypePropertiesDialog.this.attrTable.getSelectedColumn();
                int n2 = AbstractDatatypePropertiesDialog.this.attrTable.getSelectedRow();
                if (n2 != -1 && AbstractDatatypePropertiesDialog.this.usedInAttributesList.size() > 0 && n2 < AbstractDatatypePropertiesDialog.this.usedInAttributesList.size()) {
                    int n3 = AbstractDatatypePropertiesDialog.this.attrTable.getEditingColumn();
                    int n4 = AbstractDatatypePropertiesDialog.this.attrTable.getEditingRow();
                    if (n3 > -1 && n4 > -1) {
                        AbstractDatatypePropertiesDialog.this.attrTable.getCellEditor(n4, n3).stopCellEditing();
                    }
                    DesignUtilities.AttributeRef attributeRef = (DesignUtilities.AttributeRef)AbstractDatatypePropertiesDialog.this.usedInAttributesList.get(n2);
                    if (n == 0) {
                        Entity entity = attributeRef.getEntity();
                        if (!entity.isDialogVisible()) {
                            entity.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            entity.showPropertyDialog();
                        }
                    } else {
                        Attribute attribute = attributeRef.getAttribute();
                        if (!attribute.isDialogVisible()) {
                            attribute.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            attribute.showPropertyDialog();
                        }
                    }
                }
            }
        };
        return this.createUsedInPanel(this.attrTable, mouseAdapter, actionListener);
    }

    public JPanel initColumnsPanel() {
        this.columnsTable = new JTable(new ColumnTableModel());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = AbstractDatatypePropertiesDialog.this.columnsTable.getSelectedColumn();
                    int n2 = AbstractDatatypePropertiesDialog.this.columnsTable.getSelectedRow();
                    if (n2 != -1 && AbstractDatatypePropertiesDialog.this.usedInColumnsList.size() > 0 && n2 < AbstractDatatypePropertiesDialog.this.usedInColumnsList.size()) {
                        DesignUtilities.ColumnRef columnRef = (DesignUtilities.ColumnRef)AbstractDatatypePropertiesDialog.this.usedInColumnsList.get(n2);
                        if (n == 0) {
                            RelationalDesign relationalDesign = columnRef.getModel();
                            if (!relationalDesign.isDialogVisible()) {
                                relationalDesign.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                                relationalDesign.showPropertyDialog();
                            }
                        } else if (n == 1) {
                            Table table = columnRef.getTable();
                            if (!table.isDialogVisible()) {
                                table.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                                table.showPropertyDialog();
                            }
                        } else {
                            Column column = columnRef.getColumn();
                            if (!column.isDialogVisible()) {
                                column.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                                column.showPropertyDialog();
                            }
                        }
                    }
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractDatatypePropertiesDialog.this.columnsTable.getSelectedColumn();
                int n2 = AbstractDatatypePropertiesDialog.this.columnsTable.getSelectedRow();
                if (n2 != -1 && AbstractDatatypePropertiesDialog.this.usedInColumnsList.size() > 0 && n2 < AbstractDatatypePropertiesDialog.this.usedInColumnsList.size()) {
                    int n3 = AbstractDatatypePropertiesDialog.this.columnsTable.getEditingColumn();
                    int n4 = AbstractDatatypePropertiesDialog.this.columnsTable.getEditingRow();
                    if (n3 > -1 && n4 > -1) {
                        AbstractDatatypePropertiesDialog.this.columnsTable.getCellEditor(n4, n3).stopCellEditing();
                    }
                    DesignUtilities.ColumnRef columnRef = (DesignUtilities.ColumnRef)AbstractDatatypePropertiesDialog.this.usedInColumnsList.get(n2);
                    if (n == 0) {
                        RelationalDesign relationalDesign = columnRef.getModel();
                        if (!relationalDesign.isDialogVisible()) {
                            relationalDesign.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            relationalDesign.showPropertyDialog();
                        }
                    } else if (n == 1) {
                        Table table = columnRef.getTable();
                        if (!table.isDialogVisible()) {
                            table.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            table.showPropertyDialog();
                        }
                    } else {
                        Column column = columnRef.getColumn();
                        if (!column.isDialogVisible()) {
                            column.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            column.showPropertyDialog();
                        }
                    }
                }
            }
        };
        return this.createUsedInPanel(this.columnsTable, mouseAdapter, actionListener);
    }

    public JPanel initObjAttributesPanel() {
        this.objAttrTable = new JTable(new ObjAttributeTableModel());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = AbstractDatatypePropertiesDialog.this.objAttrTable.getSelectedColumn();
                    int n2 = AbstractDatatypePropertiesDialog.this.objAttrTable.getSelectedRow();
                    if (n2 != -1 && AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.size() > 0 && n2 < AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.size()) {
                        TypeElement typeElement = (TypeElement)AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.get(n2);
                        if (n == 0) {
                            StructuredType structuredType = typeElement.getStructuredType();
                            if (!structuredType.isDialogVisible()) {
                                structuredType.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                                structuredType.showPropertyDialog();
                            }
                        } else if (!typeElement.isDialogVisible()) {
                            typeElement.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            typeElement.showPropertyDialog();
                        }
                    }
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractDatatypePropertiesDialog.this.objAttrTable.getSelectedColumn();
                int n2 = AbstractDatatypePropertiesDialog.this.objAttrTable.getSelectedRow();
                if (n2 != -1 && AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.size() > 0 && n2 < AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.size()) {
                    int n3 = AbstractDatatypePropertiesDialog.this.objAttrTable.getEditingColumn();
                    int n4 = AbstractDatatypePropertiesDialog.this.objAttrTable.getEditingRow();
                    if (n3 > -1 && n4 > -1) {
                        AbstractDatatypePropertiesDialog.this.objAttrTable.getCellEditor(n4, n3).stopCellEditing();
                    }
                    TypeElement typeElement = (TypeElement)AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.get(n2);
                    if (n == 0) {
                        StructuredType structuredType = typeElement.getStructuredType();
                        if (!structuredType.isDialogVisible()) {
                            structuredType.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            structuredType.showPropertyDialog();
                        }
                    } else if (!typeElement.isDialogVisible()) {
                        typeElement.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                        typeElement.showPropertyDialog();
                    }
                }
            }
        };
        return this.createUsedInPanel(this.objAttrTable, mouseAdapter, actionListener);
    }

    protected void initUsedInAttributes(DesignObject designObject, short s) {
        this.datatypeObject = designObject;
        this.use = s;
        this.usedInAttributesList = DesignUtilities.extractUsedInAttributes(this.getDesignObject().getDesign(), designObject, s);
    }

    protected void initUsedInColumns() {
        this.usedInColumnsList = DesignUtilities.extractUsedInColumns(this.getDesignObject().getDesign(), this.datatypeObject, this.use);
    }

    protected void initUsedInObjectAttributes() {
        this.usedInObjAttributesList = DesignUtilities.extractUsedInStructuredTypeAttributes(this.getDesignObject().getDesign(), this.datatypeObject);
    }

    class ColumnTableModel
    extends UsedInObjectModel {
        ColumnTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return AbstractDatatypePropertiesDialog.this.usedInColumnsList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractDatatypePropertiesDialog.Model");
            }
            if (n == 1) {
                return Messages.getString("AbstractDatatypePropertiesDialog.Table");
            }
            return Messages.getString("AbstractDatatypePropertiesDialog.Column");
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignUtilities.ColumnRef columnRef = (DesignUtilities.ColumnRef)AbstractDatatypePropertiesDialog.this.usedInColumnsList.get(n);
            if (n2 == 0) {
                return columnRef.getModel().getName();
            }
            if (n2 == 1) {
                return columnRef.getTable().getName();
            }
            if (n2 == 2) {
                return columnRef.getColumn().getName();
            }
            return super.getValueAt(n, n2);
        }
    }

    class ObjAttributeTableModel
    extends UsedInObjectModel {
        ObjAttributeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractDatatypePropertiesDialog.Object");
            }
            return Messages.getString("AbstractDatatypePropertiesDialog.Attribute");
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TypeElement typeElement = (TypeElement)AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.get(n);
            if (n2 == 0) {
                return typeElement.getStructuredType().getName();
            }
            if (n2 == 1) {
                return typeElement.getName();
            }
            return super.getValueAt(n, n2);
        }
    }

    class AttributeTableModel
    extends UsedInObjectModel {
        AttributeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AbstractDatatypePropertiesDialog.this.usedInAttributesList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractDatatypePropertiesDialog.Entity");
            }
            return Messages.getString("AbstractDatatypePropertiesDialog.Attribute");
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignUtilities.AttributeRef attributeRef = (DesignUtilities.AttributeRef)AbstractDatatypePropertiesDialog.this.usedInAttributesList.get(n);
            if (n2 == 0) {
                return attributeRef.getEntity().getName();
            }
            if (n2 == 1) {
                return attributeRef.getAttribute().getName();
            }
            return super.getValueAt(n, n2);
        }
    }

    protected abstract class UsedInObjectModel
    extends AbstractTableModel {
        protected UsedInObjectModel() {
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return new Integer(n * n2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

