/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.ui.def;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelListener;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionListener;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.BasicMarqueeHandler;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewHandle;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultPort;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramCellEditor;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramLayoutCache;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramSelectionModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramTransferable;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.ParentMap;
import oracle.dbtools.crest.swingui.diagram.logical.EntityView;
import oracle.dbtools.crest.swingui.diagram.ui.DiagramUI;
import oracle.dbtools.crest.swingui.diagram.ui.def.DefaultDiagramDropTargetListener;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.logging.Logger;

public class DefaultDiagramUI
extends DiagramUI
implements Serializable {
    public static final boolean DNDPREVIEW = System.getProperty("java.version").compareTo("1.4.0") < 0 || System.getProperty("java.version").compareTo("1.4.0") > 0;
    public static int SCROLLBORDER = 18;
    public static float SCROLLSTEP = 0.05f;
    public static int MAXCELLS = 5;
    public static int MAXHANDLES = 10000;
    public static int MAXCLIPCELLS = 20;
    protected Dimension preferredMinSize;
    protected AbstractDiagram diagram;
    protected DiagramLayoutCache diagramLayoutCache;
    protected DiagramCellEditor cellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected DiagramModel diagramModel;
    protected DiagramSelectionModel diagramSelectionModel;
    protected CellHandle handle;
    protected BasicMarqueeHandler marquee;
    protected Component editingComponent;
    protected CellView focus;
    protected Object editingCell;
    protected boolean editorHasDifferentSize;
    protected Point insertionLocation;
    protected int dropAction = 0;
    protected boolean snapSelectedView = false;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected ComponentListener componentListener;
    protected CellEditorListener cellEditorListener = this.createCellEditorListener();
    protected DiagramSelectionListener diagramSelectionListener;
    protected DiagramModelListener diagramModelListener;
    protected Observer diagramViewObserver;
    protected TransferHandler defaultTransferHandler;
    protected DiagramDropTargetListener defaultDropTargetListener;
    private static final Logger LOGGER = new Logger(DefaultDiagramUI.class);

    public static ComponentUI createUI(JComponent jComponent) {
        return new DefaultDiagramUI();
    }

    protected void setModel(DiagramModel diagramModel) {
        this.cancelEditing(this.diagram);
        if (this.diagramModel != null && this.diagramModelListener != null) {
            this.diagramModel.removeDiagramModelListener(this.diagramModelListener);
        }
        this.diagramModel = diagramModel;
        if (this.diagramModel != null && this.diagramModelListener != null) {
            this.diagramModel.addDiagramModelListener(this.diagramModelListener);
        }
        if (this.diagramModel != null) {
            this.updateSize();
        }
    }

    protected void setDiagramLayoutCache(DiagramLayoutCache diagramLayoutCache) {
        this.cancelEditing(this.diagram);
        if (this.diagramLayoutCache != null && this.diagramViewObserver != null) {
            this.diagramLayoutCache.deleteObserver(this.diagramViewObserver);
        }
        this.diagramLayoutCache = diagramLayoutCache;
        if (this.diagramLayoutCache != null && this.diagramViewObserver != null) {
            this.diagramLayoutCache.addObserver(this.diagramViewObserver);
        }
        this.updateSize();
    }

    protected void setMarquee(BasicMarqueeHandler basicMarqueeHandler) {
        this.marquee = basicMarqueeHandler;
    }

    protected void setSelectionModel(DiagramSelectionModel diagramSelectionModel) {
        this.cancelEditing(this.diagram);
        if (this.diagramSelectionListener != null && this.diagramSelectionModel != null) {
            this.diagramSelectionModel.removeDiagramSelectionListener(this.diagramSelectionListener);
        }
        this.diagramSelectionModel = diagramSelectionModel;
        if (this.diagramSelectionModel != null && this.diagramSelectionListener != null) {
            this.diagramSelectionModel.addDiagramSelectionListener(this.diagramSelectionListener);
        }
        if (this.diagram != null) {
            this.diagram.repaint();
        }
    }

    @Override
    public CellHandle getHandle(AbstractDiagram abstractDiagram) {
        return this.handle;
    }

    protected Object getFocusedCell() {
        if (this.focus != null) {
            return this.focus.getCell();
        }
        return null;
    }

    @Override
    public Dimension2D getPreferredSize(AbstractDiagram abstractDiagram, CellView cellView) {
        if (cellView != null) {
            boolean bl;
            Component component;
            boolean bl2;
            Object object = cellView.getCell();
            String string = abstractDiagram.convertValueToString(object);
            boolean bl3 = string != null && string.length() > 0;
            boolean bl4 = bl2 = DiagramConstants.getIcon(cellView.getAllAttributes()) != null;
            if ((bl3 || bl2) && (component = cellView.getRendererComponent(abstractDiagram, bl = this.getFocusedCell() == object && abstractDiagram.hasFocus(), false, false)) != null) {
                abstractDiagram.add(component);
                component.validate();
                return component.getPreferredSize();
            }
            Rectangle2D rectangle2D = cellView.getBounds();
            return new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        return null;
    }

    public Point getInsertionLocation() {
        return this.insertionLocation;
    }

    public void setInsertionLocation(Point point) {
        this.insertionLocation = point;
    }

    @Override
    public void selectCellsForEvent(AbstractDiagram abstractDiagram, Object[] objectArray, MouseEvent mouseEvent) {
        this.selectCellsForEvent(objectArray, mouseEvent);
    }

    public void selectCellsForEvent(Object[] objectArray, MouseEvent mouseEvent) {
        if (objectArray == null) {
            return;
        }
        if (this.isToggleSelectionEvent(mouseEvent)) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.toggleSelectionCellForEvent(objectArray[i], mouseEvent);
            }
        } else if (this.isAddToSelectionEvent(mouseEvent)) {
            this.diagram.addSelectionCells(objectArray);
        } else {
            this.diagram.setSelectionCells(objectArray);
        }
    }

    public void selectCellForEvent(Object object, MouseEvent mouseEvent) {
        if (this.isToggleSelectionEvent(mouseEvent)) {
            this.toggleSelectionCellForEvent(object, mouseEvent);
        } else if (this.isAddToSelectionEvent(mouseEvent)) {
            this.diagram.addSelectionCell(object);
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            if (!this.diagram.getSelectionModel().isCellSelected(object)) {
                this.diagram.setSelectionCell(object);
            }
        } else {
            this.diagram.setSelectionCell(object);
        }
    }

    protected void toggleSelectionCellForEvent(Object object, MouseEvent mouseEvent) {
        if (this.diagram.isCellSelected(object)) {
            this.diagram.removeSelectionCell(object);
        } else {
            this.diagram.addSelectionCell(object);
        }
    }

    public boolean isAddToSelectionEvent(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown();
    }

    public boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return mouseEvent.isControlDown();
    }

    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        if (this.marquee != null) {
            return this.marquee.isForceMarqueeEvent(mouseEvent);
        }
        return false;
    }

    public boolean isConstrainedMoveEvent(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            return mouseEvent.isShiftDown();
        }
        return false;
    }

    @Override
    public boolean isEditing(AbstractDiagram abstractDiagram) {
        return this.editingComponent != null;
    }

    @Override
    public boolean stopEditing(AbstractDiagram abstractDiagram) {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    @Override
    public void cancelEditing(AbstractDiagram abstractDiagram) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    @Override
    public void startEditingAtCell(AbstractDiagram abstractDiagram, Object object) {
        abstractDiagram.scrollCellToVisible(object);
        if (object != null) {
            this.startEditing(object, null);
        }
    }

    @Override
    public Object getEditingCell(AbstractDiagram abstractDiagram) {
        return this.editingCell;
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("null component passed to DefaultDiagramUI.installUI()");
        }
        this.diagram = (AbstractDiagram)jComponent;
        this.marquee = this.diagram.getMarqueeHandler();
        this.prepareForUIInstall();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.installComponents();
        this.completeUIInstall();
    }

    protected void prepareForUIInstall() {
        this.stopEditingInCompleteEditing = true;
        this.preferredSize = new Dimension();
        this.setDiagramLayoutCache(this.diagram.getDiagramLayoutCache());
        this.setModel(this.diagram.getModel());
    }

    protected void completeUIInstall() {
        this.setSelectionModel(this.diagram.getSelectionModel());
        this.updateSize();
    }

    protected void installDefaults() {
        if (this.diagram.getBackground() == null || this.diagram.getBackground() instanceof UIResource) {
            this.diagram.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.diagram.getFont() == null || this.diagram.getFont() instanceof UIResource) {
            this.diagram.setFont(UIManager.getFont("Tree.font"));
        }
        this.diagram.setMarqueeColor(UIManager.getColor("Table.gridColor"));
        this.diagram.setHandleColor(UIManager.getColor("MenuItem.selectionBackground"));
        this.diagram.setLockedHandleColor(UIManager.getColor("MenuItem.background"));
        this.diagram.setGridColor(UIManager.getColor("Tree.selectionBackground"));
        this.diagram.setOpaque(true);
    }

    protected void installListeners() {
        TransferHandler transferHandler = this.diagram.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.defaultTransferHandler = this.createTransferHandler();
            this.diagram.setTransferHandler(this.defaultTransferHandler);
        }
        if (this.diagramLayoutCache != null) {
            this.diagramViewObserver = this.createDiagramViewObserver();
            this.diagramLayoutCache.addObserver(this.diagramViewObserver);
        }
        DropTarget dropTarget = this.diagram.getDropTarget();
        try {
            if (dropTarget != null) {
                this.defaultDropTargetListener = new DiagramDropTargetListener();
                dropTarget.addDropTargetListener(this.defaultDropTargetListener);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.diagram.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.diagram.addMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.diagram.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.diagram.addKeyListener(this.keyListener);
        }
        if ((this.diagramModelListener = this.createDiagramModelListener()) != null && this.diagramModel != null) {
            this.diagramModel.addDiagramModelListener(this.diagramModelListener);
        }
        if ((this.diagramSelectionListener = this.createDiagramSelectionListener()) != null && this.diagramSelectionModel != null) {
            this.diagramSelectionModel.addDiagramSelectionListener(this.diagramSelectionListener);
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.diagram, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.diagram, 0, inputMap);
        SwingUtilities.replaceUIActionMap(this.diagram, this.createActionMap());
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("Tree.ancestorInputMap");
        }
        if (n == 0) {
            return (InputMap)UIManager.get("Tree.focusInputMap");
        }
        return null;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("selectPrevious", new DiagramIncrementAction(1, "selectPrevious"));
        actionMapUIResource.put("selectPreviousChangeLead", new DiagramIncrementAction(1, "selectPreviousLead"));
        actionMapUIResource.put("selectPreviousExtendSelection", new DiagramIncrementAction(1, "selectPreviousExtendSelection"));
        actionMapUIResource.put("selectParent", new DiagramIncrementAction(4, "selectParent"));
        actionMapUIResource.put("selectParentChangeLead", new DiagramIncrementAction(4, "selectParentChangeLead"));
        actionMapUIResource.put("selectNext", new DiagramIncrementAction(3, "selectNext"));
        actionMapUIResource.put("selectNextChangeLead", new DiagramIncrementAction(3, "selectNextLead"));
        actionMapUIResource.put("selectNextExtendSelection", new DiagramIncrementAction(3, "selectNextExtendSelection"));
        actionMapUIResource.put("selectChild", new DiagramIncrementAction(2, "selectChild"));
        actionMapUIResource.put("selectChildChangeLead", new DiagramIncrementAction(2, "selectChildChangeLead"));
        actionMapUIResource.put("cancel", new DiagramCancelEditingAction("cancel"));
        actionMapUIResource.put("startEditing", new DiagramEditAction("startEditing"));
        actionMapUIResource.put("selectAll", new DiagramSelectAllAction("selectAll", true));
        actionMapUIResource.put("clearSelection", new DiagramSelectAllAction("clearSelection", false));
        return actionMapUIResource;
    }

    protected void installComponents() {
        this.rendererPane = this.createCellRendererPane();
        if (this.rendererPane != null) {
            this.diagram.add(this.rendererPane);
        }
    }

    protected TransferHandler createTransferHandler() {
        return new DiagramTransferHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected DiagramSelectionListener createDiagramSelectionListener() {
        return new DiagramSelectionHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected Observer createDiagramViewObserver() {
        return new DiagramViewObserver();
    }

    protected DiagramModelListener createDiagramModelListener() {
        return new DiagramModelHandler();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.cancelEditing(this.diagram);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void completeUIUninstall() {
        this.diagramLayoutCache = null;
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.keyListener = null;
        this.setSelectionModel(null);
        this.diagram = null;
        this.diagramModel = null;
        this.diagramSelectionModel = null;
        this.diagramSelectionListener = null;
    }

    protected void uninstallListeners() {
        TransferHandler transferHandler = this.diagram.getTransferHandler();
        if (transferHandler == this.defaultTransferHandler) {
            this.diagram.setTransferHandler(null);
        }
        if (this.diagramViewObserver != null) {
            this.diagramLayoutCache.deleteObserver(this.diagramViewObserver);
        }
        if (this.diagram.getDropTarget() != null && this.defaultDropTargetListener != null) {
            this.diagram.getDropTarget().removeDropTargetListener(this.defaultDropTargetListener);
        }
        if (this.componentListener != null) {
            this.diagram.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.diagram.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.mouseListener != null) {
            this.diagram.removeMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.diagram.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if (this.keyListener != null) {
            this.diagram.removeKeyListener(this.keyListener);
        }
        if (this.diagramModel != null && this.diagramModelListener != null) {
            this.diagramModel.removeDiagramModelListener(this.diagramModelListener);
        }
        if (this.diagramSelectionListener != null && this.diagramSelectionModel != null) {
            this.diagramSelectionModel.removeDiagramSelectionListener(this.diagramSelectionListener);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.diagram, null);
        SwingUtilities.replaceUIInputMap(this.diagram, 1, null);
        SwingUtilities.replaceUIInputMap(this.diagram, 0, null);
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.diagram.remove(this.rendererPane);
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.diagram != jComponent) {
            throw new InternalError("DefaultDiagramUI cannot paint " + jComponent.toString() + "; " + this.diagram + " was expected.");
        }
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle2D rectangle2D = DiagramConstants.createRect(graphics.getClipBounds());
            Rectangle2D rectangle2D2 = this.diagram.fromScreen(DiagramConstants.createRect(rectangle2D));
            this.paintBackground(graphics);
            AffineTransform affineTransform = graphics2D.getTransform();
            if (this.diagram.isAntiAliased()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            double d = this.diagram.getScale();
            graphics2D.scale(d, d);
            CellView[] cellViewArray = this.diagramLayoutCache.getRoots();
            for (int i = 0; i < cellViewArray.length; ++i) {
                Rectangle2D rectangle2D3 = cellViewArray[i].getBounds();
                if (rectangle2D3 == null || rectangle2D2 == null || !rectangle2D3.intersects(rectangle2D2)) continue;
                this.paintCell(graphics, cellViewArray[i], rectangle2D3, false);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setTransform(affineTransform);
            this.paintForeground(graphics);
            if (this.handle != null) {
                this.handle.paint(graphics);
            }
            graphics.setColor(this.diagram.getMarqueeColor());
            graphics.setXORMode(this.diagram.getBackground());
            if (this.marquee != null) {
                this.marquee.paint(graphics);
            }
            graphics.setPaintMode();
            if (this.rendererPane != null) {
                this.rendererPane.removeAll();
            }
        }
        catch (Exception exception) {
            LOGGER.error("DefaultDiagramUI.paint:", exception);
        }
    }

    @Override
    public void paintCell(Graphics graphics, CellView cellView, Rectangle2D rectangle2D, boolean bl) {
        if (cellView != null) {
            int n;
            if (rectangle2D != null) {
                boolean bl2 = cellView == this.focus;
                n = this.diagram.isCellSelected(cellView.getCell());
                Component component = cellView.getRendererComponent(this.diagram, n != 0, bl2, bl);
                this.rendererPane.paintComponent(graphics, component, this.diagram, (int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), true);
            }
            if (!cellView.isLeaf()) {
                CellView[] cellViewArray = cellView.getChildViews();
                for (n = 0; n < cellViewArray.length; ++n) {
                    this.paintCell(graphics, cellViewArray[n], cellViewArray[n].getBounds(), bl);
                }
            }
        }
    }

    protected void paintBackground(Graphics graphics) {
        if (this.diagram.isGridVisible()) {
            this.paintGrid(this.diagram.getGridSize(), graphics, graphics.getClipBounds());
        }
    }

    protected void paintGrid(double d, Graphics graphics, Rectangle2D rectangle2D) {
        Rectangle rectangle = graphics.getClipBounds();
        double d2 = rectangle.x;
        double d3 = rectangle.y;
        double d4 = d2 + (double)rectangle.width;
        double d5 = d3 + (double)rectangle.height;
        double d6 = Math.max(2.0, d * this.diagram.getScale());
        int n = (int)(Math.floor(d2 / d6) * d6);
        int n2 = (int)(Math.ceil(d4 / d6) * d6);
        int n3 = (int)(Math.floor(d3 / d6) * d6);
        int n4 = (int)(Math.ceil(d5 / d6) * d6);
        graphics.setColor(this.diagram.getGridColor());
        switch (this.diagram.getGridMode()) {
            case 1: {
                int n5 = d6 > 16.0 ? 2 : (d6 < 8.0 ? 0 : 1);
                for (double d7 = (double)n; d7 <= (double)n2; d7 += d6) {
                    for (double d8 = (double)n3; d8 <= (double)n4; d8 += d6) {
                        int n6 = (int)Math.round(d7);
                        int n7 = (int)Math.round(d8);
                        graphics.drawLine(n6 - n5, n7, n6 + n5, n7);
                        graphics.drawLine(n6, n7 - n5, n6, n7 + n5);
                    }
                }
                break;
            }
            case 2: {
                int n8;
                double d9;
                n2 += (int)Math.ceil(d6);
                n4 += (int)Math.ceil(d6);
                for (d9 = (double)n; d9 <= (double)n2; d9 += d6) {
                    n8 = (int)Math.round(d9);
                    graphics.drawLine(n8, n3, n8, n4);
                }
                for (d9 = (double)n3; d9 <= (double)n4; d9 += d6) {
                    n8 = (int)Math.round(d9);
                    graphics.drawLine(n, n8, n2, n8);
                }
                break;
            }
            default: {
                for (double d10 = (double)n; d10 <= (double)n2; d10 += d6) {
                    for (double d11 = (double)n3; d11 <= (double)n4; d11 += d6) {
                        int n9 = (int)Math.round(d10);
                        int n10 = (int)Math.round(d11);
                        graphics.drawLine(n9, n10, n9, n10);
                    }
                }
            }
        }
    }

    protected void paintForeground(Graphics graphics) {
        if (this.diagram.isPortsVisible()) {
            this.paintPorts(graphics, this.diagramLayoutCache.getPorts());
        }
    }

    @Override
    public void paintPorts(Graphics graphics, CellView[] cellViewArray) {
        if (cellViewArray != null) {
            Rectangle rectangle = graphics.getClipBounds();
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                Rectangle2D rectangle2D = DiagramConstants.createRect(cellViewArray[i].getBounds());
                Point2D point2D = this.diagram.toScreen(DiagramConstants.createPoint(rectangle2D.getCenterX(), rectangle2D.getCenterY()));
                rectangle2D.setFrame(point2D.getX() - rectangle2D.getWidth() / 2.0, point2D.getY() - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
                if (rectangle != null && !rectangle2D.intersects(rectangle)) continue;
                this.paintCell(graphics, cellViewArray[i], rectangle2D, false);
            }
        }
    }

    protected void updateHandle() {
        if (this.diagramLayoutCache != null) {
            Object[] objectArray = this.diagramLayoutCache.order(this.diagram.getSelectionCells());
            this.handle = objectArray != null && objectArray.length > 0 ? this.createHandle(this.createContext(this.diagram, objectArray)) : null;
        }
    }

    protected DiagramContext createContext(AbstractDiagram abstractDiagram, Object[] objectArray) {
        return new DiagramContext(abstractDiagram, objectArray);
    }

    public CellHandle createHandle(DiagramContext diagramContext) {
        try {
            if (diagramContext != null && !diagramContext.isEmpty() && this.diagram.isEnabled()) {
                return new RootHandle(diagramContext);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void updateSize() {
        this.validCachedPreferredSize = false;
        this.diagram.diagramDidChange();
        this.updateHandle();
    }

    protected void updateCachedPreferredSize() {
        Rectangle2D rectangle2D = AbstractCellView.getBounds(this.diagramLayoutCache.getRoots());
        if (rectangle2D == null) {
            rectangle2D = DiagramConstants.createRect();
        }
        Point2D point2D = DiagramConstants.createPoint(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
        Dimension dimension = this.diagram.getMinimumSize();
        Point point = dimension != null ? this.diagram.toScreen(new Point(dimension.width, dimension.height)) : new Point(0, 0);
        Point2D point2D2 = this.diagram.toScreen(point2D);
        this.preferredSize = new Dimension((int)Math.max(((Point2D)point).getX(), point2D2.getX()), (int)Math.max(((Point2D)point).getY(), point2D2.getY()));
        Insets insets = this.diagram.getInsets();
        if (insets != null) {
            this.preferredSize.setSize(this.preferredSize.getWidth() + (double)insets.left + (double)insets.right, this.preferredSize.getHeight() + (double)insets.top + (double)insets.bottom);
        }
        this.validCachedPreferredSize = true;
    }

    public void setPreferredMinSize(Dimension dimension) {
        this.preferredMinSize = dimension;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return null;
        }
        return new Dimension(this.preferredMinSize);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredMinSize();
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.diagram != null) {
            if (dimension != null) {
                return new Dimension(Math.max(dimension.width, this.preferredSize.width), Math.max(dimension.height, this.preferredSize.height));
            }
            return new Dimension(this.preferredSize.width, this.preferredSize.height);
        }
        if (dimension != null) {
            return dimension;
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.diagram != null) {
            return this.getPreferredSize(this.diagram);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    protected void completeEditing() {
        if (this.diagram.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component component = this.editingComponent;
            Object object = this.editingCell;
            DiagramCellEditor diagramCellEditor = this.cellEditor;
            Object object2 = diagramCellEditor.getCellEditorValue();
            boolean bl4 = this.diagram != null && (this.diagram.hasFocus() || this.editingComponent.hasFocus());
            this.editingCell = null;
            this.editingComponent = null;
            if (bl) {
                diagramCellEditor.stopCellEditing();
            } else if (bl2) {
                diagramCellEditor.cancelCellEditing();
            }
            if (this.diagram != null) {
                this.diagram.remove(component);
                if (bl4) {
                    this.diagram.requestFocus();
                }
            }
            if (bl3) {
                Map map = DiagramConstants.createAttributes(object, (Object)"value", object2);
                this.diagramLayoutCache.edit(map, null, null, null);
            }
            this.updateSize();
            if (diagramCellEditor != null && this.cellEditorListener != null) {
                diagramCellEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = null;
        }
    }

    protected boolean startEditing(Object object, MouseEvent mouseEvent) {
        this.completeEditing();
        if (this.diagram.isCellEditable(object)) {
            CellView cellView = this.diagramLayoutCache.getMapping(object, false);
            this.cellEditor = cellView.getEditor();
            this.editingComponent = this.cellEditor.getDiagramCellEditorComponent(this.diagram, object, this.diagram.isCellSelected(object));
            if (this.cellEditor.isCellEditable(mouseEvent)) {
                Rectangle2D rectangle2D = this.diagram.getCellBounds(object);
                this.editingCell = object;
                Dimension dimension = this.editingComponent.getPreferredSize();
                this.diagram.add(this.editingComponent);
                Point2D point2D = this.diagram.toScreen(DiagramConstants.createPoint(rectangle2D.getX(), rectangle2D.getY()));
                if (this.diagramLayoutCache.getMapping(object, false) instanceof EdgeView) {
                    // empty if block
                }
                this.editingComponent.setBounds((int)point2D.getX(), (int)point2D.getY(), (int)((Dimension2D)dimension).getWidth(), (int)((Dimension2D)dimension).getHeight());
                this.editingCell = object;
                this.editingComponent.validate();
                if (this.cellEditorListener == null) {
                    this.cellEditorListener = this.createCellEditorListener();
                }
                if (this.cellEditor != null && this.cellEditorListener != null) {
                    this.cellEditor.addCellEditorListener(this.cellEditorListener);
                }
                Rectangle rectangle = this.diagram.getVisibleRect();
                this.diagram.paintImmediately((int)point2D.getX(), (int)point2D.getY(), (int)(((RectangularShape)rectangle).getWidth() + ((RectangularShape)rectangle).getX() - rectangle2D.getX()), (int)((Dimension2D)dimension).getHeight());
                if (this.cellEditor != null && this.cellEditor.shouldSelectCell(mouseEvent)) {
                    this.stopEditingInCompleteEditing = false;
                    try {
                        this.diagram.setSelectionCell(object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.stopEditingInCompleteEditing = true;
                }
                if (mouseEvent instanceof MouseEvent) {
                    Point point = SwingUtilities.convertPoint(this.diagram, new Point(mouseEvent.getX(), mouseEvent.getY()), this.editingComponent);
                    Component component = SwingUtilities.getDeepestComponentAt(this.editingComponent, point.x, point.y);
                    if (component != null) {
                        new MouseInputHandler(this.diagram, component, mouseEvent);
                    }
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    public static void autoscroll(AbstractDiagram abstractDiagram, Point point) {
        try {
            abstractDiagram.scrollPointToVisible(point);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void insertCells(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, boolean bl, int n, int n2) {
        if (bl) {
            Map map2 = this.diagram.cloneCells(objectArray);
            map = DiagramConstants.replaceKeys(map2, map);
            DiagramConstants.translate(map.values(), (double)n, (double)n2, this.diagram);
            connectionSet = connectionSet.clone(map2);
            parentMap = parentMap.clone(map2);
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = map2.get(objectArray[i]);
            }
        }
        this.diagramLayoutCache.insert(objectArray, map, connectionSet, parentMap, null);
    }

    public boolean isSnapSelectedView() {
        return this.snapSelectedView;
    }

    public void setSnapSelectedView(boolean bl) {
        this.snapSelectedView = bl;
    }

    public class DiagramTransferHandler
    extends TransferHandler {
        protected Object out;
        protected Object in;
        protected int inCount = 0;

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (dataFlavorArray[i] != DiagramTransferable.dataFlavor) continue;
                return true;
            }
            return false;
        }

        public Transferable createTransferable() {
            return this.createTransferable(DefaultDiagramUI.this.diagram);
        }

        @Override
        protected final Transferable createTransferable(JComponent jComponent) {
            AbstractDiagram abstractDiagram;
            Object[] objectArray;
            if (jComponent instanceof AbstractDiagram && (objectArray = DefaultDiagramUI.this.diagramLayoutCache.order((abstractDiagram = (AbstractDiagram)jComponent).getSelectionCells())) != null && objectArray.length > 0) {
                Object[] objectArray2 = DefaultDiagramUI.this.diagramLayoutCache.order(abstractDiagram.getDescendantList(objectArray));
                ParentMap parentMap = ParentMap.create(DefaultDiagramUI.this.diagramModel, objectArray2, false, true);
                ConnectionSet connectionSet = ConnectionSet.create(DefaultDiagramUI.this.diagramModel, objectArray2, false);
                Map map = DiagramConstants.createAttributes(objectArray2, DefaultDiagramUI.this.diagramLayoutCache);
                Rectangle2D rectangle2D = abstractDiagram.getCellBounds(objectArray);
                this.out = objectArray2;
                return this.create(abstractDiagram, objectArray2, map, rectangle2D, connectionSet, parentMap);
            }
            return null;
        }

        protected DiagramTransferable create(AbstractDiagram abstractDiagram, Object[] objectArray, Map map, Rectangle2D rectangle2D, ConnectionSet connectionSet, ParentMap parentMap) {
            return new DiagramTransferable(objectArray, map, rectangle2D, connectionSet, parentMap);
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (jComponent instanceof AbstractDiagram && transferable instanceof DiagramTransferable && n == 2) {
                AbstractDiagram abstractDiagram = (AbstractDiagram)jComponent;
                Object[] objectArray = ((DiagramTransferable)transferable).getCells();
                abstractDiagram.getDiagramLayoutCache().remove(objectArray);
            }
            DefaultDiagramUI.this.updateHandle();
            DefaultDiagramUI.this.setInsertionLocation(null);
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                if (jComponent instanceof AbstractDiagram) {
                    AbstractDiagram abstractDiagram = (AbstractDiagram)jComponent;
                    if (transferable.isDataFlavorSupported(DiagramTransferable.dataFlavor)) {
                        int n;
                        Point point = DefaultDiagramUI.this.getInsertionLocation();
                        Object object = transferable.getTransferData(DiagramTransferable.dataFlavor);
                        DiagramTransferable diagramTransferable = (DiagramTransferable)object;
                        Object[] objectArray = diagramTransferable.getCells();
                        boolean bl = true;
                        for (n = 0; n < objectArray.length && bl; ++n) {
                            bl = bl && abstractDiagram.getModel().contains(objectArray[n]);
                        }
                        this.inCount = this.in == objectArray ? ++this.inCount : (bl ? 1 : 0);
                        this.in = objectArray;
                        if (point != null && this.in == this.out && DefaultDiagramUI.this.handle != null) {
                            n = DefaultDiagramUI.this.dropAction == 1 ? 2 : 0;
                            DefaultDiagramUI.this.handle.mouseReleased(new MouseEvent(jComponent, 0, 0L, n, point.x, point.y, 1, false));
                            return false;
                        }
                        Rectangle2D rectangle2D = diagramTransferable.getBounds();
                        Map map = diagramTransferable.getAttributeMap();
                        ConnectionSet connectionSet = diagramTransferable.getConnectionSet();
                        ParentMap parentMap = diagramTransferable.getParentMap();
                        if (!bl || point == null || DefaultDiagramUI.this.dropAction == 1) {
                            Object[] objectArray2;
                            Map map2 = abstractDiagram.cloneCells(objectArray);
                            map = DiagramConstants.replaceKeys(map2, map);
                            connectionSet = connectionSet.clone(map2);
                            parentMap = parentMap.clone(map2);
                            double d = 0.0;
                            double d2 = 0.0;
                            if (point != null) {
                                objectArray2 = abstractDiagram.fromScreen(abstractDiagram.snap((Point2D)point.clone()));
                                d = objectArray2.getX() - rectangle2D.getX();
                                d2 = objectArray2.getY() - rectangle2D.getY();
                            } else {
                                d = (double)this.inCount * abstractDiagram.getGridSize();
                                d2 = (double)this.inCount * abstractDiagram.getGridSize();
                            }
                            DiagramConstants.translate(map.values(), d, d2, abstractDiagram);
                            objectArray2 = new Object[objectArray.length];
                            for (int i = 0; i < objectArray.length; ++i) {
                                objectArray2[i] = map2.get(objectArray[i]);
                            }
                            abstractDiagram.getDiagramLayoutCache().insert(objectArray2, map, connectionSet, parentMap, null);
                            return DefaultDiagramUI.this.dropAction == 2 && !bl;
                        }
                        if (point != null) {
                            Point2D point2D = abstractDiagram.fromScreen(abstractDiagram.snap(new Point(point)));
                            double d = point2D.getX() - rectangle2D.getX();
                            double d3 = point2D.getY() - rectangle2D.getY();
                            DiagramConstants.translate(map.values(), d, d3, abstractDiagram);
                            abstractDiagram.getDiagramLayoutCache().edit(map, null, null, null);
                        }
                        abstractDiagram.setSelectionCells(objectArray);
                        return false;
                    }
                    return this.importDataImpl(jComponent, transferable);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        protected boolean importDataImpl(JComponent jComponent, Transferable transferable) {
            return false;
        }
    }

    public class DiagramDropTargetListener
    extends DefaultDiagramDropTargetListener
    implements Serializable {
        @Override
        protected void saveComponentState(JComponent jComponent) {
        }

        @Override
        protected void restoreComponentState(JComponent jComponent) {
            if (DefaultDiagramUI.this.handle != null) {
                DefaultDiagramUI.this.handle.mouseDragged(null);
            }
        }

        @Override
        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            DefaultDiagramUI.this.setInsertionLocation(point);
            if (DefaultDiagramUI.this.handle != null) {
                int n = DefaultDiagramUI.this.dropAction == 1 ? 2 : 0;
                DefaultDiagramUI.this.handle.mouseDragged(new MouseEvent(jComponent, 0, 0L, n, point.x, point.y, 1, false));
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DefaultDiagramUI.this.dropAction = dropTargetDragEvent.getDropAction();
            super.dragEnter(dropTargetDragEvent);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            DefaultDiagramUI.this.dropAction = dropTargetDragEvent.getDropAction();
            super.dropActionChanged(dropTargetDragEvent);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(Component component, Component component2, MouseEvent mouseEvent) {
            this.source = component;
            this.destination = component2;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            component2.dispatchEvent(SwingUtilities.convertMouseEvent(component, mouseEvent, component2));
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
            this.removeFromSource();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.destination = null;
            this.source = null;
        }
    }

    private class DiagramSelectAllAction
    extends AbstractAction {
        private boolean selectAll;

        public DiagramSelectAllAction(String string, boolean bl) {
            this.selectAll = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DefaultDiagramUI.this.diagram != null) {
                if (this.selectAll) {
                    Object[] objectArray = new Object[DefaultDiagramUI.this.diagramModel.getRootCount()];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = DefaultDiagramUI.this.diagramModel.getRootAt(i);
                    }
                    DefaultDiagramUI.this.diagram.addSelectionCells(objectArray);
                } else {
                    DefaultDiagramUI.this.diagram.clearSelection();
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return DefaultDiagramUI.this.diagram != null && DefaultDiagramUI.this.diagram.isEnabled();
        }
    }

    private class DiagramEditAction
    extends AbstractAction {
        public DiagramEditAction(String string) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled() && DefaultDiagramUI.this.getFocusedCell() instanceof DiagramCell) {
                DefaultDiagramUI.this.diagram.startEditingAtCell(DefaultDiagramUI.this.getFocusedCell());
            }
        }

        @Override
        public boolean isEnabled() {
            return DefaultDiagramUI.this.diagram != null && DefaultDiagramUI.this.diagram.isEnabled();
        }
    }

    private class DiagramCancelEditingAction
    extends AbstractAction {
        public DiagramCancelEditingAction(String string) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DefaultDiagramUI.this.diagram != null) {
                DefaultDiagramUI.this.cancelEditing(DefaultDiagramUI.this.diagram);
            }
        }

        @Override
        public boolean isEnabled() {
            return DefaultDiagramUI.this.diagram != null && DefaultDiagramUI.this.diagram.isEnabled();
        }
    }

    public class DiagramIncrementAction
    extends AbstractAction {
        protected int direction;

        private DiagramIncrementAction(int n, String string) {
            this.direction = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DefaultDiagramUI.this.diagram != null) {
                int n = 70;
                Rectangle rectangle = DefaultDiagramUI.this.diagram.getVisibleRect();
                if (this.direction == 1) {
                    rectangle.translate(0, -n);
                } else if (this.direction == 2) {
                    rectangle.translate(n, 0);
                } else if (this.direction == 3) {
                    rectangle.translate(0, n);
                } else if (this.direction == 4) {
                    rectangle.translate(-n, 0);
                }
                DefaultDiagramUI.this.diagram.scrollRectToVisible(rectangle);
            }
        }

        @Override
        public boolean isEnabled() {
            return DefaultDiagramUI.this.diagram != null && DefaultDiagramUI.this.diagram.isEnabled();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener,
    Serializable {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == DefaultDiagramUI.this.diagram) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("minimumSize")) {
                    DefaultDiagramUI.this.updateCachedPreferredSize();
                } else if (string.equals("model")) {
                    DefaultDiagramUI.this.setModel((DiagramModel)propertyChangeEvent.getNewValue());
                } else if (string.equals("view")) {
                    DefaultDiagramUI.this.setDiagramLayoutCache((DiagramLayoutCache)propertyChangeEvent.getNewValue());
                    DefaultDiagramUI.this.diagram.repaint();
                } else if (string.equals("marquee")) {
                    DefaultDiagramUI.this.setMarquee((BasicMarqueeHandler)propertyChangeEvent.getNewValue());
                } else if (string.equals("editable")) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    if (!bl && DefaultDiagramUI.this.isEditing(DefaultDiagramUI.this.diagram)) {
                        DefaultDiagramUI.this.cancelEditing(DefaultDiagramUI.this.diagram);
                    }
                } else if (string.equals("selectionModel")) {
                    DefaultDiagramUI.this.setSelectionModel(DefaultDiagramUI.this.diagram.getSelectionModel());
                } else if (string.equals("gridVisible") || string.equals("gridSize") || string.equals("portsVisible") || string.equals("antiAliased")) {
                    DefaultDiagramUI.this.diagram.repaint();
                } else if (string.equals("scale")) {
                    DefaultDiagramUI.this.updateSize();
                } else if (string.equals("font")) {
                    DefaultDiagramUI.this.completeEditing();
                    DefaultDiagramUI.this.updateSize();
                } else if (string.equals("componentOrientation") && DefaultDiagramUI.this.diagram != null) {
                    DefaultDiagramUI.this.diagram.diagramDidChange();
                }
            }
        }
    }

    public class RootHandle
    implements CellHandle,
    Serializable {
        protected transient double _mouseToViewDelta_x = 0.0;
        protected transient double _mouseToViewDelta_y = 0.0;
        protected transient Image offscreen;
        protected transient Graphics offgraphics;
        protected transient boolean firstDrag = true;
        protected transient CellView[] views;
        protected transient CellView[] contextViews;
        protected transient CellView[] portViews;
        protected transient Rectangle2D cachedBounds;
        protected transient Point2D initialLocation;
        protected transient CellHandle[] handles;
        protected transient Point2D start = null;
        protected transient Point2D last;
        protected transient Point2D snapStart;
        protected transient Point2D snapLast;
        protected boolean isMoving = false;
        protected boolean isDragging = false;
        protected transient CellHandle activeHandle = null;
        protected transient DiagramContext context;
        protected boolean isContextVisible = true;
        protected boolean blockPaint = false;
        protected transient ConnectionSet disconnect = null;

        public RootHandle(DiagramContext diagramContext) {
            this.context = diagramContext;
            if (!diagramContext.isEmpty()) {
                Object[] objectArray;
                this.views = diagramContext.createTemporaryCellViews();
                Rectangle2D rectangle2D = DefaultDiagramUI.this.diagram.toScreen(DefaultDiagramUI.this.diagram.getCellBounds(diagramContext.getCells()));
                if (diagramContext.getDescendantCount() < MAXCELLS && !((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView().showLabels() && !((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView().isShowLabelsChanging()) {
                    this.contextViews = diagramContext.createTemporaryContextViews();
                    this.initialLocation = DefaultDiagramUI.this.diagram.toScreen(this.getInitialLocation(diagramContext.getCells()));
                } else {
                    this.cachedBounds = rectangle2D;
                }
                if (this.initialLocation == null) {
                    this.initialLocation = DiagramConstants.createPoint(rectangle2D.getX(), rectangle2D.getY());
                }
                if ((objectArray = diagramContext.getCells()).length < MAXHANDLES) {
                    this.handles = new CellHandle[this.views.length];
                    for (int i = 0; i < this.views.length; ++i) {
                        this.handles[i] = this.views[i].getHandle(diagramContext);
                    }
                    this.portViews = diagramContext.createTemporaryPortViews();
                }
            }
        }

        protected Point2D getInitialLocation(Object[] objectArray) {
            if (objectArray != null && objectArray.length > 0) {
                Rectangle2D rectangle2D = DiagramConstants.createRect(DefaultDiagramUI.this.diagram.getCellBounds(objectArray[0]));
                for (int i = 1; i < objectArray.length; ++i) {
                    Object object;
                    if (DefaultDiagramUI.this.diagramModel.isEdge(objectArray[i])) {
                        Point2D point2D;
                        object = DefaultDiagramUI.this.diagramLayoutCache.getMapping(objectArray[i], false);
                        if (!(object instanceof EdgeView)) continue;
                        EdgeView edgeView = (EdgeView)object;
                        if (edgeView.getSource() == null) {
                            point2D = edgeView.getPoint(0);
                            Rectangle2D.union(rectangle2D, DiagramConstants.createRect(point2D), rectangle2D);
                        }
                        if (edgeView.getTarget() != null) continue;
                        point2D = edgeView.getPoint(edgeView.getPointCount() - 1);
                        Rectangle2D.union(rectangle2D, DiagramConstants.createRect(point2D), rectangle2D);
                        continue;
                    }
                    object = DefaultDiagramUI.this.diagram.getCellBounds(objectArray[i]);
                    Rectangle2D.union(rectangle2D, (Rectangle2D)object, rectangle2D);
                }
                if (rectangle2D != null) {
                    return DiagramConstants.createPoint(rectangle2D.getX(), rectangle2D.getY());
                }
            }
            return null;
        }

        public DiagramContext getContext() {
            return this.context;
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.handles != null && this.handles.length < MAXHANDLES) {
                for (int i = 0; i < this.handles.length; ++i) {
                    if (this.handles[i] == null) continue;
                    this.handles[i].paint(graphics);
                }
            }
            this.blockPaint = true;
        }

        @Override
        public void overlay(Graphics graphics) {
            if (this.isDragging && !DNDPREVIEW) {
                return;
            }
            if (this.cachedBounds != null) {
                graphics.setColor(Color.black);
                graphics.drawRect((int)this.cachedBounds.getX(), (int)this.cachedBounds.getY(), (int)this.cachedBounds.getWidth() - 2, (int)this.cachedBounds.getHeight() - 2);
            } else {
                int n;
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.scale(DefaultDiagramUI.this.diagram.getScale(), DefaultDiagramUI.this.diagram.getScale());
                if (this.views != null) {
                    for (n = 0; n < this.views.length; ++n) {
                        DefaultDiagramUI.this.paintCell(graphics, this.views[n], this.views[n].getBounds(), true);
                    }
                }
                if (this.contextViews != null && this.isContextVisible) {
                    for (n = 0; n < this.contextViews.length; ++n) {
                        DefaultDiagramUI.this.paintCell(graphics, this.contextViews[n], this.contextViews[n].getBounds(), true);
                    }
                }
                graphics2D.setTransform(affineTransform);
                if (this.portViews != null && DefaultDiagramUI.this.diagram.isPortsVisible()) {
                    DefaultDiagramUI.this.paintPorts(graphics, this.portViews);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && this.handles != null) {
                for (int i = this.handles.length - 1; i >= 0 && !mouseEvent.isConsumed(); --i) {
                    if (this.handles[i] == null) continue;
                    this.handles[i].mouseMoved(mouseEvent);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && DefaultDiagramUI.this.diagram.isMoveable()) {
                Point point;
                Point2D point2D;
                CellView cellView;
                if (this.handles != null) {
                    for (int i = this.handles.length - 1; i >= 0; --i) {
                        if (this.handles[i] == null) continue;
                        this.handles[i].mousePressed(mouseEvent);
                        if (!mouseEvent.isConsumed()) continue;
                        this.activeHandle = this.handles[i];
                        return;
                    }
                }
                if (this.views != null && (cellView = this.findViewForPoint(point2D = DefaultDiagramUI.this.diagram.fromScreen(DiagramConstants.createPoint(point = mouseEvent.getPoint())))) != null) {
                    if (cellView instanceof EntityView) {
                        ((EntityView)cellView).saveChildPositions();
                    }
                    if (DefaultDiagramUI.this.snapSelectedView) {
                        Rectangle2D rectangle2D = cellView.getBounds();
                        this.start = DefaultDiagramUI.this.diagram.toScreen(DiagramConstants.createPoint(rectangle2D.getX(), rectangle2D.getY()));
                        this.snapStart = DefaultDiagramUI.this.diagram.snap(DiagramConstants.createPoint(this.start));
                        this._mouseToViewDelta_x = ((Point2D)point).getX() - this.start.getX();
                        this._mouseToViewDelta_y = ((Point2D)point).getY() - this.start.getY();
                    } else {
                        this.snapStart = DefaultDiagramUI.this.diagram.snap(DiagramConstants.createPoint(point));
                        this._mouseToViewDelta_x = this.snapStart.getX() - ((Point2D)point).getX();
                        this._mouseToViewDelta_y = this.snapStart.getY() - ((Point2D)point).getY();
                        this.start = DiagramConstants.createPoint(this.snapStart);
                    }
                    this.last = DiagramConstants.createPoint(this.start);
                    this.snapLast = DiagramConstants.createPoint(this.snapStart);
                    this.isContextVisible = this.contextViews != null && this.contextViews.length < MAXCELLS && (!mouseEvent.isControlDown() || !DefaultDiagramUI.this.diagram.isCloneable());
                    mouseEvent.consume();
                }
            }
        }

        protected CellView findViewForPoint(Point2D point2D) {
            double d = DefaultDiagramUI.this.diagram.getTolerance();
            Rectangle2D rectangle2D = DiagramConstants.createRect(point2D.getX() - d, point2D.getY() - d, 2.0 * d, 2.0 * d);
            for (int i = 0; i < this.views.length; ++i) {
                if (!this.views[i].intersects(DefaultDiagramUI.this.diagram.getGraphics(), rectangle2D)) continue;
                return this.views[i];
            }
            return null;
        }

        protected void startDragging(MouseEvent mouseEvent) {
            this.isDragging = true;
            if (DefaultDiagramUI.this.diagram.isDragEnabled()) {
                int n = mouseEvent.isControlDown() && DefaultDiagramUI.this.diagram.isCloneable() ? 1 : 2;
                TransferHandler transferHandler = DefaultDiagramUI.this.diagram.getTransferHandler();
                DefaultDiagramUI.this.setInsertionLocation(mouseEvent.getPoint());
                try {
                    transferHandler.exportAsDrag(DefaultDiagramUI.this.diagram, mouseEvent, n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void initOffscreen() {
            try {
                Rectangle rectangle = DefaultDiagramUI.this.diagram.getBounds();
                this.offscreen = new BufferedImage(rectangle.width, rectangle.height, 1);
                this.offgraphics = this.offscreen.getGraphics();
                this.offgraphics.setClip(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
                this.offgraphics.setColor(DefaultDiagramUI.this.diagram.getBackground());
                this.offgraphics.fillRect(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
                DefaultDiagramUI.this.diagram.getUI().paint(this.offgraphics, DefaultDiagramUI.this.diagram);
            }
            catch (Error error) {
                this.offscreen = null;
                this.offgraphics = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (DefaultDiagramUI.this.diagram.isMoveable()) {
                boolean bl = DefaultDiagramUI.this.isConstrainedMoveEvent(mouseEvent);
                Rectangle2D rectangle2D = null;
                if (this.firstDrag && DefaultDiagramUI.this.diagram.isDoubleBuffered() && this.cachedBounds == null) {
                    this.firstDrag = false;
                }
                if (mouseEvent != null && !mouseEvent.isConsumed()) {
                    if (this.activeHandle != null) {
                        this.activeHandle.mouseDragged(mouseEvent);
                    } else if (this.start != null) {
                        Point2D point2D;
                        Graphics graphics = this.offgraphics != null ? this.offgraphics : DefaultDiagramUI.this.diagram.getGraphics();
                        Point point = mouseEvent.getPoint();
                        Point2D point2D2 = DiagramConstants.createPoint(point.getX() - this._mouseToViewDelta_x, point.getY() - this._mouseToViewDelta_y);
                        Point2D point2D3 = point2D = DefaultDiagramUI.this.diagram.snap(point2D2);
                        int n = DefaultDiagramUI.this.diagram.getMinimumMove();
                        double d = point2D3.getX() - this.start.getX();
                        double d2 = point2D3.getY() - this.start.getY();
                        if (this.isMoving || Math.abs(d) > (double)n || Math.abs(d2) > (double)n) {
                            boolean bl2 = false;
                            this.isMoving = true;
                            if (this.disconnect == null && DefaultDiagramUI.this.diagram.isDisconnectOnMove()) {
                                this.disconnect = this.context.disconnect(DefaultDiagramUI.this.diagramLayoutCache.getAllDescendants(this.views));
                            }
                            double d3 = point2D3.getX() - this.start.getX();
                            double d4 = point2D3.getY() - this.start.getY();
                            d = point2D3.getX() - this.last.getX();
                            d2 = point2D3.getY() - this.last.getY();
                            if (bl && this.cachedBounds == null) {
                                if (Math.abs(d3) < Math.abs(d4)) {
                                    d = 0.0;
                                    d2 = d4;
                                } else {
                                    d = d3;
                                    d2 = 0.0;
                                }
                            } else if (DefaultDiagramUI.this.diagram.isMoveBelowZero() || this.last == null || this.initialLocation == null || this.start != null) {
                                // empty if block
                            }
                            double d5 = DefaultDiagramUI.this.diagram.getScale();
                            d = (int)(d / d5);
                            d2 = (int)(d2 / d5);
                            graphics.setColor(DefaultDiagramUI.this.diagram.getForeground());
                            graphics.setXORMode(DefaultDiagramUI.this.diagram.getBackground());
                            if (DefaultDiagramUI.this.diagram.isDragEnabled() && !this.isDragging) {
                                this.startDragging(mouseEvent);
                            }
                            if (d != 0.0 || d2 != 0.0) {
                                Object object;
                                if (!(this.snapLast.equals(this.snapStart) || this.offscreen == null && this.blockPaint)) {
                                    this.overlay(graphics);
                                    bl2 = true;
                                }
                                this.isContextVisible = (!mouseEvent.isControlDown() || !DefaultDiagramUI.this.diagram.isCloneable()) && this.contextViews != null && this.contextViews.length < MAXCELLS && DefaultDiagramUI.this.diagramLayoutCache.getRoots().length < 150 && !((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView().showLabels() && !((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView().isShowLabelsChanging();
                                this.blockPaint = false;
                                if (this.offscreen != null) {
                                    rectangle2D = DefaultDiagramUI.this.diagram.toScreen(AbstractCellView.getBounds(this.views));
                                    object = DefaultDiagramUI.this.diagram.toScreen(AbstractCellView.getBounds(this.contextViews));
                                    if (object != null) {
                                        rectangle2D.add((Rectangle2D)object);
                                    }
                                }
                                if (bl && this.cachedBounds == null) {
                                    object = DefaultDiagramUI.this.diagramLayoutCache.getAllDescendants(this.views);
                                    for (int i = 0; i < ((CellView[])object).length; ++i) {
                                        CellView cellView = DefaultDiagramUI.this.diagramLayoutCache.getMapping(object[i].getCell(), false);
                                        Map map = cellView.getAllAttributes();
                                        object[i].setAttributes(DiagramConstants.cloneMap(map));
                                        object[i].refresh(false);
                                    }
                                }
                                if (this.cachedBounds != null) {
                                    this.cachedBounds.setFrame(this.cachedBounds.getX() + d * d5, this.cachedBounds.getY() + d2 * d5, this.cachedBounds.getWidth(), this.cachedBounds.getHeight());
                                } else {
                                    DiagramLayoutCache.translateViews(this.views, d, d2, DefaultDiagramUI.this.diagram);
                                    if (this.views != null) {
                                        DefaultDiagramUI.this.diagramLayoutCache.update(this.views);
                                    }
                                    if (this.contextViews != null) {
                                        DefaultDiagramUI.this.diagramLayoutCache.update(this.contextViews);
                                    }
                                }
                                if (!point2D.equals(this.snapStart)) {
                                    this.overlay(graphics);
                                    bl2 = true;
                                }
                                if (bl) {
                                    this.last = DiagramConstants.createPoint(this.start);
                                }
                                this.last.setLocation(this.last.getX() + d * d5, this.last.getY() + d2 * d5);
                                this.snapLast = point2D;
                                if (bl2 && this.offscreen != null) {
                                    rectangle2D.add(DefaultDiagramUI.this.diagram.toScreen(AbstractCellView.getBounds(this.views)));
                                    object = DefaultDiagramUI.this.diagram.toScreen(AbstractCellView.getBounds(this.contextViews));
                                    if (object != null) {
                                        rectangle2D.add((Rectangle2D)object);
                                    }
                                    rectangle2D.setFrame(rectangle2D.getX() - 2.0, rectangle2D.getY() - 2.0, rectangle2D.getWidth() + 4.0, rectangle2D.getHeight() + 4.0);
                                    double d6 = Math.max(0.0, rectangle2D.getX());
                                    double d7 = Math.max(0.0, rectangle2D.getY());
                                    double d8 = d6 + rectangle2D.getWidth();
                                    double d9 = d7 + rectangle2D.getHeight();
                                    if (this.isDragging && !DNDPREVIEW) {
                                        return;
                                    }
                                    DefaultDiagramUI.this.diagram.getGraphics().drawImage(this.offscreen, (int)d6, (int)d7, (int)d8, (int)d9, (int)d6, (int)d7, (int)d8, (int)d9, DefaultDiagramUI.this.diagram);
                                }
                            }
                        }
                    }
                } else if (mouseEvent == null) {
                    DefaultDiagramUI.this.diagram.repaint();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            block23: {
                try {
                    Object object;
                    if (mouseEvent == null || mouseEvent.isConsumed()) break block23;
                    if (this.activeHandle != null) {
                        if (this.activeHandle instanceof CellViewHandle) {
                            DefaultDiagramCell defaultDiagramCell;
                            CellView cellView = ((CellViewHandle)this.activeHandle).getCellView();
                            if (cellView == null || (defaultDiagramCell = (DefaultDiagramCell)cellView.getCell()) == null) break block23;
                            TopView topView = defaultDiagramCell.getTopView();
                            if (topView != null && topView.getModel() != null) {
                                DesignPartView designPartView = topView.getDesignPartView();
                                designPartView.startAutoLayoutEdit(MessageFormat.format(Messages.getString("DefaultDiagramModel.Resize"), topView.getModel().getName()));
                                try {
                                    this.activeHandle.mouseReleased(mouseEvent);
                                    this.activeHandle = null;
                                    this.straightenLines();
                                    break block23;
                                }
                                finally {
                                    designPartView.stopAutoLayoutEdit();
                                }
                            }
                            this.activeHandle.mouseReleased(mouseEvent);
                            this.activeHandle = null;
                            this.straightenLines();
                            break block23;
                        }
                        this.activeHandle.mouseReleased(mouseEvent);
                        this.activeHandle = null;
                        this.straightenLines();
                        break block23;
                    }
                    if (!this.isMoving || mouseEvent.getPoint().equals(this.start)) break block23;
                    if (this.cachedBounds != null) {
                        double d = (double)mouseEvent.getX() - this.start.getX();
                        double d2 = (double)mouseEvent.getY() - this.start.getY();
                        object = DefaultDiagramUI.this.diagram.fromScreen(DiagramConstants.createPoint(d, d2));
                        DiagramLayoutCache.translateViews(this.views, ((Point2D)object).getX(), ((Point2D)object).getY(), DefaultDiagramUI.this.diagram);
                    }
                    Object[] objectArray = DefaultDiagramUI.this.diagramLayoutCache.getAllDescendants(this.views);
                    if (mouseEvent.isControlDown() && DefaultDiagramUI.this.diagram.isCloneable()) {
                        Object[] objectArray2 = DefaultDiagramUI.this.diagramLayoutCache.order(DefaultDiagramUI.this.diagram.getDescendantList(this.context.getCells()));
                        ConnectionSet connectionSet = ConnectionSet.create(DefaultDiagramUI.this.diagramModel, objectArray2, false);
                        ParentMap parentMap = ParentMap.create(DefaultDiagramUI.this.diagramModel, objectArray2, false, true);
                        object = DiagramConstants.createAttributes(objectArray, null);
                        DefaultDiagramUI.this.insertCells(objectArray2, (Map)object, connectionSet, parentMap, true, 0, 0);
                    } else if (DefaultDiagramUI.this.diagram.isMoveable()) {
                        Object object2;
                        Map map = DiagramConstants.createAttributes(objectArray, null);
                        String string = "";
                        DesignPartView designPartView = null;
                        if (this.views.length >= 1) {
                            object = (DefaultDiagramCell)this.views[0].getCell();
                            if (object != null && (object2 = ((DefaultDiagramCell)object).getTopView()) != null && ((TopView)object2).getModel() != null) {
                                designPartView = ((TopView)object2).getDesignPartView();
                                string = ((TopView)object2).getModel().getName();
                            }
                            string = MessageFormat.format(Messages.getString("DefaultDiagramModel.Move"), string);
                            if (this.views.length > 1) {
                                string = Messages.getString("DefaultDiagramModel.MoveOfGroupOfObjects");
                            }
                        }
                        if (designPartView != null) {
                            designPartView.startAutoLayoutEdit(string);
                            try {
                                DefaultDiagramUI.this.diagram.getDiagramLayoutCache().edit(map, this.disconnect, null, null);
                                for (int i = 0; i < objectArray.length; ++i) {
                                    object2 = objectArray[i];
                                    if (!(object2 instanceof EntityView)) continue;
                                    ((EntityView)object2).setChildPositions();
                                }
                                this.straightenLines();
                            }
                            finally {
                                designPartView.stopAutoLayoutEdit();
                            }
                        }
                    }
                    mouseEvent.consume();
                }
                catch (Exception exception) {
                }
                finally {
                    this.initialLocation = null;
                    this.isDragging = false;
                    this.disconnect = null;
                    this.offscreen = null;
                    this.firstDrag = true;
                    this.start = null;
                }
            }
        }

        private void straightenLines() {
            boolean bl = ((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView().isAutoRoute();
            if (this.views.length > 0) {
                DiagramModel diagramModel = DefaultDiagramUI.this.diagram.getModel();
                for (int i = 0; i < this.views.length; ++i) {
                    CellView cellView = this.views[i];
                    for (int j = 0; j < diagramModel.getChildCount(cellView.getCell()); ++j) {
                        Object object = diagramModel.getChild(cellView.getCell(), j);
                        if (!DefaultDiagramUI.this.diagram.getDiagramLayoutCache().isVisible(object) || !(object instanceof DefaultPort)) continue;
                        DefaultPort defaultPort = (DefaultPort)object;
                        for (Object e : defaultPort.getEdges()) {
                            if (!(e instanceof DefaultEdge)) continue;
                            DefaultEdge defaultEdge = (DefaultEdge)e;
                            if (!bl) {
                                if (((EdgeView)defaultEdge.getTopView().getCellView()).getPoints().size() == 2) {
                                    defaultEdge.straightLine(false);
                                    continue;
                                }
                                ((EdgeView)defaultEdge.getTopView().getCellView()).refreshLabels();
                                continue;
                            }
                            ((EdgeView)defaultEdge.getTopView().getCellView()).refreshLabels();
                        }
                    }
                }
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        protected CellView cell;
        protected Object handler;
        protected transient Cursor previousCursor = null;

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.handler = null;
            if (!mouseEvent.isConsumed() && DefaultDiagramUI.this.diagram.isEnabled()) {
                DefaultDiagramUI.this.diagram.requestFocus();
                int n = DefaultDiagramUI.this.diagram.getTolerance();
                Rectangle2D rectangle2D = DefaultDiagramUI.this.diagram.fromScreen(DiagramConstants.createRect(mouseEvent.getX() - n, mouseEvent.getY() - n, 2 * n, 2 * n));
                DefaultDiagramUI.this.focus = DefaultDiagramUI.this.focus != null && DefaultDiagramUI.this.focus.intersects(DefaultDiagramUI.this.diagram.getGraphics(), rectangle2D) ? DefaultDiagramUI.this.focus : null;
                DefaultDiagramCell defaultDiagramCell = (DefaultDiagramCell)DefaultDiagramUI.this.diagram.getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY());
                this.cell = defaultDiagramCell != null ? ((DefaultDiagramCell)DefaultDiagramUI.this.diagram.getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY())).getCellView() : null;
                if (DefaultDiagramUI.this.focus == null) {
                    DefaultDiagramUI.this.focus = this.cell;
                }
                DefaultDiagramUI.this.completeEditing();
                if (!DefaultDiagramUI.this.isForceMarqueeEvent(mouseEvent)) {
                    if (mouseEvent.getClickCount() == DefaultDiagramUI.this.diagram.getEditClickCount() && DefaultDiagramUI.this.focus != null && DefaultDiagramUI.this.focus.isLeaf() && DefaultDiagramUI.this.focus.getParentView() == null) {
                        mouseEvent.consume();
                        this.cell = null;
                    } else if (!DefaultDiagramUI.this.isToggleSelectionEvent(mouseEvent)) {
                        if (DefaultDiagramUI.this.handle != null) {
                            DefaultDiagramUI.this.handle.mousePressed(mouseEvent);
                            this.handler = DefaultDiagramUI.this.handle;
                        }
                        if (!mouseEvent.isConsumed() && this.cell != null && !DefaultDiagramUI.this.diagram.isCellSelected(this.cell)) {
                            DefaultDiagramUI.this.selectCellForEvent(this.cell.getCell(), mouseEvent);
                            DefaultDiagramUI.this.focus = this.cell;
                            if (DefaultDiagramUI.this.handle != null) {
                                DefaultDiagramUI.this.handle.mousePressed(mouseEvent);
                                this.handler = DefaultDiagramUI.this.handle;
                            }
                            mouseEvent.consume();
                        }
                    }
                }
                if (!(mouseEvent.isConsumed() || DefaultDiagramUI.this.isToggleSelectionEvent(mouseEvent) && DefaultDiagramUI.this.focus != null || DefaultDiagramUI.this.marquee == null)) {
                    DefaultDiagramUI.this.marquee.mousePressed(mouseEvent);
                    this.handler = DefaultDiagramUI.this.marquee;
                }
            }
        }

        protected void handleEditTrigger(Object object, MouseEvent mouseEvent) {
            DefaultDiagramUI.this.diagram.scrollCellToVisible(object);
            if (object != null) {
                DefaultDiagramUI.this.startEditing(object, mouseEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            DefaultDiagramUI.autoscroll(DefaultDiagramUI.this.diagram, mouseEvent.getPoint());
            if (this.handler != null && this.handler == DefaultDiagramUI.this.marquee) {
                DefaultDiagramUI.this.marquee.mouseDragged(mouseEvent);
            } else if (this.handler == null && !DefaultDiagramUI.this.isEditing(DefaultDiagramUI.this.diagram) && DefaultDiagramUI.this.focus != null) {
                if (!DefaultDiagramUI.this.diagram.isCellSelected(DefaultDiagramUI.this.focus.getCell())) {
                    DefaultDiagramUI.this.selectCellForEvent(DefaultDiagramUI.this.focus.getCell(), mouseEvent);
                    this.cell = null;
                }
                if (DefaultDiagramUI.this.handle != null) {
                    DefaultDiagramUI.this.handle.mousePressed(mouseEvent);
                }
                this.handler = DefaultDiagramUI.this.handle;
            }
            if (DefaultDiagramUI.this.handle != null && this.handler == DefaultDiagramUI.this.handle) {
                DefaultDiagramUI.this.handle.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.previousCursor == null) {
                this.previousCursor = DefaultDiagramUI.this.diagram.getCursor();
            }
            if (DefaultDiagramUI.this.diagram != null && DefaultDiagramUI.this.diagram.isEnabled()) {
                if (DefaultDiagramUI.this.marquee != null) {
                    DefaultDiagramUI.this.marquee.mouseMoved(mouseEvent);
                }
                if (DefaultDiagramUI.this.handle != null) {
                    DefaultDiagramUI.this.handle.mouseMoved(mouseEvent);
                }
                if (!mouseEvent.isConsumed() && this.previousCursor != null) {
                    DefaultDiagramUI.this.diagram.setCursor(this.previousCursor);
                    this.previousCursor = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                if (mouseEvent != null && !mouseEvent.isConsumed()) {
                    Object object;
                    boolean bl = false;
                    if (this.cell != null && SwingUtilities.isRightMouseButton(mouseEvent)) {
                        object = this.cell.getCell();
                        DefaultDiagramUI.this.selectCellForEvent(object, mouseEvent);
                    }
                    if (this.handler == DefaultDiagramUI.this.marquee && DefaultDiagramUI.this.marquee != null) {
                        DefaultDiagramUI.this.marquee.mouseReleased(mouseEvent);
                    } else if (this.handler == DefaultDiagramUI.this.handle && DefaultDiagramUI.this.handle != null) {
                        DefaultDiagramUI.this.handle.mouseReleased(mouseEvent);
                    }
                    if (this.isDescendant(this.cell, DefaultDiagramUI.this.focus) && mouseEvent.getModifiers() != 0) {
                        this.cell = DefaultDiagramUI.this.focus;
                    }
                    if (!mouseEvent.isConsumed() && this.cell != null) {
                        object = this.cell.getCell();
                        bl = DefaultDiagramUI.this.diagram.isCellSelected(object);
                        DefaultDiagramUI.this.selectCellForEvent(object, mouseEvent);
                        DefaultDiagramUI.this.focus = this.cell;
                        this.postProcessSelection(mouseEvent, object, bl);
                        if (DefaultDiagramUI.this.diagram instanceof Diagram) {
                            ((Diagram)DefaultDiagramUI.this.diagram).getAppView().getCurrentDPV().fireSelectionChanged();
                        }
                    }
                }
            }
            finally {
                this.handler = null;
                this.cell = null;
            }
            DefaultDiagramUI.autoscroll(DefaultDiagramUI.this.diagram, mouseEvent.getPoint());
        }

        protected void postProcessSelection(MouseEvent mouseEvent, Object object, boolean bl) {
            if (bl && DefaultDiagramUI.this.diagram.isCellSelected(object)) {
                Object object2 = object;
                Object object3 = null;
                while ((object3 = DefaultDiagramUI.this.diagramModel.getParent(object2)) != null && DefaultDiagramUI.this.diagramLayoutCache.isVisible(object3)) {
                    object2 = object3;
                }
                DefaultDiagramUI.this.selectCellForEvent(object2, mouseEvent);
                DefaultDiagramUI.this.focus = DefaultDiagramUI.this.diagramLayoutCache.getMapping(object2, false);
            }
        }

        protected boolean isDescendant(CellView cellView, CellView cellView2) {
            Object object;
            if (cellView == null || cellView2 == null) {
                return false;
            }
            Object object2 = cellView.getCell();
            Object object3 = object = cellView2.getCell();
            do {
                if (object3 != object2) continue;
                return true;
            } while ((object3 = DefaultDiagramUI.this.diagramModel.getParent(object3)) != null);
            return false;
        }
    }

    public class KeyHandler
    extends KeyAdapter
    implements Serializable {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (DefaultDiagramUI.this.diagram != null && DefaultDiagramUI.this.diagram.hasFocus() && DefaultDiagramUI.this.diagram.isEnabled()) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                if (DefaultDiagramUI.this.diagram.getConditionForKeyStroke(keyStroke) == 0) {
                    ActionListener actionListener = DefaultDiagramUI.this.diagram.getActionForKeyStroke(keyStroke);
                    this.repeatKeyAction = actionListener instanceof Action ? (Action)actionListener : null;
                } else {
                    this.repeatKeyAction = null;
                    if (keyStroke.getKeyCode() == 27) {
                        if (DefaultDiagramUI.this.marquee != null) {
                            DefaultDiagramUI.this.marquee.mouseReleased(null);
                        }
                        if (DefaultDiagramUI.this.mouseListener != null) {
                            DefaultDiagramUI.this.mouseListener.mouseReleased(null);
                        }
                        DefaultDiagramUI.this.updateHandle();
                        DefaultDiagramUI.this.diagram.repaint();
                    }
                }
                if (this.isKeyDown && this.repeatKeyAction != null) {
                    this.repeatKeyAction.actionPerformed(new ActionEvent(DefaultDiagramUI.this.diagram, 1001, ""));
                    keyEvent.consume();
                } else {
                    this.isKeyDown = true;
                }
                if (Extension.isExtension && keyEvent.getKeyCode() == 127) {
                    ((Diagram)DefaultDiagramUI.this.diagram).getAppView().getCurrentDPV().getWorkSpace().deleteAllSelected();
                    keyEvent.consume();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.isKeyDown = false;
        }
    }

    public class CellEditorHandler
    implements CellEditorListener,
    Serializable {
        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            DefaultDiagramUI.this.completeEditing(false, false, true);
        }

        @Override
        public void editingCanceled(ChangeEvent changeEvent) {
            DefaultDiagramUI.this.completeEditing(false, false, false);
        }
    }

    public class DiagramSelectionHandler
    implements DiagramSelectionListener,
    Serializable {
        @Override
        public void valueChanged(DiagramSelectionEvent diagramSelectionEvent) {
            DefaultDiagramUI.this.updateHandle();
            Object[] objectArray = diagramSelectionEvent.getCells();
            if (objectArray != null && objectArray.length <= MAXCLIPCELLS) {
                Rectangle2D rectangle2D = DefaultDiagramUI.this.diagram.toScreen(DefaultDiagramUI.this.diagram.getCellBounds(objectArray));
                if (rectangle2D != null) {
                    int n = DefaultDiagramUI.this.diagram.getHandleSize();
                    DefaultDiagramUI.this.updateHandle();
                    DefaultDiagramUI.this.diagram.repaint((int)rectangle2D.getX() - n, (int)rectangle2D.getY() - n, (int)rectangle2D.getWidth() + 2 * n, (int)rectangle2D.getHeight() + 2 * n);
                }
            } else {
                DefaultDiagramUI.this.diagram.repaint();
            }
        }
    }

    public class DiagramViewObserver
    implements Observer,
    Serializable {
        @Override
        public void update(Observable observable, Object object) {
            DefaultDiagramUI.this.updateSize();
        }
    }

    public class DiagramModelHandler
    implements DiagramModelListener,
    Serializable {
        @Override
        public void diagramChanged(DiagramModelEvent diagramModelEvent) {
            if (DefaultDiagramUI.this.diagramLayoutCache != null) {
                DefaultDiagramUI.this.diagramLayoutCache.diagramChanged(diagramModelEvent.getChange());
            }
            Object[] objectArray = diagramModelEvent.getChange().getInserted();
            Object[] objectArray2 = diagramModelEvent.getChange().getRemoved();
            if (objectArray != null && objectArray.length > 0) {
                DefaultDiagramUI.this.focus = DefaultDiagramUI.this.diagramLayoutCache.getMapping(objectArray[0], false);
            }
            if (objectArray2 != null && objectArray2.length > 0) {
                for (int i = 0; i < objectArray2.length && DefaultDiagramUI.this.focus != null; ++i) {
                    if (objectArray2[i] != DefaultDiagramUI.this.focus.getCell()) continue;
                    DefaultDiagramUI.this.focus = null;
                }
                DefaultDiagramUI.this.diagram.getSelectionModel().removeSelectionCells(objectArray2);
            }
            DefaultDiagramUI.this.updateSize();
            if (objectArray != null && objectArray.length > 0 && DefaultDiagramUI.this.diagram.isSelectNewCells()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (DefaultDiagramUI.this.diagramModel.getParent(objectArray[i]) != null || !DefaultDiagramUI.this.diagramLayoutCache.isVisible(objectArray[i])) continue;
                    arrayList.add(objectArray[i]);
                }
                DefaultDiagramUI.this.diagram.setSelectionCells(arrayList.toArray());
                DefaultDiagramUI.this.diagram.requestFocus();
            }
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            if (this.timer == null) {
                JScrollPane jScrollPane = this.getScrollPane();
                if (jScrollPane == null) {
                    DefaultDiagramUI.this.updateSize();
                } else {
                    this.scrollBar = jScrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = jScrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            DefaultDiagramUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container container;
            for (container = DefaultDiagramUI.this.diagram.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
            }
            if (container instanceof JScrollPane) {
                return (JScrollPane)container;
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                DefaultDiagramUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }
}

