/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.ui.def;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import javax.swing.plaf.UIResource;

public class DefaultDiagramTransferable
implements Transferable,
UIResource,
Serializable {
    private static DataFlavor[] htmlFlavors;
    private static DataFlavor[] stringFlavors;
    private static DataFlavor[] plainFlavors;

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = this.getRicherFlavors();
        int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
        int n2 = this.isHTMLSupported() ? htmlFlavors.length : 0;
        int n3 = this.isPlainSupported() ? plainFlavors.length : 0;
        int n4 = this.isPlainSupported() ? stringFlavors.length : 0;
        int n5 = n + n2 + n3 + n4;
        DataFlavor[] dataFlavorArray2 = new DataFlavor[n5];
        int n6 = 0;
        if (n > 0) {
            System.arraycopy(dataFlavorArray, 0, dataFlavorArray2, n6, n);
            n6 += n;
        }
        if (n2 > 0) {
            System.arraycopy(htmlFlavors, 0, dataFlavorArray2, n6, n2);
            n6 += n2;
        }
        if (n3 > 0) {
            System.arraycopy(plainFlavors, 0, dataFlavorArray2, n6, n3);
            n6 += n3;
        }
        if (n4 > 0) {
            System.arraycopy(stringFlavors, 0, dataFlavorArray2, n6, n4);
            n6 += n4;
        }
        return dataFlavorArray2;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isRicherFlavor(dataFlavor)) {
            return this.getRicherData(dataFlavor);
        }
        if (this.isHTMLFlavor(dataFlavor)) {
            String string = this.getHTMLData();
            String string2 = string = string == null ? "" : string;
            if (String.class.equals(dataFlavor.getRepresentationClass())) {
                return string;
            }
            if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                return new StringReader(string);
            }
            if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                return new StringBufferInputStream(string);
            }
        } else if (this.isPlainFlavor(dataFlavor)) {
            String string = this.getPlainData();
            String string3 = string = string == null ? "" : string;
            if (String.class.equals(dataFlavor.getRepresentationClass())) {
                return string;
            }
            if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                return new StringReader(string);
            }
            if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                return new StringBufferInputStream(string);
            }
        } else if (this.isStringFlavor(dataFlavor)) {
            String string = this.getPlainData();
            string = string == null ? "" : string;
            return string;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    protected boolean isRicherFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getRicherFlavors();
        int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected DataFlavor[] getRicherFlavors() {
        return null;
    }

    protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        return null;
    }

    protected boolean isHTMLFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = htmlFlavors;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isHTMLSupported() {
        return false;
    }

    protected String getHTMLData() {
        return null;
    }

    protected boolean isPlainFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = plainFlavors;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPlainSupported() {
        return false;
    }

    protected String getPlainData() {
        return null;
    }

    protected boolean isStringFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = stringFlavors;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            htmlFlavors = new DataFlavor[3];
            DefaultDiagramTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
            DefaultDiagramTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
            DefaultDiagramTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
            plainFlavors = new DataFlavor[3];
            DefaultDiagramTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
            DefaultDiagramTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
            DefaultDiagramTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
            stringFlavors = new DataFlavor[2];
            DefaultDiagramTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
            DefaultDiagramTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

