/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.relational.TVView;

public class TableViewDiagramCell
extends ContainerDiagramCell {
    private JMenuItem miDeleteView;
    private JMenuItem miSyncWithDict;
    private JMenuItem miSyncDict;

    public TableViewDiagramCell(ContainerObject containerObject) {
        super(containerObject);
    }

    public TableViewDiagramCell(ContainerObject containerObject, Map map) {
        super(containerObject, map);
    }

    private void showProperty() {
        this.getContainer().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (this.isEditable() && this.miDeleteView != null) {
            if (this.getTopView().canRemove()) {
                this.miDeleteView.setEnabled(true);
            } else {
                this.miDeleteView.setEnabled(false);
            }
        }
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu.removeAll();
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(CREATE_SYNONYM){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableViewDiagramCell.this.getTopView().createViewSynonim(TableViewDiagramCell.this.getDiagram().getAppView().getCurrentDPV());
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(CREATE_SUBVIEW_FROM_SELECTED){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableViewDiagramCell.this.getTopView().getDesignPartView().createSubViewFromSelected();
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(new AbstractAction(DDL_PREVIEW){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableViewDiagramCell.this.getDiagram().getAppView().setDDLViewerVisible(true);
            }
        });
        this.menu.addSeparator();
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(COPY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableViewDiagramCell.this.getContainer().getAppView().clearCopiedObjects();
                    TableViewDiagramCell.access$002(TableViewDiagramCell.this, TableViewDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    for (int i = 0; i < TableViewDiagramCell.this.selectedObjects.length; ++i) {
                        if (!(TableViewDiagramCell.this.selectedObjects[i] instanceof DesignObject)) continue;
                        TableViewDiagramCell.this.getContainer().getAppView().addCopiedObject((DesignObject)TableViewDiagramCell.this.selectedObjects[i]);
                    }
                }
            });
        }
        if (this.isEditable(true)) {
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            if (this.selectedObjects.length > 1) {
                this.menu.add(new AbstractAction(DELETE_OBJECTS){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DefaultDiagramCell.deleteObjects(TableViewDiagramCell.this.selectedObjects, TableViewDiagramCell.this.getDiagram().getAppView());
                    }
                });
                if (!this.getDiagram().getDesignPartView().isMainDiagram()) {
                    this.menu.add(new AbstractAction(DELETE_VIEWS){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TableViewDiagramCell.this.getDiagram().getDesignPartView().removeTopViewsWithUndo(TableViewDiagramCell.this.getDiagram().getSelectionCells());
                        }
                    });
                }
            } else {
                this.menu.add(new AbstractAction(DELETE_OBJECT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableViewDiagramCell.this.deleteView();
                    }
                });
                this.miDeleteView = this.menu.add(new AbstractAction(DELETE_VIEW){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableViewDiagramCell.this.getTopView().getDesignPartView().postTopViewRemove(TableViewDiagramCell.this.getTopView());
                        ((ContainerView)TableViewDiagramCell.this.getTopView()).remove(false);
                    }
                });
            }
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableViewDiagramCell.this.format();
                }
            });
            this.menu.addSeparator();
        }
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(SEND_TO_BACK){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableViewDiagramCell.this.getTopView().sendToBack();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(RESIZE_TO_VISIBLE){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableViewDiagramCell.this.getTopView().getDesignPartView().resizeSelectedObjects();
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableViewDiagramCell.this.showProperty();
            }
        });
        if (this.isEditable()) {
            this.miSyncWithDict = this.menu.add(new AbstractAction(DesignPartView.MI_SYNC_WITH_DATA_DICTIONARY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableViewDiagramCell.access$602(TableViewDiagramCell.this, TableViewDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    TableViewDiagramCell.this.getTopView().getDesignPartView().sync(false, TableViewDiagramCell.this.selectedObjects);
                }
            });
            this.miSyncWithDict.setIcon(GUIConfiguration.getInstance().getIcon("SYNC_MODEL_WITH_DICT", 16));
            this.miSyncDict = this.menu.add(new AbstractAction(DesignPartView.MI_SYNC_DATA_DICTIONARY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableViewDiagramCell.access$802(TableViewDiagramCell.this, TableViewDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    TableViewDiagramCell.this.getTopView().getDesignPartView().sync(true, TableViewDiagramCell.this.selectedObjects);
                }
            });
            this.miSyncDict.setIcon(GUIConfiguration.getInstance().getIcon("SYNC_DICT_WITH_MODEL", 16));
        }
        return this.menu;
    }

    public void deleteView() {
        TVView tVView = (TVView)this.getTopView();
        ApplicationView.log(MessageFormat.format(Messages.getString("TableViewDiagramCell.DeleteView"), tVView.getModel().getName()));
        tVView.remove();
    }

    @Override
    public void deleteSelected() {
        ((ContainerView)this.getTopView()).remove();
    }

    static /* synthetic */ Object[] access$002(TableViewDiagramCell tableViewDiagramCell, Object[] objectArray) {
        tableViewDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[] access$602(TableViewDiagramCell tableViewDiagramCell, Object[] objectArray) {
        tableViewDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[] access$802(TableViewDiagramCell tableViewDiagramCell, Object[] objectArray) {
        tableViewDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }
}

