/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.Color;
import java.awt.Font;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class TableRenderer
extends ContainerRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 255, 180);
    public static final Color DEFAULT_DATATYPE_COLOR = new Color(0, 128, 0);
    public static final Color DEFAULT_ALLOW_NULL_COLOR = Color.RED;

    public TableRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        this.datatypeColor = DEFAULT_DATATYPE_COLOR;
        this.allowNullColor = DEFAULT_ALLOW_NULL_COLOR;
    }

    @Override
    protected Color getBackgroundColor() {
        if (this.container instanceof Table) {
            if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
                Table table = (Table)this.container;
                ClassificationType classificationType = table.getDesign().getDLSettings().getClassificationTypeByID(table.getTypeID());
                if (classificationType != null) {
                    return classificationType.getTypeColor();
                }
                DefaultFontAndColor defaultFontAndColor = this.container.getDesign().getDLSettings().getDefaultFCObject("Table");
                if (defaultFontAndColor != null) {
                    return defaultFontAndColor.getBackgroundColor();
                }
            } else {
                return this.getTopView().getBackgroundColor();
            }
        }
        return this.defaultBackground;
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.container.getDesign().getDLSettings().getDefaultFCObject("Table");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.getForeground();
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    protected Color getElementsColor() {
        if (this.container instanceof EditableFonts) {
            return ((EditableFonts)((Object)this.container)).getFontObject(EditableFonts.FO_COLUMN).getColor();
        }
        return super.getElementsColor();
    }

    @Override
    protected Font getElementsFont() {
        if (this.container instanceof EditableFonts) {
            return ((EditableFonts)((Object)this.container)).getFontObject(EditableFonts.FO_COLUMN).getFont();
        }
        return super.getElementsFont();
    }

    @Override
    protected String getType() {
        String string;
        if (this.container instanceof Table && (string = ((Table)this.container).getDesign().getDLSettings().getClassificationTypeNameByID(((Table)this.container).getTypeID())) != null && string.length() > 0) {
            return string.substring(0, 1);
        }
        return null;
    }
}

