/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.relational.TVTable;

public class TableDiagramCell
extends ContainerDiagramCell {
    private JMenuItem miPaste;
    private JMenuItem miSelectNeighbors;
    private JMenuItem miDeleteView;
    private JMenuItem miSyncWithDict;
    private JMenuItem miSyncDict;

    public TableDiagramCell(ContainerObject containerObject) {
        super(containerObject);
    }

    public TableDiagramCell(ContainerObject containerObject, Map map) {
        super(containerObject, map);
    }

    private void showProperty() {
        this.getContainer().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    public void syncObjects(boolean bl) {
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (this.isEditable(true) && this.selectedObjects.length == 1) {
            if (this.getTopView().canRemove()) {
                this.miDeleteView.setEnabled(true);
            } else {
                this.miDeleteView.setEnabled(false);
            }
        }
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu.removeAll();
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(CREATE_SYNONYM){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDiagramCell.this.getTopView().createViewSynonim(TableDiagramCell.this.getDiagram().getAppView().getCurrentDPV());
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(CREATE_SUBVIEW_FROM_SELECTED){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDiagramCell.this.getTopView().getDesignPartView().createSubViewFromSelected();
                }
            });
            this.menu.addSeparator();
            this.miSelectNeighbors = this.menu.add(new AbstractAction(SELECT_NEIGHBORS){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDiagramCell.this.getTopView().getDesignPartView().selectNeighbors(TableDiagramCell.this.getContainer());
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(new AbstractAction(DDL_PREVIEW){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableDiagramCell.this.getDiagram().getAppView().setDDLViewerVisible(true);
            }
        });
        this.menu.addSeparator();
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(COPY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDiagramCell.this.getContainer().getAppView().clearCopiedObjects();
                    TableDiagramCell.access$002(TableDiagramCell.this, TableDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    for (int i = 0; i < TableDiagramCell.this.selectedObjects.length; ++i) {
                        if (!(TableDiagramCell.this.selectedObjects[i] instanceof DesignObject)) continue;
                        TableDiagramCell.this.getContainer().getAppView().addCopiedObject((DesignObject)TableDiagramCell.this.selectedObjects[i]);
                    }
                }
            });
            this.miPaste = this.menu.add(new AbstractAction(PASTE){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDiagramCell.access$402(TableDiagramCell.this, TableDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    for (int i = 0; i < TableDiagramCell.this.selectedObjects.length; ++i) {
                        ((ContainerObject)TableDiagramCell.this.selectedObjects[i]).paste();
                    }
                }
            });
        }
        if (this.isEditable(true)) {
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            if (this.selectedObjects.length > 1) {
                this.menu.add(new AbstractAction(DELETE_OBJECTS){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DefaultDiagramCell.deleteObjects(TableDiagramCell.this.selectedObjects, TableDiagramCell.this.getDiagram().getAppView());
                    }
                });
                if (!this.getDiagram().getDesignPartView().isMainDiagram()) {
                    this.menu.add(new AbstractAction(DELETE_VIEWS){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TableDiagramCell.this.getDiagram().getDesignPartView().removeTopViewsWithUndo(TableDiagramCell.this.getDiagram().getSelectionCells());
                        }
                    });
                }
            } else {
                this.menu.add(new AbstractAction(DELETE_OBJECT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableDiagramCell.this.deleteTable();
                    }
                });
                this.miDeleteView = this.menu.add(new AbstractAction(DELETE_VIEW){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DesignPartView designPartView = TableDiagramCell.this.getTopView().getDesignPartView();
                        designPartView.setCommandInProgress(true);
                        designPartView.postTopViewRemove(TableDiagramCell.this.getTopView());
                        ((ContainerView)TableDiagramCell.this.getTopView()).remove(false);
                        designPartView.setCommandInProgress(false);
                    }
                });
            }
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDiagramCell.this.format();
                }
            });
            this.menu.addSeparator();
        }
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(SEND_TO_BACK){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDiagramCell.this.getTopView().sendToBack();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(RESIZE_TO_VISIBLE){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDiagramCell.this.getTopView().getDesignPartView().resizeSelectedObjects();
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableDiagramCell.this.showProperty();
            }
        });
        if (this.isEditable()) {
            this.miPaste.setEnabled(this.getContainer().canPaste());
            this.miSelectNeighbors.setEnabled(this.enableSelectNeighbors());
            this.miSyncWithDict = this.menu.add(new AbstractAction(DesignPartView.MI_SYNC_WITH_DATA_DICTIONARY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDiagramCell.access$902(TableDiagramCell.this, TableDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    TableDiagramCell.this.getTopView().getDesignPartView().sync(false, TableDiagramCell.this.selectedObjects);
                }
            });
            this.miSyncWithDict.setIcon(GUIConfiguration.getInstance().getIcon("SYNC_MODEL_WITH_DICT", 16));
            this.miSyncDict = this.menu.add(new AbstractAction(DesignPartView.MI_SYNC_DATA_DICTIONARY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDiagramCell.access$1102(TableDiagramCell.this, TableDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    TableDiagramCell.this.getTopView().getDesignPartView().sync(true, TableDiagramCell.this.selectedObjects);
                }
            });
            this.miSyncDict.setIcon(GUIConfiguration.getInstance().getIcon("SYNC_DICT_WITH_MODEL", 16));
        } else {
            this.setEnabled(this.miPaste, false);
        }
        return this.menu;
    }

    private boolean enableSelectNeighbors() {
        Table table = (Table)this.getContainer();
        return ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getRelatedTablesTo(table).size() > 0;
    }

    public void deleteTable() {
        TVTable tVTable = (TVTable)this.getTopView();
        tVTable.remove(MessageFormat.format(Messages.getString("TableDiagramCell.DeleteTable"), tVTable.getModel().getName()));
    }

    @Override
    public void deleteSelected() {
        this.deleteTable();
    }

    static /* synthetic */ Object[] access$002(TableDiagramCell tableDiagramCell, Object[] objectArray) {
        tableDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[] access$402(TableDiagramCell tableDiagramCell, Object[] objectArray) {
        tableDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[] access$902(TableDiagramCell tableDiagramCell, Object[] objectArray) {
        tableDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[] access$1102(TableDiagramCell tableDiagramCell, Object[] objectArray) {
        tableDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }
}

