/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.swingui.diagram.process.DFDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class TransformationRenderer
extends DFDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 255, 213);

    public TransformationRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.processObject.getDesign().getDLSettings().getDefaultFCObject("Transformation");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.processObject.getDesign().getDLSettings().getDefaultFCObject("Transformation");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        String string;
        Object object2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        EditableFonts editableFonts = (EditableFonts)((Object)this.processObject);
        if (this.processObject instanceof Transformation) {
            object2 = (Transformation)this.processObject;
            string = ((Transformation)object2).getProcessNumber();
        } else {
            string = String.valueOf(this.processObject.getDesignObjectSet().getIndexOf(this.processObject) + 1);
        }
        graphics2D.setPaint(this.getBackgroundColor());
        graphics.fillRoundRect(0, 0, n - 1, n2 - 1, 20, 20);
        graphics.setColor(this.getBorderColor());
        graphics.drawRoundRect(0, 0, n - 1, n2 - 1, 20, 20);
        if (this.processObject instanceof Transformation && ((Transformation)(object2 = (Transformation)this.processObject)).getType() == 1) {
            object = new int[]{n - 14, n - 8, n - 14, n - 19, n - 14};
            int[] nArray = new int[]{5, 5, 14, 5, 5};
            graphics.drawPolyline((int[])object, nArray, 5);
        }
        object2 = editableFonts.getFontObject(EditableFonts.FO_PROCESS_NUMBER).getFont();
        graphics.setFont((Font)object2);
        object = graphics.getFontMetrics();
        int n3 = ((FontMetrics)object).getMaxAscent() - ((FontMetrics)object).getMaxDescent() + 3;
        BasicStroke basicStroke = new BasicStroke(this.borderWidth);
        BasicStroke basicStroke2 = new BasicStroke(1.0f);
        int n4 = Math.max(n3, ((Font)object2).getSize());
        int n5 = (n - ((FontMetrics)object).stringWidth(string)) / 2;
        if (n5 < 20) {
            n5 = 20;
        }
        graphics2D.setStroke(basicStroke2);
        graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_PROCESS_NUMBER).getColor());
        graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_PROCESS_NUMBER).getFont());
        graphics.drawString(string, n5, n4);
        graphics2D.setStroke(basicStroke);
        graphics.setColor(this.getBorderColor());
        graphics.drawLine(0, n4 += 3 + this.borderWidth, n - 2, n4);
        object2 = editableFonts.getFontObject(EditableFonts.FO_TITLE).getFont();
        graphics.setFont((Font)object2);
        object = graphics.getFontMetrics();
        n3 = ((FontMetrics)object).getMaxAscent() - ((FontMetrics)object).getMaxDescent() + 3;
        graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_TITLE).getColor());
        graphics2D.setStroke(basicStroke2);
        n4 = n2 / 2 + ((Font)object2).getSize() / 3;
        n5 = (n - ((FontMetrics)object).stringWidth(this.title)) / 2;
        graphics.drawString(this.title, n5, n4);
    }
}

