/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.process.DFDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class ProcessRenderer
extends DFDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 255, 150);

    public ProcessRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.processObject.getDesign().getDLSettings().getDefaultFCObject("Process");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.processObject.getDesign().getDLSettings().getDefaultFCObject("Process");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics graphics) {
        String string;
        Object object;
        Process process;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Process process2 = process = (Process)this.processObject;
        String string2 = this.processObject instanceof Process ? process.getProcessNumber() : String.valueOf(this.processObject.getDesignObjectSet().getIndexOf(this.processObject) + 1);
        graphics2D.setPaint(this.getBackgroundColor());
        graphics.fillRoundRect(0, 0, n - 1, n2 - 1, 20, 20);
        graphics.setColor(this.getBorderColor());
        graphics.drawRoundRect(0, 0, n - 1, n2 - 1, 20, 20);
        boolean bl = false;
        if (this.processObject instanceof Process) {
            int[] nArray;
            if (process.hasEvent()) {
                graphics.drawOval(3, 3, 10, 10);
                bl = true;
            }
            if (process.getType() == 1) {
                object = new int[]{n - 14, n - 8, n - 14, n - 20, n - 14};
                nArray = new int[]{3, 3, 13, 3, 3};
                graphics.drawPolyline((int[])object, nArray, 5);
            } else if (process.getType() == 2) {
                object = new int[]{n - 20, n - 14, n - 8, n - 14, n - 20};
                nArray = new int[]{8, 3, 8, 13, 8};
                graphics.drawPolyline((int[])object, nArray, 5);
            }
        }
        object = process2.getFontObject(EditableFonts.FO_PROCESS_NUMBER).getFont();
        float f = ((Font)object).getSize2D();
        f = Math.max(f, process2.getFontObject(EditableFonts.FO_TASK).getFont().getSize2D());
        object = ((Font)object).deriveFont(f);
        graphics.setFont((Font)object);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
        BasicStroke basicStroke = new BasicStroke(this.borderWidth);
        BasicStroke basicStroke2 = new BasicStroke(1.0f);
        int n4 = Math.max(n3, ((Font)object).getSize()) + 2;
        int n5 = 15 - string2.length();
        if (bl) {
            n5 = 20;
        }
        graphics2D.setStroke(basicStroke2);
        graphics.setColor(process2.getFontObject(EditableFonts.FO_PROCESS_NUMBER).getColor());
        graphics.setFont(process2.getFontObject(EditableFonts.FO_PROCESS_NUMBER).getFont().deriveFont(f));
        graphics.drawString(string2, n5, n4);
        object = process2.getFontObject(EditableFonts.FO_TITLE).getFont();
        graphics.setFont((Font)object);
        fontMetrics = graphics.getFontMetrics();
        n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
        graphics.setColor(process2.getFontObject(EditableFonts.FO_TITLE).getColor());
        graphics2D.setStroke(basicStroke2);
        n4 = Math.max(n3, ((Font)object).getSize()) + 2;
        n5 = (n - fontMetrics.stringWidth(this.title)) / 2;
        n5 = Math.max(n5, 35);
        String[] stringArray = ProcessRenderer.wrapText(this.title, ProcessRenderer.getMaxChars(this.title, fontMetrics, n - 20 - 5));
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            graphics.drawString(string, n5, n4);
            n4 += n3;
        }
        DesignPartView designPartView = this.getDesignPartView();
        if (designPartView != null && !designPartView.isShowNamesOnly()) {
            graphics2D.setStroke(basicStroke);
            graphics.setColor(this.getBorderColor());
            graphics.drawLine(0, n4 -= n3 / 2, n - 2, n4);
            if (!designPartView.isShowNamesOnly() && (string = process.getFootNote()) != null && !"".equals(string)) {
                graphics2D.setStroke(basicStroke2);
                n4 += n3;
                stringArray = ProcessRenderer.wrapText(string, ProcessRenderer.getMaxChars(string, fontMetrics, n - 20 - 5));
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    graphics.drawString(string3, 3, n4);
                    n4 += n3;
                }
            }
        }
    }
}

