/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.process.TVProcess;
import oracle.ide.Ide;

public class ProcessDiagramCell
extends DFDiagramCell {
    private JPopupMenu menu;
    private JMenuItem miCopy;
    private JMenuItem goToDiagram = new JMenuItem(Messages.getString("ProcessDiagramCell.GoToDiagram"));

    public ProcessDiagramCell(AbstractProcessObject abstractProcessObject) {
        super(abstractProcessObject);
    }

    public ProcessDiagramCell(AbstractProcessObject abstractProcessObject, Map map) {
        super(abstractProcessObject, map);
    }

    private void showProperty() {
        this.getProcessObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        Process process;
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.goToDiagram.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Process process = (Process)ProcessDiagramCell.this.getProcessObject();
                    if (process.getType() == 1) {
                        process.getDiagram().setMainViewVisible(true);
                    } else if (process.getType() == 2 && process.getTransformationTask() != null) {
                        process.getTransformationTask().setMainViewVisible(true);
                    }
                }
            });
            this.menu.add(this.goToDiagram);
            this.menu.addSeparator();
            if (this.isEditable()) {
                this.miCopy = this.menu.add(new AbstractAction(COPY){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ProcessDiagramCell.this.getProcessObject().getAppView().clearCopiedObjects();
                        ProcessDiagramCell.access$002(ProcessDiagramCell.this, ProcessDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                        for (int i = 0; i < ProcessDiagramCell.this.selectedObjects.length; ++i) {
                            if (!(ProcessDiagramCell.this.selectedObjects[i] instanceof ExternalAgent) && !(ProcessDiagramCell.this.selectedObjects[i] instanceof Process) && !(ProcessDiagramCell.this.selectedObjects[i] instanceof InfoStore)) continue;
                            ProcessDiagramCell.this.getProcessObject().getAppView().addCopiedObject((DesignObject)ProcessDiagramCell.this.selectedObjects[i]);
                        }
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ProcessDiagramCell.this.deleteProcess();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ProcessDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ProcessDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProcessDiagramCell.this.showProperty();
                }
            });
        }
        if ((process = (Process)this.getProcessObject()).getType() != 0) {
            if (process.getType() == 2) {
                if (process.getTransformationTask() != null) {
                    this.goToDiagram.setEnabled(true);
                } else {
                    this.goToDiagram.setEnabled(false);
                }
            } else {
                this.goToDiagram.setEnabled(true);
            }
        } else {
            this.goToDiagram.setEnabled(false);
        }
        this.miCopy.setEnabled(!process.isComposite());
        return this.menu;
    }

    public void deleteProcess() {
        Diagram diagram = this.getDiagram();
        ApplicationView applicationView = diagram.getAppView();
        DesignPartView designPartView = applicationView.getCurrentDPV();
        Process process = (Process)this.getProcessObject();
        if (process.getDesignPart() == designPartView.getDesignPart()) {
            ApplicationView.log(MessageFormat.format(Messages.getString("ProcessDiagramCell.DeleteProcess"), process.getName()));
            TVProcess tVProcess = (TVProcess)this.getTopView();
            tVProcess.remove(true);
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ProcessDiagramCell.ProcessNotCreatedAtThisLevel"));
        }
    }

    @Override
    public void deleteSelected() {
        this.deleteProcess();
    }

    static /* synthetic */ Object[] access$002(ProcessDiagramCell processDiagramCell, Object[] objectArray) {
        processDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }
}

