/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.process.DFDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class InOutParamsRenderer
extends DFDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(250, 250, 250);
    private InOutParams inOutParams;

    public InOutParamsRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.processObject.getDesign().getDLSettings().getDefaultFCObject("In-Out Parameters");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.processObject.getDesign().getDLSettings().getDefaultFCObject("In-Out Parameters");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics graphics) {
        this.inOutParams = (InOutParams)this.processObject;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        EditableFonts editableFonts = (EditableFonts)((Object)this.processObject);
        graphics2D.setPaint(this.getBackgroundColor());
        graphics.fillRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(this.getBorderColor());
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        Font font = editableFonts.getFontObject(EditableFonts.FO_TITLE).getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
        int n4 = Math.max(n3, font.getSize());
        int n5 = (n - fontMetrics.stringWidth(this.title)) / 2;
        BasicStroke basicStroke = new BasicStroke(this.borderWidth);
        BasicStroke basicStroke2 = new BasicStroke(1.0f);
        graphics2D.setStroke(basicStroke2);
        graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_TITLE).getColor());
        graphics.setFont(font);
        graphics.drawString(this.title, n5, n4);
        DesignPartView designPartView = this.getDesignPartView();
        if (designPartView != null && !designPartView.clearDetails() && !designPartView.isShowNamesOnly()) {
            graphics2D.setStroke(basicStroke);
            int n6 = n4 - n3;
            graphics.setColor(this.getBorderColor());
            graphics.drawLine(0, n4 += n6 + 3 + this.borderWidth, n - 2, n4);
            graphics2D.setStroke(basicStroke2);
            float f = editableFonts.getFontObject(EditableFonts.FO_PARAMETERS).getFont().getSize2D();
            f = Math.max(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getFont().getSize2D(), f);
            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_PARAMETERS).getFont().deriveFont(f));
            Object[] objectArray = this.inOutParams.getParams().toArray();
            String string = this.getLongestName(objectArray);
            fontMetrics = graphics.getFontMetrics();
            int n7 = fontMetrics.stringWidth(string) + 20;
            for (int i = 0; i < objectArray.length; ++i) {
                ParameterObject parameterObject = (ParameterObject)objectArray[i];
                graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_PARAMETERS).getColor());
                graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_PARAMETERS).getFont().deriveFont(f));
                graphics.drawString(parameterObject.getName(), 5, n4 += 3 + fontMetrics.getMaxAscent());
                graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getFont().deriveFont(f));
                graphics.drawString(parameterObject.getLogicalDatatype().toString(), n7, n4);
                if (n4 <= n2) continue;
                graphics.setColor(this.getBorderColor());
                int n8 = n - 4;
                int n9 = n8 - 8;
                int n10 = n8 - 4;
                int n11 = n2 - 4;
                int n12 = n11 - 8;
                int[] nArray = new int[]{n10, n9, n8};
                int[] nArray2 = new int[]{n11, n12, n12};
                graphics.fillPolygon(nArray, nArray2, 3);
                break;
            }
        }
    }

    private String getLongestName(Object[] objectArray) {
        String string = "";
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = ((DesignObject)objectArray[i]).getName();
            if (string2.length() <= string.length()) continue;
            string = string2;
        }
        return string;
    }
}

