/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDiagramCell;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;

public class MDDRenderer
extends JLabel
implements CellViewRenderer {
    public static final int TITLE_PADDING = 3;
    public static final int ROW_SPACING = 3;
    protected transient AbstractDiagram diagram;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient Color defaultForeground = Color.BLACK;
    protected transient Color defaultBackground = Color.WHITE;
    protected transient Color bordercolor;
    protected transient int borderWidth;
    protected transient AbstractMDObject mdObject;
    protected String title = "";
    protected CellView view;
    protected boolean detailedView = true;

    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            return this.getForeground();
        }
        return this.getTopView().getForegroundColor();
    }

    public Color getBorderColor() {
        return this.getForegroundColor();
    }

    public Color getRedColor() {
        if (this.getMdObject().getTopView().useDefaultColor() || this.getMdObject().getTopView().getForegroundColor() == null) {
            return Color.RED;
        }
        return this.getMdObject().getTopView().getForegroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackgroundColor();
    }

    @Override
    public Color getFGColor() {
        return this.getForegroundColor();
    }

    public Color getBlueColor() {
        if (this.getMdObject().getTopView().useDefaultColor() || this.getMdObject().getTopView().getForegroundColor() == null) {
            return Color.BLUE;
        }
        return this.getMdObject().getTopView().getForegroundColor();
    }

    protected DesignPartView getDesignPartView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDesignPartView();
        }
        return null;
    }

    @Override
    public Component getRendererComponent(AbstractDiagram abstractDiagram, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof MDDView) {
            MDDiagramCell mDDiagramCell = (MDDiagramCell)cellView.getCell();
            this.mdObject = mDDiagramCell.getMDObject();
            if (mDDiagramCell.getTopView() != null) {
                this.title = mDDiagramCell.getTopView().toString();
                this.detailedView = !(mDDiagramCell.getTopView().getDesignPartView() instanceof DPVCompactMultidimentional);
            }
            this.diagram = abstractDiagram;
            this.hasFocus = bl2;
            this.selected = bl;
            this.preview = bl3;
            this.setComponentOrientation(abstractDiagram.getComponentOrientation());
            if (cellView.isLeaf()) {
                this.installAttributes(cellView);
            } else {
                this.setBorder(null);
                this.setOpaque(false);
            }
            this.view = cellView;
            return this;
        }
        return null;
    }

    protected void installAttributes(CellView cellView) {
        Color color;
        Map map = cellView.getAllAttributes();
        this.setOpaque(DiagramConstants.isOpaque(map));
        this.setBorder(DiagramConstants.getBorder(map));
        this.bordercolor = DiagramConstants.getBorderColor(map);
        this.borderWidth = Math.max(1, Math.round(DiagramConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((color = DiagramConstants.getForeground(map)) != null ? color : this.defaultForeground);
        Color color2 = DiagramConstants.getBackground(map);
        this.setBackground(color2 != null ? color2 : this.defaultBackground);
        this.setFont(this.diagram.getFont());
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        graphics.setColor(this.getBackgroundColor());
        graphics.fillRoundRect(0, 0, n - 1, n2 - 1, 40, 40);
        graphics.setColor(this.getBorderColor());
        graphics.drawRoundRect(0, 0, n - 1, n2 - 1, 40, 40);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Font font = this.diagram.getFont();
        Font font2 = font.deriveFont(1);
        int n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
        int n4 = n3 + 3;
        int n5 = (n - fontMetrics.stringWidth(this.title)) / 2;
        BasicStroke basicStroke = new BasicStroke(this.borderWidth);
        BasicStroke basicStroke2 = new BasicStroke(1.0f);
        graphics2D.setStroke(basicStroke2);
        graphics.setColor(this.getBorderColor());
        graphics.setFont(font2);
        graphics.drawString(this.title, n5, n4);
        graphics2D.setStroke(basicStroke);
        graphics.drawLine(0, n4 += 3 + this.borderWidth, n - 2, n4);
        graphics.setColor(this.getForegroundColor());
        graphics2D.setStroke(basicStroke2);
        graphics.setFont(font);
    }

    public Point2D getPerimeterPoint(MDDView mDDView, Point2D point2D, Point2D point2D2, boolean bl) {
        Rectangle2D rectangle2D = mDDView.getBounds();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = d + d3 / 2.0;
        double d6 = d2 + d4 / 2.0;
        double d7 = point2D2.getX() - d5;
        double d8 = point2D2.getY() - d6;
        double d9 = Math.atan2(d8, d7);
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = Math.PI;
        double d13 = Math.atan2(d4, d3);
        if (d9 < -d12 + d13 || d9 > d12 - d13) {
            d10 = d;
            d11 = d6;
        } else if (d9 < -d13) {
            d11 = d2;
            d10 = d5;
        } else if (d9 < d13) {
            d10 = d + d3;
            d11 = d6;
        } else {
            d11 = d2 + d4;
            d10 = d5;
        }
        return DiagramConstants.createPoint(d10, d11);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public AbstractMDObject getMdObject() {
        return this.mdObject;
    }

    protected TopView getTopView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView();
        }
        if (this.mdObject != null) {
            return this.mdObject.getTopView();
        }
        return null;
    }
}

