/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class LinkEdge
extends DefaultEdge {
    private JPopupMenu menu;
    private JMenuItem miStraightLine = null;
    private JMenuItem miAddBP = null;
    private JMenuItem miRemoveBP = null;
    private Point point = new Point();

    private void showProperty() {
        this.getTopView().getModel().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        this.point.setLocation(point);
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(DELETE){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LinkEdge.this.deleteLink();
                }
            });
            this.menu.addSeparator();
            this.miStraightLine = this.menu.add(new AbstractAction(STRAIGHT_LINE){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LinkEdge.this.straightenLine();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LinkEdge.this.format();
                }
            });
            this.menu.addSeparator();
            this.miAddBP = this.menu.add(new AbstractAction(ADD_BREAKPOINT){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LinkEdge.this.addBreakpoint(LinkEdge.this.point);
                }
            });
            this.miRemoveBP = this.menu.add(new AbstractAction(REMOVE_BREAKPOINT){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LinkEdge.this.removeBreakpoint(LinkEdge.this.point);
                }
            });
        }
        if (this.getLink().getRollupLink() != null && !(this.getLink().getSourceMDObject() instanceof Dimension)) {
            if (this.isEditable()) {
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LinkEdge.this.showProperty();
                }
            });
        }
        if (this.getLink().getSourceMDObject() instanceof Dimension) {
            Dimension dimension = (Dimension)this.getLink().getSourceMDObject();
            Iterator iterator = dimension.getHierarchies().iterator();
            while (iterator.hasNext()) {
                Hierarchy hierarchy = (Hierarchy)iterator.next();
                if (this.isEditable()) {
                    this.menu.addSeparator();
                }
                this.menu.add(new HierarchyAction(MessageFormat.format(Messages.getString("LinkEdge.PropertiesOf"), hierarchy.getName()), hierarchy));
            }
        }
        if (this.miStraightLine != null) {
            this.miStraightLine.setEnabled(!this.getTopView().getDesignPartView().isAutoRoute() && this.onlyEdgesAreSelected());
        }
        if (this.miAddBP != null && this.miRemoveBP != null) {
            if (this.getTopView().getDesignPartView().isAutoRoute()) {
                this.miAddBP.setEnabled(false);
                this.miRemoveBP.setEnabled(false);
            } else {
                boolean bl = this.hasBreakpointAt(this.point);
                this.miAddBP.setEnabled(!bl);
                this.miRemoveBP.setEnabled(bl);
            }
        }
        return this.menu;
    }

    public Link getLink() {
        return (Link)this.getTopView().getModel();
    }

    @Override
    public String getName() {
        if (this.getLink().getRollupLink() != null) {
            return this.getLink().getRollupLink().getName();
        }
        return "";
    }

    @Override
    public Object getUserObject() {
        if (this.getTopView() != null && this.getLink() != null) {
            return this.getName();
        }
        return null;
    }

    public boolean showName() {
        return this.getLink().getRollupLink() != null && this.getLink().getRollupLink().isRolePlaying();
    }

    public void deleteLink() {
        Link link = this.getLink();
        TVConnector tVConnector = (TVConnector)this.getTopView();
        if (tVConnector.remove(link)) {
            ApplicationView.log(MessageFormat.format(Messages.getString("LinkEdge.RemoveLink"), link.getName()));
        }
    }

    public String getSourceName() {
        return this.getLink().getSource().getName();
    }

    public String getTargetName() {
        return this.getLink().getDestination().getName();
    }

    @Override
    public void deleteSelected() {
        this.deleteLink();
    }

    class HierarchyAction
    extends AbstractAction {
        private Hierarchy hierarchy;

        HierarchyAction(String string, Hierarchy hierarchy) {
            super(string);
            this.hierarchy = hierarchy;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.hierarchy.showPropertyDialog();
        }
    }
}

