/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class DimensionRenderer
extends MDDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(0, 250, 20);

    public DimensionRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.getMdObject().getDesign().getDLSettings().getDefaultFCObject("Dimension");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.getMdObject().getDesign().getDLSettings().getDefaultFCObject("Dimension");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        EditableFonts editableFonts = (EditableFonts)((Object)this.getMdObject());
        int n = dimension.width;
        int n2 = dimension.height;
        graphics2D.setPaint(this.getBackgroundColor());
        graphics.fillRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(this.getBorderColor());
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        int n3 = n / 8;
        int n4 = n - n3;
        graphics.drawLine(n3, 0, n3, n2 - 1);
        graphics.drawLine(n4, 0, n4, n2 - 1);
        Font font = editableFonts.getFontObject(EditableFonts.FO_TITLE).getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = n2 / 2 + font.getSize() / 3;
        int n6 = (n - fontMetrics.stringWidth(this.title)) / 2;
        if (n6 < 20) {
            n6 = 20;
        }
        BasicStroke basicStroke = new BasicStroke(1.0f);
        graphics2D.setStroke(basicStroke);
        graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_TITLE).getColor());
        graphics.drawString(this.title, n6, n5);
    }
}

