/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityRenderer;

public class EntityView
extends ContainerView {
    private EntityRenderer renderer;
    private double dx = 10.0;
    private double dy = 10.0;

    public EntityView(Object object, AbstractDiagram abstractDiagram, CellMapper cellMapper) {
        super(object, abstractDiagram, cellMapper);
    }

    @Override
    public CellViewRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new EntityRenderer();
        }
        return this.renderer;
    }

    public void saveChildPositions() {
        if (this.showBoxInBox()) {
            CellView[] cellViewArray = this.getAllChildren();
            Rectangle2D rectangle2D = this.getBounds();
            for (int i = 0; i < cellViewArray.length; ++i) {
                EntityView entityView = (EntityView)cellViewArray[i];
                entityView.savePosition(rectangle2D);
            }
        }
    }

    public void setChildPositions() {
        if (this.showBoxInBox()) {
            CellView[] cellViewArray = this.getAllChildren();
            Rectangle2D rectangle2D = this.getBounds();
            for (int i = 0; i < cellViewArray.length; ++i) {
                EntityView entityView = (EntityView)cellViewArray[i];
                entityView.setPosition(rectangle2D);
            }
        }
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.isChild() && this.showBoxInBox()) {
            Rectangle2D rectangle2D = super.getBounds();
            Rectangle2D rectangle2D2 = this.getParentBounds();
            if (rectangle2D2 != null) {
                double d = Math.max(rectangle2D.getX(), rectangle2D2.getX());
                double d2 = Math.max(rectangle2D.getY(), rectangle2D2.getY());
                double d3 = Math.min(rectangle2D.getWidth(), rectangle2D2.getWidth() - 20.0);
                double d4 = Math.min(rectangle2D.getHeight(), rectangle2D2.getHeight() - 20.0);
                if (d + d3 > rectangle2D2.getX() + rectangle2D2.getWidth() - 10.0) {
                    d = rectangle2D2.getX() + rectangle2D2.getWidth() - d3 - 10.0;
                } else if (d == rectangle2D2.getX()) {
                    d += 10.0;
                }
                if (d2 + d4 > rectangle2D2.getY() + rectangle2D2.getHeight() - 10.0) {
                    d2 = rectangle2D2.getY() + rectangle2D2.getHeight() - d4 - 10.0;
                } else if (d2 == rectangle2D2.getY()) {
                    d2 += 10.0;
                }
                if (d3 < 10.0) {
                    d3 = 10.0;
                    d = rectangle2D2.getX();
                }
                if (d4 < 10.0) {
                    d4 = 10.0;
                    d2 = rectangle2D2.getY();
                }
                return new Rectangle2D.Double(d, d2, d3, d4);
            }
            return rectangle2D;
        }
        return super.getBounds();
    }

    private boolean isChild() {
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            return ((Entity)topView.getModel()).isInheriting();
        }
        return false;
    }

    public boolean isParent() {
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            return ((Entity)topView.getModel()).hasHierarchicalChildren();
        }
        return false;
    }

    public Object[] getChildren() {
        Entity entity;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && (entity = (Entity)topView.getModel()).hasHierarchicalChildren()) {
            int n = entity.getHierarchicalChildrenCount();
            for (int i = 0; i < n; ++i) {
                Entity entity2 = entity.getHierarchicalChild(i);
                TopViewCollection topViewCollection = entity2.getViewsForDPV(((Diagram)this.diagram).getDesignPartView());
                for (TopView topView2 : topViewCollection) {
                    AbstractCellView abstractCellView;
                    if (topView2 == null || (abstractCellView = topView2.getCellView()) == null) continue;
                    arrayList.add(abstractCellView.getCell());
                }
            }
        }
        return arrayList.toArray();
    }

    public CellView[] getAllChildren() {
        CellView[] cellViewArray;
        ArrayList<AbstractCellView> arrayList = new ArrayList<AbstractCellView>();
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && (cellViewArray = (CellView[])topView.getModel()).hasHierarchicalChildren()) {
            int n = cellViewArray.getHierarchicalChildrenCount();
            for (int i = 0; i < n; ++i) {
                AbstractCellView abstractCellView;
                Entity entity = cellViewArray.getHierarchicalChild(i);
                TopView topView2 = entity.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView());
                if (topView2 == null || (abstractCellView = topView2.getCellView()) == null) continue;
                arrayList.add(abstractCellView);
            }
        }
        cellViewArray = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray);
        return cellViewArray;
    }

    public Object[] getRelationCells() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            Entity entity = (Entity)topView.getModel();
            Relation.Connection[] connectionArray = entity.getRelationConnections();
            for (int i = 0; i < connectionArray.length; ++i) {
                AbstractCellView abstractCellView;
                Relation.Connection connection = connectionArray[i];
                TopView topView2 = connection.getRelation().getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView());
                if (topView2 == null || (abstractCellView = topView2.getCellView()) == null) continue;
                arrayList.add(abstractCellView.getCell());
            }
        }
        return arrayList.toArray();
    }

    public Object[] getArcCells() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            Entity entity = (Entity)topView.getModel();
            List list = entity.getArcs();
            for (Arc arc : list) {
                AbstractCellView abstractCellView;
                TopView topView2 = arc.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView());
                if (topView2 == null || (abstractCellView = topView2.getCellView()) == null) continue;
                arrayList.add(abstractCellView.getCell());
            }
        }
        return arrayList.toArray();
    }

    public void updateParent() {
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && topView.getDesignPartView().isBoxInBox()) {
            AbstractCellView abstractCellView;
            TopView topView2;
            Entity entity = null;
            Entity entity2 = (Entity)topView.getModel();
            entity = entity2.getHierarchicalRoot();
            if (entity == null && entity2.isHierarchicalRoot()) {
                entity = entity2;
            }
            if (entity != null && (topView2 = entity.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView())) != null && (abstractCellView = topView2.getCellView()) != null) {
                ((EntityView)abstractCellView).toFront();
            }
        }
    }

    public void toFront() {
        EntityDiagramCell entityDiagramCell;
        int n;
        Object[] objectArray = this.getChildren();
        for (n = 0; n < objectArray.length; ++n) {
            Object[] objectArray2;
            entityDiagramCell = (EntityDiagramCell)objectArray[n];
            Object[] objectArray3 = ((EntityView)entityDiagramCell.getCellView()).getRelationCells();
            if (objectArray3.length > 0) {
                this.diagram.getDiagramLayoutCache().toFront(objectArray3);
            }
            if ((objectArray2 = ((EntityView)entityDiagramCell.getCellView()).getArcCells()).length <= 0) continue;
            this.diagram.getDiagramLayoutCache().toFront(objectArray2);
        }
        if (objectArray.length > 0) {
            this.diagram.getDiagramLayoutCache().toFront(objectArray);
        }
        for (n = 0; n < objectArray.length; ++n) {
            entityDiagramCell = (EntityDiagramCell)objectArray[n];
            if (!((EntityView)entityDiagramCell.getCellView()).isParent()) continue;
            ((EntityView)entityDiagramCell.getCellView()).toFront();
        }
    }

    private boolean showBoxInBox() {
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            return topView.getDesignPartView().isBoxInBox();
        }
        return false;
    }

    public Rectangle2D getParentBounds() {
        AbstractCellView abstractCellView;
        Entity entity;
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && (entity = ((Entity)topView.getModel()).getHierarchicalParent()) != null && entity.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView()) != null && (abstractCellView = entity.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView()).getCellView()) != null) {
            return abstractCellView.getBounds();
        }
        return null;
    }

    public void setParentBounds(Rectangle rectangle) {
        AbstractCellView abstractCellView;
        Entity entity;
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && (entity = ((Entity)topView.getModel()).getHierarchicalParent()) != null && entity.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView()) != null && (abstractCellView = entity.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView()).getCellView()) != null) {
            abstractCellView.setNewBounds(rectangle);
        }
    }

    public EntityView getRoot() {
        AbstractCellView abstractCellView;
        Entity entity;
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && (entity = ((Entity)topView.getModel()).getHierarchicalRoot()) != null && entity.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView()) != null && (abstractCellView = entity.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView()).getCellView()) != null) {
            return (EntityView)abstractCellView;
        }
        return this;
    }

    public void savePosition(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        this.dx = rectangle2D2.getX() - rectangle2D.getX();
        this.dy = rectangle2D2.getY() - rectangle2D.getY();
        this.saveChildPositions();
    }

    public void setPosition(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + this.dx, rectangle2D.getY() + this.dy, rectangle2D2.getWidth(), rectangle2D2.getHeight());
        this.setNewBounds(double_.getBounds());
        this.setChildPositions();
    }
}

