/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class EntityRenderer
extends ContainerRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(164, 225, 255);
    public static final Color DEFAULT_DATATYPE_COLOR = new Color(0, 0, 128);
    public static final Color DEFAULT_ALLOW_NULL_COLOR = Color.RED;

    public EntityRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        this.datatypeColor = DEFAULT_DATATYPE_COLOR;
        this.allowNullColor = DEFAULT_ALLOW_NULL_COLOR;
    }

    @Override
    protected Color getBackgroundColor() {
        if (this.container instanceof Entity) {
            if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
                Entity entity = (Entity)this.container;
                ClassificationType classificationType = entity.getDesign().getDLSettings().getClassificationTypeByID(entity.getTypeID());
                if (classificationType != null) {
                    return classificationType.getTypeColor();
                }
                DefaultFontAndColor defaultFontAndColor = this.container.getDesign().getDLSettings().getDefaultFCObject("Entity");
                if (defaultFontAndColor != null) {
                    return defaultFontAndColor.getBackgroundColor();
                }
            } else {
                return this.getTopView().getBackgroundColor();
            }
        }
        return this.defaultBackground;
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.container.getDesign().getDLSettings().getDefaultFCObject("Entity");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.getForeground();
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    protected Color getElementsColor() {
        if (this.container instanceof EditableFonts) {
            return ((EditableFonts)((Object)this.container)).getFontObject(EditableFonts.FO_ATTRIBUTE).getColor();
        }
        return super.getElementsColor();
    }

    @Override
    protected Font getElementsFont() {
        if (this.container instanceof EditableFonts) {
            return ((EditableFonts)((Object)this.container)).getFontObject(EditableFonts.FO_ATTRIBUTE).getFont();
        }
        return super.getElementsFont();
    }

    @Override
    protected String getType() {
        String string;
        if (this.container instanceof Entity && (string = ((Entity)this.container).getDesign().getDLSettings().getClassificationTypeNameByID(((Entity)this.container).getTypeID())) != null && string.length() > 0) {
            return string.substring(0, 1);
        }
        return null;
    }

    private void paintUsingBarkerNotation(Graphics graphics) {
        block11: {
            BasicStroke basicStroke;
            int n;
            int n2;
            FontMetrics fontMetrics;
            EditableFonts editableFonts;
            int n3;
            int n4;
            Graphics2D graphics2D;
            block12: {
                StructuredType structuredType;
                Object object;
                graphics2D = (Graphics2D)graphics;
                Dimension dimension = this.getSize();
                n4 = dimension.width;
                n3 = dimension.height;
                editableFonts = (EditableFonts)((Object)this.container);
                graphics2D.setPaint(this.getBackgroundColor());
                graphics.fillRoundRect(0, 0, n4 - 1, n3 - 1, 20, 20);
                graphics.setColor(this.getBorderColor());
                graphics.drawRoundRect(0, 0, n4 - 1, n3 - 1, 20, 20);
                String string = this.title.toUpperCase();
                Font font = editableFonts.getFontObject(EditableFonts.FO_TITLE).getFont();
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics();
                n2 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                n = Math.max(n2, font.getSize());
                int n5 = (n4 - fontMetrics.stringWidth(this.title)) / 2;
                if (n5 < 20) {
                    n5 = 20;
                }
                basicStroke = new BasicStroke(1.0f);
                graphics2D.setStroke(basicStroke);
                graphics.setColor(this.getBorderColor());
                graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_TITLE).getColor());
                String[] stringArray = EntityRenderer.wrapText(string, EntityRenderer.getMaxChars(string, fontMetrics, n4 - 20 - 5));
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    graphics.drawString((String)object, n5, n);
                    n += n2;
                }
                n -= n2;
                String string2 = this.getType();
                if (string2 != null && string2.length() > 0) {
                    graphics.drawString(string2, 5, n);
                }
                if ((object = this.getDesignPartView()) == null || ((DesignPartView)object).clearDetails() || ((DesignPartView)object).isShowNamesOnly() || ((DesignPartView)object).showKeys()) break block11;
                n += 3 + this.borderWidth;
                if (!this.container.isBST() || this.container.getTypeSubstitution() == null) break block12;
                TypeSubstitution typeSubstitution = this.container.getTypeSubstitution();
                ContainerObject containerObject = typeSubstitution.getParentContainerObject();
                if (containerObject != null) {
                    // empty if block
                }
                if ((structuredType = this.container.getBasedOnStructuredType()) == null) break block11;
                TypeElement[] typeElementArray = structuredType.getElements();
                String string3 = this.getLongestTypeName(typeElementArray);
                graphics.setFont(this.getElementsFont());
                fontMetrics = graphics.getFontMetrics();
                n2 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                for (int i = 0; i < typeElementArray.length; ++i) {
                    TypeElement typeElement = typeElementArray[i];
                    graphics.setColor(this.getElementsColor());
                    graphics.setFont(this.getElementsFont());
                    float f = this.getElementsFont().getSize2D();
                    graphics.drawString(typeElement.getName(), 25, n += 3 + fontMetrics.getMaxAscent());
                    fontMetrics = graphics.getFontMetrics();
                    int n6 = fontMetrics.stringWidth(string3) + 50;
                    graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                    graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getFont().deriveFont(f));
                    graphics.drawString(typeElement.getDataType(), n6, n);
                    graphics.setColor(this.getForeground());
                }
                break block11;
            }
            graphics.setFont(this.getElementsFont());
            graphics2D.setStroke(basicStroke);
            float f = this.getElementsFont().getSize2D();
            ContainedObject[] containedObjectArray = this.container.getElements();
            fontMetrics = graphics.getFontMetrics();
            n2 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
            for (int i = 0; i < containedObjectArray.length; ++i) {
                ContainedObjectWithDomain containedObjectWithDomain = (ContainedObjectWithDomain)containedObjectArray[i];
                if (containedObjectWithDomain.isFKElement()) continue;
                n += 3 + fontMetrics.getMaxAscent();
                String string = " ";
                if (containedObjectWithDomain.isPKElement()) {
                    string = "#";
                    graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_PK).getColor());
                    graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_PK).getFont().deriveFont(f));
                } else if (containedObjectWithDomain.isUnique()) {
                    string = "U";
                    graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_UK).getColor());
                    graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_UK).getFont().deriveFont(f));
                }
                graphics.drawString(string, 5, n);
                fontMetrics = graphics.getFontMetrics();
                int n7 = fontMetrics.stringWidth("AU");
                graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_NOT_NULL).getColor());
                graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_NOT_NULL).getFont().deriveFont(f));
                if (!containedObjectWithDomain.getNullsAllowed()) {
                    graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_NOT_NULL).getColor());
                    graphics.drawString("*", n7, n);
                } else {
                    graphics.drawString("o", n7, n);
                }
                fontMetrics = graphics.getFontMetrics();
                graphics.setFont(this.getElementsFont());
                graphics.setColor(this.getElementsColor());
                graphics.drawString(containedObjectWithDomain.getName(), n7 += fontMetrics.stringWidth("*") + 3, n);
                if (n <= n3) continue;
                graphics.setColor(this.getBorderColor());
                int n8 = n4 - 4;
                int n9 = n8 - 8;
                int n10 = n8 - 4;
                int n11 = n3 - 4;
                int n12 = n11 - 8;
                int[] nArray = new int[]{n10, n9, n8};
                int[] nArray2 = new int[]{n11, n12, n12};
                graphics.fillPolygon(nArray, nArray2, 3);
                break;
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.container.getDesign().getAppView().getSettings().getNotation();
        if (this.getDesignPartView() != null) {
            n = this.getDesignPartView().getNotation();
        }
        switch (n) {
            case 0: {
                super.paint(graphics);
                break;
            }
            case 1: {
                this.paintUsingBarkerNotation(graphics);
                break;
            }
            default: {
                super.paint(graphics);
            }
        }
    }
}

