/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;

public class ArcDiagramCell
extends DefaultDiagramCell {
    private Arc arc;
    private JPopupMenu menu;

    public ArcDiagramCell(Arc arc) {
        this(arc, DiagramConstants.createMap());
    }

    public ArcDiagramCell(Arc arc, Map map) {
        this.arc = arc;
        this.setAttributes(map);
        DiagramConstants.setValue(this.getAttributes(), arc.getObjectID());
    }

    public Arc getArc() {
        return this.arc;
    }

    private void showProperty() {
        this.arc.showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ArcDiagramCell.this.deleteArc();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ArcDiagramCell.this.showProperty();
                }
            });
        }
        return this.menu;
    }

    public void deleteArc() {
        Diagram diagram = this.getDiagram();
        ApplicationView applicationView = diagram.getAppView();
        ApplicationView.log(MessageFormat.format(Messages.getString("ArcDiagramCell.RemoveArc"), this.arc.getName()));
        this.arc.remove();
    }

    @Override
    public void deleteSelected() {
        this.deleteArc();
    }
}

